/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import guitools.GuiUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetContainable;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.util.StringTools;
import jet.exception.ParseFormulaFailedException;
import jet.log.JRLogger;
import jet.universe.AliasColumnInfoList;
import jet.universe.JetShare;
import jet.universe.JetUCloneable;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUQueryField;
import jet.universe.JetURefQueryField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.JetUWhereFormula;
import jet.universe.UMapTable;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.BusinessView;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.psql.JetRptPsqlQuery;
import jet.universe.psql.RptPsqlFormulaColumn;
import jet.universe.psql.RptPsqlQuery;
import jet.util.HashVector;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.PsqlUnion;

public class JetUQuery
extends JetUResourceContainer
implements JetUQueriable,
JetUCloneable {
    public JetEnumeration transactionIsolation = new JetEnumeration(this, "TransactionIsolation", 99);
    public JetEnumeration readOnly = new JetEnumeration(this, "ReadOnly", 84);
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    public JetShare share = new JetShare(this, "Share", true);
    public JetBoolean enableSQLStmtCreator = new JetBoolean(this, "EnableSQLStmtCreator", false);
    public JetBoolean enableSQLNameAnalyser = new JetBoolean(this, "EnableSQLNameAnalyser", false);
    protected transient UMapTable mapTable = new UMapTable();
    protected RptPsqlQuery psqlQuery = null;
    Vector qryFields = new Vector();
    public JetString pathName = new JetString(this, "pathName");
    private static JRLogger logger = JRLogger.getLogger(JetUQuery.class.getName());
    public JetNumber pushDownGroupQuery = new JetNumber(this, "PushDownGroupQuery", 0);
    private AliasColumnInfoList aliasColumnsList;
    private static final HashMap nameIdx = new HashMap(10);
    private static final HashVector grpDesc;

    public JetUQuery() {
        this.pushDownGroupQuery.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(0));
        v.add(String.valueOf(1));
        v.add(String.valueOf(2));
        this.pushDownGroupQuery.setPropertyChoice(v);
        this.pushDownGroupQuery.enableAllChangeBys(false);
        this.aliasColumnsList = new AliasColumnInfoList();
        this.initialize();
    }

    public JetUQuery(String strName, String strDesc) {
        super(strName, strDesc);
        this.pushDownGroupQuery.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(0));
        v.add(String.valueOf(1));
        v.add(String.valueOf(2));
        this.pushDownGroupQuery.setPropertyChoice(v);
        this.pushDownGroupQuery.enableAllChangeBys(false);
        this.aliasColumnsList = new AliasColumnInfoList();
        this.initialize();
    }

    public JetUQuery(String strName, RptPsqlQuery psqlQuery) {
        super(strName, "");
        this.pushDownGroupQuery.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(0));
        v.add(String.valueOf(1));
        v.add(String.valueOf(2));
        this.pushDownGroupQuery.setPropertyChoice(v);
        this.pushDownGroupQuery.enableAllChangeBys(false);
        this.aliasColumnsList = new AliasColumnInfoList();
        this.initialize();
        this.psqlQuery = psqlQuery;
        psqlQuery.setMappingName(strName);
        this.pathName.set(psqlQuery.getPathName());
    }

    protected void initialize() {
        this.transactionIsolation.set(new Integer(0));
        this.readOnly.set(new Integer(1));
        this.enableSQLNameAnalyser.setEditFlag(3);
        this.addPG();
    }

    private void addPG() {
        String GName = "General";
    }

    @Override
    public void InitAfterCreate() {
        this.scanAliasColumns(this.psqlQuery);
        this.InitQuery();
        super.InitAfterCreate();
    }

    private void putToMapTable(UMapTable mapTable) {
        Vector children = this.getFields();
        JetObject child = null;
        Object mappingName = null;
        for (int i = 0; i < children.size(); ++i) {
            JetUFldQueryField field;
            child = (JetObject)children.elementAt(i);
            if (child instanceof JetUCompColQueryField) {
                mapTable.addElement((JetUResourceEntity)child);
                continue;
            }
            if (!(child instanceof JetUFldQueryField) || (field = (JetUFldQueryField)child).getCorrName() == null || field.getCorrName().trim().length() <= 0 || mapTable.getElementByName(field.getResourceNameInUpperCase()) != null) continue;
            mapTable.addElement(field);
        }
    }

    private void removeFromMapTable(UMapTable mapTable) {
        Vector children = this.getFields();
        int iSize = children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            JetUFldQueryField field;
            child = (JetObject)children.elementAt(i);
            if (child instanceof JetUCompColQueryField) {
                mapTable.removeElement((JetUResourceEntity)child);
                continue;
            }
            if (!(child instanceof JetUFldQueryField) || (field = (JetUFldQueryField)child).getCorrName() == null || field.getCorrName().trim().length() <= 0 || !(mapTable.getElementByName(field.getResourceNameInUpperCase()) instanceof JetUFldQueryField)) continue;
            mapTable.removeElement(field);
        }
    }

    @Override
    void AddEntitiesToMapTable(UMapTable mapTable) {
        this.putToMapTable(mapTable);
        if (mapTable.equals(this.mapTable)) {
            UMapTable mapTab = this.getDatabase().mapTable;
            this.putToMapTable(mapTab);
        }
    }

    @Override
    void RemoveEntitiesFromMapTable(UMapTable mapTable) {
        this.removeFromMapTable(mapTable);
        if (mapTable.equals(this.mapTable)) {
            UMapTable mapTab = this.getDatabase().mapTable;
            this.removeFromMapTable(mapTab);
        }
    }

    @Override
    public void InitAfterLoad() {
        if (this.children == null) {
            return;
        }
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)this.children.elementAt(i);
            if (child instanceof JetRptPsqlQuery) {
                JetRptPsqlQuery jetPsqlQuery = (JetRptPsqlQuery)child;
                this.psqlQuery = new RptPsqlQuery();
                JetUDatabase db = this.getDatabase();
                if (db.getResourceName().equals("")) {
                    db.name.set("Data Source 1");
                    db.setDefaultDB(true);
                }
                this.psqlQuery.setUniverse(db.getUniverse(), db.getResourceName());
                this.psqlQuery.getFromJetObject(jetPsqlQuery);
                this.psqlQuery.setPathName(this.pathName.get());
                break;
            }
            if (!(child instanceof JBusinessLogic)) continue;
            BusinessLogic bLogic = (BusinessLogic)child;
            bLogic.initAfterLoad();
        }
        super.InitAfterLoad();
        this.extractAliasColumns(this.psqlQuery);
    }

    void PrepareBeforeSave() {
        Vector children = (Vector)this.getChildren().clone();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetRptPsqlQuery)) continue;
            this.remove(i);
        }
        JetObject jetPsqlQuery = this.psqlQuery.createJetObject();
        this.add(jetPsqlQuery);
    }

    protected void InitQuery() {
        String strWhereFormula = null;
        boolean bChanged = false;
        Hashtable paramPair = this.psqlQuery.getParameterValuePairs();
        this.psqlQuery.prepareWhereClauseString(false);
        strWhereFormula = this.psqlQuery.getFormulaSelectionString();
        this.pathName.set(this.psqlQuery.getPathName());
        if (!strWhereFormula.equals("")) {
            JetUWhereFormula uf = this.getWhereFormula();
            if (uf == null || !strWhereFormula.equals(uf.getExpression())) {
                if (uf == null) {
                    uf = this.createWhereFormula("~WhereFormula@" + this.getResourceName(), strWhereFormula);
                } else {
                    uf.setExpression(strWhereFormula);
                }
                bChanged = true;
            }
        } else if (this.getWhereFormula() != null) {
            this.deleteWhereFormula();
            bChanged = true;
        }
        if (!this.psqlQuery.isOldExecuteQuery()) {
            String[][] nameAndExp = this.psqlQuery.getBranchWhereFormula("~WhereFormula", this.getResourceName());
            for (int i = 0; i < nameAndExp.length; ++i) {
                JetUWhereFormula uf;
                if (nameAndExp[i][0] == null || (uf = this.getWhereFormula(nameAndExp[i][0])) != null && strWhereFormula.equals(uf.getExpression())) continue;
                if (uf == null) {
                    uf = this.createWhereFormula(nameAndExp[i][0], nameAndExp[i][1]);
                } else {
                    uf.setExpression(nameAndExp[i][1]);
                }
                bChanged = true;
            }
        }
        if (bChanged) {
            try {
                JetUDatabase db = this.getDatabase();
                db.parseFormulas(false);
            }
            catch (ParseFormulaFailedException e) {
            }
        }
        this.InitQueryFields();
    }

    public String getWhereFormulaName() {
        String strWFName = null;
        JetUWhereFormula wf = this.getWhereFormula();
        strWFName = wf != null ? wf.getResourceName() : null;
        return strWFName;
    }

    public JetUWhereFormula createWhereFormula(String strWFName, String strWFExpr) {
        JetUWhereFormula wf = new JetUWhereFormula(strWFName, "", strWFExpr);
        this.add(wf);
        wf.InitAfterCreate();
        return wf;
    }

    public JetUWhereFormula deleteWhereFormula() {
        Vector children = this.getChildren();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUWhereFormula)) continue;
            this.remove(i);
            return (JetUWhereFormula)child;
        }
        return null;
    }

    public JetUWhereFormula getWhereFormula() {
        int iSize = this.children.size();
        String mapName = "~WhereFormula@" + this.getResourceName();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUWhereFormula) || !((JetUWhereFormula)child).getResourceName().equalsIgnoreCase(mapName)) continue;
            return (JetUWhereFormula)child;
        }
        return null;
    }

    public JetUWhereFormula getWhereFormula(String mapName) {
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUWhereFormula) || !((JetUWhereFormula)child).getResourceName().equalsIgnoreCase(mapName)) continue;
            return (JetUWhereFormula)child;
        }
        return null;
    }

    protected void InitQueryFields() {
        Vector vSelCols = this.psqlQuery.getSelColsVector();
        for (int i = 0; i < vSelCols.size(); ++i) {
            PsqlSelColumn col = (PsqlSelColumn)vSelCols.elementAt(i);
            if (col.isNotResolved()) continue;
            this.addField(col);
        }
    }

    @Override
    public void setResourceName(String rscName) {
        if (this.getDatabase() != null) {
            this.getDatabase().mapTable4Queriable.remove(this.getResourceName().toUpperCase());
            this.getDatabase().mapTable4Queriable.put(rscName.toUpperCase(), this);
        }
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUWhereFormula)) continue;
            JetUWhereFormula uWhereFormula = (JetUWhereFormula)child;
            String curQueryName = this.getResourceName();
            String curFormulaName = uWhereFormula.getResourceName();
            int index = curFormulaName.toUpperCase().lastIndexOf(curQueryName.toUpperCase());
            if (index == -1) continue;
            uWhereFormula.setResourceName(curFormulaName.substring(0, index) + rscName);
        }
        if (this.psqlQuery != null) {
            this.psqlQuery.setMappingName(rscName);
        }
        super.setResourceName(rscName);
    }

    public void setTransactionIsolation(int iTransactionIsolation) {
        this.transactionIsolation.set(new Integer(iTransactionIsolation));
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation.intValue();
    }

    public void setReadOnly(int iReadOnly) {
        this.readOnly.set(new Integer(iReadOnly));
    }

    @Override
    public int getReadOnly() {
        return this.readOnly.intValue();
    }

    public void setMaxRows(int maxRows) {
        this.maxRows.set(maxRows);
    }

    @Override
    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration.set(maxDuration);
    }

    @Override
    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    @Override
    public JetUDBTreeNode copy() {
        JetUDatabase db = this.getDatabase();
        String strName = this.getResourceName();
        int i = 1;
        String strTmp = "Copy of " + strName;
        while (db.IsQueryNameExist(strTmp)) {
            strTmp = "Copy (" + String.valueOf(++i) + ") of " + strName;
        }
        RptPsqlQuery pq = this.getPsqlQuery().getCopy(true);
        JetUQuery copyQuery = new JetUQuery(strTmp, pq);
        JetObject.copyProperties(copyQuery, this);
        copyQuery.setResourceName(strTmp);
        copyQuery.removeBL();
        JBusinessLogic bl = this.getBL();
        copyQuery.add((JetObject)((Object)(bl == null ? null : bl.copy())));
        copyQuery.removeBV();
        JBusinessView bv = this.getBV();
        copyQuery.add((JetObject)((Object)(bv == null ? null : bv.copy())));
        return copyQuery;
    }

    @Override
    public String getFullSQLString() {
        return this.getSQLString();
    }

    @Override
    public String getSQLString() {
        this.psqlQuery.prepareWhereClauseString(false);
        return this.psqlQuery.getRawQueryString(true);
    }

    public RptPsqlQuery getPsqlQuery() {
        return this.psqlQuery;
    }

    public void setPsqlQuery(RptPsqlQuery psqlQuery) {
        this.scanAliasColumns(psqlQuery);
        this.psqlQuery = psqlQuery;
        this.psqlQuery.setMappingName(this.getResourceName());
        UMapTable umapTable = this.getDatabase().getMapTable();
        this.RemoveEntitiesFromMapTable(umapTable);
        this.removeAllFields();
        this.InitQuery();
        this.objectModified();
        JetUUniverse.objectChanged(this.getUniverse(), this, 1002);
        this.AddEntitiesToMapTable(umapTable);
    }

    @Override
    public Vector getFields() {
        return this.getFields(false);
    }

    public Vector getFields(boolean withHideColumn) {
        if (withHideColumn) {
            return this.qryFields;
        }
        Vector<JetUQueryField> ret = new Vector<JetUQueryField>();
        for (int i = 0; i < this.qryFields.size(); ++i) {
            JetUQueryField fd = (JetUQueryField)this.qryFields.get(i);
            if (fd.bHide.get()) continue;
            ret.add(fd);
        }
        return ret;
    }

    public void rebuildMapTable() {
        this.mapTable = new UMapTable();
        Vector ret = new Vector();
        for (int i = 0; i < this.qryFields.size(); ++i) {
            JetUQueryField fd = (JetUQueryField)this.qryFields.get(i);
            this.mapTable.addElement(fd);
        }
    }

    @Override
    public JetUResourceEntity getFieldByResourceName(String fldName) {
        int iSize = this.qryFields.size();
        for (int i = 0; i < iSize; ++i) {
            JetUQueryField fld = (JetUQueryField)this.qryFields.elementAt(i);
            if (!fld.getResourceName().equalsIgnoreCase(fldName)) continue;
            return fld;
        }
        return null;
    }

    protected synchronized JetObject _addField(JetUQueryField field, int pos) {
        if (field != null) {
            JetContainable parent = field.getParent();
            if (parent != null) {
                if (parent == this) {
                    return field;
                }
                parent.remove(field);
            }
            if (pos == -1) {
                this.qryFields.addElement(field);
            } else {
                this.qryFields.insertElementAt(field, pos);
            }
            field.setParent(this);
            JetUResourceEntity f = this.getDatabase().getResourceByName(field.getResourceName());
            if (f instanceof JetUField) {
                JetUField jetUField = (JetUField)f;
                field.setDataMappingFile(f.getDataMappingFile());
            }
            this.objectModified();
        }
        return field;
    }

    protected JetObject _removeField(JetUQueryField field) {
        this.objectModified();
        this.qryFields.removeElement(field);
        field.setParent(null);
        return field;
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    public void addField(PsqlSelColumn col) {
        JetUQueryField queryfield;
        String name2 = col.getMappingName();
        if (name2 == null) {
            name2 = this.getDefaultQueryFieldName(col);
        }
        if (col instanceof RptPsqlFormulaColumn) {
            DbColDesc colDesc;
            queryfield = new JetUFmlQueryField(name2, "", col);
            JetUDatabase db = this.getDatabase();
            JetUFormula uformula = db.getFormulaByResourceName(col.getName());
            if (uformula != null && (colDesc = uformula.getColDesc()) != null) {
                queryfield.setSqlType(colDesc.getSqlType());
                queryfield.setPrecision(colDesc.getPrecision());
                queryfield.setScale(colDesc.getScale());
                queryfield.setNullable(colDesc.getNullable());
            }
        } else if (col.isCompCol()) {
            queryfield = new JetUCompColQueryField(name2, "", col);
        } else {
            String strTableName;
            PsqlTable table = col.getPsqlTable();
            if (table.isQueriable()) {
                strTableName = table.getMappingName();
                queryfield = new JetURefQueryField(name2, "", col);
            } else {
                strTableName = table.getMappingName();
                String strTableAlias = table.getNameCorr();
                String strTableShowName = null;
                strTableShowName = strTableName;
                JetUConnection cnnct = table.getDataObj();
                queryfield = new JetUFldQueryField(name2, "", col, cnnct, strTableName, strTableAlias, strTableShowName);
            }
            JetUDatabase database = this.getDatabase();
            JetUResourceEntity entity = database.getResourceByName(col.getMappingName());
            if (entity instanceof JetUField) {
                JetUField field = (JetUField)entity;
                queryfield.currency.set(field.currency.get());
            }
        }
        this.addField(queryfield);
    }

    public String getDefaultQueryFieldName(PsqlSelColumn col) {
        return JetUQuery.getDefaultQueryFieldName(this.getDatabase(), col);
    }

    public void addField(JetUQueryField queryfield) {
        this._addField(queryfield, -1);
        queryfield.InitAfterCreate();
    }

    public JetUQueryField removeField(JetUQueryField child) {
        child.col.setHide(true);
        this._removeField(child);
        return child;
    }

    protected void removeAllFields() {
        Vector qryFlds = (Vector)this.getFields().clone();
        int iSize = qryFlds.size();
        for (int i = 0; i < iSize; ++i) {
            JetUQueryField child = (JetUQueryField)qryFlds.elementAt(i);
            this._removeField(child);
        }
    }

    @Override
    public JetUDatabase getDatabase() {
        return (JetUDatabase)this.getParent();
    }

    @Override
    public UMapTable getMapTable() {
        return this.mapTable;
    }

    void resolvePsqlQuery() {
        this.psqlQuery.resolveAll(this.getDatabase().getUniverse());
        this.InitQueryFields();
    }

    public boolean isResolvedOK() {
        boolean bIsResolvedOK = this.psqlQuery.isResolved();
        return bIsResolvedOK;
    }

    public String check() {
        return this.psqlQuery.check();
    }

    public JetUResourceEntity getResourceByName(String name2) {
        return this.mapTable.getResourceByName(name2.toUpperCase());
    }

    public JetUFldQueryField getQueryFieldBy3PartName(String str3PartName) {
        Vector qryFlds = this.getFields();
        int iSize = qryFlds.size();
        for (int i = 0; i < iSize; ++i) {
            JetUQueryField qryFld = (JetUQueryField)qryFlds.elementAt(i);
            if (!(qryFld instanceof JetUFldQueryField) || !str3PartName.equalsIgnoreCase(((JetUFldQueryField)qryFld).get3PartName())) continue;
            return (JetUFldQueryField)qryFld;
        }
        return null;
    }

    public JetUFldQueryField getSameFieldInQuery(JetUField field) {
        return this.getQueryFieldBy3PartName(field.get3PartName());
    }

    public JetUFldQueryField getSameFieldInQuery(JetUFldQueryField qryFld) {
        return this.getQueryFieldBy3PartName(qryFld.get3PartName());
    }

    public boolean isThereSameFieldInQuery(JetUField fldEntity) {
        return this.getSameFieldInQuery(fldEntity) != null;
    }

    public boolean isThereSameFieldInQuery(JetUFldQueryField fldEntity) {
        return this.getSameFieldInQuery(fldEntity) != null;
    }

    public boolean isQueryFieldInQuery(JetUQueryField qryFld) {
        Vector qryFlds = this.getFields();
        return qryFlds.contains(qryFld);
    }

    public boolean isThereSameFieldInQuery(JetUFormula formula2) {
        Vector qryFlds = this.getFields();
        int size = qryFlds.size();
        boolean bReturn = false;
        for (int i = 0; i < size; ++i) {
            JetUQueryField field = (JetUQueryField)qryFlds.elementAt(i);
            if (!(field instanceof JetUFmlQueryField) || !((JetUFmlQueryField)field).getFomulaName().equalsIgnoreCase(formula2.getResourceName())) continue;
            bReturn = true;
            break;
        }
        return bReturn;
    }

    public boolean isThereSameFieldInQuery(JetUFmlQueryField formula2) {
        Vector qryFlds = this.getFields();
        int size = qryFlds.size();
        boolean bReturn = false;
        for (int i = 0; i < size; ++i) {
            JetUQueryField field = (JetUQueryField)qryFlds.elementAt(i);
            if (!(field instanceof JetUFmlQueryField) || !((JetUFmlQueryField)field).getFomulaName().equalsIgnoreCase(formula2.getFomulaName())) continue;
            bReturn = true;
            break;
        }
        return bReturn;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, String mappingName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity entity = universe.getResourceByName(this.getResourceName(), mappingName);
        if (entity == null) {
            throw new CannotFindEntity(mappingName);
        }
        return this.isFieldValidToQuery(universe, entity);
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, String mappingName, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity en;
        String resourceName = this.getResourceName();
        JetUResourceEntity entity = universe.getResourceByName(dataSourceName, resourceName, mappingName);
        if (entity == null && (en = universe.getAnyResourceByName(mappingName)) != null && en instanceof JetUParameter) {
            entity = en;
        }
        if (entity == null) {
            throw new CannotFindEntity(mappingName);
        }
        if (entity instanceof JetURefQueryField) {
            JetURefQueryField refQueryField = (JetURefQueryField)entity;
            if (refQueryField.bHide.get()) {
                return false;
            }
        }
        return this.isFieldValidToQuery(universe, entity, dataSourceName);
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, JetUResourceEntity entity) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (entity instanceof JetUParameter) {
            bRet = true;
        } else {
            if (entity instanceof JetUFormula) {
                return this.isFormulaValidToQuery((JetUFormula)entity, universe);
            }
            if (entity instanceof JetUQueryField) {
                if (entity instanceof JetUFldQueryField) {
                    bRet = ((JetUQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (entity instanceof JetUCompColQueryField) {
                    bRet = ((JetUQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (entity instanceof JetUFmlQueryField && ((JetUFmlQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName())) {
                    String strRscName = entity.getResourceName();
                    if ((entity = universe.getResourceByName(strRscName)) == null) {
                        throw new CannotFindEntity(strRscName);
                    }
                    bRet = this.isFormulaValidToQuery((JetUFormula)entity, universe);
                }
            }
        }
        return bRet;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, JetUResourceEntity entity, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (entity instanceof JetUParameter) {
            bRet = true;
        } else {
            if (entity instanceof JetUFormula) {
                return this.isFormulaValidToQuery((JetUFormula)entity, universe, dataSourceName);
            }
            if (entity instanceof JetUQueryField) {
                if (entity instanceof JetUFldQueryField) {
                    bRet = ((JetUQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (entity instanceof JetUCompColQueryField) {
                    bRet = ((JetUQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (entity instanceof JetUFmlQueryField) {
                    if (((JetUFmlQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName())) {
                        String strRscName = entity.getResourceName();
                        if ((entity = universe.getMaterialByName(dataSourceName, strRscName)) == null) {
                            throw new CannotFindEntity(strRscName);
                        }
                        bRet = this.isFormulaValidToQuery((JetUFormula)entity, universe, dataSourceName);
                    }
                } else if (entity instanceof JetURefQueryField) {
                    bRet = ((JetURefQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                }
            }
        }
        return bRet;
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        return this.isFormulaValidToQuery(uFormula, this.getUniverse());
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            try {
                if (uFormula instanceof JetUSummary && JetUDatabase.isDigital(name4) || name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            try {
                if (JetUDatabase.isDigital(name4) || name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    public Vector getFormulas() {
        Vector qryFlds = this.getFields();
        Vector<JetUQueryField> ret = new Vector<JetUQueryField>();
        int iSize = qryFlds.size();
        for (int i = 0; i < iSize; ++i) {
            JetUQueryField qryFld = (JetUQueryField)qryFlds.elementAt(i);
            if (!(qryFld instanceof JetUFmlQueryField)) continue;
            ret.addElement(qryFld);
        }
        return ret;
    }

    public JetUFmlQueryField getFmlFieldByFmlName(String fmlName) {
        if (fmlName == null) {
            return null;
        }
        Vector qryFlds = this.getFields();
        int iSize = qryFlds.size();
        for (int i = 0; i < iSize; ++i) {
            JetUQueryField qryFld = (JetUQueryField)qryFlds.elementAt(i);
            if (!(qryFld instanceof JetUFmlQueryField) || !fmlName.equalsIgnoreCase(((JetUFmlQueryField)qryFld).getFomulaName())) continue;
            return (JetUFmlQueryField)qryFld;
        }
        return null;
    }

    public static String getDefaultQueryFieldName(JetUDatabase udb, PsqlSelColumn col) {
        String strName = null;
        if (col instanceof RptPsqlFormulaColumn) {
            strName = col.getName();
        } else if (col.isCompCol()) {
            strName = col.getName();
        } else {
            PsqlTable table = col.getPsqlTable();
            JetUConnection cnnct = table.getDataObj();
            JetUField ufield = udb.GetFieldByRealName(cnnct.getResourceName(), table.getMappingName(), col.getName());
            strName = table.getCorrelationName() != null ? table.getNameCorr() + "_" + ufield.getResourceName() : ufield.getResourceName();
        }
        return strName;
    }

    public Vector getDBFields() {
        Vector<JetUQueryField> dbfields = new Vector<JetUQueryField>();
        int iSize = this.qryFields.size();
        for (int i = 0; i < iSize; ++i) {
            JetUQueryField field = (JetUQueryField)this.qryFields.elementAt(i);
            if (field instanceof JetUFmlQueryField) continue;
            dbfields.addElement(field);
        }
        return dbfields;
    }

    public void clearMem() {
        int size;
        int i = size = this.qryFields.size();
        while (--i >= 0) {
            try {
                ((JetObject)this.qryFields.elementAt(i)).delete();
            }
            catch (Exception exception) {}
        }
        this.qryFields.removeAllElements();
        if (this.psqlQuery != null) {
            this.psqlQuery.setUniverse(null);
            this.psqlQuery.clearMem();
            this.psqlQuery = null;
        }
        if (this.mapTable != null) {
            this.mapTable.clearMem();
        }
    }

    public boolean replaceFldName(String oldname, String newname) {
        Vector fields = this.getFields();
        int size = fields == null ? 0 : fields.size();
        boolean ret = false;
        for (int i = 0; i < size; ++i) {
            JetUQueryField queryfld = (JetUQueryField)fields.elementAt(i);
            if (!queryfld.getResourceName().equalsIgnoreCase(oldname)) continue;
            queryfld.setResourceName(newname);
            ret = true;
        }
        if (this.psqlQuery.replaceFldName(oldname, newname)) {
            ret = true;
        }
        return ret;
    }

    public boolean replaceFieldName(String oldname, String newname) {
        Vector fields = this.getFields();
        int size = fields == null ? 0 : fields.size();
        boolean ret = false;
        for (int i = 0; i < size; ++i) {
            JetUQueryField queryfld = (JetUQueryField)fields.elementAt(i);
            if (!queryfld.getResourceName().equalsIgnoreCase(oldname)) continue;
            queryfld.setResourceName(newname);
            ret = true;
        }
        return ret;
    }

    public boolean replaceTabName(String oldname, String newname) {
        boolean ret = false;
        Vector fields = this.getFields();
        int size = fields == null ? 0 : fields.size();
        for (int i = 0; i < size; ++i) {
            JetUQueriableField qryFld = (JetUQueriableField)fields.elementAt(i);
            if (!(qryFld instanceof JetUFldQueryField) || !((JetUFldQueryField)qryFld).getTableName().equalsIgnoreCase(oldname)) continue;
            ((JetUFldQueryField)qryFld).setTableName(newname);
            ret = true;
        }
        if (this.psqlQuery.replaceTabName(oldname, newname)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public Vector getAutoGroupFields() {
        return null;
    }

    public String[] getUsedFiled() {
        String name2;
        String[] ret = new String[this.qryFields.size()];
        Hashtable<String, Object> flds = new Hashtable<String, Object>();
        int i = ret.length;
        while (--i >= 0) {
            JetUQueryField fld = (JetUQueryField)this.qryFields.elementAt(i);
            ret[i] = name2 = fld.getResourceName();
            flds.put(name2, fld);
        }
        int length = 0;
        int size = this.psqlQuery.vPsqlJoin.size();
        String[] joinflds = new String[size + size];
        for (i = 0; i < size; ++i) {
            PsqlJoin join = (PsqlJoin)this.psqlQuery.vPsqlJoin.elementAt(i);
            name2 = join.getColumnFrom().mappingName;
            if (flds.get(name2) == null) {
                joinflds[length++] = name2;
                flds.put(name2, name2);
            }
            if (flds.get(name2 = join.getColumnTo().mappingName) != null) continue;
            joinflds[length++] = name2;
            flds.put(name2, name2);
        }
        if (length > 0) {
            String[] temp = new String[ret.length + length];
            System.arraycopy(ret, 0, temp, 0, ret.length);
            System.arraycopy(joinflds, 0, temp, ret.length, length);
            ret = temp;
        }
        return ret;
    }

    public String getUsername() {
        return this.psqlQuery.getUsername();
    }

    public String getPassword() {
        return this.psqlQuery.getPassword();
    }

    public void setUsername(String name2) {
        this.psqlQuery.setUsername(name2);
    }

    public void setPassword(String pw) {
        this.psqlQuery.setPassword(pw);
    }

    @Override
    public String getInstancePrefix() {
        return "Query";
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        boolean bRet = super.isSimilar(container);
        if (bRet) {
            bRet = GuiUtil.areEqual(this.getSQLString(), ((JetUQuery)container).getSQLString());
        }
        if (bRet) {
            bRet = this.isBLSimilar((JetUQuery)container);
        }
        if (bRet) {
            bRet = this.isBVSimilar((JetUQuery)container);
        }
        return bRet;
    }

    @Override
    public boolean isEqual(JetUResourceContainer query) {
        boolean bRet = super.isEqual(query);
        if (bRet) {
            bRet = GuiUtil.areEqual(this.getSQLString(), ((JetUQuery)query).getSQLString());
        }
        if (bRet) {
            bRet = this.isBLSimilar((JetUQuery)query);
        }
        if (bRet) {
            bRet = this.isBVSimilar((JetUQuery)query);
        }
        return bRet;
    }

    private boolean isBLSimilar(JetUQuery query) {
        JBusinessLogic bl2;
        JBusinessLogic bl1 = this.getBL();
        if (bl1 == (bl2 = query.getBL())) {
            return true;
        }
        if (bl1 == null) {
            return bl2 == null;
        }
        return bl1.isSimilar(bl2);
    }

    private boolean isBVSimilar(JetUQuery query) {
        JBusinessView bv2;
        JBusinessView bv1 = this.getBV();
        if (bv1 == (bv2 = query.getBV())) {
            return true;
        }
        if (bv1 == null) {
            return bv2 == null;
        }
        return bv1.isSimilar(bv2);
    }

    private void extractAliasColumns(RptPsqlQuery rptPsqlQuery) {
        Vector vColumns = rptPsqlQuery.vSelCols;
        for (int j = 0; j < vColumns.size(); ++j) {
            PsqlSelColumn selColumn = (PsqlSelColumn)vColumns.elementAt(j);
            String corrName = selColumn.corr;
            if (corrName == null || corrName.length() == 0) continue;
            String tableName = selColumn.sTableName;
            this.aliasColumnsList.addItem(selColumn.corr, tableName, selColumn.getName(), selColumn.mappingName);
        }
    }

    private String getMappingName(String oldName) {
        StringBuffer error;
        String mappingName;
        JetUDatabase db = this.getDatabase();
        boolean isNameValid = db.IsMappingNameOK(mappingName = oldName, error = new StringBuffer());
        if (!isNameValid) {
            int i = 1;
            String strTemp = mappingName;
            while (!isNameValid) {
                mappingName = strTemp + "_" + i;
                ++i;
                isNameValid = db.IsMappingNameOK(mappingName, error);
            }
        }
        return mappingName;
    }

    private void scanAliasColumns(RptPsqlQuery rptPsqlQuery) {
        Vector vColumns = rptPsqlQuery.vSelCols;
        for (int j = 0; j < vColumns.size(); ++j) {
            PsqlSelColumn selColumn = (PsqlSelColumn)vColumns.elementAt(j);
            PsqlTable t = selColumn.table;
            if (t != null) continue;
        }
        this.aliasColumnsList.clear();
        this.extractAliasColumns(this.psqlQuery);
    }

    public JBusinessLogic newBL(String blName) throws BLIlegalNameException, BLDupleNameException {
        if (this.getBL() != null) {
            return null;
        }
        BusinessLogic bl = new BusinessLogic();
        bl.setDisplayName(blName);
        this.add(bl);
        return bl;
    }

    public JBusinessView newBV(String bvName) throws BLIlegalNameException, BLDupleNameException {
        if (this.getBV() != null) {
            return null;
        }
        BusinessView bv = new BusinessView();
        bv.setDisplayName(bvName);
        this.add(bv);
        return bv;
    }

    public void removeBL() {
        JBusinessLogic bl = this.getBL();
        if (bl != null) {
            this.remove((JetObject)((Object)bl));
        }
    }

    public void removeBV() {
        JBusinessView bv = this.getBV();
        if (bv != null) {
            this.remove((JetObject)((Object)bv));
        }
    }

    @Override
    public JBusinessLogic getBL() {
        JBusinessLogic ret = null;
        for (JetObject element : this.children) {
            JBusinessLogic bl;
            if (!(element instanceof JBusinessLogic) || (bl = (JBusinessLogic)((Object)element)).getElementType() != 0) continue;
            return bl;
        }
        return ret;
    }

    @Override
    public JBusinessView getBV() {
        JBusinessView ret = null;
        for (JetObject element : this.children) {
            JBusinessLogic bl;
            if (!(element instanceof JBusinessLogic) || (bl = (JBusinessLogic)((Object)element)).getElementType() != 1) continue;
            return (JBusinessView)bl;
        }
        return ret;
    }

    @Override
    public JetObject deepDup() {
        JetUQuery copyQ = (JetUQuery)super.deepDup();
        copyQ.mapTable = this.getMapTable();
        copyQ.psqlQuery = this.getPsqlQuery();
        return copyQ;
    }

    @Override
    public JetObject deepDupWithoutCopyProperties(Hashtable oldToNew, Hashtable newToOld, boolean setTmpl, boolean withName) {
        JetUQuery copyQ = (JetUQuery)super.deepDupWithoutCopyProperties(oldToNew, newToOld, setTmpl, withName);
        copyQ.mapTable = this.getMapTable();
        copyQ.psqlQuery = this.getPsqlQuery();
        return copyQ;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, String mappingName, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity en;
        if (refFldOfFml.containsKey(mappingName)) {
            return true;
        }
        String resourceName = this.getResourceName();
        JetUResourceEntity entity = universe.getResourceByName(dataSourceName, resourceName, mappingName);
        if (entity == null && (en = universe.getAnyResourceByName(mappingName)) != null && en instanceof JetUParameter) {
            entity = en;
        }
        if (entity == null) {
            throw new CannotFindEntity(mappingName);
        }
        boolean ret = this.isFieldValidToQuery(universe, entity, dataSourceName, refFldOfFml);
        if (ret) {
            refFldOfFml.put(mappingName, "");
        }
        return ret;
    }

    private boolean isFieldValidToQuery(JetUUniverse universe, JetUResourceEntity entity, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (entity instanceof JetUParameter) {
            bRet = true;
        } else {
            if (entity instanceof JetUFormula) {
                return this.isFormulaValidToQuery((JetUFormula)entity, universe, dataSourceName, refFldOfFml);
            }
            if (entity instanceof JetUQueryField) {
                if (entity instanceof JetUFldQueryField) {
                    bRet = ((JetUQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (entity instanceof JetUCompColQueryField) {
                    bRet = ((JetUQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName());
                } else if (entity instanceof JetUFmlQueryField) {
                    if (((JetUFmlQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName())) {
                        String strRscName = entity.getResourceName();
                        if ((entity = universe.getMaterialByName(dataSourceName, strRscName)) == null) {
                            throw new CannotFindEntity(strRscName);
                        }
                        bRet = this.isFormulaValidToQuery((JetUFormula)entity, universe, dataSourceName, refFldOfFml);
                    }
                } else if (entity instanceof JetURefQueryField) {
                    bRet = ((JetURefQueryField)entity).getQuery().getResourceName().equalsIgnoreCase(this.getResourceName()) && !((JetURefQueryField)entity).bHide.get();
                }
            }
        }
        return bRet;
    }

    private boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName, refFldOfFml)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    @Override
    public int isPushDownGroupQuery() {
        return this.pushDownGroupQuery.get();
    }

    @Override
    public boolean canPushdownSort(String fieldMappingName) {
        JetUResourceEntity field = this.getFieldByResourceName(fieldMappingName);
        JetUConnection conn = null;
        if (field instanceof JetUFmlQueryField) {
            return false;
        }
        if (field instanceof JetUFldQueryField) {
            conn = ((JetUFldQueryField)field).getConnection();
            JetUJDBCConnection jdbcConn = null;
            if (conn instanceof JetUJDBCConnection) {
                jdbcConn = (JetUJDBCConnection)conn;
                if (jdbcConn.getJdbcDriver().equalsIgnoreCase("com.jinfonet.jdbc.obj.ObjectDriver")) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.enableSQLStmtCreator.get() || jdbcConn != null && !StringTools.isEmptyStringWithTrim(jdbcConn.customQueryOptimizer.get())) {
                return false;
            }
            if (!StringTools.isEmptyStringWithTrim(this.getPsqlQuery().getUserDefinedQueryStmt())) {
                return false;
            }
            if (this.getPsqlQuery().getUnionVector().size() > 0) {
                return false;
            }
        } else if (field instanceof JetURefQueryField) {
            JetUQueriable subquery = ((JetURefQueryField)field).getRefQuery();
            return subquery.canPushdownSort(fieldMappingName);
        }
        return true;
    }

    @Override
    public JetUConnection[] getConnections() {
        HashSet<JetUConnection> retList = new HashSet<JetUConnection>();
        RptPsqlQuery psqlQuery = this.getPsqlQuery();
        Vector pTables = psqlQuery.getPsqlTablesVector();
        int size = pTables.size();
        for (int i = 0; i < size; ++i) {
            PsqlTable pTable = (PsqlTable)pTables.get(i);
            if (pTable.isQueriable()) {
                JetUConnection[] refConns;
                JetUQueriable queriable = this.getDatabase().getQueriableByResourceName(pTable.mappingName);
                if (queriable == null) continue;
                for (JetUConnection refConn : refConns = queriable.getConnections()) {
                    retList.add(refConn);
                }
                continue;
            }
            JetUConnection conn = pTable.getDataObj();
            retList.add(conn);
        }
        Vector unionQuerys = psqlQuery.getUnionVector();
        for (PsqlUnion psqlUnion : unionQuerys) {
            JetUConnection[] conns;
            JetUQueriable unionQuery = this.getDatabase().getQueriableByResourceName(psqlUnion.getUnionQuery());
            if (unionQuery == null) continue;
            for (JetUConnection jetUConnection : conns = unionQuery.getConnections()) {
                retList.add(jetUConnection);
            }
        }
        JetUConnection[] ret = new JetUConnection[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    static {
        nameIdx.put("TransactionIsolation", new Integer(0));
        nameIdx.put("Name", new Integer(1));
        nameIdx.put("maxRows", new Integer(2));
        nameIdx.put("EnableSQLStmtCreator", new Integer(3));
        nameIdx.put("Description", new Integer(4));
        nameIdx.put("ReadOnly", new Integer(5));
        nameIdx.put("EnableSQLNameAnalyser", new Integer(6));
        nameIdx.put("Share", new Integer(7));
        nameIdx.put("pathName", new Integer(8));
        nameIdx.put("maxDuration", new Integer(9));
        nameIdx.put("PushDownGroupQuery", new Integer(10));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(10);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("pathName");
        grpItems.add("EnableSQLStmtCreator");
        grpItems.add("TransactionIsolation");
        grpItems.add("ReadOnly");
        grpItems.add("Share");
        grpItems.add("maxRows");
        grpItems.add("maxDuration");
        grpItems.add("PushDownGroupQuery");
        grpDesc.put(grpName, grpItems);
    }
}

