/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUQuery;
import jet.universe.JetURefQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.UMapTable;
import jet.util.HashVector;
import toolkit.db.PsqlSelColumn;

public abstract class JetUQueryField
extends JetUResourceEntity
implements JetUQueriableField {
    public JetString colName = new JetString(this, "ColumnName");
    public JetNumber sqlType = new JetNumber(this, "SQLType");
    public JetNumber precision = new JetNumber(this, "Precision");
    public JetNumber scale = new JetNumber(this, "Scale");
    public JetNumber nullable = new JetNumber(this, "Nullable");
    public JetNumber currency = new JetNumber(this, "Currency");
    public JetBoolean array = new JetBoolean(this, "Array");
    public JetBoolean bHide = new JetBoolean(this, "BHide");
    PsqlSelColumn col;
    private static final HashVector grpDesc = new HashVector(7);

    public JetUQueryField() {
    }

    public JetUQueryField(String strName, String strDesc, String strColName, int iSQLType, int iPrecision, int iScale, int iNullable) {
        this(strName, strDesc, strColName, iSQLType, iPrecision, iScale, iNullable, false);
    }

    public JetUQueryField(String strName, String strDesc, String strColName, int iSQLType, int iPrecision, int iScale, int iNullable, boolean bArray) {
        super(strName, strDesc);
        this.colName.set(strColName);
        this.sqlType.set(iSQLType);
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(iPrecision);
        this.scale.set(iScale);
        this.nullable.set(iScale);
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setPropertyChoice(DataTypeUtils.getIsCurrencyChoiceVector());
        this.array.set(bArray);
    }

    public JetUQueryField(String strName, String strDesc, PsqlSelColumn col) {
        super(strName, strDesc);
        this.col = col;
        this.colName.set(col.getName());
        this.sqlType.set(col.getType());
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(col.getPrecision());
        this.scale.set(col.getScale());
        this.nullable.set(col.getNullable());
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setPropertyChoice(DataTypeUtils.getIsCurrencyChoiceVector());
        this.array.set(col.getArray());
        col.setMappingName(strName);
        this.bHide.set(col.isHide());
    }

    @Override
    public void setResourceName(String rscName) {
        super.setResourceName(rscName);
        this.col.setMappingName(rscName);
    }

    @Override
    public String getFldName() {
        return this.colName.get();
    }

    public void setFldName(String strColName) {
        this.colName.set(strColName);
    }

    @Override
    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int iSQLType) {
        this.sqlType.set(iSQLType);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int iPrecision) {
        this.precision.set(iPrecision);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int iScale) {
        this.scale.set(iScale);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int iNullable) {
        this.nullable.set(iNullable);
    }

    public boolean getArray() {
        return this.array.get();
    }

    public void setArray(boolean bArray) {
        this.array.set(bArray);
    }

    @Override
    public DbColDesc getColDesc() {
        String name2 = this.getFldName();
        if (this instanceof JetURefQueryField) {
            name2 = this.getResourceName();
        }
        DbColDesc dcd = new DbColDesc(name2, this.getSqlType(), this.getPrecision(), this.getScale(), this.getNullable());
        if (this.currency.get() > 0) {
            dcd.setCurrency(true);
        }
        dcd.setArray(this.getArray());
        this.addCaseSensitiveInfo(dcd);
        this.addEncodingPattern(dcd);
        return dcd;
    }

    @Override
    public JetUQueriable getQueriable() {
        return this.getQuery();
    }

    @Override
    public String getQueriableName() {
        JetUQueriable jetUQueriable = this.getQueriable();
        if (jetUQueriable != null) {
            return jetUQueriable.getResourceName();
        }
        return null;
    }

    public JetUQuery getQuery() {
        return (JetUQuery)this.getParent();
    }

    public String getQueryName() {
        JetUQuery qry = this.getQuery();
        if (qry != null) {
            return qry.getResourceName();
        }
        return null;
    }

    public abstract String getDefaultMapingName();

    public PsqlSelColumn getPsqlSelColumn() {
        return this.col;
    }

    public boolean isNotResolved() {
        return this.col.isNotResolved();
    }

    @Override
    public String getDefinition() {
        return "real name: " + this.getQueryName() + "." + this.getFldName();
    }

    @Override
    public UMapTable getMapTable() {
        JetUQuery query = this.getQuery();
        if (query != null) {
            return query.getMapTable();
        }
        return null;
    }

    @Override
    public String toString() {
        String strParam = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this.getResourceName() + "|" + this.colName.get() + "|" + this.sqlType.get() + "|" + this.precision.get() + "|" + this.scale.get() + "|" + this.array.get() + "|" + " ]";
        return strParam;
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        return super.isSimilar(field) && this.sqlType.equal(((JetUQueryField)field).sqlType) && this.colName.equal(((JetUQueryField)field).colName);
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        return super.isSimilarExceptName(field) && this.sqlType.equal(((JetUQueryField)field).sqlType) && this.colName.equal(((JetUQueryField)field).colName);
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    static {
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(16);
        grpItems.add("SQLType");
        grpItems.add("Precision");
        grpItems.add("Scale");
        grpItems.add("Nullable");
        grpItems.add("Name");
        grpItems.add("DisplayWidth");
        grpItems.add("Description");
        grpItems.add("ColumnName");
        grpItems.add("Currency");
        grpItems.add("Array");
        grpDesc.put(grpName, grpItems);
    }
}

