/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import jet.JResource;
import jet.controls.JetDate;
import jet.controls.JetString;
import jet.universe.JetUDocFolder;
import jet.universe.JetUDocument;
import jet.util.WildcardMatcher;

public class JetUReportDoc
extends JetUDocument {
    public static final long DEFAULT_TIME = 0L;
    public JetString file = new JetString(this, "File");
    public JetString type = new JetString(this, "Type");
    public JetString queryName = new JetString(this, "QueryName");
    public JetString author = new JetString(this, "Author");
    public JetDate lastModifiedTime = new JetDate(this, "Last_Modified_Time");
    public JetDate lastRunTime = new JetDate(this, "Last_Run_Time");
    public JetDate lastPrintTime = new JetDate(this, "Last_Print_Time");
    public JetString keywords = new JetString(this, "Keywords");
    public boolean bDeleteFlag = false;
    private static final HashMap nameIdx = new HashMap(10);

    public JetUReportDoc() {
    }

    public JetUReportDoc(String strName, String strDesc, String strFile, String strType, String strQueryName, String strAuthor, String strKeywords, long lastModifiedTime, long lastRunTime, long lastPrintTime) {
        super(strName, strDesc);
        this.setFile(strFile);
        this.setType(strType);
        this.setQueryName(strQueryName);
        this.setAuthor(strAuthor);
        this.setKeywords(strKeywords);
        this.setLastModifiedTime(lastModifiedTime);
        this.setLastRunTime(lastRunTime);
        this.setLastPrintTime(lastPrintTime);
    }

    public String getFile() {
        return this.file.get();
    }

    public void setFile(String strFile) {
        this.file.set(strFile);
    }

    public String getType() {
        return this.type.get();
    }

    public void setType(String strType) {
        this.type.set(strType);
    }

    public String getQueryName() {
        return this.queryName.get();
    }

    public void setQueryName(String strQueryName) {
        this.queryName.set(strQueryName);
    }

    public String getAuthor() {
        return this.author.get();
    }

    public void setAuthor(String strAuthor) {
        this.author.set(strAuthor);
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime.get();
    }

    public String getLastModifiedTimeString() {
        long value = this.getLastModifiedTime();
        return value == 0L ? JResource.getMessage("ReportDateUnknown") : DateFormat.getDateTimeInstance().format(new Date(value));
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime.set(lastModifiedTime);
    }

    public long getLastRunTime() {
        return this.lastRunTime.get();
    }

    public String getLastRunTimeString() {
        long value = this.getLastRunTime();
        return value == 0L ? JResource.getMessage("ReportDateUnknown") : DateFormat.getDateTimeInstance().format(new Date(value));
    }

    public void setLastRunTime(long lastRunTime) {
        this.lastRunTime.set(lastRunTime);
    }

    public long getLastPrintTime() {
        return this.lastPrintTime.get();
    }

    public String getLastPrintTimeString() {
        long value = this.getLastPrintTime();
        return value == 0L ? JResource.getMessage("ReportDateUnknown") : DateFormat.getDateTimeInstance().format(new Date(value));
    }

    public void setLastPrintTime(long lastPrintTime) {
        this.lastPrintTime.set(lastPrintTime);
    }

    public String getKeywords() {
        return this.keywords.get();
    }

    public void setKeywords(String strKeywords) {
        this.keywords.set(strKeywords);
    }

    public void setDeleteFileFlag(boolean bFlag) {
        this.bDeleteFlag = bFlag;
    }

    @Override
    public boolean delete(boolean bDeleteFile) throws SecurityException {
        String strFileName;
        File rptFile;
        JetUDocFolder parentNode = (JetUDocFolder)this.getParent();
        if (bDeleteFile && (rptFile = new File(strFileName = parentNode.getUniverse().getFilePath() + this.getFile())).exists()) {
            rptFile.delete();
        }
        parentNode.remove(this);
        return true;
    }

    public String getPath() {
        return ((JetUDocFolder)this.getParent()).getLocator();
    }

    @Override
    public String getLocator() {
        return this.getPath() + "/" + this.getName();
    }

    public boolean isMatch(String strFind, boolean bIgnoreCase, boolean bInName, boolean bInKeywords) {
        boolean bMatch = false;
        if (bInName) {
            bMatch = super.isMatch(strFind, bIgnoreCase);
        }
        if (!bMatch && bInKeywords && !this.getKeywords().equals("")) {
            bMatch = WildcardMatcher.matchWildcard(this.getKeywords(), strFind, bIgnoreCase);
        }
        return bMatch;
    }

    public String toString() {
        return this.getLocator();
    }

    @Override
    public String getInstancePrefix() {
        return "ReportDoc";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Last_Run_Time", new Integer(0));
        nameIdx.put("Name", new Integer(1));
        nameIdx.put("Keywords", new Integer(2));
        nameIdx.put("Description", new Integer(3));
        nameIdx.put("QueryName", new Integer(4));
        nameIdx.put("File", new Integer(5));
        nameIdx.put("Last_Modified_Time", new Integer(6));
        nameIdx.put("Last_Print_Time", new Integer(7));
        nameIdx.put("Author", new Integer(8));
        nameIdx.put("Type", new Integer(9));
    }
}

