/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.log.JRLogger;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUTableView;
import jet.universe.UMapTable;

public abstract class JetUResourceContainer
extends JetUDBTreeNode
implements JetContainable {
    protected Vector children = new Vector();
    private static JRLogger logger = JRLogger.getLogger(JetUResourceContainer.class.getName());
    private static final int CountStep = 10;

    public JetUResourceContainer() {
    }

    public JetUResourceContainer(String strName, String strDesc) {
        super(strName, strDesc);
    }

    @Override
    public void InitAfterCreate() {
        this.AfterAdd();
    }

    @Override
    public void BeforeRemove() {
        UMapTable mapTable = this.getMapTable();
        if (mapTable != null) {
            this.RemoveEntitiesFromMapTable(mapTable);
        }
    }

    @Override
    public void AfterAdd() {
        UMapTable mapTable = this.getMapTable();
        if (mapTable != null) {
            this.AddEntitiesToMapTable(mapTable);
        }
    }

    @Override
    public Vector getChildren() {
        return (Vector)this.children.clone();
    }

    public Enumeration getChildrenEnumeration() {
        return this.children.elements();
    }

    @Override
    public JetObject add(JetObject child) {
        return this.add(child, -1);
    }

    public synchronized JetObject add(JetObject child, int pos) {
        if (child != null) {
            JetContainable parent = child.getParent();
            if (parent != null) {
                if (parent == this) {
                    return child;
                }
                parent.remove(child);
            }
            if (pos == -1) {
                this.children.addElement(child);
            } else {
                this.children.insertElementAt(child, pos);
            }
            child.setParent(this);
            this.objectModified();
        }
        return child;
    }

    @Override
    public JetObject remove(JetObject child) {
        this.objectModified();
        if (this.children.contains(child)) {
            this.children.removeElement(child);
            child.setParent(null);
        }
        return child;
    }

    public synchronized JetObject remove(int index) {
        return this.remove((JetObject)this.children.elementAt(index));
    }

    public void removeall() {
        Vector children = (Vector)this.getChildren().clone();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            this.remove((JetObject)children.elementAt(i));
        }
    }

    @Override
    public void broadcast(JetObject sender, int iMessage) {
        int iSize = this.children.size();
        int iIndex = 0;
        while (iIndex < iSize) {
            JetObject xobj;
            if ((xobj = (JetObject)this.children.elementAt(iIndex++)).equals(sender) || !(xobj instanceof JetContainable)) continue;
            ((JetContainable)((Object)xobj)).broadcast(sender, iMessage);
        }
    }

    void AddEntitiesToMapTable(UMapTable mapTable) {
        int stackSize = 10;
        Vector[] childrenStack = new Vector[stackSize];
        int[] childrenPointerStack = new int[stackSize];
        int SP = 0;
        JetObject currentObj = this;
        block0: do {
            Vector vecChildren;
            if (currentObj instanceof JetUResourceEntity) {
                mapTable.addElement((JetUResourceEntity)currentObj);
            }
            if (currentObj instanceof JetContainable && (vecChildren = ((JetContainable)((Object)currentObj)).getChildren()).size() != 0) {
                if (SP >= stackSize) {
                    Vector[] cs = new Vector[stackSize + 10];
                    int[] cps = new int[stackSize + 10];
                    System.arraycopy(childrenStack, 0, cs, 0, stackSize);
                    System.arraycopy(childrenPointerStack, 0, cps, 0, stackSize);
                    childrenStack = cs;
                    childrenPointerStack = cps;
                    stackSize += 10;
                }
                childrenStack[SP] = vecChildren;
                childrenPointerStack[SP] = 1;
                ++SP;
                currentObj = (JetObject)vecChildren.elementAt(0);
                continue;
            }
            while (SP > 0) {
                int t = childrenPointerStack[SP - 1];
                vecChildren = childrenStack[SP - 1];
                if (t < vecChildren.size()) {
                    currentObj = (JetObject)vecChildren.elementAt(t);
                    int n = SP - 1;
                    childrenPointerStack[n] = childrenPointerStack[n] + 1;
                    continue block0;
                }
                --SP;
            }
        } while (SP > 0);
    }

    void RemoveEntitiesFromMapTable(UMapTable mapTable) {
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (child instanceof JetUResourceContainer) {
                ((JetUResourceContainer)child).RemoveEntitiesFromMapTable(mapTable);
            }
            if (!(child instanceof JetUResourceEntity)) continue;
            mapTable.removeElement((JetUResourceEntity)child);
        }
    }

    public boolean isSimilar(JetUResourceContainer container) {
        if (!(this.getClass().getName().equals(container.getClass().getName()) || this instanceof JetUTableView || container instanceof JetUTableView)) {
        }
        return this.name.equal(container.name) && (this instanceof JetUTableView && container instanceof JetUTableView || this.getClass().getName().equals(container.getClass().getName())) && this.isEqualChildren(container);
    }

    public boolean isEqualChildren(JetUResourceContainer container) {
        Vector children = this instanceof JetUQueriable ? ((JetUQueriable)((Object)this)).getFields() : this.getChildren();
        Vector tChildren = container instanceof JetUQueriable ? ((JetUQueriable)((Object)container)).getFields() : container.getChildren();
        boolean bRet = children.size() <= tChildren.size();
        boolean isQuery = container instanceof JetUQuery;
        if (bRet) {
            for (int i = 0; i < children.size(); ++i) {
                if (children.get(i) instanceof JetUDBTreeNode) {
                    JetUDBTreeNode child = (JetUDBTreeNode)children.get(i);
                    JetUDBTreeNode tChild = JetUResourceContainer.findNodeByName(tChildren, child.getResourceName());
                    if (tChild == null) {
                        bRet = false;
                        break;
                    }
                    if (!isQuery || !(child instanceof JetUFldQueryField) || !child.getClass().getName().equals(tChild.getClass().getName()) || (bRet = ((JetUFldQueryField)child).getTableName().equalsIgnoreCase(((JetUFldQueryField)tChild).getTableName()))) continue;
                    break;
                }
                JetObject childObject = (JetObject)children.get(i);
                JetObject nodeObject = null;
                if (!container.getUniverse().getFullFileName().equalsIgnoreCase(this.getUniverse().getFullFileName())) continue;
                boolean isEqualObject = false;
                for (int j = 0; j < tChildren.size(); ++j) {
                    if (!(tChildren.get(j) instanceof JetObject) || !(nodeObject = (JetObject)tChildren.get(j)).getInstName().equals(childObject.getInstName())) continue;
                    isEqualObject = true;
                    break;
                }
                if (isEqualObject) continue;
                bRet = false;
                break;
            }
        }
        return bRet;
    }

    public boolean isEqual(JetUResourceContainer container) {
        boolean bRet = super.isEqual(container);
        if (bRet) {
            bRet = this.isEqualChildren(container);
        }
        return bRet;
    }

    @Override
    public boolean isSimilar(JetUDBTreeNode container) {
        return container instanceof JetUResourceContainer && this.isSimilar((JetUResourceContainer)container);
    }

    @Override
    public boolean isEqual(JetUDBTreeNode container) {
        return container instanceof JetUResourceContainer && this.isEqual((JetUResourceContainer)container);
    }

    Vector getChildren(String className) {
        Vector<JetObject> ret = new Vector<JetObject>(1);
        for (int i = 0; i < this.children.size(); ++i) {
            JetObject obj = (JetObject)this.children.get(i);
            if (!obj.getClass().getName().equals(className)) continue;
            ret.add(obj);
        }
        return ret;
    }

    Vector getExtChildren(String className) {
        Class<?> cls;
        Vector<JetObject> ret;
        block3: {
            ret = new Vector<JetObject>(1);
            cls = null;
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error("", e);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            JetObject obj = (JetObject)this.children.get(i);
            if (!cls.isAssignableFrom(obj.getClass())) continue;
            ret.add(obj);
        }
        return ret;
    }

    public boolean equalTo(JetUResourceContainer container) {
        return this.isEqual(container);
    }

    @Override
    public boolean equalsTo(JetUDBTreeNode node) {
        return this.isEqual(node);
    }

    public boolean isEqualTo(JetUResourceContainer container) {
        return this.isEqual(container);
    }
}

