/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.awt.Event;
import jet.JResource;
import jet.connect.Db;
import jet.connect.DbColDesc;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.dataengine.util.DSLog;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.SupportedSQLType;
import jet.universe.UMapTable;

public abstract class JetUResourceEntity
extends JetUDBTreeNode {
    private static char chTransfer = (char)92;
    private static String sQuote = "\"";
    public JetString guiField = new JetString(this, "GUIField");
    public JetString dataMappingFile = new JetString(this, "DataMappingFile");
    public JetUnitNumber displaywidth;
    private String strNameInUpperCase;
    private static JRLogger logger = JRLogger.getLogger(JetUResourceEntity.class.getName());
    protected static DSLog log = DSLog.getDSLog(JetUResourceEntity.class.getName());

    public JetUResourceEntity() {
        this.dataMappingFile.setCanChangeByOthers(false);
        this.dataMappingFile.setEditorType(JetString.COMBO_EDITOR);
        this.displaywidth = new JetUnitNumber(this, "DisplayWidth");
        this.strNameInUpperCase = null;
        this.guiField.set("Standard_DBField");
        this.displaywidth.set(0);
    }

    public JetUResourceEntity(String strName, String strDescription) {
        super(strName, strDescription);
        this.dataMappingFile.setCanChangeByOthers(false);
        this.dataMappingFile.setEditorType(JetString.COMBO_EDITOR);
        this.displaywidth = new JetUnitNumber(this, "DisplayWidth");
        this.strNameInUpperCase = null;
        this.guiField.set("Standard_DBField");
        this.displaywidth.set(0);
        this.strNameInUpperCase = this.name.get().toUpperCase();
    }

    @Override
    public void setResourceName(String strName) {
        String strOldName = this.strNameInUpperCase;
        super.setResourceName(strName);
        UMapTable mapTable = this.getMapTable();
        if (mapTable != null) {
            mapTable.updateElementName(this, strOldName);
        }
    }

    public String getResourceNameInUpperCase() {
        return this.strNameInUpperCase;
    }

    public boolean IsTypeSupported() {
        DbColDesc desc = this.getColDesc();
        if (desc != null) {
            return SupportedSQLType.isSupported(desc);
        }
        return true;
    }

    public String getGUIField() {
        return this.guiField.get();
    }

    public void setGUIField(String strGuiField) {
        this.guiField.set(strGuiField);
    }

    public void createDescription() {
        DbColDesc coldesc = this.getColDesc();
        if (coldesc != null) {
            this.setDesc(JResource.getMessage("CAT_41", (Object)Db.toTypeString(coldesc.sqlType)));
        } else {
            this.setDesc("");
        }
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.id == -1000 && evt.arg != null && ((String)evt.arg).equalsIgnoreCase("Name")) {
            this.strNameInUpperCase = this.name.get().toUpperCase();
        }
        return super.handleEvent(evt);
    }

    @Override
    public void InitAfterLoad() {
        this.strNameInUpperCase = this.name.get().toUpperCase();
        this.guiField.setEditFlag(3);
        super.InitAfterLoad();
    }

    @Override
    public void InitAfterCreate() {
        this.strNameInUpperCase = this.name.get().toUpperCase();
        if (this.desc.get() == null || this.desc.get().length() == 0) {
            this.createDescription();
        }
        this.guiField.setEditFlag(3);
        this.AfterAdd();
    }

    @Override
    public void BeforeRemove() {
        UMapTable mapTable = this.getMapTable();
        if (mapTable != null) {
            mapTable.removeElement(this);
        }
    }

    @Override
    public void AfterAdd() {
        UMapTable mapTable = this.getMapTable();
        if (mapTable != null) {
            mapTable.addElement(this);
        }
    }

    public static String transferQuote(String s) {
        StringBuffer sBuffer = new StringBuffer(s);
        for (int i = 0; i < sBuffer.length(); ++i) {
            char ch = sBuffer.charAt(i);
            if (ch != '\"' && ch != '\\') continue;
            sBuffer = sBuffer.insert(i, chTransfer);
            ++i;
        }
        return sBuffer.toString();
    }

    private static boolean canCastAsIdentifer(String s) {
        char ch = s.charAt(0);
        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_')) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static String qutoedWhenNeed(String s) {
        if (!JetUResourceEntity.canCastAsIdentifer(s)) {
            s = sQuote + s + sQuote;
        }
        return "@" + s;
    }

    public String getResourceNameString() {
        String sIdentifier = new String(this.name.get());
        sIdentifier = JetUResourceEntity.transferQuote(sIdentifier);
        sIdentifier = JetUResourceEntity.qutoedWhenNeed(sIdentifier);
        return sIdentifier;
    }

    JetObject getDefaultGUIFieldObject() {
        try {
            return (JetObject)Class.forName("jet.report.JetRptDBField").newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    void initGUIFieldObject(JetObject guiFieldObj) {
        guiFieldObj.nameToProperty("ColumnName").set(this.getResourceName());
    }

    public JetObject getGUIFieldObject(StringBuffer error) {
        JetObject objReturn = null;
        objReturn = this.getDefaultGUIFieldObject();
        if (objReturn != null) {
            this.initGUIFieldObject(objReturn);
        }
        return objReturn;
    }

    public boolean isMediaField() {
        boolean bRet = false;
        DbColDesc colDesc = this.getColDesc();
        if (colDesc != null) {
            bRet = colDesc.getSqlType() == -2 || colDesc.getSqlType() == -3 || colDesc.getSqlType() == -4;
        }
        return bRet;
    }

    public abstract DbColDesc getColDesc();

    public abstract String getDefinition();

    @Override
    public abstract String toString();

    public String getRealName() {
        return null;
    }

    public void addCaseSensitiveInfo(DbColDesc dbc) {
        JetUConnection Connt;
        JetUDatabase db = this.getDatabase();
        if (db != null && (Connt = db.getConnection()) != null) {
            dbc.setIgnoreCase(!Connt.isSQLTypeCaseSensitive(dbc.getSqlType()));
        }
    }

    public void addEncodingPattern(DbColDesc dbc) {
        JetUConnection Connt;
        JetUDatabase db = this.getDatabase();
        if (db != null && (Connt = db.getConnection()) != null) {
            int iEncodingOpt = Connt.getEncodingPattern();
            if (iEncodingOpt == 0) {
                dbc.setNotAutoEncode(false);
            } else {
                dbc.setNotAutoEncode(true);
            }
            if (iEncodingOpt == 1) {
                dbc.setEncode(true);
            }
            if (iEncodingOpt == 2) {
                dbc.setEncode(false);
            }
        }
    }

    public boolean isSimilar(JetUResourceEntity field) {
        return this.name.equal(field.name) && this.getClass().getName().equals(field.getClass().getName());
    }

    @Override
    public boolean isSimilar(JetUDBTreeNode field) {
        return field instanceof JetUResourceEntity && this.isSimilar((JetUResourceEntity)field);
    }

    public boolean isSimilarExceptName(JetUResourceEntity field) {
        return this.getClass().getName().equals(field.getClass().getName());
    }

    public String getDataMappingFile() {
        if (this.dataMappingFile.isCurrentAutoValue()) {
            String ret = this.getDataMappingFileAuto();
            if (log.isDebugAll()) {
                String logMsg = "ResourceName = " + this.getResourceName() + " dataMappingFile is <Auto> inherit = " + ret;
                log.debugAll(logMsg, null);
            }
            return ret;
        }
        String ret = this.dataMappingFile.get();
        if (log.isDebugAll()) {
            String logMsg = "ResourceName = " + this.getResourceName() + " dataMappingFile = " + ret;
            log.debugAll(logMsg, null);
        }
        return ret;
    }

    public String getDataMappingFileAuto() {
        return "";
    }

    public void setDataMappingFile(String dataMappingFile) {
        if (log.isDebugAll()) {
            String logMsg = "ResourceName = " + this.getResourceName() + " setDataMappingFile = " + dataMappingFile;
            log.debugAll(logMsg);
        }
        this.dataMappingFile.set(dataMappingFile);
    }
}

