/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetEnumeration;
import jet.controls.JetFont;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetPropertyGroup;
import jet.controls.JetStringList;
import jet.controls.JetUnitNumber;
import jet.log.JRLogger;
import jet.naming.EnumerationConstant;
import jet.naming.PropertyNameConstant;
import jet.report.JetRptBorderStyle;
import jet.report.JetRptLineWidth;
import jet.universe.JetUFileQuery;
import jet.universe.JetUResourceEntity;
import jet.util.HashVector;
import jet.util.ReportFormat;
import jet.util.ValueToUnit;

public abstract class JetUResourceField
extends JetUResourceEntity
implements PainterConstants {
    private static JRLogger logger = JRLogger.getLogger(JetUFileQuery.class.getName());
    protected static final int DEFAULT_FONTSIZE = Unit.convertInchToUnit(0.125);
    public JetColor backColor = new JetColor(this, "Background", null, true);
    public JetColor fontColor = new JetColor(this, "Foreground", Color.black);
    public JetUnitNumber width = new JetUnitNumber(this, "Width");
    public JetUnitNumber height = new JetUnitNumber(this, "Height");
    public JetFont fontName = new JetFont(this, "FontFace");
    public JetUnitNumber fontSize = new JetUnitNumber(this, "FontSize");
    public JetBoolean bold = new JetBoolean(this, "Bold", false);
    public JetBoolean italic = new JetBoolean(this, "Italic", false);
    public JetBoolean strikeout = new JetBoolean(this, "StrikeOut", false);
    public JetBoolean underline = new JetBoolean(this, "Underline", false);
    public JetEnumeration align = new JetEnumeration(this, "Alignment", 0);
    public JetEnumeration patternStyle = new JetEnumeration(this, "PatternStyle", 78);
    public JetColor patternColor = new JetColor(this, "PatternColor", Color.black, false);
    public JetStringList format = new JetStringList(this, "Format");
    public JetBoolean autoFit = new JetBoolean(this, "AutoFit", false);
    public JetBoolean wordWrap = new JetBoolean(this, "WordWrap", false);
    public JetRptLineWidth borderWidth = new JetRptLineWidth(this, "BorderWidth");
    public JetRptBorderStyle top = new JetRptBorderStyle(this, "TopLine");
    public JetRptBorderStyle bottom = new JetRptBorderStyle(this, "BottomLine");
    public JetRptBorderStyle left = new JetRptBorderStyle(this, "LeftLine");
    public JetRptBorderStyle right = new JetRptBorderStyle(this, "RightLine");
    public JetColor borderColor = new JetColor(this, "BorderColor", Color.black);
    public JetBoolean drawShadow = new JetBoolean(this, "Shadow");
    public JetColor shadowColor = new JetColor(this, "ShadowColor", Color.black);
    public JetEnumeration HAlignment = new JetEnumeration(this, PropertyNameConstant.getNameByID(PropertyNameConstant.HORIZONTALALIGNMENT), 2);
    public JetEnumeration VAlignment = new JetEnumeration(this, PropertyNameConstant.getNameByID(PropertyNameConstant.VERTICALALIGNMENT), 6);
    public JetUnitNumber topPadding = new JetUnitNumber(this, "padding-top");
    public JetUnitNumber bottomPadding = new JetUnitNumber(this, "padding-bottom");
    public JetUnitNumber leftPadding = new JetUnitNumber(this, "padding-left");
    public JetUnitNumber rightPadding = new JetUnitNumber(this, "padding-right");

    public JetUResourceField() {
        this.init();
    }

    public JetUResourceField(String strName, String strDescription) {
        super(strName, strDescription);
        this.init();
    }

    void init() {
        this.topPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.01));
        this.bottomPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.01));
        this.leftPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.03));
        this.rightPadding.setUnitValue(ValueToUnit.convertInchToUnit(0.03));
        this.patternStyle.set(new Integer(0));
        this.top.set(new Integer(0));
        this.bottom.set(new Integer(0));
        this.left.set(new Integer(0));
        this.right.set(new Integer(0));
        this.fontSize.setUnitValue(DEFAULT_FONTSIZE);
        this.align.set(new Integer(5));
        this.HAlignment.set(new Integer(0));
        this.VAlignment.set(new Integer(0));
    }

    public void setHAlignmentDefault(int sqlDataType) {
        this.HAlignment.set(EnumerationConstant.ALIGNMENT_HOR_STR_NAMES[DataTypeUtils.getDefaultHAlignment(sqlDataType)]);
    }

    public void setVAlignmentDefault(int sqlDataType) {
        this.VAlignment.set(EnumerationConstant.ALIGNMENT_VER_STR_NAMES[DataTypeUtils.getDefaultVAlignment(sqlDataType)]);
    }

    public void setFormatDefault(int sqlDataType) {
        this.format.setDefault(DataTypeUtils.getDefaultFormat(sqlDataType));
    }

    public void copyInitProperties(JetUResourceField src, JetObject dest) {
        HashVector groups = (HashVector)src.getEditableProperties();
        for (int i = 0; i < groups.size(); ++i) {
            String name2 = (String)groups.elementAt(i);
            if (name2.equals("General")) continue;
            JetPropertyGroup group = (JetPropertyGroup)groups.get(name2);
            Vector props = group.getProperties();
            for (int j = 0; j < props.size(); ++j) {
                JetProperty srcProp = (JetProperty)props.elementAt(j);
                JetProperty prop = dest.nameToProperty(srcProp.getName());
                if (prop == null) continue;
                try {
                    prop.setUnitValue(srcProp.toUnitString());
                    continue;
                }
                catch (Exception exp) {
                    logger.debug(exp);
                }
            }
        }
    }

    public Hashtable copyInitProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        HashVector groups = (HashVector)this.getEditableProperties();
        for (int i = 0; i < groups.size(); ++i) {
            String name2 = (String)groups.elementAt(i);
            if (name2.equals("General")) continue;
            JetPropertyGroup group = (JetPropertyGroup)groups.get(name2);
            Vector props = group.getProperties();
            for (int j = 0; j < props.size(); ++j) {
                JetProperty srcProp = (JetProperty)props.elementAt(j);
                properties.put(srcProp.getName(), srcProp.toUnitString());
            }
        }
        return properties;
    }

    public Hashtable copyInitNoGeomtryProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        HashVector groups = (HashVector)this.getEditableProperties();
        for (int i = 0; i < groups.size(); ++i) {
            String name2 = (String)groups.elementAt(i);
            if (name2.equals("General") || name2.equals("Geometry")) continue;
            JetPropertyGroup group = (JetPropertyGroup)groups.get(name2);
            Vector props = group.getProperties();
            for (int j = 0; j < props.size(); ++j) {
                JetProperty srcProp = (JetProperty)props.elementAt(j);
                properties.put(srcProp.getName(), srcProp.toUnitString());
            }
        }
        return properties;
    }

    public void copyInitNoGeomtryProperties(JetUResourceField src, JetObject dest) {
        HashVector groups = (HashVector)src.getEditableProperties();
        for (int i = 0; i < groups.size(); ++i) {
            String name2 = (String)groups.elementAt(i);
            if (name2.equals("General") || name2.equals("Geometry")) continue;
            JetPropertyGroup group = (JetPropertyGroup)groups.get(name2);
            Vector props = group.getProperties();
            for (int j = 0; j < props.size(); ++j) {
                JetProperty srcProp = (JetProperty)props.elementAt(j);
                JetProperty prop = dest.nameToProperty(srcProp.getName());
                if (prop == null) continue;
                try {
                    prop.setUnitValue(srcProp.toUnitString());
                    continue;
                }
                catch (Exception exp) {
                    logger.debug(exp);
                }
            }
        }
    }

    @Override
    public void afterInit() {
        super.afterInit();
        JetProperty sqlType = this.nameToProperty("SQLType");
        JetProperty precision = this.nameToProperty("Precision");
        if (sqlType != null && precision != null) {
            Vector formats = ReportFormat.getMoreFormat(((JetNumber)sqlType).get(), ((JetNumber)precision).get());
            this.format.setList(formats);
        }
    }
}

