/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.JetObjInspector.ObjectInfo;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.export.style.StyleLoader;
import jet.universe.JetUStyle;
import jet.universe.JetUStyleNode;
import jet.universe.JetUTree;

public class JetUStyleGroup
extends JetUTree
implements JetUStyle {
    public JetString groupName = new JetString(this, "GroupName");
    public JetString desc = new JetString(this, "Description");
    transient ObjectInfo objInfo = null;
    private Vector renameGrp = new Vector();
    private Hashtable typeStyle = new Hashtable();
    private static final HashMap nameIdx = new HashMap(2);

    public JetUStyleGroup() {
    }

    public JetUStyleGroup(String name2, String des) {
        this.setName(name2);
        this.setDesc(des);
        this.groupName.setEditFlag(0);
    }

    public JetUStyleGroup addStyleGroup(JetUStyleGroup stlGrp) {
        String grpName = stlGrp.getName();
        this.add(stlGrp);
        if (StyleLoader.loadedGroups.contains(grpName)) {
            StyleLoader.loadedGroups.remove(grpName);
        }
        StyleLoader.loadedGroups.put(grpName, stlGrp);
        return stlGrp;
    }

    @Override
    public void delete() {
        this.deleteStyleGroup();
    }

    public void deleteStyleGroup() {
        JetUStyleGroup root = (JetUStyleGroup)this.getParent();
        if (root != null) {
            root.removeSubNodes(this);
            root.remove(this);
            StyleLoader.loadedGroups.remove(this.getName());
        }
    }

    public Vector getAllGroupNames(Vector grpNames) {
        Enumeration groups = this.getChildren().elements();
        JetUStyleGroup grp = null;
        while (groups.hasMoreElements()) {
            JetObject obj = (JetObject)groups.nextElement();
            if (!(obj instanceof JetUStyleGroup)) continue;
            grp = (JetUStyleGroup)obj;
            grpNames.add(grp.getName());
            if (!grp.hasStyleGroup()) continue;
            grpNames = grp.getAllGroupNames(grpNames);
        }
        return grpNames;
    }

    public JetUStyleGroup getGroupByName(String grpName) {
        Enumeration groups = this.getChildren().elements();
        JetUStyleGroup grp = null;
        while (groups.hasMoreElements()) {
            JetObject obj = (JetObject)groups.nextElement();
            if (!(obj instanceof JetUStyleGroup)) continue;
            grp = (JetUStyleGroup)obj;
            if (grp.getName().equalsIgnoreCase(grpName)) {
                return grp;
            }
            if ((grp = grp.getGroupByName(grpName)) == null) continue;
            break;
        }
        return grp;
    }

    public JetUStyleNode getStyleByName(String stlName) {
        Enumeration stls = this.getChildren().elements();
        while (stls.hasMoreElements()) {
            String name2;
            JetObject stl = (JetObject)stls.nextElement();
            if (!(stl instanceof JetUStyleNode) || (name2 = ((JetUStyleNode)stl).getName()) == null || name2.trim().length() <= 0 || !name2.equalsIgnoreCase(stlName)) continue;
            return (JetUStyleNode)stl;
        }
        return null;
    }

    public Vector getStyleNameByType(String type) {
        this.typeStyle.put(type, this.getStlNamesByType(type));
        return (Vector)this.typeStyle.get(type);
    }

    private Vector getStlNamesByType(String stlType) {
        Vector stls = this.getStyleByType(stlType);
        Vector<String> names = new Vector<String>();
        names.add(0, stlType);
        names.add(1, "None");
        for (int i = 0; i < stls.size(); ++i) {
            JetUStyleNode stl = (JetUStyleNode)stls.elementAt(i);
            if (names.contains(stl.getName())) continue;
            names.add(stl.getName());
        }
        return names;
    }

    public Vector getStyleByType(String stlType) {
        Enumeration stls = this.getChildren().elements();
        Vector<JetUStyleNode> ret = new Vector<JetUStyleNode>();
        while (stls.hasMoreElements()) {
            String type;
            JetObject stl = (JetObject)stls.nextElement();
            if (!(stl instanceof JetUStyleNode) || (type = ((JetUStyleNode)stl).getType()) == null || type.trim().length() <= 0 || !type.equalsIgnoreCase(stlType)) continue;
            ret.add((JetUStyleNode)stl);
        }
        return ret;
    }

    public boolean hasStyleNode() {
        Enumeration children = this.getChildren().elements();
        while (children.hasMoreElements()) {
            if (!(children.nextElement() instanceof JetUStyleNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStyleGroup() {
        Enumeration children = this.getChildren().elements();
        while (children.hasMoreElements()) {
            if (!(children.nextElement() instanceof JetUStyleGroup)) continue;
            return true;
        }
        return false;
    }

    public JetUStyleGroup dupGroup(String name2) {
        JetUStyleGroup grp = new JetUStyleGroup(name2, this.getDesc());
        Enumeration children = this.getChildren().elements();
        while (children.hasMoreElements()) {
            JetUStyle stl = (JetUStyle)children.nextElement();
            if (!(stl instanceof JetUStyleNode)) continue;
            JetUStyleNode style = (JetUStyleNode)stl;
            String objType = style.getType();
            JetUStyleNode newStl = style.dupStyle();
            if (newStl == null) continue;
            grp.add(newStl);
        }
        return grp;
    }

    public void removeSubNodes(JetUStyleGroup node) {
        Vector subNodesVec = (Vector)node.getChildren().clone();
        JetUStyle subNode = null;
        for (int i = 0; i < subNodesVec.size(); ++i) {
            subNode = (JetUStyle)subNodesVec.elementAt(i);
            if (subNode instanceof JetUStyleNode) {
                ((JetUStyleNode)subNode).deleteStyle();
                continue;
            }
            ((JetUStyleGroup)subNode).deleteStyleGroup();
        }
    }

    public void removeStlNode(String stlName) {
        JetUStyleNode node = this.getStyleByName(stlName);
        if (node != null) {
            node.deleteStyle();
        }
    }

    public void removeGrpNode(String grpName) {
        JetUStyleGroup node = this.getGroupByName(grpName);
        if (node != null) {
            node.deleteStyleGroup();
        }
    }

    public JetUStyleNode addStyle(JetUStyleNode style) {
        this.add(style);
        return style;
    }

    public JetUStyleNode addStyle(JetObject obj, String stlName, String objType, String desc) {
        JetUStyleNode style = new JetUStyleNode(obj, stlName, objType, desc);
        return this.addStyle(style);
    }

    protected void createObjectInfo() {
        this.objInfo = new ObjectInfo(this, null);
    }

    @Override
    public ObjectInfo getObjectInfo() {
        if (this.objInfo == null) {
            this.createObjectInfo();
        }
        return this.objInfo;
    }

    public void addRenameGrp(String grpName) {
        this.renameGrp.add(grpName);
    }

    public Vector getRenameGrp() {
        return this.renameGrp;
    }

    @Override
    public void setName(String value) {
        this.groupName.set(value);
    }

    @Override
    public String getName() {
        return this.groupName.get();
    }

    public String getFileName(String groupName) {
        return groupName + "_stl.xsd";
    }

    @Override
    public void setDesc(String value) {
        this.desc.set(value);
    }

    @Override
    public String getDesc() {
        return this.desc.get();
    }

    @Override
    public String getInstancePrefix() {
        return "StyleGroup";
    }

    public static boolean isValidName(String strClassName) {
        if (strClassName == null || strClassName.length() == 0) {
            return false;
        }
        int length = strClassName.length();
        char c = strClassName.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = strClassName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("GroupName", new Integer(1));
    }
}

