/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.JetObjInspector.ObjectInfo;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetPropertyGroup;
import jet.controls.JetString;
import jet.export.xml.XMLToObject;
import jet.log.JRLogger;
import jet.universe.JetUStyle;
import jet.universe.JetUStyleGroup;
import jet.universe.JetUTreeNode;
import jet.util.HashVector;

public class JetUStyleNode
extends JetUTreeNode
implements JetUStyle {
    public JetString stlName = new JetString(this, "StyleName");
    public JetString stlType = new JetString(this, "StyleType");
    public JetString des = new JetString(this, "Description");
    transient ObjectInfo objInfo = null;
    JetObject srcObj = null;
    private Hashtable props = null;
    private static JRLogger logger;
    public static Hashtable styleTypes;
    private static final HashMap nameIdx;

    public JetUStyleNode() {
        logger = JRLogger.getLogger(JetUStyleNode.class.getName());
    }

    public JetUStyleNode(Hashtable props, String name2, String objType, String desc) {
        logger = JRLogger.getLogger(JetUStyleNode.class.getName());
        this.props = props;
        this.setName(name2);
        this.setType(objType);
        this.setDesc(desc);
    }

    public JetUStyleNode(JetObject obj, String name2, String objType, String desc) {
        logger = JRLogger.getLogger(JetUStyleNode.class.getName());
        this.setName(name2);
        this.setType(objType);
        this.setDesc(desc);
        this.setSrcObject(obj);
        this.stlName.setEditFlag(0);
        this.stlType.setEditFlag(0);
        this.addPropertyGroupDirectly("Style");
        this.addPropertytoGroupDirectly("StyleName", "Style");
        this.addPropertytoGroupDirectly("StyleType", "Style");
        this.addPropertytoGroupDirectly("Description", "Style");
        this.transProperties(obj);
    }

    private void setSrcObject(JetObject obj) {
        this.srcObj = obj;
    }

    public JetObject getSrcObject() {
        return this.srcObj;
    }

    public void transProperties(JetObject oldObj) {
        Hashtable oldProps = new Hashtable();
        HashVector oldPropGrps = new HashVector();
        oldPropGrps = oldObj.getPropertyGroups();
        Enumeration grpNames = oldPropGrps.keys();
        Hashtable _props = new Hashtable();
        boolean by = false;
        boolean bx = false;
        boolean tx = false;
        boolean ty = false;
        while (grpNames.hasMoreElements()) {
            this.addPropertyGroupDirectly((String)grpNames.nextElement());
        }
        oldProps = oldObj.getProperties();
        if (oldProps.containsKey("TopAttachPosX")) {
            _props.put("TopAttachPosX", oldProps.get("TopAttachPosX"));
            oldProps.remove("TopAttachPosX");
            tx = true;
        }
        if (oldProps.containsKey("TopAttachPosY")) {
            _props.put("TopAttachPosY", oldProps.get("TopAttachPosY"));
            oldProps.remove("TopAttachPosY");
            ty = true;
        }
        if (oldProps.containsKey("BottomAttachPosY")) {
            _props.put("BottomAttachPosY", oldProps.get("BottomAttachPosY"));
            oldProps.remove("BottomAttachPosY");
            by = true;
        }
        if (oldProps.containsKey("BottomAttachPosX")) {
            _props.put("BottomAttachPosX", oldProps.get("BottomAttachPosX"));
            oldProps.remove("BottomAttachPosX");
            bx = true;
        }
        oldProps.remove("StyleName");
        oldProps.remove("StyleType");
        oldProps.remove("Description");
        Enumeration e = oldProps.keys();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            this.addProperty((JetProperty)oldProps.get(propName));
            this.addPropertytoGroupDirectly(propName, oldObj.getGroupNamebyPropName(propName));
        }
        if (tx) {
            this.add((JetProperty)_props.get("TopAttachPosX"));
            this.addPropertytoGroupDirectly("TopAttachPosX", "Geometry");
        }
        if (ty) {
            this.add((JetProperty)_props.get("TopAttachPosY"));
            this.addPropertytoGroupDirectly("TopAttachPosY", "Geometry");
        }
        if (bx) {
            this.add((JetProperty)_props.get("BottomAttachPosX"));
            this.addPropertytoGroupDirectly("BottomAttachPosX", "Geometry");
        }
        if (by) {
            this.add((JetProperty)_props.get("BottomAttachPosY"));
            this.addPropertytoGroupDirectly("BottomAttachPosY", "Geometry");
        }
    }

    @Override
    public void delete() {
        this.deleteStyle();
    }

    public boolean deleteStyle() {
        JetUStyleGroup parentNode = (JetUStyleGroup)this.getParent();
        if (parentNode != null) {
            parentNode.remove(this);
        }
        return true;
    }

    public JetUStyleNode dupStyle() {
        JetUStyleNode newStl;
        block6: {
            String objType = this.getType();
            newStl = null;
            try {
                JetObject obj = XMLToObject.createObject(XMLToObject.getTag(objType));
                JetUStyleNode _stl = new JetUStyleNode();
                obj.addPropertyGroup("Style");
                Enumeration _props = _stl.getProperties().keys();
                while (_props.hasMoreElements()) {
                    String _pname = (String)_props.nextElement();
                    obj.add(_stl.nameToProperty(_pname));
                    obj.addPropertyToGroup(_pname, "Style");
                }
                Hashtable<String, JetProperty> objProps = new Hashtable<String, JetProperty>();
                Enumeration stlProps = this.getProperties().keys();
                while (stlProps.hasMoreElements()) {
                    String pname = (String)stlProps.nextElement();
                    objProps.put(pname, obj.nameToProperty(pname));
                }
                Hashtable prop2Grp = this.getPropNameToGroupNameTbl(obj);
                obj.removePropertiesAndGroups();
                Enumeration proNames = objProps.keys();
                while (proNames.hasMoreElements()) {
                    String proName = (String)proNames.nextElement();
                    String grpName = (String)prop2Grp.get(proName);
                    obj.add((JetProperty)objProps.get(proName));
                    JetProperty oprop = obj.nameToProperty(proName);
                    JetProperty sprop = this.nameToProperty(proName);
                    oprop.set(sprop.toString());
                    if (!obj.isIncludePropertyGroupDirectly(grpName)) {
                        obj.addPropertyGroupDirectly(grpName);
                    }
                    obj.addPropertytoGroupDirectly(proName, grpName);
                }
                newStl = new JetUStyleNode(obj, this.getName(), objType, this.getDesc());
            }
            catch (Exception ex) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error("", ex);
            }
        }
        return newStl;
    }

    protected void createObjectInfo() {
        this.objInfo = new ObjectInfo(this, null);
    }

    @Override
    public ObjectInfo getObjectInfo() {
        if (this.objInfo == null) {
            this.createObjectInfo();
        }
        return this.objInfo;
    }

    @Override
    public void setName(String tagName) {
        this.stlName.set(tagName);
    }

    @Override
    public String getName() {
        return this.stlName.get();
    }

    public String getType() {
        return this.stlType.get();
    }

    public String getImgType() {
        return (String)styleTypes.get(this.stlType.get());
    }

    public void setType(String objType) {
        this.stlType.set(objType);
    }

    @Override
    public void setDesc(String value) {
        this.des.set(value);
    }

    @Override
    public String getDesc() {
        return this.des.get();
    }

    public Hashtable getObjProperties() {
        return this.props;
    }

    @Override
    public String getInstancePrefix() {
        return "StyleNode";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    private Hashtable getPropNameToGroupNameTbl(JetObject object) {
        HashVector groups = object.getPropertyGroups();
        Hashtable<String, String> retTbl = new Hashtable<String, String>(10, 1.0f);
        if (groups == null) {
            return retTbl;
        }
        Enumeration keys = groups.elements();
        while (keys.hasMoreElements()) {
            JetPropertyGroup group = (JetPropertyGroup)groups.get(keys.nextElement());
            String grpName = group.getName();
            Vector props = group.getProperties();
            for (int i = 0; i < props.size(); ++i) {
                retTbl.put(((JetProperty)props.get(i)).getName(), grpName);
            }
        }
        return retTbl;
    }

    static {
        styleTypes = new Hashtable();
        styleTypes.put("ArcShape", "ArcShape");
        styleTypes.put("Box", "Box");
        styleTypes.put("Line", "Line");
        styleTypes.put("OvalShape", "OvalShape");
        styleTypes.put("RoundBoxShape", "RoundBoxShape");
        styleTypes.put("Label", "Label");
        styleTypes.put("DBField", "DBField");
        styleTypes.put("MediaField", "DBField");
        styleTypes.put("Image", "Image");
        styleTypes.put("Text", "Text");
        styleTypes.put("ChartPlatform", "Chart");
        styleTypes.put("ReportHeaderPanel", "rptheader");
        styleTypes.put("PageHeaderPanel", "pageheader");
        styleTypes.put("DetailPanel", "detail");
        styleTypes.put("PageFooterPanel", "pagefooter");
        styleTypes.put("ReportFooterPanel", "rptfooter");
        styleTypes.put("Subreport", "subreport");
        styleTypes.put("SpecialField", "");
        styleTypes.put("GroupHeaderPanel", "grpheader");
        styleTypes.put("GroupFooterPanel", "grpfooter");
        styleTypes.put("CTCrossTab", "CrossTab");
        styleTypes.put("CTAggField", "DBField");
        styleTypes.put("CTDBField", "DBField");
        styleTypes.put("CTTextField", "Label");
        styleTypes.put("ParameterField", "Parameter");
        styleTypes.put("DataObject", "DataObject");
        styleTypes.put("DataObjectHeaderPanel", "rptheader");
        styleTypes.put("DataObjectFooterPanel", "rptfooter");
        styleTypes.put("DataObjectDetailPanel", "detail");
        styleTypes.put("DataObjectGroupFooterPanel", "grpfooter");
        styleTypes.put("DataObjectGroupHeaderPanel", "grpheader");
        styleTypes.put("Table", "Table");
        styleTypes.put("Column", "Column");
        styleTypes.put("Map", "Map");
        styleTypes.put("MapDBField", "JetRptMapDBField");
        styleTypes.put("MapTextField", "JetRptMapTextField");
        nameIdx = new HashMap(3);
        nameIdx.put("StyleType", new Integer(0));
        nameIdx.put("Description", new Integer(1));
        nameIdx.put("StyleName", new Integer(2));
    }
}

