/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.util.JRLog;
import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.api.DSException;
import jet.dataengine.api.SumrySpecKeyTool;
import jet.formula.Functions;
import jet.formula.JetRptFormula;
import jet.formula.JetRptSummary;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.summary.JetUSpecFuncDateTime;
import jet.universe.summary.JetUSpecFuncInfo;
import jet.util.HashVector;

public class JetUSummary
extends JetUFormula
implements JetContainable {
    public JetString function;
    public JetString fldName;
    public JetString groupbyFld;
    public JetString specFunc;
    private Vector children = new Vector();
    private static final HashMap nameIdx = new HashMap(45);
    private static final HashVector grpDesc;

    public JetUSummary() {
    }

    public JetUSummary(String strName, String strDesc, String strFunction, String strFieldName, String strGroupByFld) {
        super(strName, strDesc, "");
        this.function.set(strFunction);
        this.fldName.set(strFieldName);
        this.groupbyFld.set(strGroupByFld);
        this.BuildExpression();
    }

    public JetUSummary(String strName, String strDesc, String strFunction, String strFieldName, String strGroupByFld, String strSpecFunc) {
        super(strName, strDesc, "");
        this.function.set(strFunction);
        this.fldName.set(strFieldName);
        this.groupbyFld.set(strGroupByFld);
        this.specFunc.set(strSpecFunc);
        this.BuildExpression();
    }

    @Override
    void init() {
        super.init();
        this.function = new JetString(this, "Function");
        this.fldName = new JetString(this, "FieldName");
        this.groupbyFld = new JetString(this, "GroupByField");
        this.specFunc = new JetString(this, "SpecialFunction");
        this.specFunc.setEditFlag(0);
    }

    @Override
    public JetUFormula createNew() {
        JetUSummary ret = new JetUSummary(this.getResourceName(), this.getDesc(), this.getFunction(), this.getFieldName(), this.getGroupByFld());
        ret.rptFormula = this.getRptFormula();
        ret.HandleRptFormula();
        JetObject.copyProperties(ret, this);
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.elementAt(i) instanceof JetUSpecFuncInfo)) continue;
            JetObject newObj = ((JetUSpecFuncInfo)this.children.elementAt(i)).dup();
            ret.add(newObj);
        }
        return ret;
    }

    @Override
    public void InitAfterLoad() {
        String specFunc = this.getSpecFunc();
        if (specFunc.equalsIgnoreCase("none")) {
            this.setSpecFunc("");
        }
        this.BuildExpression();
        super.InitAfterLoad();
        if (!this.specFunc.get().equals("") && this.children.size() == 0) {
            this.addSpecFuncInfo();
        }
    }

    @Override
    public void FormulaModified() {
    }

    public String getFunction() {
        return this.function.get();
    }

    public void setFunction(String strFunction) {
        this.function.set(strFunction);
        this.BuildExpression();
    }

    public String getFieldName() {
        return this.fldName.get();
    }

    public void setFieldName(String strFieldName) {
        this.fldName.set(strFieldName);
        this.BuildExpression();
    }

    public String getGroupByFld() {
        return this.groupbyFld.get();
    }

    public void setSpecFunc(String specFunc) {
        this.specFunc.set(specFunc);
        this.BuildExpression();
    }

    public String getSpecFunc() {
        return this.specFunc.get();
    }

    private void addSpecFuncInfo() {
        JetUSpecFuncDateTime jft = null;
        int iFunc = Functions.getSpecFuncByName(this.specFunc.get());
        switch (iFunc) {
            case 0: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(13);
                break;
            }
            case 1: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(12);
                break;
            }
            case 2: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(10);
                break;
            }
            case 10: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(5);
                break;
            }
            case 11: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(24);
                break;
            }
            case 17: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(23);
                break;
            }
            case 12: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(21);
                break;
            }
            case 13: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(2);
                break;
            }
            case 14: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(22);
                break;
            }
            case 15: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(20);
                break;
            }
            case 16: {
                jft = new JetUSpecFuncDateTime();
                jft.setInterNum(String.valueOf(1));
                jft.setUnit(1);
            }
        }
        if (jft != null) {
            jft.setBenchPoint(String.valueOf(0));
            this.add(jft);
        } else if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Can not create JetUSpecFuncInfo for JetUSummary :" + this.getResourceName() + " specFunc property value is :" + this.specFunc.get());
        }
    }

    public String getSpecFuncKey() {
        if (this.children.size() == 0) {
            return this.specFunc.get();
        }
        JetUSpecFuncInfo sfi = null;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.elementAt(i) instanceof JetUSpecFuncInfo)) continue;
            sfi = (JetUSpecFuncInfo)this.children.elementAt(i);
            break;
        }
        String newKey = null;
        newKey = sfi != null ? SumrySpecKeyTool.getSpecKey(sfi) : this.specFunc.get();
        return newKey;
    }

    public String getSpecFuncDesc() throws DSException {
        if (this.children.size() == 0) {
            return this.specFunc.get();
        }
        JetUSpecFuncInfo sfi = null;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.elementAt(i) instanceof JetUSpecFuncInfo)) continue;
            sfi = (JetUSpecFuncInfo)this.children.elementAt(i);
            break;
        }
        if (sfi != null) {
            return sfi.getSimpleDesc();
        }
        return this.specFunc.get();
    }

    public void setGroupByFld(String strGroupByFld) {
        this.groupbyFld.set(strGroupByFld);
        this.BuildExpression();
    }

    protected void BuildExpression() {
        String key = this.getSpecFuncKey();
        this.setExpression(this.function.get() + "(@\"" + this.fldName.get() + "\"" + (this.groupbyFld.get() == null || this.groupbyFld.get().equals("") ? "" : ",\"" + this.groupbyFld.get() + "\"") + (key == null || key.equals("") ? "" : ",\"" + key + "\"") + ")");
    }

    @Override
    public JetRptFormula createRptFormula() {
        if (this.rptFormula == null) {
            this.rptFormula = new JetRptSummary();
        }
        this.rptFormula.setDataSource(this.getDatabase());
        this.rptFormula.setName(this.getResourceName());
        ((JetRptSummary)this.rptFormula).setExpression(this.function.get(), this.fldName.get(), this.groupbyFld.get(), this.getSpecFuncKey());
        return this.rptFormula;
    }

    @Override
    public String getInstancePrefix() {
        return "Summary";
    }

    @Override
    public JetUDBTreeNode copy() {
        JetUDatabase db = this.getDatabase();
        String strName = this.getResourceName();
        int i = 1;
        String strTmp = "Copy of " + strName;
        while (db.IsMappingNameExist(strTmp)) {
            strTmp = "Copy (" + String.valueOf(++i) + ") of " + strName;
        }
        JetUSummary newSum = this.createNewByName(strTmp);
        JetObject.copyProperties(newSum, this);
        newSum.setResourceName(strTmp);
        return newSum;
    }

    private JetUSummary createNewByName(String strNewName) {
        JetUSummary newSummary = new JetUSummary(strNewName, this.getDesc(), this.getFunction(), this.getFieldName(), this.getGroupByFld());
        newSummary.rptFormula = this.getRptFormula();
        newSummary.HandleRptFormula();
        newSummary.createProperties();
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.elementAt(i) instanceof JetUSpecFuncInfo)) continue;
            JetObject newObj = ((JetUSpecFuncInfo)this.children.elementAt(i)).dup();
            newSummary.add(newObj);
        }
        return newSummary;
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        boolean flag = super.isSimilar(field) && this.function.equal(((JetUSummary)field).function) && this.fldName.equal(((JetUSummary)field).fldName) && this.groupbyFld.equal(((JetUSummary)field).groupbyFld);
        JetUSpecFuncInfo oSFI = null;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.get(i) instanceof JetUSpecFuncInfo)) continue;
            oSFI = (JetUSpecFuncInfo)this.children.get(i);
        }
        JetUSpecFuncInfo nSFI = null;
        Vector newChildren = ((JetUSummary)field).getChildren();
        for (int i = 0; i < newChildren.size(); ++i) {
            if (!(newChildren.get(i) instanceof JetUSpecFuncInfo)) continue;
            nSFI = (JetUSpecFuncInfo)newChildren.get(i);
        }
        if (oSFI != null && nSFI != null) {
            return oSFI.isSimilar(nSFI) && flag;
        }
        if (oSFI == null && nSFI == null) {
            return flag;
        }
        return false;
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        boolean flag = super.isSimilarExceptName(field) && this.function.equal(((JetUSummary)field).function) && this.fldName.equal(((JetUSummary)field).fldName) && this.groupbyFld.equal(((JetUSummary)field).groupbyFld);
        JetUSpecFuncInfo oSFI = null;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.get(i) instanceof JetUSpecFuncInfo)) continue;
            oSFI = (JetUSpecFuncInfo)this.children.get(i);
        }
        JetUSpecFuncInfo nSFI = null;
        Vector newChildren = ((JetUSummary)field).getChildren();
        for (int i = 0; i < newChildren.size(); ++i) {
            if (!(newChildren.get(i) instanceof JetUSpecFuncInfo)) continue;
            nSFI = (JetUSpecFuncInfo)newChildren.get(i);
        }
        if (oSFI != null && nSFI != null) {
            return oSFI.isSimilar(nSFI) && flag;
        }
        if (oSFI == null && nSFI == null) {
            return flag;
        }
        return false;
    }

    @Override
    public JetObject add(JetObject child) {
        if (child != null) {
            JetContainable parent = child.getParent();
            if (parent != null) {
                if (parent == this) {
                    return child;
                }
                parent.remove(child);
            }
            this.children.addElement(child);
            child.setParent(this);
            this.objectModified();
        }
        return child;
    }

    @Override
    public JetObject remove(JetObject child) {
        this.objectModified();
        if (this.children.contains(child)) {
            this.children.removeElement(child);
            child.setParent(null);
        }
        return child;
    }

    @Override
    public void broadcast(JetObject sender, int iMessage) {
    }

    @Override
    public Vector getChildren() {
        return this.children;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    static {
        nameIdx.put("SQLType", new Integer(0));
        nameIdx.put("padding-right", new Integer(1));
        nameIdx.put("RightLine", new Integer(2));
        nameIdx.put("HorizontalAlignment", new Integer(3));
        nameIdx.put("Expression", new Integer(4));
        nameIdx.put("PatternStyle", new Integer(5));
        nameIdx.put("Format", new Integer(6));
        nameIdx.put("Precision", new Integer(7));
        nameIdx.put("Length", new Integer(8));
        nameIdx.put("Bold", new Integer(9));
        nameIdx.put("AutoFit", new Integer(10));
        nameIdx.put("Width", new Integer(11));
        nameIdx.put("formulainfo", new Integer(12));
        nameIdx.put("GUIField", new Integer(13));
        nameIdx.put("Height", new Integer(14));
        nameIdx.put("Radix", new Integer(15));
        nameIdx.put("Function", new Integer(16));
        nameIdx.put("padding-bottom", new Integer(17));
        nameIdx.put("Name", new Integer(18));
        nameIdx.put("ShadowColor", new Integer(19));
        nameIdx.put("BottomLine", new Integer(20));
        nameIdx.put("padding-top", new Integer(21));
        nameIdx.put("Description", new Integer(22));
        nameIdx.put("BorderWidth", new Integer(23));
        nameIdx.put("Background", new Integer(24));
        nameIdx.put("Scale", new Integer(25));
        nameIdx.put("FieldName", new Integer(26));
        nameIdx.put("DisplayWidth", new Integer(27));
        nameIdx.put("VerticalAlignment", new Integer(28));
        nameIdx.put("PatternColor", new Integer(29));
        nameIdx.put("TopLine", new Integer(30));
        nameIdx.put("FontSize", new Integer(31));
        nameIdx.put("Underline", new Integer(32));
        nameIdx.put("LeftLine", new Integer(33));
        nameIdx.put("FontFace", new Integer(34));
        nameIdx.put("Alignment", new Integer(35));
        nameIdx.put("padding-left", new Integer(36));
        nameIdx.put("WordWrap", new Integer(37));
        nameIdx.put("Italic", new Integer(38));
        nameIdx.put("SpecialFunction", new Integer(39));
        nameIdx.put("StrikeOut", new Integer(40));
        nameIdx.put("BorderColor", new Integer(41));
        nameIdx.put("GroupByField", new Integer(42));
        nameIdx.put("Foreground", new Integer(43));
        nameIdx.put("Shadow", new Integer(44));
        grpDesc = new HashVector(7);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(15);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("GUIField");
        grpItems.add("DisplayWidth");
        grpItems.add("SQLType");
        grpItems.add("Precision");
        grpItems.add("Scale");
        grpItems.add("Length");
        grpItems.add("Radix");
        grpItems.add("Expression");
        grpItems.add("Function");
        grpItems.add("FieldName");
        grpItems.add("GroupByField");
        grpItems.add("SpecialFunction");
        grpDesc.put(grpName, grpItems);
        grpName = "TextFormat";
        grpItems = new Vector(11);
        grpItems.add("FontFace");
        grpItems.add("FontSize");
        grpItems.add("Bold");
        grpItems.add("Italic");
        grpItems.add("StrikeOut");
        grpItems.add("Underline");
        grpItems.add("Format");
        grpItems.add("AutoFit");
        grpItems.add("WordWrap");
        grpItems.add("VerticalAlignment");
        grpItems.add("HorizontalAlignment");
        grpDesc.put(grpName, grpItems);
        grpName = "Padding";
        grpItems = new Vector(4);
        grpItems.add("padding-top");
        grpItems.add("padding-bottom");
        grpItems.add("padding-left");
        grpItems.add("padding-right");
        grpDesc.put(grpName, grpItems);
        grpName = "Geometry";
        grpItems = new Vector(2);
        grpItems.add("Width");
        grpItems.add("Height");
        grpDesc.put(grpName, grpItems);
        grpName = "Color";
        grpItems = new Vector(2);
        grpItems.add("Background");
        grpItems.add("Foreground");
        grpDesc.put(grpName, grpItems);
        grpName = "Border";
        grpItems = new Vector(8);
        grpItems.add("BorderWidth");
        grpItems.add("TopLine");
        grpItems.add("BottomLine");
        grpItems.add("LeftLine");
        grpItems.add("RightLine");
        grpItems.add("Shadow");
        grpItems.add("BorderColor");
        grpItems.add("ShadowColor");
        grpDesc.put(grpName, grpItems);
        grpName = "Pattern";
        grpItems = new Vector(2);
        grpItems.add("PatternColor");
        grpItems.add("PatternStyle");
        grpDesc.put(grpName, grpItems);
        grpName = "Other";
        grpItems = new Vector(1);
        grpItems.add("DataMappingFile");
        grpDesc.put(grpName, grpItems);
    }
}

