/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import com.jinfonet.dataservice.schema.relational.datasource.IMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.ITransformToRelationRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlMappingSource;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlMappingTarget;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlNFKMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlNPKMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlTransformToRelation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JRException;
import jet.connect.DbColDesc;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.api.DSException;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJsonConnection;
import jet.universe.JetUJsonField;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUTransformRelationModel;
import jet.universe.JetUTransformRelationSchema;
import jet.universe.JetUWSOperationConnection;
import jet.universe.UniverseEditor;
import jet.universe.mongodb.JetUMongoConnection;
import jet.util.HashVector;
import toolkit.db.TableInfo;

public class JetUTableView
extends JetUResourceContainer {
    public static final int TYPE_TABLE = 1;
    public static final int TYPE_VIEW = 2;
    public static final int TYPE_ALIAS = 4;
    public static final int TYPE_SYNONYM = 8;
    public static final int TYPE_MASK_ALL = 15;
    public JetEnumeration tableType = new JetEnumeration(this, "TableType", 94);
    public JetString qualifier = new JetString(this, "Qualifier");
    public JetString owner = new JetString(this, "Owner");
    public JetString tableName = new JetString(this, "TableName");
    public TableInfo table = null;
    protected JetString paramLinks = new JetString(this, "ObjParamLinks");
    private static final String DELIMER = "=";
    private static final String JETDELIMER = ";";
    private Hashtable htParamLinks = null;
    private static JRLogger logger = JRLogger.getLogger(JetUTableView.class.getName());
    private static final HashMap nameIdx = new HashMap(7);
    private static final HashVector grpDesc;

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    public JetUTableView() {
    }

    public JetUTableView(String strName, String strDescription, int iTableType, String strQlf, String strOwner, String strTableName) {
        super(strName, strDescription);
        this.tableType.set(new Integer(iTableType));
        this.qualifier.set(strQlf);
        this.owner.set(strOwner);
        this.tableName.set(strTableName);
    }

    public JetUTableView(String strName, String strDescription, TableInfo table) {
        super(strName, strDescription);
        this.tableType.set(new Integer(table.getTableType()));
        this.qualifier.set(table.getQualifierName());
        this.owner.set(table.getOwnerName());
        this.tableName.set(table.getTableName());
        this.table = table;
    }

    public JetUTableView createNew() {
        return new JetUTableView(this.getResourceName(), this.getDesc(), this.getTableType(), this.getQualifier(), this.getOwner(), this.getTableName());
    }

    public JetUTableView createNew(String newName) {
        return new JetUTableView(newName, this.getDesc(), this.getTableType(), this.getQualifier(), this.getOwner(), this.getTableName());
    }

    @Override
    public void InitAfterLoad() {
        boolean isObj;
        super.InitAfterLoad();
        JetUConnection con = this.getConnection();
        if (con instanceof JetUJDBCConnection && (isObj = ((JetUJDBCConnection)con).getJdbcDriver().equals("com.jinfonet.jdbc.obj.ObjectDriver"))) {
            this.qualifier.set("jinfonet");
            this.owner.set("object");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void InitAfterCreate(Character c) {
        super.InitAfterCreate();
        if (this.table == null) {
            return;
        }
        Vector cols = this.table.getColumns();
        int size = cols.size();
        String strFieldMappingName = null;
        DatabaseMetaData dbmd = null;
        JetUConnection conn = this.getConnection();
        HashSet<String> pks = new HashSet<String>();
        HashSet<String> fks = new HashSet<String>();
        if (conn instanceof JetUMongoConnection) {
            JetUJDBCConnection con = (JetUJDBCConnection)conn;
            Connection conn2 = null;
            try {
                conn2 = con.getConnection();
                dbmd = conn2.getMetaData();
                ResultSet pk = dbmd.getPrimaryKeys(this.qualifier.get(), this.getOwner(), this.tableName.get());
                if (pk != null) {
                    while (pk.next()) {
                        String pkName = pk.getString(4);
                        pks.add(pkName.toUpperCase());
                    }
                }
                pk.close();
                ResultSet fk = dbmd.getImportedKeys(this.qualifier.get(), this.getOwner(), this.tableName.get());
                if (fk != null) {
                    while (fk.next()) {
                        String fkName = fk.getString(8);
                        fks.add(fkName.toUpperCase());
                    }
                }
                fk.close();
            }
            catch (DSException e) {
            }
            catch (SQLException e) {
            }
            finally {
                if (conn2 != null) {
                    try {
                        conn2.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        if (conn instanceof JetUJsonConnection) {
            int i;
            HashSet<String> jsonpks = new HashSet<String>();
            HashSet<String> jsonfks = new HashSet<String>();
            Hashtable<String, String> dataElementName = new Hashtable<String, String>();
            JetUTransformRelationSchema schema = ((JetUJsonConnection)conn).getTransformRelationSchema();
            JetUTransformRelationModel model = schema.getJetUTransformRelationModel(this.tableName.get());
            TransformRelationModel transModel = null;
            try {
                transModel = model.createTransformRelationModel();
            }
            catch (JRException e) {
                // empty catch block
            }
            XmlTransformToRelation jsonTransformToRelation = (XmlTransformToRelation)transModel.getTransformToRelation();
            ITransformToRelationRule[] rs = jsonTransformToRelation.getTransformRules();
            IMappingRule[] mappingRules = rs[0].getMappingRules();
            for (i = 0; i < mappingRules.length; ++i) {
                XmlMappingTarget target = (XmlMappingTarget)mappingRules[i].getTransformTarget();
                String filedName = target.getTransformDataFieldName();
                if (mappingRules[i] instanceof XmlNPKMappingRule) {
                    jsonpks.add(filedName.toUpperCase());
                    continue;
                }
                if (mappingRules[i] instanceof XmlNFKMappingRule) {
                    jsonfks.add(filedName.toUpperCase());
                    continue;
                }
                XmlMappingSource source = (XmlMappingSource)mappingRules[i].getTransformSource();
                String xpath = source.getAbsoluteXpath();
                String elementName = xpath.substring(xpath.lastIndexOf(47) + 1);
                dataElementName.put(filedName.toUpperCase(), elementName);
            }
            for (i = 0; i < size; ++i) {
                int type;
                DbColDesc coldesc = (DbColDesc)cols.elementAt(i);
                strFieldMappingName = this.getMappingName(coldesc.getColName(), c);
                JetUJsonField field = new JetUJsonField(strFieldMappingName, "", coldesc);
                String colName = coldesc.getColName().toUpperCase();
                if (jsonpks.contains(colName)) {
                    type = 1;
                } else if (jsonfks.contains(colName)) {
                    type = 2;
                } else {
                    type = 0;
                    field.elementName.set((String)dataElementName.get(colName));
                }
                field.columnType.set(type);
                this.addField(field);
            }
            this.table = null;
            return;
        }
        for (int i = 0; i < size; ++i) {
            DbColDesc coldesc = (DbColDesc)cols.elementAt(i);
            strFieldMappingName = this.getMappingName(coldesc.getColName(), c);
            JetUField field = new JetUField(strFieldMappingName, "", coldesc);
            String colName = coldesc.getColName().toUpperCase();
            int type = pks.contains(colName) ? 1 : (fks.contains(colName) ? 2 : 0);
            field.columnType.set(type);
            this.addField(field);
        }
        this.table = null;
    }

    public void InitAfterAlias(JetUTableView originalTableview) {
        Vector fields = originalTableview.getFields();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            JetUField f = (JetUField)fields.get(i);
            DbColDesc coldesc = f.getColDesc();
            String strFieldMappingName = this.getMappingName(coldesc.getColName(), null);
            JetUField field = new JetUField(strFieldMappingName, "", coldesc);
            field.columnType.set(f.columnType.get());
            this.addField(field);
        }
    }

    public String getMappingName(String strRealName, Character c) {
        StringBuffer error = new StringBuffer();
        JetUDatabase db = this.getDatabase();
        String strTemp = null;
        String strMappingName = strRealName;
        boolean bIsOK = false;
        if (c == null) {
            bIsOK = db.IsMappingNameOK(strMappingName, error);
            c = JetUConnection.conChar;
        }
        int i = 1;
        if (!bIsOK) {
            strMappingName = this.getResourceName() + c + strRealName;
            bIsOK = db.IsMappingNameOK(strMappingName, error);
        }
        strTemp = strMappingName;
        while (!bIsOK) {
            strMappingName = strTemp + i++;
            bIsOK = db.IsMappingNameOK(strMappingName, error);
        }
        return strMappingName;
    }

    public int getTableType() {
        return this.tableType.intValue();
    }

    public void setQualifiedNamePattern(int iTableType) {
        this.tableType.set(new Integer(iTableType));
    }

    public boolean isTable() {
        return (this.getTableType() & 1) == 1;
    }

    public boolean isView() {
        return (this.getTableType() & 2) == 2;
    }

    public boolean isAlias() {
        return (this.getTableType() & 4) == 4;
    }

    public boolean isSynonym() {
        return (this.getTableType() & 8) == 8;
    }

    public String getQualifier() {
        return this.qualifier.get();
    }

    public void setQualifier(String strQlf) {
        this.qualifier.set(strQlf);
    }

    public String getOwner() {
        return this.owner.get();
    }

    public void setOwner(String strOwner) {
        this.owner.set(strOwner);
    }

    public String getTableName() {
        return this.tableName.get();
    }

    public void setTableName(String strTableName) {
        this.tableName.set(strTableName);
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    public void addField(JetUField field) {
        this.add(field);
        field.InitAfterCreate();
    }

    public JetUField removeField(JetUField field) {
        this.remove(field);
        return field;
    }

    public Vector getFields() {
        return this.getChildren();
    }

    public JetUField getFieldByResourceName(String fldName) {
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetUField fld = (JetUField)this.children.elementAt(i);
            if (!fld.getResourceName().equalsIgnoreCase(fldName)) continue;
            return fld;
        }
        return null;
    }

    public JetUField getFieldByFieldName(String fldName) {
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetUField fld = (JetUField)this.children.elementAt(i);
            if (!fld.getFldName().equalsIgnoreCase(fldName)) continue;
            return fld;
        }
        return null;
    }

    public JetUConnection getConnection() {
        JetUConnection con = null;
        JetUConnection obj = (JetUConnection)this.getParent();
        con = obj instanceof JetUWSOperationConnection ? (JetUConnection)obj.getParent() : obj;
        return con;
    }

    private Hashtable savedToTable(String input) {
        StringTokenizer t = new StringTokenizer(input, JETDELIMER);
        Vector<String> v = new Vector<String>();
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        Hashtable<String, String> ht = new Hashtable<String, String>(v.size());
        JetUDatabase udb = this.getDatabase();
        for (int i = 0; i < v.size(); ++i) {
            String strV = (String)v.elementAt(i);
            int k = strV.indexOf(DELIMER);
            if (k <= -1) continue;
            String dyP = strV.substring(0, k);
            String upName = strV.substring(k + 1);
            ht.put(dyP, upName);
        }
        return ht;
    }

    private String tableToSaved(Hashtable ht) {
        String sv = "";
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String dyParam = (String)e.nextElement();
            sv = sv + dyParam + DELIMER + ht.get(dyParam) + JETDELIMER;
        }
        if (sv.length() > 0) {
            sv = sv.substring(0, sv.length() - 1);
        }
        return sv;
    }

    public void bindParameter(Hashtable linkInfo) {
        this.htParamLinks = linkInfo;
        this.paramLinks.set(this.tableToSaved(this.htParamLinks));
    }

    public String getBindUPName(String dyParamName) {
        if (this.htParamLinks == null) {
            this.htParamLinks = this.savedToTable(this.paramLinks.get());
        }
        return (String)this.htParamLinks.get(dyParamName);
    }

    public JetUParameter getBindParameter(String dyParamName) {
        String upName = this.getBindUPName(dyParamName);
        if (upName != null) {
            return this.getDatabase().getParameterByResourceName(upName);
        }
        return null;
    }

    public boolean isEmptyLinks() {
        return this.paramLinks.get().length() == 0;
    }

    public Hashtable getParamLink() {
        if (this.htParamLinks == null) {
            this.htParamLinks = this.savedToTable(this.paramLinks.get());
        }
        return this.htParamLinks;
    }

    public void setParamLinks(String sParamLinks) {
        this.paramLinks.set(sParamLinks);
        this.htParamLinks = null;
    }

    public String getParamLinks() {
        return this.paramLinks.get();
    }

    @Override
    public String getInstancePrefix() {
        return "TableView";
    }

    @Override
    public void setResourceName(String strName) {
        JetUDatabase db = this.getDatabase();
        UniverseEditor editor = db.getUniverse().editor;
        if (editor != null) {
            editor.updateTableNames(this.getResourceName(), strName, db.getResourceName());
        }
        super.setResourceName(strName);
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        return super.isSimilar(container) && this.tableType.equal(((JetUTableView)container).tableType) && this.tableName.equal(((JetUTableView)container).tableName);
    }

    static {
        nameIdx.put("TableType", new Integer(0));
        nameIdx.put("Description", new Integer(1));
        nameIdx.put("ObjParamLinks", new Integer(2));
        nameIdx.put("TableName", new Integer(3));
        nameIdx.put("Name", new Integer(4));
        nameIdx.put("Owner", new Integer(5));
        nameIdx.put("Qualifier", new Integer(6));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "anonymous";
        grpItems = new Vector<String>(7);
        grpItems.add("TableType");
        grpItems.add("Description");
        grpItems.add("ObjParamLinks");
        grpItems.add("TableName");
        grpItems.add("Name");
        grpItems.add("Owner");
        grpItems.add("Qualifier");
        grpDesc.put(grpName, grpItems);
    }
}

