/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.dataservice.schema.relational.TransformDataField;
import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import jet.JRException;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUTransformDataField;
import jet.universe.JetUTransformToRelation;

public class JetUTransformRelationModel
extends JetUResourceContainer {
    private TransformRelationModel transformRelationModel;
    private static final HashMap nameIdx = new HashMap(2);

    public JetUTransformRelationModel() {
    }

    public JetUTransformRelationModel(TransformRelationModel model) {
        super(model.getName(), "");
        this.setTransformRelationModel(model);
    }

    public void setTransformRelationModel(TransformRelationModel model) {
        this.transformRelationModel = model;
        this.removeall();
        this.add(new JetUTransformToRelation(model.getTransformToRelation()));
        TransformDataField[] fields = model.getTransformDataFields();
        for (int i = 0; i < fields.length; ++i) {
            this.add(new JetUTransformDataField(fields[i]));
        }
    }

    public synchronized TransformRelationModel getTransformRelationModel() throws JRException {
        if (this.transformRelationModel == null) {
            this.transformRelationModel = this.createTransformRelationModel();
        }
        return this.transformRelationModel;
    }

    public JetUTransformDataField[] getJetUTransformDataFields() {
        Vector children = this.getChildren();
        ArrayList retList = new ArrayList();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            if (!(children.get(i) instanceof JetUTransformDataField)) continue;
            retList.add(children.get(i));
        }
        JetUTransformDataField[] ret = new JetUTransformDataField[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    public TransformRelationModel createTransformRelationModel() throws JRException {
        TransformRelationModel ret = new TransformRelationModel(this.getResourceName());
        JetUTransformDataField[] fields = this.getJetUTransformDataFields();
        for (int i = 0; i < fields.length; ++i) {
            ret.addTransformDataField(fields[i].createTransformDataField());
        }
        JetUTransformToRelation transformToRelation = this.getJetUTransformToRelation();
        ret.setTransformToRelation(transformToRelation.createTransformToRelation());
        return ret;
    }

    private JetUTransformToRelation getJetUTransformToRelation() {
        Vector children = this.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            if (!(children.get(i) instanceof JetUTransformToRelation)) continue;
            return (JetUTransformToRelation)children.get(i);
        }
        return null;
    }

    @Override
    public String getInstancePrefix() {
        return "TransformRelationModel";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("Name", new Integer(1));
    }
}

