/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.universe.JetUTreeNode;

public abstract class JetUTree
extends JetUTreeNode
implements JetContainable {
    Vector children = new Vector();

    @Override
    public Vector getChildren() {
        return (Vector)this.children.clone();
    }

    @Override
    public JetObject add(JetObject child) {
        return this.add(child, -1);
    }

    public synchronized JetObject add(JetObject child, int pos) {
        if (child != null) {
            JetContainable parent = child.getParent();
            if (parent != null) {
                if (parent == this) {
                    return child;
                }
                parent.remove(child);
            }
            if (pos == -1) {
                this.children.addElement(child);
            } else {
                this.children.insertElementAt(child, pos);
            }
            child.setParent(this);
            this.objectModified();
        }
        return child;
    }

    @Override
    public JetObject remove(JetObject child) {
        this.objectModified();
        this.children.removeElement(child);
        child.setParent(null);
        return child;
    }

    public synchronized JetObject remove(int index) {
        return this.remove((JetObject)this.children.elementAt(index));
    }

    @Override
    public void broadcast(JetObject sender, int iMessage) {
        int iSize = this.children.size();
        int iIndex = 0;
        while (iIndex < iSize) {
            JetObject xobj;
            if ((xobj = (JetObject)this.children.elementAt(iIndex++)).equals(sender) || !(xobj instanceof JetContainable)) continue;
            ((JetContainable)((Object)xobj)).broadcast(sender, iMessage);
        }
    }
}

