/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.ibus.InformationBusManager;
import com.jinfonet.jdbc.obj.ObjectDriver;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.resstore.defaultimpl.DefaultResourceStore;
import com.jinfonet.util.loader.DynamicClassManager;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import jet.Env;
import jet.JResource;
import jet.ReportEnv;
import jet.connect.DbColDesc;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.export.style.StyleToXSD;
import jet.formula.JavaFormula;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReadFailureException;
import jet.jetc.ReportLoader;
import jet.jetc.WriteFailureException;
import jet.log.JRLogger;
import jet.universe.ConnectionDesc;
import jet.universe.DataEntryLocation;
import jet.universe.DocObject;
import jet.universe.JetUAcl;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUDocFolder;
import jet.universe.JetUDocNode;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUInformationBusEntry;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUStyleGroup;
import jet.universe.JetUSummary;
import jet.universe.JetUTableView;
import jet.universe.JetUTree;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUWherePortion;
import jet.universe.QueryFieldDesc;
import jet.universe.StreamGobbler;
import jet.universe.UUniverseListener;
import jet.universe.UniverseEditor;
import jet.universe.UniverseToolkit;
import jet.universe.UniverseUpdateTool;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.GroupInfo;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.cp_info;
import jet.universe.exception.AddTableViewException;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.DocException;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.InvalidEntityException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.universe.exception.UniverseFileException;
import jet.universe.ibus.IbusManager;
import jet.universe.psql.RptPsqlQuery;
import jet.util.FileUtil;
import jet.util.Filter;
import jet.util.FullClassPath;
import jet.util.JFieldValueNLSManager;
import jet.util.NLSResourceBundle;
import jet.util.NLSResourceBundleManager;
import jet.util.WildcardMatcher;
import jet.util.nls.NLSFontValue;
import jet.util.nls.NLSValue;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlTable;
import toolkit.db.api.SQLMapInfo;
import toolkit.db.api.SQLNameAnalyser;
import toolkit.db.api.SQLStmtCreator;
import toolkit.db.queryoptimization.QueryOptimizer;

public class JetUUniverse
extends JetUTree
implements JetRootable {
    public static final String CAT_FILE_EXTENSION = ".cat";
    public static final String CAT_FILE_WILDCARD = "*.cat";
    public static final String BACKUP_FILE_EXTENSION = ".backup";
    public static final String FORMULA_FILE_EXTENSION = ".fml";
    public static final String PREJOIN_FILE_EXTENSION = ".pre";
    public static final int TYPE_TABLE = 1;
    public static final int TYPE_VIEW = 2;
    public static final int TYPE_ALIAS = 4;
    public static final int TYPE_SYNONYM = 8;
    public static final int ClearMemory = 1;
    public static final int Not_ClearMemory = 0;
    public static final int BV = 1;
    public static final int QUERY = 2;
    public JetString name = new JetString(this, "Name");
    public JetString description = new JetString(this, "Description");
    public JetString version = new JetString(this, "Version");
    public JetNumber versionNumber = new JetNumber(this, "VersionNumber");
    public JetNumber minorVersionNumber = new JetNumber(this, "MinorVersionNumber");
    private int jetcVersion = 65648;
    private File flCat = null;
    protected transient boolean bIsModified = false;
    protected static JetUUniverse curUniverse = null;
    protected static Vector listeners = new Vector();
    private Hashtable sysObjects = new Hashtable();
    private Hashtable sysCounts = null;
    private static final String strCurVersion = "single-user";
    public static final int V9_1 = 10;
    public static final int V12 = 12;
    public static final int V12_UPDATE2 = 13;
    public static final int V12_UPDATE21 = 14;
    public static final int V13 = 15;
    public static final int V13_1 = 16;
    public static final int V13_5 = 17;
    public static final int iCurVersionNumber = 17;
    public static final int iCurMinorVersionNumber = 2;
    private static ThreadLocal<Integer> upgrade2Version = new ThreadLocal();
    private Hashtable flFormulaFiles = new Hashtable();
    private Hashtable flFormulaCodeBytes = new Hashtable();
    boolean bNeedUpdateFmlFile;
    Hashtable bNeedUpdateFmlFiles = new Hashtable();
    boolean bTmpFmlFileCreated;
    Hashtable bTmpFmlFileCreateds = new Hashtable();
    boolean singleThread;
    public JetString timeZone = new JetString(this, "TimeZone");
    public UniverseEditor editor = null;
    private String rptUser;
    public boolean isCatalogPrepareOK = false;
    public JetUStyleGroup root = null;
    private Hashtable<Locale, JFieldValueNLSManager> cachedNLSManager = new Hashtable();
    private static JRLogger logger = JRLogger.getLogger(JetUUniverse.class.getName());
    protected static DSLog log = DSLog.getDSLog(JetUUniverse.class.getName());
    public JetVector orderedParameters = new JetVector(this, "OrderedParameters");
    private Hashtable<Locale, NLSResourceBundle> cachedNLSResourceBundles = new Hashtable();
    private boolean isUpgrade = false;
    private static Object compileFormulaLock = new Object();
    private int refCount = 0;
    private volatile boolean cached = false;
    Object refLocker = new Object();
    private boolean bCrossRefApply = false;
    private String userTimeZone = "";
    private static final HashMap nameIdx = new HashMap(5);
    private ResourceStore resourceStore = new DefaultResourceStore(new File(Env.getTemporaryPath()));
    public static String KEYWORD_DR;
    public static String KEYWORD_FORMULAS;
    public static String KEYWORD_ADDFORMULA;
    public static String KEYWORD_MEASURES;
    public static String KEYWORD_ADDMEASURE;
    public static String KEYWORD_AGGS;
    public static String KEYWORD_ADDAGG;
    public static String KEYWORD_LOCPARAMS;
    public static String KEYWORD_GLOPARAMS;
    public static String KEYWORD_PARAMS;
    public static String KEYWORD_ADDPARAM;

    public JetUUniverse() {
    }

    public JetUUniverse(String strFullFileName) {
        this();
        this.versionNumber.set(17);
        this.minorVersionNumber.set(2);
        this.setFullFileName(new File(strFullFileName));
    }

    public void setSingleThread(boolean single) {
        this.singleThread = single;
    }

    public boolean getSingleThread() {
        return this.singleThread;
    }

    @Override
    public void afterInit() {
        super.afterInit();
        this.InitAfterLoad();
        this.jetcVersion = 65648;
    }

    public void InitAfterCreate() {
        this.version.set(strCurVersion);
        JetUDatabase uDatabase = new JetUDatabase();
        this.add(uDatabase);
        uDatabase.InitAfterCreate();
        JetUDocFolder folder = new JetUDocFolder(JResource.getMessage("DocumentTree"), "");
        this.add(folder);
        this.isCatalogPrepareOK = true;
    }

    public void InitAfterLoad() {
        String dsName;
        Vector datasources = this.getAllDatabases();
        if (this.flCat != null) {
            File flFml = null;
            for (int i = 0; i < datasources.size(); ++i) {
                dsName = ((JetUDatabase)datasources.elementAt(i)).getResourceName();
                flFml = this.getFMLFile(dsName);
                if (flFml.exists() && this.isFMLFileMatch(flFml, dsName)) {
                    this.flFormulaFiles.put(dsName, flFml);
                }
                this.bNeedUpdateFmlFiles.put(dsName, new Boolean(false));
                this.bTmpFmlFileCreateds.put(dsName, new Boolean(false));
            }
        }
        this.bNeedUpdateFmlFile = false;
        this.bTmpFmlFileCreated = false;
        this.setModified(false);
        logger.outLine("Catalog version is: " + this.versionNumber.get());
        if (this.versionNumber.get() < 17 || this.minorVersionNumber.get() < 2 && this.versionNumber.get() == 17) {
            this.updateVersion();
        }
        if (this.jetcVersion < 65554) {
            this.bNeedUpdateFmlFile = true;
            this.flFormulaFiles.clear();
        }
        JetUDatabase dataBase = this.getDatabase();
        for (int i = 0; i < datasources.size(); ++i) {
            dataBase = (JetUDatabase)datasources.elementAt(i);
            dsName = dataBase.getResourceName();
            JetUConnection connection = dataBase.getConnection();
            if (connection == null || !(connection instanceof JetUJDBCConnection)) continue;
            JetUJDBCConnection con = (JetUJDBCConnection)connection;
            con.conFlag = 0;
        }
        this.isCatalogPrepareOK = true;
    }

    private String extractClassName(String classNameAndParams) {
        StringTokenizer token = new StringTokenizer(classNameAndParams, ";", false);
        return token.nextToken().trim();
    }

    private JetUParameter[] initParams(String classNameAndParams, String sourceName) {
        JetUParameter[] params = new JetUParameter[]{};
        StringTokenizer token = new StringTokenizer(classNameAndParams, ";", false);
        if (token.countTokens() > 0) {
            params = new JetUParameter[token.countTokens() - 1];
            int count = 0;
            token.nextToken();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                JetUResourceEntity entity = this.getMaterialByName(sourceName, (str = str.substring(1).trim().toUpperCase()).toUpperCase());
                if (entity instanceof JetUParameter) {
                    params[count++] = (JetUParameter)entity;
                    continue;
                }
                if (!logger.isErrorEnabled()) continue;
                logger.error("", new Exception("Can not find parameter '" + str + "'!"));
                return new JetUParameter[0];
            }
        }
        return params;
    }

    public SQLNameAnalyser createSQLNameAnalyser(String datasourceName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        JetUConnection conn = this.getDatabase(datasourceName).getConnection();
        if (conn instanceof JetUJDBCConnection) {
            String className = ((JetUJDBCConnection)conn).sqlNameAnalyser.get();
            if (!StringTools.isEmptyStringWithTrim(className)) {
                return (SQLNameAnalyser)this.newInstanceForClassName(this.extractClassName(className));
            }
            throw new IllegalArgumentException("SQLNameAnalyser className [" + className + "] in DataSoruce[" + datasourceName + "] is empty.");
        }
        throw new IllegalArgumentException("DataSoruce[" + datasourceName + "] does not have a JetUJDBCConnection.");
    }

    public SQLStmtCreator createSQLStmtCreator(String datasourceName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        JetUConnection conn = this.getDatabase(datasourceName).getConnection();
        if (conn instanceof JetUJDBCConnection) {
            String className = ((JetUJDBCConnection)conn).sqlStmtCreator.get();
            if (!StringTools.isEmptyStringWithTrim(className)) {
                return (SQLStmtCreator)this.newInstanceForClassName(this.extractClassName(className));
            }
            throw new IllegalArgumentException("SQLStmtCreator className [" + className + "] in DataSoruce[" + datasourceName + "] is empty.");
        }
        throw new IllegalArgumentException("DataSoruce[" + datasourceName + "] does not have a JetUJDBCConnection.");
    }

    private Object newInstanceForClassName(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (logger.isErrorEnabled()) {
                logger.error("", e);
            }
            throw e;
        }
        catch (InstantiationException e) {
            if (logger.isErrorEnabled()) {
                logger.error("", e);
            }
            throw e;
        }
        catch (IllegalAccessException e) {
            if (logger.isErrorEnabled()) {
                logger.error("", e);
            }
            throw e;
        }
    }

    public QueryOptimizer createCustomQueryOptimzer(String datasourceName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        JetUConnection conn = this.getDatabase(datasourceName).getConnection();
        if (conn instanceof JetUJDBCConnection) {
            return (QueryOptimizer)this.newInstanceForClassName(((JetUJDBCConnection)conn).customQueryOptimizer.get());
        }
        throw new IllegalArgumentException("DataSoruce[" + datasourceName + "] does not have a JetUJDBCConnection.");
    }

    protected void updateVersion() {
        int iOldVersion = this.versionNumber.get();
        int up2version = 17;
        Integer u = upgrade2Version.get();
        if (u != null) {
            up2version = u;
        }
        logger.outLine("Upgrade Catalog from " + iOldVersion + " to " + up2version);
        logger.outLine("Upgrade Catalog from minor " + this.minorVersionNumber.get() + " to " + up2version);
        long start = System.currentTimeMillis();
        Vector sources = this.getAllDatabases();
        int size = sources.size();
        if (iOldVersion < 10 && up2version >= 10) {
            logger.outLine("  Upgrade Catalog for V9.1 ");
            UniverseUpdateTool.updateToV91(this);
        }
        if (iOldVersion < 12 && up2version >= 12) {
            logger.outLine("  Upgrade Catalog for V12 ");
            int s = sources.size();
            for (int i = 0; i < s; ++i) {
                JetUDatabase dataBase = (JetUDatabase)sources.get(i);
                Vector queriables = dataBase.getQueriables();
                int size2 = queriables.size();
                for (int j = 0; j < size2; ++j) {
                    RptPsqlQuery psqlQuery;
                    IUnCheckedExpression iExp;
                    JetUQueriable qs = (JetUQueriable)queriables.get(j);
                    if (!(qs instanceof JetUQuery) || (iExp = (IUnCheckedExpression)(psqlQuery = ((JetUQuery)qs).getPsqlQuery()).getSearchConditionGroups()) == null) continue;
                    try {
                        IUnCheckedExpression upgradedIExp = ExpressionToolKit.buildUncheckedMappingNameExpression(iExp, psqlQuery);
                        psqlQuery.setSearchConditionGroups(upgradedIExp);
                        ((JetUQuery)qs).setPsqlQuery(psqlQuery);
                        continue;
                    }
                    catch (ConditionException e) {
                        logger.error("Upgrade to v12 fail, can not convert old IUnCheckedExpression to new IUnCheckedExpression using Mapping Name,", e);
                    }
                }
            }
        }
        if (iOldVersion < 13 && up2version >= 13) {
            logger.outLine("  Upgrade Catalog for V12 update2 ");
            UniverseUpdateTool.updateToV1202(this);
        }
        if (iOldVersion < 14 && up2version >= 14) {
            logger.outLine("  Upgrade Catalog for V12 update2.1 ");
            UniverseUpdateTool.updateToV12021(this);
        }
        if (iOldVersion < 15 && up2version >= 15) {
            logger.outLine("  Upgrade Catalog for V13 ");
            UniverseUpdateTool.updateToV13(this);
        }
        if (iOldVersion <= 15 && up2version >= 15) {
            logger.outLine("  Upgrade Catalog for V13,eliminate duplicate BV member level security item ");
            UniverseUpdateTool.fixbug4V13(this);
        }
        if (iOldVersion < 16 || this.minorVersionNumber.get() < 2 && this.versionNumber.get() == 16 && up2version >= 16) {
            logger.outLine("  Upgrade Catalog for V13.1");
            UniverseUpdateTool.updateToV13_1(this);
        }
        if (iOldVersion < 17 || this.minorVersionNumber.get() < 2 && this.versionNumber.get() == 17 && up2version >= 17) {
            logger.outLine("  Upgrade Catalog for V13.1");
            UniverseUpdateTool.updateToV13_5_unifiedBV(this);
        }
        this.versionNumber.set(up2version);
        this.isUpgrade = true;
        this.minorVersionNumber.set(2);
        this.setModified(true);
        logger.outLine("Upgrade Catalog time: " + (System.currentTimeMillis() - start) + "(ms).");
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    void PrepareBeforeSave(Vector names) throws FMLFileException {
        int dsize = names.size();
        for (int i = 0; i < dsize; ++i) {
            String sourceName = (String)names.elementAt(i);
            JetUDatabase uDatabase = this.getDatabase(sourceName);
            uDatabase.PrepareBeforeSave();
        }
    }

    public void PrepareBeforeSaveForXMLCat() {
        Vector sources = this.getAllDatabases();
        int dsize = sources.size();
        for (int i = 0; i < dsize; ++i) {
            JetUDatabase uDatabase = (JetUDatabase)sources.elementAt(i);
            String sourceName = uDatabase.getResourceName();
            uDatabase.PrepareBeforeSave();
        }
    }

    public void BeforeSave() {
        this.PrepareBeforeSaveForXMLCat();
    }

    public void PrepareBeforeSave() throws FMLFileException {
        Vector sources = this.getAllDatabases();
        int dsize = sources.size();
        for (int i = 0; i < dsize; ++i) {
            JetUDatabase uDatabase = (JetUDatabase)sources.elementAt(i);
            String sourceName = uDatabase.getResourceName();
            File fmlFile = (File)this.flFormulaFiles.get(sourceName);
            uDatabase.PrepareBeforeSave();
            if (!this.flCat.getName().endsWith(CAT_FILE_EXTENSION) && !this.flCat.getName().endsWith(".cat.xml")) continue;
            if (fmlFile == null || !fmlFile.exists() || uDatabase.isNeedGenerateJava()) {
                try {
                    if (!this.generateFormulaFile(sourceName)) {
                        continue;
                    }
                }
                catch (GenerateFormulasCodeException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error("GenerateFormulasCodeException:", e);
                    }
                    throw new FMLFileException(e.getMessage());
                }
            }
            if (this.bNeedUpdateFmlFiles.get(sourceName) != null && !((Boolean)this.bNeedUpdateFmlFiles.get(sourceName)).booleanValue()) continue;
            fmlFile = (File)this.flFormulaFiles.get(sourceName);
            File flFml = this.getFMLFile(sourceName);
            boolean isSame = fmlFile.getPath().equalsIgnoreCase(flFml.getPath());
            if (flFml.exists() && !isSame && !flFml.delete()) {
                FMLFileException e = new FMLFileException(flFml.getPath());
                logger.error("Delete old formula file fail!", e);
                throw e;
            }
            try {
                FileUtil.copy(fmlFile, flFml);
            }
            catch (IOException e) {
                logger.error("Copy new Formula file to old Formula file fail!", e);
                throw new FMLFileException(flFml.getPath());
            }
            this.bNeedUpdateFmlFiles.remove(sourceName);
            this.bNeedUpdateFmlFiles.put(sourceName, new Boolean(false));
        }
    }

    void PrepareAfterSave() {
    }

    public void setName(String strName) {
        this.name.set(strName);
        this.NameChanged(this);
    }

    public String getName() {
        return this.name.get();
    }

    @Override
    public String getDesc() {
        return this.description.get();
    }

    @Override
    public void setDesc(String strDesc) {
        this.description.set(strDesc);
    }

    public boolean isSearchable(JetUResourceEntity entity) {
        boolean bRet = false;
        if (entity != null) {
            DbColDesc desc = entity.getColDesc();
            bRet = desc != null && this.isSearchable(desc);
        }
        return bRet;
    }

    public boolean isSearchable(String datasourceName, JetUResourceEntity entity) {
        boolean bRet = false;
        if (entity != null) {
            DbColDesc desc = entity.getColDesc();
            bRet = desc != null && this.isSearchable(datasourceName, desc);
        }
        return bRet;
    }

    boolean checkSearchable(JetUConnection connection, DbColDesc desc) {
        boolean bRet = false;
        Vector vecTypeInfos = connection.getTypeInfo();
        int iSize = vecTypeInfos.size();
        JetUJDBCTypeInfo typeinfo = null;
        for (int i = 0; i < iSize; ++i) {
            typeinfo = (JetUJDBCTypeInfo)vecTypeInfos.elementAt(i);
            int type = JetUConnection.mapColType(typeinfo.DataType.get());
            if (type != desc.sqlType) continue;
            short searchable = (short)typeinfo.Searchable.get();
            bRet = searchable == 3 || searchable == 2;
            break;
        }
        return bRet;
    }

    boolean isSearchable(DbColDesc desc) {
        JetUConnection connection = this.getDatabase().getConnection();
        if (connection != null && connection instanceof JetUJDBCConnection) {
            return this.checkSearchable((JetUJDBCConnection)connection, desc);
        }
        return false;
    }

    boolean isSearchable(String datasourceName, DbColDesc desc) {
        JetUConnection connection = this.getDatabase(datasourceName).getConnection();
        if (connection != null && connection instanceof JetUJDBCConnection) {
            return this.checkSearchable((JetUJDBCConnection)connection, desc);
        }
        return false;
    }

    public JetUDatabase getDatabase() {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            JetUDatabase dbChild;
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUDatabase) || !(dbChild = (JetUDatabase)child).IsDefaultDB() && !dbChild.getResourceName().equals("")) continue;
            return dbChild;
        }
        return null;
    }

    public JetUDatabase getDatabase(String datasourceName) {
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUDatabase) || !((JetUDatabase)child).getResourceName().equals(datasourceName)) continue;
            return (JetUDatabase)child;
        }
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("Cannot find database [");
        errorMsg.append(datasourceName);
        errorMsg.append("]. + current database names are");
        for (Object child : this.children) {
            if (!(child instanceof JetUDatabase)) continue;
            errorMsg.append(" [");
            errorMsg.append(((JetUDatabase)child).getResourceName());
            errorMsg.append("]");
        }
        errorMsg.append(".");
        logger.debug(errorMsg);
        return null;
    }

    public Vector getAllDatabases() {
        Vector<JetObject> dbs = new Vector<JetObject>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUDatabase)) continue;
            dbs.addElement(child);
        }
        return dbs;
    }

    public Vector getAllDatabaseNames() {
        Vector v = this.getAllDatabases();
        int iSize = v.size();
        Vector<String> dbNames = new Vector<String>();
        for (int i = 0; i < iSize; ++i) {
            dbNames.addElement(((JetUDatabase)v.elementAt(i)).getResourceName());
        }
        return dbNames;
    }

    public boolean hasHierDataSource() {
        boolean ret = false;
        Vector ds = this.getAllDatabases();
        if (ds != null && ds.size() != 0) {
            for (int i = 0; i < ds.size(); ++i) {
                JetUDatabase db = (JetUDatabase)ds.elementAt(i);
                Vector hds = db.getHierDataSources();
                if (hds == null || hds.size() <= 0) continue;
                return true;
            }
        } else {
            return false;
        }
        return ret;
    }

    protected boolean createReportFolder(String strLocator) throws DocException {
        JetUDocFolder rootNode = this.getDocumentTree();
        rootNode.addFolder(strLocator);
        return true;
    }

    protected boolean createReportEntity(String strFolderName, String strName) throws DocException {
        return this.createReportEntity(strFolderName, strName, "", "", "", "", "", "", 0L, 0L, 0L);
    }

    protected boolean createReportEntity(String strFolderName, String strName, String strDesc, String strFile, String strType, String strQueryName, String strAuthor, String strKeywords, long lastModifiedTime, long lastRunTime, long lastPrintTime) throws DocException {
        JetUDocFolder rootNode = this.getDocumentTree();
        this.createReportFolder(strFolderName);
        JetUDocNode parentNode = this.getDocNodeByPath(strFolderName);
        if (parentNode != null && parentNode instanceof JetUDocFolder) {
            ((JetUDocFolder)parentNode).addReport(strName, strDesc, strFile, strType, strQueryName, strAuthor, strKeywords, lastModifiedTime, lastRunTime, lastPrintTime);
            return true;
        }
        return false;
    }

    protected boolean renameTo(DocObject sourceDoc, DocObject destDoc) {
        if (destDoc.exists()) {
            return false;
        }
        String strSourceParent = sourceDoc.getParent();
        String strDestParent = destDoc.getParent();
        if (strSourceParent != null && strDestParent != null && strSourceParent.equalsIgnoreCase(strDestParent)) {
            JetUDocNode sourceNode = this.getDocNodeByPath(sourceDoc.getPath());
            sourceNode.setName(destDoc.getName());
        }
        destDoc = null;
        return true;
    }

    protected boolean deleteReport(DocObject docObj, boolean bDeleteFile) {
        JetUDocNode docNode = this.getDocNodeByPath(docObj.getPath());
        if (docNode == null) {
            return false;
        }
        return docNode.delete(bDeleteFile);
    }

    public JetUDocFolder getDocumentTree() {
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUDocFolder)) continue;
            return (JetUDocFolder)child;
        }
        return null;
    }

    public Vector getAllDocFiles() {
        return this.getDocumentTree().getAllDocFiles();
    }

    public JetUDocNode getDocNodeByPath(String strPath) {
        JetUDocFolder rootNode = this.getDocumentTree();
        if (rootNode != null) {
            return rootNode.getChildByLocator(strPath);
        }
        return null;
    }

    public String getFullFileName() {
        String strRet = null;
        if (this.flCat == null) {
            return null;
        }
        try {
            strRet = this.flCat.getCanonicalPath();
        }
        catch (IOException e) {
            strRet = this.flCat.getPath();
        }
        return strRet;
    }

    public String getFileName() {
        if (this.flCat == null) {
            return null;
        }
        return this.flCat.getName();
    }

    public String getFilePath() {
        return this.flCat != null ? this.flCat.getParent() + File.separator : "";
    }

    public void setFullFileName(File flCat) {
        int i;
        String newPath;
        String oldPath;
        Vector vOdf;
        if (this.flCat != null && (vOdf = this.getOdfFiles()).size() > 0 && !(oldPath = this.flCat.getParent()).equalsIgnoreCase(newPath = flCat.getParent())) {
            for (i = 0; i < vOdf.size(); ++i) {
                String odfFile = (String)vOdf.elementAt(i);
                try {
                    FileUtil.copyFile(oldPath, newPath, new File(odfFile).getName());
                    continue;
                }
                catch (IOException e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("", e);
                }
            }
        }
        this.flCat = new File(flCat.getParent(), flCat.getName());
        String strName = flCat.getName();
        this.setName(Env.getFileName(strName, 1));
        Vector v = this.getAllDatabases();
        for (i = 0; i < v.size(); ++i) {
            JetUDatabase uDatabase = (JetUDatabase)v.elementAt(i);
            Vector conns = uDatabase.getConnections();
            for (int j = 0; j < conns.size(); ++j) {
                Object conn = conns.elementAt(j);
                if (!(conn instanceof JetUJDBCConnection)) continue;
                String connectionName = ((JetUJDBCConnection)conn).getResourceName();
                String url = ((JetUJDBCConnection)conn).getURL();
                this.setOOJDBCPath(uDatabase.getResourceName(), connectionName, url);
            }
        }
    }

    public void setOOJDBCPath(String dbName, String connectionName, String sURL) {
        if (sURL.startsWith("jdbc:jinfonet:object")) {
            this.setOdfPath(dbName, this.getFilePath(), connectionName, sURL);
        }
    }

    public Vector getOdfFiles() {
        Vector v = this.getAllDatabases();
        Vector<String> ret = new Vector<String>(1);
        for (int i = 0; i < v.size(); ++i) {
            JetUDatabase db = (JetUDatabase)v.elementAt(i);
            Vector conns = db.getConnections();
            for (int j = 0; j < conns.size(); ++j) {
                JetUJDBCConnection jdbcConn;
                String url;
                JetUConnection conn = (JetUConnection)conns.get(j);
                if (!(conn instanceof JetUJDBCConnection) || !(url = (jdbcConn = (JetUJDBCConnection)conn).getURL()).startsWith("jdbc:jinfonet:object")) continue;
                try {
                    Driver objDriver = jdbcConn.getDriver();
                    String odfFile = ((ObjectDriver)objDriver).parseUrl(url);
                    if (odfFile != null) {
                        ret.addElement(odfFile);
                        continue;
                    }
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Fail to find the odf file of database " + db.getResourceName() + " connection = [" + jdbcConn.getResourceName() + "].");
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Fail to find the odf file of database " + db.getResourceName() + " connection = [" + jdbcConn.getResourceName() + "].");
                }
            }
        }
        return ret;
    }

    private void setOdfPath(String dbName, String odfPath, String connectionName, String url) {
        Driver objDriver;
        JetUConnection conn = this.getDatabase(dbName).getConnectionByResourceName(connectionName);
        if (conn instanceof JetUJDBCConnection && (objDriver = ((JetUJDBCConnection)conn).getDriver()) instanceof ObjectDriver) {
            ((ObjectDriver)objDriver).setOdfPath(odfPath, url);
        }
    }

    public boolean isNeedUpdateFmlFile() {
        return this.bNeedUpdateFmlFile;
    }

    public boolean isNeedUpdateFmlFile(String sourceName) {
        Boolean isNeed = (Boolean)this.bNeedUpdateFmlFiles.get(sourceName);
        return isNeed == null ? true : isNeed;
    }

    public boolean IsModified() {
        return this.bIsModified;
    }

    public void setModified(boolean bIsModified) {
        this.bIsModified = bIsModified;
    }

    @Override
    public synchronized JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    public boolean isNeedSaveCatalog() {
        Vector v = this.getAllDatabaseNames();
        boolean isN = false;
        for (int i = 0; i < v.size(); ++i) {
            Boolean b = (Boolean)this.bNeedUpdateFmlFiles.get(v.elementAt(i));
            boolean bl = isN = b == null ? true : b;
            if (isN) break;
        }
        return !this.flCat.exists() || this.IsModified() || this.isNeedUpdateFmlFile() || isN;
    }

    private boolean CreateBackupCopy() {
        String strUnvsName = this.getFullFileName();
        File flBackup = new File(strUnvsName + BACKUP_FILE_EXTENSION);
        File flUnvs = new File(strUnvsName);
        if (flBackup.exists()) {
            flBackup.delete();
        }
        boolean bSuc = true;
        if (flUnvs.exists()) {
            bSuc = flUnvs.renameTo(flBackup);
        }
        return bSuc;
    }

    private void saveStyle() {
        block3: {
            if (this.root != null) {
                try {
                    new StyleToXSD(this.resourceStore.getDiskStore(), this.root, this.getFullFileName());
                }
                catch (Exception ie) {
                    if (!logger.isErrorEnabled()) break block3;
                    logger.error("", ie);
                }
            }
        }
    }

    public static Vector getStyleGroupNameList() {
        Vector nameList = new Vector();
        JetUUniverse unv = JetUUniverse.GetCurrentUniverse();
        if (unv != null && unv.root != null) {
            nameList = unv.root.getAllGroupNames(new Vector());
        }
        String path = ReportEnv.stylePath != null ? ReportEnv.stylePath : System.getProperty("reporthome") + File.separator + "style";
        File fPath = new File(path);
        Filter styleGroupFilter = new Filter(fPath, "_stl.xsd");
        File[] files = fPath.listFiles(styleGroupFilter);
        nameList.add("None");
        for (int i = 0; files != null && i < files.length; ++i) {
            String fileName = files[i].getName();
            String stlGrpName = fileName.substring(0, fileName.lastIndexOf("_"));
            if (nameList.contains(stlGrpName)) continue;
            nameList.add(stlGrpName);
        }
        return nameList;
    }

    public boolean Save() throws WriteFailureException, FMLFileException {
        boolean bSuc = true;
        this.PrepareBeforeSave();
        this.CreateBackupCopy();
        this.SaveToJetFile(this.getFullFileName());
        Vector names = this.getAllDatabaseNames();
        for (int i = 0; i < names.size(); ++i) {
            String name2 = (String)names.elementAt(i);
            this.savePrejoin(name2);
        }
        this.saveStyle();
        this.PrepareAfterSave();
        this.setModified(false);
        return bSuc;
    }

    public boolean Save(Vector names) throws WriteFailureException, FMLFileException {
        boolean bSuc = true;
        this.PrepareBeforeSave(names);
        this.CreateBackupCopy();
        this.SaveToJetFile(this.getFullFileName());
        for (int i = 0; i < names.size(); ++i) {
            String name2 = (String)names.elementAt(i);
            this.savePrejoin(name2);
        }
        this.saveStyle();
        this.PrepareAfterSave();
        this.setModified(false);
        return bSuc;
    }

    public boolean SaveNoParseFml() throws WriteFailureException {
        boolean bSuc = true;
        Vector v = this.getAllDatabases();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            JetUDatabase db = (JetUDatabase)v.elementAt(i);
            db.PrepareBeforeSave();
        }
        this.CreateBackupCopy();
        this.SaveToJetFile(this.getFullFileName());
        Vector names = this.getAllDatabaseNames();
        for (int i = 0; i < names.size(); ++i) {
            String name2 = (String)names.elementAt(i);
            this.savePrejoin(name2);
        }
        this.saveStyle();
        this.PrepareAfterSave();
        this.setModified(false);
        return bSuc;
    }

    public boolean Save(String strFilePath, String strFileName) throws WriteFailureException, FMLFileException {
        this.bNeedUpdateFmlFile = true;
        Vector v = this.getAllDatabaseNames();
        for (int i = 0; i < v.size(); ++i) {
            String name2 = (String)v.elementAt(i);
            if (this.bNeedUpdateFmlFiles.get(name2) != null) {
                this.bNeedUpdateFmlFiles.remove(name2);
            }
            this.bNeedUpdateFmlFiles.put(name2, new Boolean(true));
        }
        this.setFullFileName(new File(strFilePath, strFileName));
        return this.Save();
    }

    public boolean Save(String strFilePath, String strFileName, Vector names) throws WriteFailureException, FMLFileException {
        this.bNeedUpdateFmlFile = false;
        Vector v = this.getAllDatabaseNames();
        for (int i = 0; i < v.size(); ++i) {
            String name2 = (String)v.elementAt(i);
            if (this.bNeedUpdateFmlFiles.get(name2) != null) {
                this.bNeedUpdateFmlFiles.remove(name2);
            }
            if (names.contains(name2)) {
                this.bNeedUpdateFmlFiles.put(name2, new Boolean(true));
                continue;
            }
            this.bNeedUpdateFmlFiles.put(name2, new Boolean(false));
        }
        this.setFullFileName(new File(strFilePath, strFileName));
        return this.Save(names);
    }

    public static String getCatNameFromFileName(String catFileName) {
        if (catFileName.toLowerCase().endsWith(CAT_FILE_EXTENSION)) {
            return catFileName.substring(0, catFileName.lastIndexOf(46));
        }
        if (catFileName.toLowerCase().endsWith(".cat.xml")) {
            return catFileName.substring(0, catFileName.length() - ".cat.xml".length());
        }
        return null;
    }

    public synchronized boolean SaveTo(File flCat) throws WriteFailureException, FMLFileException {
        String strPath = flCat.getParent() + File.separator;
        String strName = flCat.getName();
        if (!strName.toLowerCase().endsWith(CAT_FILE_EXTENSION) && !strName.toLowerCase().endsWith(".cat.xml")) {
            throw new IllegalArgumentException("Catalog file name [" + strName + "] is illegal, the Catalog file name must end with [.cat] or [.cat.xml]");
        }
        strName = JetUUniverse.getCatNameFromFileName(strName);
        boolean bSuc = true;
        if (this.flCat == null) {
            this.setFullFileName(flCat);
        }
        this.PrepareBeforeSave();
        if (strName == null) {
            throw new WriteFailureException(32833, (Object[])new String[]{strName}, null);
        }
        Vector sourceNames = this.getAllDatabaseNames();
        int size = sourceNames.size();
        for (int i = 0; i < size; ++i) {
            String dname = (String)sourceNames.elementAt(i);
            File file = (File)this.flFormulaFiles.get(dname);
            File flFml = new File(strPath + strName + dname + FORMULA_FILE_EXTENSION);
            if (file == null) continue;
            try {
                FileUtil.copy(file, flFml);
                continue;
            }
            catch (IOException e) {
                throw new FMLFileException(flFml.getPath());
            }
        }
        this.SaveToJetFile(flCat.getPath());
        this.PrepareAfterSave();
        return bSuc;
    }

    public void output(OutputStream stream) throws WriteFailureException {
        ReportLoader.save((JetObject)this, stream, "Catalog");
    }

    protected void SaveToJetFile(String strFullFileName) throws WriteFailureException {
        ReportLoader.save(this.resourceStore.getDiskStore(), this, "Catalog", strFullFileName);
    }

    public JavaFormula loadJavaFormula() throws GenerateFormulasCodeException, ReadFailureException, ClassNotFoundException, FileNotFoundException, IOException, InstantiationException, IllegalAccessException, GenerateFormulasCodeException, LoadJavaFormulaException {
        JetUDatabase db = this.getDatabase();
        String name2 = db.getResourceName();
        return this.loadJavaFormula(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JavaFormula loadJavaFormula(String sourceName) throws GenerateFormulasCodeException, ReadFailureException, ClassNotFoundException, FileNotFoundException, IOException, InstantiationException, IllegalAccessException, GenerateFormulasCodeException, LoadJavaFormulaException {
        JetUDatabase uDatabase = this.getDatabase(sourceName);
        if (uDatabase == null) {
            throw new LoadJavaFormulaException(1);
        }
        File fmlFile = (File)this.flFormulaFiles.get(sourceName);
        byte[] classcode = null;
        classcode = (byte[])this.flFormulaCodeBytes.get(sourceName);
        Object object = compileFormulaLock;
        synchronized (object) {
            if (fmlFile == null || uDatabase.isNeedGenerateJava()) {
                if (!this.generateFormulaFile(sourceName)) {
                    return null;
                }
                classcode = null;
            }
            if (classcode == null) {
                fmlFile = (File)this.flFormulaFiles.get(sourceName);
                FileInputStream fi = new FileInputStream(fmlFile);
                classcode = new byte[fi.available()];
                fi.read(classcode);
                fi.close();
                this.flFormulaCodeBytes.put(sourceName, classcode);
            }
        }
        String qualifiedName = uDatabase.getCurFormulasFullClassName();
        DynamicClassManager dc = DynamicClassManager.getInstance();
        Class theClass = dc.bytesToClass(qualifiedName, classcode);
        Object o = null;
        try {
            o = theClass.newInstance();
        }
        catch (NoClassDefFoundError e) {
            if (logger.isErrorEnabled()) {
                logger.error(this, e);
            }
            LoadJavaFormulaException lfe = new LoadJavaFormulaException(1);
            lfe.initCause(e);
            throw lfe;
        }
        return o;
    }

    public boolean savePrejoin() {
        return this.savePrejoin("");
    }

    public boolean savePrejoin(String sourceName) {
        boolean success = true;
        if (this.editor != null) {
            try {
                this.editor.saveToFile(sourceName);
            }
            catch (WriteFailureException e) {
                success = false;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isContain(File f, String name2) {
        if (f.exists() && f.isFile()) {
            ZipFile zf = null;
            try {
                zf = new ZipFile(f);
                if (zf.getEntry(name2) != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (ZipException e) {
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            catch (Throwable t) {
                boolean bl = false;
                return bl;
            }
            finally {
                block24: {
                    try {
                        zf.close();
                    }
                    catch (Throwable e) {
                        if (!logger.isDebugEnabled()) break block24;
                        logger.debug(e);
                    }
                }
            }
        }
        return false;
    }

    private String filterClassPath() {
        String classPath = "";
        String javaHome = System.getProperty("java.home");
        String fullClassPath = FullClassPath.getFullClassPath();
        StringTokenizer st = new StringTokenizer(fullClassPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String name2 = st.nextToken();
            if (name2.indexOf(javaHome.substring(0, javaHome.length() - 4)) >= 0) continue;
            if (name2.endsWith(".zip") || name2.endsWith(".jar")) {
                File file = new File(name2);
                if (!file.exists() || !file.isFile() || !this.isContain(file, "jet")) continue;
                classPath = classPath + name2 + File.pathSeparator;
                continue;
            }
            classPath = classPath + name2 + File.pathSeparator;
        }
        return classPath;
    }

    private boolean generateFormulaFile(String sourceName) throws GenerateFormulasCodeException {
        JetUDatabase uDatabase = this.getDatabase(sourceName);
        if (uDatabase == null) {
            throw new GenerateFormulasCodeException("When GenerateFormulaFile, Database[" + sourceName + "] does not exist.");
        }
        File file = uDatabase.generateFormulaCodes(true, false);
        if (file == null) {
            return false;
        }
        File oldFML = this.getFMLFile(sourceName);
        if (this.bTmpFmlFileCreateds.get(sourceName) != null && ((Boolean)this.bTmpFmlFileCreateds.get(sourceName)).booleanValue() && file != null) {
            oldFML.delete();
        }
        this.flFormulaCodeBytes.remove(sourceName);
        this.flFormulaFiles.remove(sourceName);
        this.flFormulaFiles.put(sourceName, file);
        if (this.bNeedUpdateFmlFiles.get(sourceName) != null) {
            this.bNeedUpdateFmlFiles.remove(sourceName);
        }
        this.bNeedUpdateFmlFiles.put(sourceName, new Boolean(true));
        if (this.bTmpFmlFileCreateds.get(sourceName) != null) {
            this.bTmpFmlFileCreateds.remove(sourceName);
        }
        this.bTmpFmlFileCreateds.put(sourceName, new Boolean(true));
        return true;
    }

    private boolean complieFormula(String[] args) {
        boolean bClassSuc;
        block15: {
            String javacPath;
            block14: {
                bClassSuc = false;
                String javaHome = System.getProperty("java.home");
                javacPath = "";
                if (logger.isDebugEnabled()) {
                    logger.info("compiling formula#1: java.home = " + javaHome);
                }
                if (!javaHome.endsWith("java")) {
                    try {
                        if (javaHome.endsWith("jre")) {
                            javaHome = javaHome.substring(0, javaHome.length() - 3);
                            javacPath = javaHome + "bin" + File.separator;
                            break block14;
                        }
                        if (javaHome.indexOf("java") == -1) {
                            if (logger.isDebugEnabled()) {
                                logger.info("compiling formula#2: Java Home get error.");
                            }
                            throw new Exception("Java Home get error");
                        }
                        int index = javaHome.indexOf("java");
                        javaHome = javaHome.substring(0, index + 4);
                        javacPath = javaHome + File.separator + "bin" + File.separator;
                    }
                    catch (Exception e) {
                        if (logger.isErrorEnabled()) {
                            logger.error("", e);
                        }
                        break block14;
                    }
                }
                javacPath = javaHome + File.separator + "bin" + File.separator;
            }
            if (logger.isDebugEnabled()) {
                logger.info("compiling formula#3: javacPath = " + javacPath);
            }
            if (!javacPath.equals("") || javacPath != "") {
                String[] cmd = new String[]{javacPath.trim() + "javac", "-source", "1.4", "-target", "1.4", "-nowarn", "-classpath", args[1], args[3]};
                if (logger.isDebugEnabled()) {
                    String msg = "The compile cmd:";
                    for (int i = 0; i < cmd.length; ++i) {
                        msg = msg + " " + cmd[i];
                    }
                    logger.debug(msg);
                    logger.info("compiling formula#4: classpath = " + args[1]);
                }
                try {
                    Process proc = Runtime.getRuntime().exec(cmd);
                    StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), true);
                    StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), false);
                    errorGobbler.start();
                    outputGobbler.start();
                    int retValue = proc.waitFor();
                    bClassSuc = retValue == 0;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block15;
                    logger.error("", e);
                }
            }
        }
        return bClassSuc;
    }

    private String addExtenalLib(String dataSource) {
        int i;
        String arg = "";
        Vector udfClass = new Vector();
        JetUDatabase db = this.getDatabase(dataSource);
        if (db != null) {
            udfClass = db.getUDFNames();
        }
        String[] udfNames = new String[udfClass.size()];
        for (int i2 = 0; i2 < udfClass.size(); ++i2) {
            udfNames[i2] = (String)udfClass.elementAt(i2);
        }
        DynamicClassManager dc = DynamicClassManager.getInstance();
        String[] paths = dc.getResourceName(udfNames);
        for (i = 0; i < paths.length; ++i) {
            arg = arg.endsWith(File.pathSeparator) ? arg + paths[i] : arg + File.pathSeparator + paths[i];
        }
        for (i = 0; i < udfClass.size(); ++i) {
            try {
                Class<?> c = Class.forName(udfNames[i]);
                String jar = this.reflectClasspath(c.getClassLoader(), c);
                if (arg.endsWith(File.pathSeparator)) {
                    arg = arg + jar;
                    continue;
                }
                arg = arg + File.pathSeparator + jar;
                continue;
            }
            catch (ClassNotFoundException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error(e);
            }
        }
        String[] findClassName = new String[]{"jet.formula.FormulaClassLoader", "jet.util.FullClassPath", "jet.connect.DbQuery"};
        String[] classPath = dc.getResourceName(findClassName);
        for (int i3 = 0; i3 < classPath.length; ++i3) {
            arg = arg.endsWith(File.pathSeparator) ? arg + classPath[i3] : arg + File.pathSeparator + classPath[i3];
        }
        return arg;
    }

    public String reflectClasspath(ClassLoader classLoader, Class clazz) {
        String cFile = clazz.getName().replace('.', '/') + ".class";
        URL url = classLoader.getResource(cFile);
        String path = URLDecoder.decode(url.getPath());
        String protocol = url.getProtocol();
        if (protocol.equals("jar") || protocol.equals("wsjar") || protocol.equals("zip")) {
            if (path.startsWith("file:")) {
                path = path.charAt(7) == ':' ? path.substring(6) : path.substring(5);
            }
            return path.substring(0, path.indexOf(33)).replace('/', File.separatorChar);
        }
        if (path.length() >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        return path.substring(0, path.length() - cFile.length()).replace('/', File.separatorChar);
    }

    public File getFMLFile() {
        String strFMLFilePath = this.getFilePath() + this.getName() + FORMULA_FILE_EXTENSION;
        return new File(strFMLFilePath);
    }

    public File getFMLFile(String sourceName) {
        String strFMLFilePath = this.getFilePath() + this.getName() + sourceName + FORMULA_FILE_EXTENSION;
        return new File(strFMLFilePath);
    }

    public boolean isFMLFileMatch(File flFml) {
        JetUDatabase uDatabase = this.getDatabase();
        String uQualifiedName = uDatabase.getCurFormulasFullClassName();
        String fQualifiedName = JetUUniverse.getClassNameOfFMLFile(flFml);
        return uQualifiedName.equals(fQualifiedName);
    }

    public boolean isFMLFileMatch(File flFml, String sourceName) {
        JetUDatabase uDatabase = this.getDatabase(sourceName);
        String uQualifiedName = uDatabase.getCurFormulasFullClassName();
        String fQualifiedName = JetUUniverse.getClassNameOfFMLFile(flFml);
        return uQualifiedName.equals(fQualifiedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameOfFMLFile(File flFml) {
        String strClassName = null;
        FileInputStream fi = null;
        FilterInputStream di = null;
        try {
            fi = new FileInputStream(flFml);
            di = new DataInputStream(new BufferedInputStream(fi));
            ((DataInputStream)di).readInt();
            ((DataInputStream)di).readUnsignedShort();
            ((DataInputStream)di).readUnsignedShort();
            int constant_pool_count = ((DataInputStream)di).readUnsignedShort();
            cp_info[] constant_pool = new cp_info[constant_pool_count];
            for (int i = 1; i < constant_pool_count; ++i) {
                cp_info cp = new cp_info();
                cp.load((DataInputStream)di);
                constant_pool[i] = cp;
                switch (cp.getTag()) {
                    case 5: 
                    case 6: {
                        ++i;
                    }
                }
            }
            ((DataInputStream)di).readUnsignedShort();
            int this_class = ((DataInputStream)di).readUnsignedShort();
            ((DataInputStream)di).readUnsignedShort();
            strClassName = constant_pool[constant_pool[this_class].getIndex0()].getUTF().replace('/', '.');
            di.close();
        }
        catch (Exception e) {
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException e) {
                    logger.error("", e);
                }
            }
            if (di != null) {
                try {
                    di.close();
                }
                catch (IOException e) {
                    logger.error("", e);
                }
            }
        }
        return strClassName;
    }

    @Override
    public void objectModified() {
        this.setModified(true);
    }

    public static void addUniverseListener(UUniverseListener listener) {
        if (!listeners.contains(listener)) {
            listeners.addElement(listener);
        }
    }

    public static void removeUniverseListener(UUniverseListener listener) {
        if (listeners.contains(listener)) {
            listeners.removeElement(listener);
        }
    }

    public static void objectChanged(JetUUniverse universe, JetUTreeNode object, int type) {
        int iSize = listeners.size();
        for (int i = 0; i < iSize; ++i) {
            ((UUniverseListener)listeners.elementAt(i)).objectChanged(universe, object, type);
        }
    }

    public static boolean isInUse(JetUUniverse universe, JetUTreeNode object, StringBuffer buffer) {
        boolean ret = false;
        int iSize = listeners.size();
        for (int i = 0; i < iSize; ++i) {
            if (!((UUniverseListener)listeners.elementAt(i)).isInUse(universe, object, buffer)) continue;
            ret = true;
        }
        return ret;
    }

    protected static void Closing() {
        int iSize = listeners.size();
        for (int i = 0; i < iSize; ++i) {
            ((UUniverseListener)listeners.elementAt(i)).UniverseClosing(curUniverse);
        }
    }

    private static void Changed(JetUUniverse unvsOld) {
        int iSize = listeners.size();
        for (int i = 0; i < iSize; ++i) {
            ((UUniverseListener)listeners.elementAt(i)).UniverseChanged(unvsOld, curUniverse);
        }
    }

    private void NameChanged(JetUUniverse unvs) {
        if (unvs == curUniverse) {
            int iSize = listeners.size();
            for (int i = 0; i < iSize; ++i) {
                ((UUniverseListener)listeners.elementAt(i)).UniverseNameChanged();
            }
        }
    }

    public static JetUUniverse GetCurrentUniverse() {
        return curUniverse;
    }

    public static void closeCurrentUniverse() {
        if (curUniverse != null) {
            curUniverse.clearMem();
            curUniverse = null;
        }
    }

    private static void SetUniverse(JetUUniverse unvs) {
        JetUUniverse.Closing();
        JetUUniverse unvsOld = curUniverse;
        curUniverse = unvs;
        JetUUniverse.Changed(unvsOld);
    }

    private static void SetUniverse(JetUUniverse unvs, int clearMem) {
        JetUUniverse.Closing();
        JetUUniverse unvsOld = curUniverse;
        curUniverse = unvs;
        JetUUniverse.Changed(unvsOld);
        if (clearMem == 1 && unvsOld != null && !unvsOld.getName().equals(curUniverse.getName())) {
            unvsOld.clearMem();
        }
    }

    public static void setUniverse(JetUUniverse unvs) {
        curUniverse = unvs;
    }

    public static JetUUniverse OpenUniverse(String strFullFileName) throws ReadFailureException, UniverseFileException {
        File flCat = new File(strFullFileName);
        return JetUUniverse.OpenUniverse(flCat.getParent(), flCat.getName());
    }

    public static JetUUniverse OpenUniverse(String strFilePath, String strFileName) throws ReadFailureException, UniverseFileException {
        JetUUniverse unvs = JetUUniverse.LoadFromJetFile(strFilePath, strFileName);
        JetUUniverse.SetUniverse(unvs);
        return unvs;
    }

    public static JetUUniverse OpenUniverse(String strFilePath, String strFileName, int clearMem) throws ReadFailureException, UniverseFileException {
        JetUUniverse unvs = JetUUniverse.LoadFromJetFile(strFilePath, strFileName);
        JetUUniverse.SetUniverse(unvs, clearMem);
        return unvs;
    }

    public static JetUUniverse LoadUniverse(String strFullFileName) throws ReadFailureException, UniverseFileException {
        File flCat = new File(strFullFileName);
        return JetUUniverse.LoadUniverse(flCat.getParent(), flCat.getName());
    }

    public static JetUUniverse LoadUniverse(String strFilePath, String strFileName) throws ReadFailureException, UniverseFileException {
        return JetUUniverse.LoadFromJetFile(strFilePath, strFileName);
    }

    private static JetUUniverse LoadFromJetFile(String strFilePath, String strFileName) throws ReadFailureException, UniverseFileException {
        JetUUniverse unvs = null;
        JetObject obj = null;
        ReportLoader loader = new ReportLoader(strFilePath, strFileName);
        obj = loader.load();
        if (!(obj instanceof JetUUniverse)) {
            throw new UniverseFileException(strFileName, 1);
        }
        unvs = (JetUUniverse)obj;
        String strVersion = unvs.version.get();
        if (strVersion != null && !strVersion.equals("") && !strCurVersion.equalsIgnoreCase(strVersion)) {
            throw new UniverseFileException(strFileName, 2);
        }
        if (unvs.versionNumber.get() > 17) {
            throw new UniverseFileException(strFileName, 3, unvs.versionNumber.get(), 17);
        }
        return unvs;
    }

    public static JetUUniverse LoadNoCache(String strFullFileName) throws ReadFailureException, UniverseFileException {
        File flCat = new File(strFullFileName);
        return JetUUniverse.LoadNoCache(flCat.getParent(), flCat.getName());
    }

    public static JetUUniverse LoadNoCache(String strFilePath, String strFileName) throws ReadFailureException, UniverseFileException {
        return JetUUniverse.LoadFromJetFileNoCache(strFilePath, strFileName, 17);
    }

    public static JetUUniverse LoadNoCache(String strFilePath, String strFileName, int upgrade2Version) throws ReadFailureException, UniverseFileException {
        return JetUUniverse.LoadFromJetFileNoCache(strFilePath, strFileName, upgrade2Version);
    }

    private static JetUUniverse LoadFromJetFileNoCache(String strFilePath, String strFileName, int upgrade2Version) throws ReadFailureException, UniverseFileException {
        JetUUniverse unvs = null;
        JetObject obj = null;
        JetUUniverse.upgrade2Version.set(upgrade2Version);
        LoaderNoCache loader = new LoaderNoCache(strFilePath, strFileName);
        obj = loader.load();
        JetUUniverse.upgrade2Version.remove();
        if (!(obj instanceof JetUUniverse)) {
            throw new UniverseFileException(strFileName, 1);
        }
        unvs = (JetUUniverse)obj;
        String strVersion = unvs.version.get();
        if (strVersion != null && !strVersion.equals("") && !strCurVersion.equalsIgnoreCase(strVersion)) {
            throw new UniverseFileException(strFileName, 2);
        }
        if (unvs.versionNumber.get() > 17) {
            throw new UniverseFileException(strFileName, 3, unvs.versionNumber.get(), 17);
        }
        return unvs;
    }

    public static JetUUniverse NewUniverse(String strFullFileName) {
        JetUUniverse unvs = JetUUniverse.BuildDefaultUniverse(strFullFileName);
        JetUUniverse.SetUniverse(unvs);
        return unvs;
    }

    public static JetUUniverse NewUnivers(String strFullFileName, String dbName) {
        JetUUniverse unvs = JetUUniverse.BuildDefaultUniverse(strFullFileName, dbName);
        JetUUniverse.SetUniverse(unvs);
        return unvs;
    }

    public static JetUUniverse BuildDefaultUniverse(String strFullFileName, String dbName) {
        JetUUniverse unvs = new JetUUniverse(strFullFileName);
        unvs.InitAfterCreate(dbName);
        return unvs;
    }

    public void InitAfterCreate(String dbName) {
        this.version.set(strCurVersion);
        JetUDatabase uDatabase = new JetUDatabase(dbName, "");
        uDatabase.setDefaultDB(true);
        this.add(uDatabase);
        uDatabase.InitAfterCreate();
        JetUDocFolder folder = new JetUDocFolder(JResource.getMessage("DocumentTree"), "");
        this.add(folder);
        this.isCatalogPrepareOK = true;
    }

    public static JetUUniverse BuildDefaultUniverse(String strFullFileName) {
        JetUUniverse unvs = new JetUUniverse(strFullFileName);
        unvs.InitAfterCreate();
        return unvs;
    }

    public static JetUUniverse BuildDefaultUniverse() {
        JetUUniverse unvs = new JetUUniverse();
        unvs.InitAfterCreate();
        return unvs;
    }

    @Override
    public void setNamingTable(Hashtable h) {
        this.sysObjects = h;
    }

    @Override
    public Hashtable getNamingTable() {
        return this.sysObjects;
    }

    @Override
    public void setNamingCount(Hashtable h) {
        this.sysCounts = h;
    }

    @Override
    public Hashtable getNamingCount() {
        if (this.sysCounts == null) {
            this.sysCounts = new Hashtable();
        }
        return this.sysCounts;
    }

    public JetUConnection getConnectionByResourceName(String strRscConnectionName) {
        return this.getDatabase().getConnectionByResourceName(strRscConnectionName);
    }

    public JetUConnection getConnectionByResourceName(String dataSourceName, String strRscConnectionName) {
        return this.getDatabase(dataSourceName).getConnectionByResourceName(strRscConnectionName);
    }

    public JetUQuery GetQueryByResourceName(String strQueryName) {
        return this.getDatabase().GetQueryByResourceName(strQueryName);
    }

    public JetUQuery GetQueryByResourceName(String sourceName, String strQueryName) {
        JetUDatabase db = this.getDatabase(sourceName);
        if (db != null) {
            return db.GetQueryByResourceName(strQueryName);
        }
        logger.debug("Can't find database " + sourceName);
        return null;
    }

    public boolean IsDataSourceNameExist(String sourceName) {
        Vector v = this.getAllDatabaseNames();
        for (int i = 0; i < v.size(); ++i) {
            String name2 = (String)v.elementAt(i);
            if (!name2.equals(sourceName)) continue;
            return true;
        }
        return false;
    }

    public boolean isDataSourceNameOK(String dataSourceName, StringBuffer error) {
        if (dataSourceName != null && (dataSourceName = dataSourceName.trim()).length() != 0) {
            return true;
        }
        if (error != null) {
            error.append("The name can not be empty.");
        }
        return false;
    }

    public boolean IsQueryNameExist(String strQueryName) {
        return this.getDatabase().IsQueryNameExist(strQueryName);
    }

    public boolean IsQueryNameExist(String dataSourceName, String strQueryName) {
        return this.getDatabase(dataSourceName).IsQueryNameExist(strQueryName);
    }

    public boolean IsMappingNameOK(String name2, StringBuffer error) {
        Vector dbs = this.getAllDatabases();
        for (int i = 0; i < dbs.size(); ++i) {
            JetUDatabase db = (JetUDatabase)dbs.elementAt(i);
            if (!db.IsNameValid(name2, error)) {
                return false;
            }
            if (!db.IsMappingNameExist(name2)) continue;
            if (error != null) {
                error.append(JResource.getMessage("CAT_16", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public boolean IsNonParaMappingNameOK(String name2, StringBuffer error) {
        Vector dbs = this.getAllDatabases();
        for (int i = 0; i < dbs.size(); ++i) {
            JetUDatabase db = (JetUDatabase)dbs.elementAt(i);
            if (!(db.getResourceByName(name2) instanceof JetUParameter)) continue;
            if (error != null) {
                error.append(JResource.getMessage("CAT_16", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public Vector getQueriables() {
        return this.getDatabase().getQueriables();
    }

    public Vector getQueriables(String dataSourceName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        return db == null ? new Vector() : db.getQueriables();
    }

    public Vector getSummaries(String colName, Vector groupByNames, String func) {
        return this.getDatabase().getSummaries(colName, groupByNames, func);
    }

    public Vector getSummaries(String dataSourceName, String colName, Vector groupByNames, String func) {
        return this.getDatabase(dataSourceName).getSummaries(colName, groupByNames, func);
    }

    public JetUQueriable getQueriableByResourceName(String strQueryName) {
        return this.getDatabase().getQueriableByResourceName(strQueryName);
    }

    public JetUQueriable getQueriableByResourceName(String dataSourceName, String strQueryName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getQueriableByResourceName(strQueryName);
        }
        logger.debug("Can't find database " + dataSourceName);
        return null;
    }

    public boolean isQueriableExist(String strQueryName) {
        return this.getDatabase().isQueriableExist(strQueryName);
    }

    public boolean isQueriableExist(String dataSourceName, String strQueryName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.isQueriableExist(strQueryName);
        }
        logger.debug("Can't find database " + dataSourceName);
        return false;
    }

    public JetUResourceEntity getResourceByName(String name2) {
        if (UniverseToolkit.isBuildinParameterName(name2)) {
            return JetUParameter.buildinParameter;
        }
        return this.getDatabase().getResourceByName(name2);
    }

    public JetUResourceEntity getAnyResourceByName(String name2) {
        if (UniverseToolkit.isBuildinParameterName(name2)) {
            return JetUParameter.buildinParameter;
        }
        Vector dbs = this.getAllDatabases();
        for (int i = 0; i < dbs.size(); ++i) {
            JetUDatabase db = (JetUDatabase)dbs.elementAt(i);
            JetUResourceEntity entity = db.getResourceByName(name2);
            if (entity == null || !(entity instanceof JetUParameter)) continue;
            return entity;
        }
        return null;
    }

    public JetUResourceEntity getMaterialByName(String dataSourceName, String name2) {
        if (UniverseToolkit.isBuildinParameterName(name2)) {
            return JetUParameter.buildinParameter;
        }
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getResourceByName(name2);
        }
        return null;
    }

    public JetUResourceEntity getResourceByName(String strQueryName, String name2) {
        if (UniverseToolkit.isBuildinParameterName(name2)) {
            return JetUParameter.buildinParameter;
        }
        return this.getDatabase().getResourceByName(strQueryName, name2);
    }

    public JetUResourceEntity getResourceByName(String dataSourceName, String strQueryName, String name2) {
        if (UniverseToolkit.isBuildinParameterName(name2)) {
            return JetUParameter.buildinParameter;
        }
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getResourceByName(strQueryName, name2);
        }
        logger.debug("Can't find database " + dataSourceName);
        return null;
    }

    public Vector getAvailableResourceEntitys(String strQueryName) {
        return this.getDatabase().getAvailableResourceEntitys(strQueryName);
    }

    public Vector getAvailableResourceEntitys(String dataSourceName, String strQueryName) {
        Vector resourceEnt = new Vector();
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            resourceEnt = db.getAvailableResourceEntitys(strQueryName);
        } else {
            logger.debug("Can't find database " + dataSourceName);
        }
        return resourceEnt;
    }

    public Vector getParameters() {
        return this.getDatabase().getParameters();
    }

    public Vector getParameters(String dataSourceName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getParameters();
        }
        logger.debug("Can't find database " + dataSourceName);
        return new Vector();
    }

    public Vector getGroupByFormula(String strGroupName) {
        return this.getDatabase().getGroupByFormula(strGroupName);
    }

    public Vector getGroupByFormulas(String dataSourceName, String strGroupName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getGroupByFormula(strGroupName);
        }
        logger.debug("Can't find database " + dataSourceName);
        return new Vector();
    }

    public Vector getGroupByFormula(String strGroupName, String strQueryName) {
        return this.getDatabase().getGroupByFormula(strGroupName, strQueryName);
    }

    public Vector getGroupByFormula(String dataSourceName, String strGroupName, String strQueryName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getGroupByFormula(strGroupName, strQueryName);
        }
        logger.debug("Can't find database " + dataSourceName);
        return new Vector();
    }

    public boolean checkIfMappingFldsValidToQuery(String strQueryName, Vector colsName) throws InvalidEntityException, CannotFindQuery {
        return this.getDatabase().checkIfMappingFldsValidToQuery(strQueryName, colsName);
    }

    public boolean checkIfMappingFldsValidToQuery(String dataSourceName, String strQueryName, Vector colsName) throws InvalidEntityException, CannotFindQuery {
        long start = System.nanoTime();
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            boolean ret = db.checkIfMappingFldsValidToQuery(strQueryName, colsName);
            long time2 = (System.nanoTime() - start) / 1000000L;
            logger.outLine("JetUUniverse.checkIfMappingFldsValidToQuery: " + time2 + "(ms) dataSourceName = " + dataSourceName + " strQueryName = " + strQueryName + " colsName size() = " + colsName.size());
            return ret;
        }
        logger.debug("Can't find database " + dataSourceName);
        return false;
    }

    public boolean checkIfMappingFldsValidToQuery(String strQueryName, Vector colsName, Hashtable otherName) throws InvalidEntityException, CannotFindQuery {
        return this.getDatabase().checkIfMappingFldsValidToQuery(strQueryName, colsName, otherName);
    }

    public boolean checkIfMappingFldsValidToQuery(String dataSourceName, String strQueryName, Vector colsName, Hashtable otherName) throws InvalidEntityException, CannotFindQuery {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.checkIfMappingFldsValidToQuery(strQueryName, colsName, otherName);
        }
        logger.debug("Can't find database " + dataSourceName);
        return false;
    }

    public DbColDesc getSQLType(String colName) {
        return this.getDatabase().getSQLType(colName);
    }

    public DbColDesc getSqlType(String dataSourceName, String colName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getSQLType(colName);
        }
        logger.debug("Can't find database " + dataSourceName);
        return null;
    }

    public DbColDesc getSQLType(String strQueryName, String colName) {
        return this.getDatabase().getSQLType(strQueryName, colName);
    }

    public DbColDesc getSQLType(String dataSourceName, String strQueryName, String colName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getSQLType(strQueryName, colName);
        }
        logger.debug("Can't find database " + dataSourceName);
        return null;
    }

    public Vector getFormulasInDatabase() {
        return this.getDatabase().getFormulas();
    }

    public Vector getFormulasInDatabase(String dataSourceName) {
        JetUDatabase db = this.getDatabase(dataSourceName);
        if (db != null) {
            return db.getFormulas();
        }
        logger.debug("Can't find database " + dataSourceName);
        return new Vector();
    }

    public static boolean canCreateCatalog(String strFile) {
        File flCat = new File(strFile);
        return JetUUniverse.canCreateCatalog(new File(flCat.getParent()));
    }

    public static boolean canCreateCatalog(String strPath, String strName) {
        return JetUUniverse.canCreateCatalog(new File(strPath));
    }

    protected static boolean canCreateCatalog(File flDir) {
        if (!flDir.exists()) {
            return false;
        }
        String[] catFiles = flDir.list(new WildcardMatcher(CAT_FILE_WILDCARD, false));
        return catFiles == null || catFiles.length == 0;
    }

    public static boolean createCatalog(String strPath, String strName, ConnectionDesc connection) {
        boolean bSuc;
        block6: {
            if (!JetUUniverse.canCreateCatalog(strPath, strName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Create the catalog failed.  Either the specified directory does not exist or there is an existing catalog in that directory.");
                }
                return false;
            }
            File flCat = new File(strPath, strName + CAT_FILE_EXTENSION);
            JetUUniverse unvs = JetUUniverse.BuildDefaultUniverse(flCat.getPath());
            JetUDatabase udb = unvs.getDatabase();
            udb.addConnection(connection.strName, "", connection.strURL, connection.strUser, connection.strPassword, 0, connection.strDriver);
            try {
                bSuc = unvs.Save();
            }
            catch (WriteFailureException e) {
                bSuc = false;
                if (logger.isErrorEnabled()) {
                    logger.error("", e);
                }
            }
            catch (FMLFileException e) {
                bSuc = false;
                if (!logger.isErrorEnabled()) break block6;
                logger.error("", e);
            }
        }
        return bSuc;
    }

    public static ConnectionDesc getCatalogsDataSource(String strCatFile) {
        ConnectionDesc connection = null;
        try {
            File flCat = new File(strCatFile);
            JetUUniverse unvs = JetUUniverse.LoadUniverse(flCat.getParent(), flCat.getName());
            JetUDatabase udb = unvs.getDatabase();
            JetUJDBCConnection cnnt = (JetUJDBCConnection)udb.getConnection();
            if (cnnt != null) {
                connection = new ConnectionDesc();
                connection.strName = cnnt.getResourceName();
                connection.strURL = cnnt.getURL();
                connection.strUser = cnnt.getUID();
                connection.strDriver = cnnt.getJdbcDriver();
            }
        }
        catch (ReadFailureException e) {
        }
        catch (UniverseFileException universeFileException) {
            // empty catch block
        }
        return connection;
    }

    public static ConnectionDesc getCatalogsDataSource(String dataSourceName, String strCatFile) {
        ConnectionDesc connection = null;
        try {
            File flCat = new File(strCatFile);
            JetUUniverse unvs = JetUUniverse.LoadUniverse(flCat.getParent(), flCat.getName());
            JetUDatabase udb = unvs.getDatabase(dataSourceName);
            JetUJDBCConnection cnnt = (JetUJDBCConnection)udb.getConnection();
            if (cnnt != null) {
                connection = new ConnectionDesc();
                connection.strName = cnnt.getResourceName();
                connection.strURL = cnnt.getURL();
                connection.strUser = cnnt.getUID();
                connection.strDriver = cnnt.getJdbcDriver();
            }
        }
        catch (ReadFailureException e) {
        }
        catch (UniverseFileException universeFileException) {
            // empty catch block
        }
        return connection;
    }

    public boolean saveWherePortion(String strName, String strQueryName, String strSQL) {
        JetUWherePortion uWherePortion = new JetUWherePortion(strName, "", strSQL);
        uWherePortion.setQueryName(strQueryName);
        return this.saveWherePortion(uWherePortion);
    }

    public boolean saveWherePortion(String strName, String sourceName, String strQueryName, String strSQL) {
        JetUWherePortion uWherePortion = new JetUWherePortion(strName, "", strSQL);
        uWherePortion.setQueryName(strQueryName);
        uWherePortion.setSourceName(sourceName);
        return this.saveWherePortion(uWherePortion);
    }

    public boolean saveWherePortion(String strName, String strQueryName, Vector vecGroups) {
        JetUWherePortion uWherePortion = new JetUWherePortion(strName, "", vecGroups);
        uWherePortion.setQueryName(strQueryName);
        return this.saveWherePortion(uWherePortion);
    }

    public boolean saveWherePortion(String strName, String sourceName, String strQueryName, Vector vecGroups) {
        JetUWherePortion uWherePortion = new JetUWherePortion(strName, "", vecGroups);
        uWherePortion.setQueryName(strQueryName);
        uWherePortion.setSourceName(sourceName);
        return this.saveWherePortion(uWherePortion);
    }

    public boolean saveWherePortion(String strName, String strSQL) {
        return this.saveWherePortion(strName, "", strSQL);
    }

    public boolean saveWherePortionBySourceName(String strName, String sourceName, String strSQL) {
        return this.saveWherePortion(strName, sourceName, "", strSQL);
    }

    public boolean saveWherePortion(String strName, Vector vecGroups) {
        return this.saveWherePortion(strName, "", vecGroups);
    }

    public boolean saveWherePortionBySourceName(String strName, String sourceName, Vector vecGroups) {
        return this.saveWherePortion(strName, sourceName, "", vecGroups);
    }

    protected boolean saveWherePortion(JetUWherePortion uWherePortion) {
        boolean bSuc = false;
        bSuc = this.getDatabase().addWherePortion(uWherePortion);
        if (bSuc) {
            bSuc = this.saveCatalog();
        }
        return bSuc;
    }

    protected boolean saveWherePortion(JetUWherePortion uWherePortion, String sourceName) {
        boolean bSuc = false;
        JetUDatabase db = this.getDatabase(sourceName);
        if (db != null) {
            bSuc = db.addWherePortion(uWherePortion);
            if (bSuc) {
                bSuc = this.saveCatalog();
            }
        } else {
            logger.debug("Can't find database " + sourceName);
        }
        return bSuc;
    }

    public boolean modifyWherePortion(String strName, String strQueryName, String strSQL) {
        return this.modifyWherePortion(strName, strQueryName, (Object)strSQL);
    }

    public boolean modifyWherePortion(String strName, String sourceName, String strQueryName, String strSQL) {
        return this.modifyWherePortion(strName, sourceName, strQueryName, (Object)strSQL);
    }

    public boolean modifyWherePortion(String strName, String strQueryName, Vector vecGroups) {
        return this.modifyWherePortion(strName, strQueryName, (Object)vecGroups);
    }

    public boolean modifyWherePortion(String strName, String sourceName, String strQueryName, Vector vecGroups) {
        return this.modifyWherePortion(strName, sourceName, strQueryName, (Object)vecGroups);
    }

    public boolean modifyWherePortion(String strName, String strQueryName, Object portion) {
        JetUWherePortion uWherePortion = this.getDatabase().getWherePortionByResourceName(strName);
        if (uWherePortion != null) {
            return this.modWherePortion(uWherePortion, null, strQueryName, portion);
        }
        return false;
    }

    public boolean modifyWherePortion(String strName, String sourceName, String strQueryName, Object portion) {
        JetUWherePortion uWherePortion = this.getDatabase(sourceName).getWherePortionByResourceName(strName);
        if (uWherePortion != null) {
            return this.modWherePortion(uWherePortion, sourceName, strQueryName, portion);
        }
        return false;
    }

    boolean modWherePortion(JetUWherePortion uWherePortion, String sourceName, String strQueryName, Object portion) {
        boolean bSuc = false;
        if (portion instanceof String) {
            uWherePortion.setWherePortion((String)portion);
        } else if (portion instanceof Vector) {
            uWherePortion.setGroups((Vector)portion);
        }
        uWherePortion.setSourceName(sourceName);
        uWherePortion.setQueryName(strQueryName);
        bSuc = true;
        if (bSuc) {
            bSuc = this.saveCatalog();
        }
        return bSuc;
    }

    public boolean deleteWherePortion(String strName) {
        boolean bSuc = this.getDatabase().removeWherePortion(strName);
        if (bSuc) {
            bSuc = this.saveCatalog();
        }
        return bSuc;
    }

    public boolean deleteWherePortion(String strName, String sourceName) {
        boolean bSuc = false;
        JetUDatabase db = this.getDatabase(sourceName);
        if (db != null) {
            bSuc = db.removeWherePortion(strName);
            if (bSuc) {
                bSuc = this.saveCatalog();
            }
        } else {
            logger.debug("Can't find database " + sourceName);
        }
        return bSuc;
    }

    public Enumeration getAvailableWherePortions() {
        Vector vecWherePortions = this.getDatabase().getWherePortions();
        return this.availableWherePortions(vecWherePortions, null);
    }

    public Enumeration getDataSourceAvailableWherePortions(String sourceName) {
        Vector vecWherePortions = new Vector();
        JetUDatabase db = this.getDatabase(sourceName);
        if (db != null) {
            vecWherePortions = db.getWherePortions();
        } else {
            logger.debug("Can't find database " + sourceName);
        }
        return this.availableWherePortions(vecWherePortions, null);
    }

    Enumeration availableWherePortions(Vector vecWherePortions, String strQueryName) {
        Vector<String> vecReturn = new Vector<String>();
        int iWherePortionCount = vecWherePortions.size();
        for (int i = 0; i < iWherePortionCount; ++i) {
            JetUWherePortion uWherePortion = (JetUWherePortion)vecWherePortions.elementAt(i);
            if (strQueryName != null) {
                if (!uWherePortion.getQueryName().equals("") && !strQueryName.equalsIgnoreCase(uWherePortion.getQueryName())) continue;
                vecReturn.addElement(uWherePortion.getResourceName());
                continue;
            }
            vecReturn.addElement(uWherePortion.getResourceName());
        }
        return vecReturn.elements();
    }

    public Enumeration getAvailableWherePortions(String strQueryName) {
        Vector vecWherePortions = this.getDatabase().getWherePortions();
        return this.availableWherePortions(vecWherePortions, strQueryName);
    }

    public Enumeration getAvailableWherePortions(String sourceName, String strQueryName) {
        Vector vecWherePortions = new Vector();
        JetUDatabase db = this.getDatabase(sourceName);
        if (db != null) {
            vecWherePortions = db.getWherePortions();
        } else {
            logger.debug("Can't find database " + sourceName);
        }
        return this.availableWherePortions(vecWherePortions, strQueryName);
    }

    public String getWherePortion(String strName) {
        JetUWherePortion uWherePortion = this.getDatabase().getWherePortionByResourceName(strName);
        if (uWherePortion != null) {
            return uWherePortion.getWherePortion();
        }
        return null;
    }

    public String getWherePortion(String sourceName, String strName) {
        JetUDatabase db = this.getDatabase(sourceName);
        if (db == null) {
            return null;
        }
        JetUWherePortion uWherePortion = db.getWherePortionByResourceName(strName);
        if (uWherePortion != null) {
            return uWherePortion.getWherePortion();
        }
        return null;
    }

    public JetUWherePortion getUWherePortion(String strName) {
        return this.getDatabase().getWherePortionByResourceName(strName);
    }

    public JetUWherePortion getUWherePortion(String sourceName, String strName) {
        JetUDatabase db = this.getDatabase(sourceName);
        if (db == null) {
            logger.debug("Can't find database " + sourceName);
            return null;
        }
        return db.getWherePortionByResourceName(strName);
    }

    public Enumeration getAvailableQueryFields(String strQueryName) {
        JetUQuery uQuery = this.GetQueryByResourceName(strQueryName);
        if (uQuery != null) {
            Vector vecAvailableFld = this.getAvailableResourceEntitys(strQueryName);
            return this.availableQueryFields(uQuery, vecAvailableFld);
        }
        return null;
    }

    public Enumeration getAvailableQueryFields(String sourceName, String strQueryName) {
        JetUQuery uQuery = this.GetQueryByResourceName(sourceName, strQueryName);
        if (uQuery != null) {
            Vector vecAvailableFld = this.getAvailableResourceEntitys(sourceName, strQueryName);
            return this.availableQueryFields(uQuery, vecAvailableFld);
        }
        return null;
    }

    public Enumeration availableQueryFields(JetUQuery uQuery, Vector vecAvailableFld) {
        QueryFieldDesc qryfldDesc;
        Vector<QueryFieldDesc> vecReturn = new Vector<QueryFieldDesc>();
        int iSize = vecAvailableFld.size();
        for (int i = 0; i < iSize; ++i) {
            JetUResourceEntity re = (JetUResourceEntity)vecAvailableFld.elementAt(i);
            if (!(re instanceof JetUQueryField && !(re instanceof JetUFmlQueryField) || re instanceof JetUFormula && !((JetUFormula)re).isGroupBy() && !(re instanceof JetUSummary)) && !(re instanceof JetUParameter)) continue;
            qryfldDesc = new QueryFieldDesc();
            DbColDesc colDesc = re.getColDesc();
            qryfldDesc.strFieldName = colDesc.colName;
            qryfldDesc.iSqlType = colDesc.sqlType;
            qryfldDesc.iPrecision = colDesc.precision;
            qryfldDesc.iScale = colDesc.scale;
            qryfldDesc.iNullable = colDesc.nullable;
            if (re instanceof JetUFldQueryField) {
                qryfldDesc.iFieldType = 1;
                PsqlTable table = ((JetUFldQueryField)re).col.getPsqlTable();
                qryfldDesc.strTableAlias = table.getCorrelationName();
                qryfldDesc.bTableAlias = qryfldDesc.strTableAlias != null;
                qryfldDesc.strTableQualifier = table.getQualifier();
                qryfldDesc.strTableOwner = table.getOwner();
                qryfldDesc.strTableName = table.getName();
            } else if (re instanceof JetUCompColQueryField) {
                qryfldDesc.iFieldType = 2;
            } else if (re instanceof JetUFormula) {
                qryfldDesc.iFieldType = 3;
            } else if (re instanceof JetUParameter) {
                qryfldDesc.iFieldType = 4;
            }
            vecReturn.addElement(qryfldDesc);
        }
        RptPsqlQuery psqlQuery = uQuery.getPsqlQuery();
        Vector vecPsqlTables = psqlQuery.getTablesForUnselectedCols();
        int iTabSize = vecPsqlTables.size();
        for (int i = 0; i < iTabSize; ++i) {
            PsqlTable psqlTable = (PsqlTable)vecPsqlTables.elementAt(i);
            Vector vecCols = psqlTable.getColumns();
            int iColSize = vecCols.size();
            for (int j = 0; j < iColSize; ++j) {
                PsqlColumn psqlCol = (PsqlColumn)vecCols.elementAt(j);
                qryfldDesc = new QueryFieldDesc();
                qryfldDesc.iFieldType = 1;
                qryfldDesc.strFieldName = psqlCol.name;
                qryfldDesc.iSqlType = psqlCol.type;
                qryfldDesc.iPrecision = psqlCol.precision;
                qryfldDesc.iScale = psqlCol.scale;
                qryfldDesc.iNullable = psqlCol.nullable;
                qryfldDesc.strTableAlias = psqlTable.getCorrelationName();
                qryfldDesc.bTableAlias = qryfldDesc.strTableAlias != null;
                qryfldDesc.strTableQualifier = psqlTable.getQualifier();
                qryfldDesc.strTableOwner = psqlTable.getOwner();
                qryfldDesc.strTableName = psqlTable.getName();
                vecReturn.addElement(qryfldDesc);
            }
        }
        return vecReturn.elements();
    }

    public Vector addTableViews(String strCatalogName, String schemaPattern, String tablePattern, int iType) throws AddTableViewException, ClassNotFoundException, SQLException {
        JetUDatabase udb = this.getDatabase();
        JetUConnection Cnnct = udb.getConnection();
        if (Cnnct == null) {
            throw new AddTableViewException(2);
        }
        if (iType >> 2 != 0) {
            throw new AddTableViewException(1);
        }
        Vector retVec = Cnnct.addTableViews(strCatalogName, schemaPattern, tablePattern, iType);
        return retVec;
    }

    public Vector addTableViews(String strCatalogName, String sourceName, String schemaPattern, String tablePattern, int iType) throws AddTableViewException, ClassNotFoundException, SQLException {
        JetUDatabase udb = this.getDatabase(sourceName);
        if (udb == null) {
            return new Vector();
        }
        JetUConnection Cnnct = udb.getConnection();
        if (Cnnct == null) {
            throw new AddTableViewException(2);
        }
        if (iType >> 2 != 0) {
            throw new AddTableViewException(1);
        }
        Vector retVec = Cnnct.addTableViews(strCatalogName, schemaPattern, tablePattern, iType);
        return retVec;
    }

    public boolean saveCatalog() {
        boolean bSuc;
        block4: {
            try {
                bSuc = this.Save();
            }
            catch (WriteFailureException e) {
                bSuc = false;
                if (logger.isErrorEnabled()) {
                    logger.error("", e);
                }
            }
            catch (FMLFileException e) {
                bSuc = false;
                if (!logger.isErrorEnabled()) break block4;
                logger.error("", e);
            }
        }
        return bSuc;
    }

    public String toString() {
        return "Name: " + this.getName();
    }

    @Override
    public void clearMem() {
        curUniverse = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRefCount() {
        Object object = this.refLocker;
        synchronized (object) {
            return this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refer() {
        Object object = this.refLocker;
        synchronized (object) {
            ++this.refCount;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("JetUUniverse.refer():The refCount (Catalog hashCode:" + this.hashCode() + ") is " + this.refCount + " isCached = " + this.cached);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        Object object = this.refLocker;
        synchronized (object) {
            if (this.refCount > 0) {
                --this.refCount;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("JetUUniverse.free():The refCount (Catalog hashCode:" + this.hashCode() + ") is " + this.refCount + " isCached = " + this.cached);
        }
        if (curUniverse == null && !this.cached && this.refCount == 0) {
            this.clearMem();
        }
        if (this.refCount == 0) {
            this.cachedNLSManager.clear();
        }
    }

    @Override
    public void setCached(boolean cached) {
        this.cached = cached;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    public void removeExceptJetUDB() {
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (child instanceof JetUDatabase) continue;
            this.remove(child);
        }
        JetUDocFolder folder = new JetUDocFolder(JResource.getMessage("DocumentTree"), "");
        this.add(folder);
    }

    public SQLMapInfo createSQLMapInfoOnTable(JetUTableView table) {
        JetUConnection uConn = this.getDatabase().getConnection();
        return this.createSQLMapInfoOnTable(table, uConn);
    }

    public SQLMapInfo createSQLMapInfoOnTable(JetUTableView table, String sourceName) {
        JetUConnection uConn = this.getDatabase(sourceName).getConnection();
        return this.createSQLMapInfoOnTable(table, uConn);
    }

    SQLMapInfo createSQLMapInfoOnTable(JetUTableView table, JetUConnection uConn) {
        SQLMapInfo sqlMapInfo = new SQLMapInfo();
        if (uConn instanceof JetUConnection) {
            sqlMapInfo.setQlfOpt(uConn.getQualifiedNamePattern());
        }
        Hashtable tabMap = sqlMapInfo.getTabMap();
        tabMap.put(table.getResourceName().toUpperCase(), "");
        Hashtable colMap = sqlMapInfo.getColMap();
        Enumeration e = table.getFields().elements();
        while (e.hasMoreElements()) {
            String mapName = ((JetUField)e.nextElement()).getResourceName().toUpperCase();
            colMap.put(mapName, "");
        }
        return sqlMapInfo;
    }

    public JetUParameter[] getSQLStmtCreatorParams(String sourceName) {
        JetUJDBCConnection con;
        JetUDatabase dbase = this.getDatabase(sourceName);
        JetUParameter[] params = null;
        if (dbase != null && (con = (JetUJDBCConnection)dbase.getConnection()) != null) {
            params = this.initParams(con.sqlStmtCreator.get(), sourceName);
        }
        return params;
    }

    public JetUParameter[] getSQLStmtCreatorParams(String sourceName, String connnectionName) {
        JetUJDBCConnection con;
        JetUDatabase dbase = this.getDatabase(sourceName);
        JetUParameter[] params = new JetUParameter[]{};
        if (dbase != null && (con = (JetUJDBCConnection)dbase.getConnectionByResourceName(connnectionName)) != null) {
            params = this.initParams(con.sqlStmtCreator.get(), sourceName);
        }
        return params;
    }

    public JetUParameter[] getSQLNameAnalyserParams(String sourceName) {
        JetUJDBCConnection con;
        JetUDatabase dbase = this.getDatabase(sourceName);
        JetUParameter[] params = null;
        if (dbase != null && (con = (JetUJDBCConnection)dbase.getConnection()) != null) {
            params = this.initParams(con.sqlNameAnalyser.get(), sourceName);
        }
        return params;
    }

    public JetUParameter[] getSQLNameAnalyserParams(String sourceName, String connName) {
        JetUJDBCConnection con;
        JetUDatabase dbase = this.getDatabase(sourceName);
        JetUParameter[] params = null;
        if (dbase != null && (con = (JetUJDBCConnection)dbase.getConnectionByResourceName(connName)) != null) {
            params = this.initParams(con.sqlNameAnalyser.get(), sourceName);
        }
        return params;
    }

    @Override
    public String getInstancePrefix() {
        return "Catalog";
    }

    public void copyDatabase(JetUUniverse ret, String sname, String tname) {
        int i;
        int i2;
        Vector temp;
        JetUDatabase srcD = this.getDatabase(sname);
        JetUDatabase desD = ret.getDatabase(tname);
        if (desD == null) {
            ret.addDatabase(tname);
            desD = ret.getDatabase(tname);
        }
        Vector conns = srcD.getConnections();
        for (JetUConnection conn : conns) {
            JetUConnection srcC = conn;
            if (srcC == null) continue;
            JetUConnection desC = srcC.createNew();
            desD.addConnection(desC);
            temp = srcC.getTableViews();
            for (int i3 = 0; i3 < temp.size(); ++i3) {
                JetUTableView tab = ((JetUTableView)temp.elementAt(i3)).createNew();
                Vector flds = ((JetUTableView)temp.elementAt(i3)).getFields();
                if (flds != null) {
                    for (int j = 0; j < flds.size(); ++j) {
                        tab.addField(((JetUField)flds.elementAt(j)).createNew());
                    }
                }
                desC.addTableView(tab);
            }
        }
        Vector procedures = srcD.getProcedures();
        for (int i4 = 0; i4 < procedures.size(); ++i4) {
            desD.addProcedure(((JetUProcedure)procedures.elementAt(i4)).cloneEntity());
        }
        Vector fileQueries = srcD.getFileQueries();
        for (i2 = 0; i2 < fileQueries.size(); ++i2) {
            JetUFileQuery uFileQuery = ((JetUFileQuery)fileQueries.elementAt(i2)).getCopy();
            desD.addFileQuery(uFileQuery);
            uFileQuery.initAfterAdd();
        }
        temp = srcD.getDataSources();
        for (i2 = 0; i2 < temp.size(); ++i2) {
            desD.addDataSource(((JetUUserDataSource)temp.elementAt(i2)).cloneEntity());
        }
        temp = srcD.getQueries();
        for (i = 0; i < temp.size(); ++i) {
            JetUQuery jetUQuery = (JetUQuery)temp.elementAt(i);
            RptPsqlQuery newPsqlQry = jetUQuery.getPsqlQuery().getCopy();
            JetUQuery qry = new JetUQuery(((JetUQuery)temp.elementAt(i)).getResourceName(), newPsqlQry);
            if (jetUQuery.getBV() != null) {
                qry.add((JetObject)((Object)jetUQuery.getBV().copy()));
            }
            if (jetUQuery.getBL() != null) {
                qry.add((JetObject)((Object)jetUQuery.getBL().copy()));
            }
            desD.addQuery(qry);
            newPsqlQry.setUniverse(ret, tname);
        }
        temp = srcD.getBvs();
        for (i = 0; i < temp.size(); ++i) {
            UnifiedBusinessView bv = temp.elementAt(i);
            desD.add(bv.copy());
            bv.setParent(desD);
        }
        temp = srcD.getFormulas();
        for (i = 0; i < temp.size(); ++i) {
            desD.addFormula(((JetUFormula)temp.elementAt(i)).createNew());
        }
        temp = srcD.getSummaries();
        for (i = 0; i < temp.size(); ++i) {
            desD.addSummary((JetUSummary)((JetUSummary)temp.elementAt(i)).createNew());
        }
        temp = srcD.getParameters();
        for (i = 0; i < temp.size(); ++i) {
            desD.addParameter(((JetUParameter)temp.elementAt(i)).createNew());
        }
        desD.FormulaModified();
        temp = srcD.getWherePortions();
        for (i = 0; i < temp.size(); ++i) {
            desD.addWherePortion(((JetUWherePortion)temp.elementAt(i)).cloneEntity());
        }
        temp = srcD.getHierDataSources();
        for (i = 0; i < temp.size(); ++i) {
            desD.addHierDataSource(((JetUHierDataSource)temp.elementAt(i)).cloneHDS());
        }
        temp = srcD.getAcls();
        for (i = 0; i < temp.size(); ++i) {
            desD.addAcl(((JetUAcl)temp.elementAt(i)).cloneEntity());
        }
    }

    public JetUUniverse copySelectDatabase(Vector names, boolean bExists, Hashtable renamedDss) {
        JetUUniverse ret = JetUUniverse.BuildDefaultUniverse();
        int size = names.size();
        if (!names.contains("") && !bExists) {
            this.copyDatabase(ret, (String)names.elementAt(0), "");
            renamedDss.put((String)names.elementAt(0), "");
            for (int i = 1; i < size; ++i) {
                String name2 = (String)names.elementAt(i);
                this.copyDatabase(ret, name2, name2);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                String name3 = (String)names.elementAt(i);
                this.copyDatabase(ret, name3, name3);
            }
        }
        return ret;
    }

    public JetUUniverse copy() {
        JetUUniverse ret = new JetUUniverse();
        this.version.set(strCurVersion);
        JetUDocFolder folder = new JetUDocFolder(JResource.getMessage("DocumentTree"), "");
        this.add(folder);
        this.isCatalogPrepareOK = true;
        Vector names = this.getAllDatabaseNames();
        int size = names.size();
        for (int k = 0; k < size; ++k) {
            String name2 = (String)names.elementAt(k);
            this.copyDatabase(ret, name2, name2);
        }
        return ret;
    }

    @Override
    public void setVersion(int ver) {
        this.jetcVersion = ver;
    }

    @Override
    public int getVersion() {
        return this.jetcVersion;
    }

    public JetUDatabase addDatabase(String dataSourceName) {
        JetUDatabase uDatabase = new JetUDatabase(dataSourceName, "");
        this.add(uDatabase);
        uDatabase.InitAfterCreate();
        return uDatabase;
    }

    public boolean removeDatabase(String dataSourceName) {
        if (dataSourceName.equals("")) {
            return false;
        }
        JetUDatabase database = this.getDatabase(dataSourceName);
        if (!database.IsDefaultDB()) {
            this.remove(database);
            return true;
        }
        return false;
    }

    public void setRptUserName(String name2) {
        this.rptUser = name2;
    }

    public String getRptUserName() {
        return this.rptUser;
    }

    public String getSpecialField(int type) {
        String strField = null;
        switch (type) {
            case 0: {
                strField = this.rptUser;
            }
        }
        return strField;
    }

    public ArrayList getSpecialFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(0, this.rptUser != null ? this.rptUser : "");
        return list;
    }

    public void setCrossRefApply(boolean isCrossRefApply) {
        this.bCrossRefApply = isCrossRefApply;
    }

    public boolean isCrossRefApply() {
        return this.bCrossRefApply;
    }

    public void setUserTimeZone(String userTimeZone) {
        this.userTimeZone = userTimeZone;
    }

    public String getUserTimeZone() {
        return this.userTimeZone;
    }

    public boolean setDefaultDatasource(String datasourceName) {
        if (this.getDatabase(datasourceName) == null) {
            return false;
        }
        Vector children = this.getAllDatabases();
        boolean ret = false;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            if (!(children.get(i) instanceof JetUDatabase)) continue;
            JetUDatabase dbChild = (JetUDatabase)children.get(i);
            dbChild.setDefaultDB(false);
            if (!dbChild.getResourceName().equals(datasourceName)) continue;
            dbChild.setDefaultDB(true);
            ret = true;
        }
        return ret;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    public void setOrderedParameters(Vector<String> orderedParas) {
        this.orderedParameters.clear();
        int size = orderedParas.size();
        for (int i = 0; i < size; ++i) {
            this.orderedParameters.add(orderedParas.get(i));
        }
    }

    public Vector<JetUParameter> getOrderedParameters() {
        Vector allPara = new Vector();
        for (JetUDatabase database : this.getAllDatabases()) {
            allPara.addAll(database.getParameters());
        }
        String[] oParas = this.orderedParameters.toStringArray();
        Vector<JetUParameter> ret = new Vector<JetUParameter>();
        block1: for (String oPara : oParas) {
            for (JetUParameter jetUpara : allPara) {
                if (!jetUpara.getResourceName().equalsIgnoreCase(oPara)) continue;
                ret.add(jetUpara);
                allPara.removeElement(jetUpara);
                continue block1;
            }
        }
        ret.addAll(allPara);
        return ret;
    }

    public String[] getOrderedParameterNames() {
        Vector<String> ret = new Vector<String>();
        Vector<JetUParameter> orderedP = this.getOrderedParameters();
        int size = orderedP.size();
        for (int i = 0; i < size; ++i) {
            ret.add(orderedP.get(i).getResourceName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public UnifiedBusinessView getBV(String datasourceName, String ubvName) {
        JetUDatabase db = this.getDatabase(datasourceName);
        if (db == null) {
            return null;
        }
        return db.getBusinessView(ubvName);
    }

    public boolean removeMLSItem(String principalName, int principalType) throws WriteFailureException, FMLFileException {
        boolean deleteSomeFlag = false;
        Vector dataBases = this.getAllDatabases();
        for (JetUDatabase jetUDatabase : dataBases) {
            Vector<UnifiedBusinessView> bvs = jetUDatabase.getBvs();
            for (UnifiedBusinessView bv : bvs) {
                MemberSecurityEntry se = bv.getMemberSecurityEntry();
                deleteSomeFlag = deleteSomeFlag || se.removeSecurityItem(principalType, principalName);
            }
        }
        return deleteSomeFlag;
    }

    public boolean removeInvalidMLSItem(SecurityData sd) throws WriteFailureException, FMLFileException {
        boolean ret = false;
        Vector dataBases = this.getAllDatabases();
        for (JetUDatabase jetUDatabase : dataBases) {
            Vector<UnifiedBusinessView> bvs = jetUDatabase.getBvs();
            for (UnifiedBusinessView bv : bvs) {
                MemberSecurityEntry se = bv.getMemberSecurityEntry();
                if (!se.removeInvalidSecurityItem(sd)) continue;
                ret = true;
            }
        }
        return ret;
    }

    public boolean isBigDataSource(String dataSourceName, String queryName) {
        return this.getDatabase(dataSourceName).isQueryHasBigDataSource(queryName);
    }

    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public void setResourceStore(ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }

    public String[] getMetadataNLSKeys() {
        HashSet<String> retList = new HashSet<String>();
        retList.add(KEYWORD_DR);
        retList.add(KEYWORD_FORMULAS);
        retList.add(KEYWORD_ADDFORMULA);
        retList.add(KEYWORD_MEASURES);
        retList.add(KEYWORD_ADDMEASURE);
        retList.add(KEYWORD_AGGS);
        retList.add(KEYWORD_ADDAGG);
        retList.add(KEYWORD_LOCPARAMS);
        retList.add(KEYWORD_GLOPARAMS);
        retList.add(KEYWORD_PARAMS);
        retList.add(KEYWORD_ADDPARAM);
        Vector sources = this.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            retList.add(dataBase.getResourceName());
            Vector<UnifiedBusinessView> bvs = dataBase.getBvs();
            for (UnifiedBusinessView unifiedBusinessView : bvs) {
                this.extractUbvEelement(unifiedBusinessView, retList);
            }
            Vector fss = dataBase.getFormulasAndSummaries();
            for (JetUFormula jetUFormula : fss) {
                retList.add(jetUFormula.getResourceName());
            }
            Vector ps = dataBase.getParameters();
            for (JetUParameter jetUParameter : ps) {
                retList.add(jetUParameter.getResourceName());
            }
            retList.addAll(this.extractColumnsAndParents(dataBase));
        }
        String[] ret = new String[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    private HashSet<String> extractColumnsAndParents(JetUDatabase dataBase) {
        HashSet<String> parentObjectNames = new HashSet<String>();
        HashSet<String> columnNames = new HashSet<String>();
        Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
        int size2 = queriables.size();
        for (int j = 0; j < size2; ++j) {
            JetUQueriable qb = queriables.get(j);
            if (qb instanceof JetUQuery) {
                Vector fields = qb.getFields();
                for (int k = 0; k < fields.size(); ++k) {
                    Object fd = fields.get(k);
                    if (!(fd instanceof JetUFldQueryField)) continue;
                    String tableName = ((JetUFldQueryField)fd).getTableName();
                    parentObjectNames.add(tableName);
                    String columnName = ((JetUFldQueryField)fd).getResourceName();
                    columnNames.add(columnName);
                }
                continue;
            }
            String parentObjectName = qb.getResourceName();
            parentObjectNames.add(parentObjectName);
            Vector fields = qb.getFields();
            for (int k = 0; k < fields.size(); ++k) {
                JetUQueriableField fd = (JetUQueriableField)fields.get(k);
                columnNames.add(fd.getResourceName());
            }
        }
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(parentObjectNames);
        ret.addAll(columnNames);
        return ret;
    }

    private void extractUbvEelement(UnifiedBusinessView ubv, HashSet<String> retList) {
        if (ubv != null) {
            DetailInformation[] ds;
            DimensionInfo[] gs;
            MeasureInfo[] as;
            CategoryInfo[] cs;
            HierarchyInfo[] hiers;
            retList.add(ubv.getDisplayName());
            for (HierarchyInfo hierarchyInfo : hiers = ubv.getAllHierarchies()) {
                retList.add(hierarchyInfo.getDisplayName());
            }
            for (CategoryInfo categoryInfo : cs = ubv.getAllCategories()) {
                retList.add(categoryInfo.getDisplayName());
            }
            for (MeasureInfo aggregationInfo : as = ubv.getAllMeasures()) {
                retList.add(aggregationInfo.getDisplayName());
            }
            for (DimensionInfo groupInfo : gs = ubv.getAllDimensions()) {
                retList.add(groupInfo.getDisplayName());
            }
            for (DetailInformation detailInformation : ds = ubv.getAllDetailInfos()) {
                retList.add(detailInformation.getDisplayName());
            }
        }
    }

    public JFieldValueNLSManager getNLSManager(Locale locale) {
        JFieldValueNLSManager ret = this.cachedNLSManager.get(locale);
        if (ret != null) {
            return ret;
        }
        ret = new JFieldValueNLSManager(this.getFilePath(), locale);
        this.cachedNLSManager.put(locale, ret);
        return ret;
    }

    public String getDataMappingBundlePrefix(DataEntryLocation dataEntryLocation) {
        BLNode blNode;
        int type = dataEntryLocation.getUbvQueryType();
        if (type == 2) {
            String mappingName = dataEntryLocation.getMappingNameOrqdName();
            if (mappingName != null) {
                JetUResourceEntity entity = this.getResourceByName(dataEntryLocation.getDataSoureceName(), null, mappingName);
                if (entity == null) {
                    return null;
                }
                return entity.getDataMappingFile();
            }
            logger.error("wrong DataEntryLocation" + dataEntryLocation);
            return null;
        }
        UnifiedBusinessView ubv = this.getBV(dataEntryLocation.getDataSoureceName(), dataEntryLocation.getUbvQueryName());
        if (ubv != null && (blNode = ubv.getByDisplayName(dataEntryLocation.getMappingNameOrqdName())) instanceof DataElement) {
            DataElement de = (DataElement)blNode;
            return de.getDataMappingFile();
        }
        logger.error("wrong DataEntryLocation" + dataEntryLocation);
        return null;
    }

    public Map<String, String> getDataMappingBundlePrefix(String datasourceName, String ubvQueryName, int ubvQueryType) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (ubvQueryType == 2) {
            JetUQueriable queriable = this.getQueriableByResourceName(datasourceName, ubvQueryName);
            if (queriable == null) {
                return ret;
            }
            Vector fs = queriable.getFields();
            StringBuilder retMsg = new StringBuilder();
            retMsg.append("getDataMappingBundlePrefix(): datasourceName = " + datasourceName + "  queryName = " + ubvQueryName + "\n");
            for (int i = 0; i < fs.size(); ++i) {
                JetUResourceEntity field = (JetUResourceEntity)fs.get(i);
                ret.put(field.getResourceName().toUpperCase(), field.getDataMappingFile());
                if (!log.isDebugAll()) continue;
                retMsg.append(field.getResourceName().toUpperCase() + "==>" + field.getDataMappingFile() + "\n");
            }
            if (log.isDebugAll()) {
                log.debugAll(retMsg);
            }
            return ret;
        }
        UnifiedBusinessView ubv = this.getBV(datasourceName, ubvQueryName);
        if (ubv == null) {
            return ret;
        }
        DataElementInfo[] deis = ubv.getAllDataElement();
        StringBuilder retMsg = new StringBuilder();
        retMsg.append("getDataMappingBundlePrefix(): datasourceName = " + datasourceName + "  ubv = " + ubvQueryName + "\n");
        for (int i = 0; i < deis.length; ++i) {
            ret.put(deis[i].getQualifyDisplayName().toUpperCase(), ((DataElement)deis[i]).getDataMappingFile());
            if (!log.isDebugAll()) continue;
            retMsg.append(deis[i].getQualifyDisplayName().toUpperCase() + "==>" + ((DataElement)deis[i]).getDataMappingFile() + "\n");
        }
        if (log.isDebugAll()) {
            log.debugAll(retMsg);
        }
        return ret;
    }

    public Map<String, String> getParameterDataMappingBundlePrefix(String datasourceName) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Vector ps = this.getParameters(datasourceName);
        StringBuilder retMsg = new StringBuilder();
        retMsg.append("getParameterDataMappingBundlePrefix(): datasourceName = " + datasourceName + "\n");
        for (int i = 0; i < ps.size(); ++i) {
            ret.put(((JetUParameter)ps.get(i)).getResourceName().toUpperCase(), ((JetUParameter)ps.get(i)).getDataMappingFile());
            if (!log.isDebugAll()) continue;
            retMsg.append(((JetUParameter)ps.get(i)).getResourceName().toUpperCase() + "==>" + ((JetUParameter)ps.get(i)).getDataMappingFile() + "\n");
        }
        if (log.isDebugAll()) {
            log.debugAll(retMsg);
        }
        return ret;
    }

    public ArrayList<String> getAllDataMappingBundlePrefix() {
        ArrayList<String> retSet = new ArrayList<String>();
        Vector sources = this.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
            int size2 = queriables.size();
            for (int j = 0; j < size2; ++j) {
                JetUQueriable queriable = queriables.get(j);
                Vector fs = queriable.getFields();
                for (int k = 0; k < fs.size(); ++k) {
                    JetUResourceEntity qf = (JetUResourceEntity)fs.get(k);
                    String dmf = qf.getDataMappingFile();
                    if (retSet.contains(dmf)) continue;
                    retSet.add(dmf);
                }
            }
            Vector<UnifiedBusinessView> bvs = dataBase.getBvs();
            for (UnifiedBusinessView unifiedBusinessView : bvs) {
                this.addDataMappingBundlePrefix(unifiedBusinessView, retSet);
            }
            Vector ps = dataBase.getParameters();
            for (int j = 0; j < ps.size(); ++j) {
                JetUParameter p = (JetUParameter)ps.get(j);
                String prefix = p.getDataMappingFile();
                if (retSet.contains(prefix)) continue;
                retSet.add(prefix);
            }
            Vector fs = dataBase.getFormulas();
            for (int j = 0; j < fs.size(); ++j) {
                JetUFormula f = (JetUFormula)fs.get(j);
                String prefix = f.getDataMappingFile();
                if (retSet.contains(prefix)) continue;
                retSet.add(prefix);
            }
        }
        retSet.remove("");
        return retSet;
    }

    public ArrayList<String> getAllDataMappingFileName() {
        ArrayList<String> ret = new ArrayList<String>();
        String path = this.getFilePath();
        File p = new File(path);
        ArrayList<String> allnlsPrefix = this.getAllDataMappingBundlePrefix();
        String[] allNLSfileNames = p.list();
        for (int i = 0; i < allNLSfileNames.length; ++i) {
            for (String nlsFilePrefix : allnlsPrefix) {
                if (nlsFilePrefix.trim().length() == 0 || !allNLSfileNames[i].startsWith(nlsFilePrefix)) continue;
                ret.add(allNLSfileNames[i]);
            }
        }
        return ret;
    }

    private void addDataMappingBundlePrefix(JUnifiedBusinessView ubv, ArrayList<String> retSet) {
        CategoryInfo[] cs;
        for (CategoryInfo categoryInfo : cs = ubv.getAllCategories()) {
            BLNode[] blChildren = categoryInfo.getBLChildren();
            for (int i = 0; i < blChildren.length; ++i) {
                String prefix;
                if (!(blChildren[i] instanceof DataElement) || retSet.contains(prefix = ((DataElement)blChildren[i]).getDataMappingFile())) continue;
                retSet.add(prefix);
            }
        }
    }

    public String[] getDisplayNLSKeys() {
        HashSet<String> retList = new HashSet<String>();
        Vector sources = this.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector ps = dataBase.getParameters();
            for (JetUParameter uParameter : ps) {
                retList.add(uParameter.getResourceName());
                retList.add(uParameter.getPrompt());
            }
            retList.add(dataBase.getResourceName());
            Vector<UnifiedBusinessView> bvs = dataBase.getBvs();
            for (UnifiedBusinessView bv : bvs) {
                DetailInformation[] ds;
                GroupInfo[] gs;
                AggregationInfo[] as;
                CategoryInfo[] cs;
                retList.add(bv.getDisplayName());
                for (CategoryInfo categoryInfo : cs = bv.getAllCategories()) {
                    retList.add(categoryInfo.getDisplayName());
                }
                for (AggregationInfo aggregationInfo : as = bv.getAllAggregations()) {
                    retList.add(aggregationInfo.getDisplayName());
                }
                for (GroupInfo groupInfo : gs = bv.getAllGroups()) {
                    retList.add(groupInfo.getDisplayName());
                }
                for (DetailInformation detailInformation : ds = bv.getAllDetailInfos()) {
                    retList.add(detailInformation.getDisplayName());
                }
            }
            Vector fss = dataBase.getFormulasAndSummaries();
            for (JetUFormula jetUFormula : fss) {
                retList.add(jetUFormula.getResourceName());
            }
            retList.addAll(this.extractColumnsAndParents(dataBase));
        }
        String[] ret = new String[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    private String[] getFormatNLSKeys() {
        ArrayList<String> retList = new ArrayList<String>();
        Vector sources = this.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            for (JetUConnection uConnection : dataBase.conns) {
                Vector tvs = uConnection.getTableViews(15);
                for (JetUTableView jetUTableView : tvs) {
                    Vector fs = jetUTableView.getFields();
                    for (JetUField jetUField : fs) {
                        retList.add(jetUField.format.get());
                    }
                }
            }
            Vector ps = dataBase.getParameters();
            for (JetUParameter uParameter : ps) {
                retList.add(uParameter.format.get());
            }
            Vector fs = dataBase.getFormulasAndSummaries();
            for (JetUFormula uFormula : fs) {
                retList.add(uFormula.format.get());
            }
        }
        String[] ret = new String[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    public NLSResourceBundle getCatalogNLSBundle(Locale locale) throws IOException {
        NLSResourceBundle ret = this.cachedNLSResourceBundles.get(locale);
        if (ret == null) {
            File folder = this.flCat.getParentFile();
            String prefix = this.flCat.getName();
            ret = NLSResourceBundleManager.loadNLSResourceBundle(folder, prefix, locale, null);
            this.cachedNLSResourceBundles.put(locale, ret);
        }
        return ret;
    }

    public NLSResourceBundle newCatalogNLSBundle(Locale locale) throws IOException {
        String[] metadataNLSKeys;
        int i;
        String[] formatNLSKeys;
        NLSResourceBundle ret = NLSResourceBundleManager.newNLSBundleInstance(locale);
        for (String formatNLSKey : formatNLSKeys = this.getFormatNLSKeys()) {
            NLSValue v = ret.getFormat(formatNLSKey);
            if (v != null && !v.isEmptyValue()) continue;
            ret.setFormat(formatNLSKey, formatNLSKey);
        }
        ArrayList<String> fontNameList = new ArrayList<String>();
        ArrayList<Integer> fontSizeList = new ArrayList<Integer>();
        Vector sources = this.getAllDatabases();
        int s = sources.size();
        for (i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            for (JetUConnection uConnection : dataBase.conns) {
                Vector tvs = uConnection.getTableViews(15);
                for (JetUTableView jetUTableView : tvs) {
                    Vector fs = jetUTableView.getFields();
                    for (JetUField jetUField : fs) {
                        fontNameList.add(jetUField.fontName.get());
                        fontSizeList.add(jetUField.fontSize.get());
                    }
                }
            }
            Vector ps = dataBase.getParameters();
            for (JetUParameter uParameter : ps) {
                fontNameList.add(uParameter.fontName.get());
                fontSizeList.add(uParameter.fontSize.get());
            }
            Vector fs = dataBase.getFormulasAndSummaries();
            for (JetUFormula uFormula : fs) {
                fontNameList.add(uFormula.fontName.get());
                fontSizeList.add(uFormula.fontSize.get());
            }
        }
        for (i = 0; i < fontNameList.size(); ++i) {
            int fontSize;
            String fontName = (String)fontNameList.get(i);
            NLSFontValue v = ret.getFont(fontName, fontSize = ((Integer)fontSizeList.get(i)).intValue());
            if (v != null && !v.isEmptyValue()) continue;
            ret.setFont(fontName, fontSize, fontName, fontSize);
        }
        for (String metadataNLSKey : metadataNLSKeys = this.getMetadataNLSKeys()) {
            NLSValue v = ret.getText(9, metadataNLSKey);
            if (v != null && !v.isEmptyValue()) continue;
            ret.setText(9, metadataNLSKey, metadataNLSKey);
        }
        return ret;
    }

    public void saveCatalogNLSBundle(NLSResourceBundle bundle, Locale locale) throws IOException {
        File folder = this.flCat.getParentFile();
        String prefix = this.flCat.getName();
        NLSResourceBundleManager.saveNLSResourceBundle(this.resourceStore.getDiskStore(), bundle, folder, prefix, locale, true, true);
        this.cachedNLSResourceBundles.clear();
    }

    public void deleteCatalogNLSBundle(Locale locale) {
        File folder = this.flCat.getParentFile();
        String prefix = this.flCat.getName();
        NLSResourceBundleManager.deleteNLSResourceBundle(this.resourceStore.getDiskStore(), folder, prefix, locale);
    }

    public void applyNLS(Locale locale) throws IOException {
        NLSResourceBundle bundle = this.getCatalogNLSBundle(locale);
        Vector sources = this.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector ps = dataBase.getParameters();
            for (JetUParameter uParameter : ps) {
                NLSValue strPromptNLS;
                String prompt = uParameter.getPrompt();
                if (prompt == null || (strPromptNLS = bundle.getText(5, prompt)) == null || strPromptNLS.isEmptyValue()) continue;
                uParameter.setPrompt(strPromptNLS.getStringValue());
            }
        }
    }

    private void add2List(UnifiedBusinessView bv, ArrayList<String> retList) {
        DetailInformation[] ds;
        GroupInfo[] gs;
        AggregationInfo[] as;
        CategoryInfo[] cs;
        retList.add(bv.getDisplayName());
        for (CategoryInfo categoryInfo : cs = bv.getAllCategories()) {
            retList.add(categoryInfo.getDisplayName());
        }
        for (AggregationInfo aggregationInfo : as = bv.getAllAggregations()) {
            retList.add(aggregationInfo.getDisplayName());
        }
        for (GroupInfo groupInfo : gs = bv.getAllGroups()) {
            retList.add(groupInfo.getDisplayName());
        }
        for (DetailInformation detailInformation : ds = bv.getAllDetailInfos()) {
            retList.add(detailInformation.getDisplayName());
        }
    }

    public List<JUnifiedBusinessView> getUbvByQuery(String datasourceName, String queryName) {
        ArrayList<JUnifiedBusinessView> retList = new ArrayList<JUnifiedBusinessView>();
        JetUDatabase db = this.getDatabase(datasourceName);
        if (db == null) {
            return null;
        }
        Vector<UnifiedBusinessView> bvs = db.getBvs();
        for (UnifiedBusinessView ubv : bvs) {
            PsqlTable psqlTable;
            JetUDemandQuery selfQuery = ubv.getQuery();
            Vector pTables = selfQuery.getPsqlQuery().getPsqlTablesVector();
            if (pTables.size() != 1 || !(psqlTable = (PsqlTable)pTables.get(0)).isQueriable() || !psqlTable.getMappingName().equalsIgnoreCase(queryName)) continue;
            retList.add(ubv);
        }
        return retList;
    }

    public InformationBusManager getInfoBusManager() {
        return new IbusManager(this.getIBusEntry());
    }

    public JetUInformationBusEntry getIBusEntry() {
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUInformationBusEntry)) continue;
            return (JetUInformationBusEntry)child;
        }
        JetUInformationBusEntry ret = new JetUInformationBusEntry();
        this.add(ret);
        return ret;
    }

    public boolean isBvReferSingleQuery(String datasourceName, String ubvName, String queriableName) {
        UnifiedBusinessView bv = this.getBV(datasourceName, ubvName);
        if (bv == null) {
            return false;
        }
        JetUDemandQuery uDemandQuery = bv.getQuery();
        Vector<JetUQueriable> qs = uDemandQuery.getRefQueriables();
        if (uDemandQuery.getTables().size() == 1 && qs.size() == 1 && qs.get(0).getResourceName().equalsIgnoreCase(queriableName)) {
            return qs.get(0).getFields().size() == uDemandQuery.getFields().size();
        }
        return false;
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("VersionNumber", new Integer(1));
        nameIdx.put("Name", new Integer(2));
        nameIdx.put("Version", new Integer(3));
        nameIdx.put("TimeZone", new Integer(4));
        KEYWORD_DR = "Dynamic Resources";
        KEYWORD_FORMULAS = "Formulas";
        KEYWORD_ADDFORMULA = "Add Formula";
        KEYWORD_MEASURES = "Measures";
        KEYWORD_ADDMEASURE = "Add Measure";
        KEYWORD_AGGS = "Aggregations";
        KEYWORD_ADDAGG = "Add Aggregation";
        KEYWORD_LOCPARAMS = "Local Parameters";
        KEYWORD_GLOPARAMS = "Global Parameters";
        KEYWORD_PARAMS = "Parameters";
        KEYWORD_ADDPARAM = "Add Parameter";
    }
}

