/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUDSField;
import jet.universe.JetUUDSParamFormatInfo;
import jet.universe.JetUUniverse;
import jet.universe.UniverseUtil;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.BusinessView;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.util.HashVector;
import toolkit.db.ColumnInfo;
import toolkit.db.ColumnInfoTree;
import toolkit.db.DataSourceInfo;
import toolkit.db.EnhancedDataSourceInfo;

public class JetUUserDataSource
extends JetUResourceContainer
implements JetUQueriable {
    private static JRLogger logger = JRLogger.getLogger(JetUUserDataSource.class.getName());
    public static final String strParameterDelimiter = ";";
    public JetString className = new JetString(this, "ClassName");
    public JetString parameter = new JetString(this, "Parameter");
    public JetBoolean specifyMetaData = new JetBoolean(this, "SpecifyMetadata");
    public JetBoolean useDefaultConnection = new JetBoolean(this, "UseDefaultConnection");
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    DataSourceInfo UDSInfo = null;
    private JetUUDSParamFormatInfo formatInfo;
    private static final HashMap nameIdx = new HashMap(7);
    private static final HashVector grpDesc;

    public JetUUserDataSource() {
    }

    public Hashtable getNameFormatPair() {
        if (this.formatInfo != null) {
            return this.formatInfo.getNameFormatPair();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.elementAt(i) instanceof JetUUDSParamFormatInfo)) continue;
            this.formatInfo = (JetUUDSParamFormatInfo)this.children.elementAt(i);
            return this.formatInfo.getNameFormatPair();
        }
        return new Hashtable();
    }

    public void setNameFormatPair(Hashtable nameFormatPair) {
        if (this.formatInfo != null) {
            this.remove(this.formatInfo);
        }
        this.formatInfo = new JetUUDSParamFormatInfo();
        this.formatInfo.setNameFormatPair(nameFormatPair);
        this.add(this.formatInfo);
    }

    private JetUUserDataSource(String strName, String strDescription) {
        super(strName, strDescription);
    }

    public JetUUserDataSource(DataSourceInfo UDSInfo) {
        super(UDSInfo.getDSName(), UDSInfo.getDescription());
        this.className.set(UDSInfo.getClassName());
        this.parameter.set(UDSInfo.getParameter());
        this.UDSInfo = UDSInfo;
        this.setSpecifyMetaData(UDSInfo.isSpecifyMetaData());
        this.setUseDefaultConnection(UDSInfo.isUseDefaultConnection());
    }

    public JetUUserDataSource(EnhancedDataSourceInfo UDSInfo) {
        super(UDSInfo.getDSName(), UDSInfo.getDescription());
        this.className.set(UDSInfo.getClassName());
        this.parameter.set(UDSInfo.getParameter());
        this.UDSInfo = UDSInfo;
        this.setSpecifyMetaData(UDSInfo.isSpecifyMetaData());
        this.setUseDefaultConnection(UDSInfo.isUseDefaultConnection());
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public int getReadOnly() {
        return 1;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows.set(maxRows);
    }

    @Override
    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration.set(maxDuration);
    }

    @Override
    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    @Override
    public Vector getAutoGroupFields() {
        Vector<String> vecReturn = new Vector<String>();
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        JetUUDSField field = null;
        for (int i = 0; i < iSize; ++i) {
            int iIndex;
            Object obj = vecChildren.elementAt(i);
            if (!(obj instanceof JetUUDSField) || (iIndex = (field = (JetUUDSField)obj).getAutoGroupIndex()) == -1) continue;
            vecReturn.addElement(field.getResourceName());
        }
        return vecReturn;
    }

    @Override
    public void InitAfterCreate() {
        super.InitAfterCreate();
        if (this.UDSInfo == null) {
            return;
        }
        Vector vecColumns = this.UDSInfo.getColumns();
        int iColCount = vecColumns.size();
        JetUUDSField uUDSField = null;
        ColumnInfoTree root = null;
        if (this.UDSInfo instanceof EnhancedDataSourceInfo) {
            root = ((EnhancedDataSourceInfo)this.UDSInfo).getColumnInfoTree();
        }
        if (root != null) {
            ColumnInfoTree treenode = null;
            for (int i = 0; i < iColCount; ++i) {
                treenode = root.getChildByColumnIndex(i);
                uUDSField = new JetUUDSField(treenode.getColumnMappingName(), "", treenode.getParentString(), treenode.getColumnInfo());
                uUDSField.setColMappingIndex(treenode.getMappingColumnIndex());
                uUDSField.setAutoGroupIndex(treenode.getAutoGroupIndex());
                this.addColumn(uUDSField);
            }
        } else {
            for (int i = 0; i < iColCount; ++i) {
                ColumnInfo colInfo = (ColumnInfo)vecColumns.elementAt(i);
                String strMappingName = this.getMappingName(colInfo.strName);
                uUDSField = new JetUUDSField(strMappingName, "", ColumnInfoTree.strRoot, colInfo);
                this.addColumn(uUDSField);
            }
        }
        this.setNameFormatPair(this.UDSInfo.getParamNameFormatPair());
        this.UDSInfo = null;
    }

    public String getMappingName(String strRealName) {
        StringBuffer error = new StringBuffer();
        JetUDatabase db = this.getDatabase();
        String strTemp = null;
        String strMappingName = strRealName;
        boolean bIsOK = db.IsMappingNameOK(strMappingName, error);
        int i = 1;
        if (!bIsOK) {
            strMappingName = this.getResourceName() + "_" + strRealName;
            bIsOK = db.IsMappingNameOK(strMappingName, error);
        }
        strTemp = strMappingName;
        while (!bIsOK) {
            strMappingName = strTemp + i++;
            bIsOK = db.IsMappingNameOK(strMappingName, error);
        }
        return strMappingName;
    }

    public void addColumn(JetUUDSField uUDSField) {
        this.add(uUDSField);
        uUDSField.InitAfterCreate();
    }

    public JetUUserDataSource cloneEntity() {
        JetUUserDataSource retUDS = new JetUUserDataSource(this.getResourceName(), this.getDesc());
        retUDS.setUDSClassName(this.getUDSClassName());
        retUDS.setParameter(this.getParameter());
        Vector vecColumns = this.getColumns();
        int iColCount = vecColumns.size();
        for (int i = 0; i < iColCount; ++i) {
            JetUUDSField srcField = (JetUUDSField)vecColumns.elementAt(i);
            JetUUDSField destField = srcField.cloneEntity();
            retUDS.addColumn(destField);
        }
        retUDS.setNameFormatPair(this.getNameFormatPair());
        JetObject.copyProperties(retUDS, this);
        return retUDS;
    }

    public String getUDSClassName() {
        return this.className.get();
    }

    public void setUDSClassName(String strClassName) {
        this.className.set(strClassName);
    }

    public String getParameter() {
        return this.parameter.get();
    }

    public void setParameter(String strParam) {
        this.parameter.set(strParam);
    }

    public void setUseDefaultConnection(boolean useDefaultConnection) {
        this.useDefaultConnection.set(useDefaultConnection);
    }

    public boolean isUseDefaultConnection() {
        return this.useDefaultConnection.get();
    }

    public boolean isSpecifyMetaData() {
        return this.specifyMetaData.get();
    }

    public void setSpecifyMetaData(boolean bSpecify) {
        this.specifyMetaData.set(bSpecify);
    }

    public String getUDSName() {
        return this.getResourceName();
    }

    public JetUConnection getConnection() {
        return null;
    }

    @Override
    public JetUConnection[] getConnections() {
        return new JetUConnection[0];
    }

    public Vector getColumns() {
        Vector<JetObject> vecRet = new Vector<JetObject>();
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)vecChildren.elementAt(i);
            if (!(child instanceof JetUUDSField)) continue;
            vecRet.addElement(child);
        }
        return vecRet;
    }

    @Override
    public Vector getFields() {
        return this.getColumns();
    }

    public String[] parseParameter() {
        String[] strParams = null;
        if (this.parameter != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.parameter.get(), strParameterDelimiter);
            Vector<String> vecParams = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                vecParams.addElement(tokenizer.nextToken());
            }
            int iSize = vecParams.size();
            strParams = new String[iSize];
            for (int i = 0; i < iSize; ++i) {
                strParams[i] = (String)vecParams.elementAt(i);
            }
        }
        return strParams;
    }

    @Override
    public JetUResourceEntity getFieldByResourceName(String fldName) {
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)vecChildren.elementAt(i);
            if (!(child instanceof JetUUDSField) || !((JetUUDSField)child).getResourceName().equalsIgnoreCase(fldName)) continue;
            return (JetUUDSField)child;
        }
        return null;
    }

    @Override
    public String getFullSQLString() {
        return this.getSQLString();
    }

    @Override
    public String getSQLString() {
        return null;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, String mappingname) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(unvs, mappingname, "");
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, String mappingname, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity entity = unvs.getResourceByName(dataSourceName, this.getResourceName(), mappingname);
        if (entity == null) {
            throw new CannotFindEntity(mappingname);
        }
        return this.isFieldValidToQuery(unvs, entity, dataSourceName);
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, JetUResourceEntity re) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(unvs, re, "");
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, JetUResourceEntity re, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (re instanceof JetUParameter) {
            bRet = true;
        } else if (re instanceof JetUFormula) {
            bRet = this.isFormulaValidToQuery((JetUFormula)re, unvs, dataSourceName);
        } else if (re instanceof JetUQueriableField && re instanceof JetUUDSField) {
            bRet = ((JetUUDSField)re).getUDS() == this;
        }
        return bRet;
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        return this.isFormulaValidToQuery(uFormula, universe, "");
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        if (!uFormula.isParsedOK()) {
            return false;
        }
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (uFormula instanceof JetUSummary && JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    public JetUUDSField getFieldByMappingIndex(int iIndex) {
        Vector vecFields = this.getColumns();
        int iSize = vecFields.size();
        JetUUDSField field = null;
        for (int i = 0; i < iSize; ++i) {
            field = (JetUUDSField)vecFields.elementAt(i);
            if (field.getColMappingIndex() != iIndex) continue;
            return field;
        }
        return null;
    }

    public JetUUDSField getFieldByPathString(String strPath) {
        Vector vecFields = this.getColumns();
        int iSize = vecFields.size();
        JetUUDSField field = null;
        for (int i = 0; i < iSize; ++i) {
            field = (JetUUDSField)vecFields.elementAt(i);
            String sFullPath = field.getPathString() + field.getFldName();
            if (!sFullPath.equals(strPath)) continue;
            return field;
        }
        return null;
    }

    @Override
    public String getInstancePrefix() {
        return "UserDataSource";
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        if (!this.className.equal(((JetUUserDataSource)container).className)) {
            return false;
        }
        return super.isSimilar(container);
    }

    private boolean isBLSimilar(JetUUserDataSource udsQuery) {
        JBusinessLogic bl2;
        JBusinessLogic bl1 = this.getBL();
        if (bl1 == (bl2 = udsQuery.getBL())) {
            return true;
        }
        if (bl1 == null) {
            return bl2 == null;
        }
        return bl1.isSimilar(bl2);
    }

    private boolean isBVSimilar(JetUUserDataSource udsQuery) {
        JBusinessView bv2;
        JBusinessView bv1 = this.getBV();
        if (bv1 == (bv2 = udsQuery.getBV())) {
            return true;
        }
        if (bv1 == null) {
            return bv2 == null;
        }
        return bv1.isSimilar(bv2);
    }

    public boolean replaceParameterName(String oldName, String newName) {
        String newExp = UniverseUtil.replaceString(this.parameter.get(), "@" + oldName, "@" + newName);
        if (newExp != null) {
            this.parameter.set(newExp);
            return true;
        }
        return false;
    }

    public JBusinessLogic newBL(String blName) throws BLIlegalNameException, BLDupleNameException {
        if (this.getBL() != null) {
            return null;
        }
        BusinessLogic bl = new BusinessLogic();
        bl.setName(blName);
        bl.setDisplayName(blName);
        this.add(bl);
        return bl;
    }

    public JBusinessView newBV(String bvName) throws BLIlegalNameException, BLDupleNameException {
        if (this.getBV() != null) {
            return null;
        }
        BusinessView bv = new BusinessView();
        bv.setDisplayName(bvName);
        this.add(bv);
        return bv;
    }

    public void removeBV() {
        JBusinessView bv = this.getBV();
        if (bv != null) {
            this.remove((JetObject)((Object)bv));
        }
    }

    @Override
    public JBusinessLogic getBL() {
        Vector children = this.getChildren();
        JBusinessLogic ret = null;
        for (JetObject element : children) {
            JBusinessLogic bl;
            if (!(element instanceof JBusinessLogic) || (bl = (JBusinessLogic)((Object)element)).getElementType() != 0) continue;
            ret = bl;
        }
        return ret;
    }

    @Override
    public JBusinessView getBV() {
        Vector children = this.getChildren();
        JBusinessView ret = null;
        for (JetObject element : children) {
            JBusinessLogic bl;
            if (!(element instanceof JBusinessLogic) || (bl = (JBusinessLogic)((Object)element)).getElementType() != 1) continue;
            ret = (JBusinessView)bl;
        }
        return ret;
    }

    @Override
    public void InitAfterLoad() {
        Vector children = this.getChildren();
        if (children == null) {
            return;
        }
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            if (!(children.get(i) instanceof JBusinessLogic)) continue;
            BusinessLogic bl = (BusinessLogic)children.get(i);
            bl.initAfterLoad();
        }
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, String mappingName, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity en;
        if (refFldOfFml.containsKey(mappingName)) {
            return true;
        }
        refFldOfFml.put(mappingName, "");
        JetUResourceEntity entity = universe.getResourceByName(dataSourceName, this.getResourceName(), mappingName);
        if (entity == null && (en = universe.getAnyResourceByName(mappingName)) != null && en instanceof JetUParameter) {
            entity = en;
        }
        if (entity == null) {
            throw new CannotFindEntity(mappingName);
        }
        return this.isFieldValidToQuery(universe, entity, dataSourceName, refFldOfFml);
    }

    private boolean isFieldValidToQuery(JetUUniverse universe, JetUResourceEntity entity, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (entity instanceof JetUParameter) {
            bRet = true;
        } else if (entity instanceof JetUFormula) {
            bRet = this.isFormulaValidToQuery((JetUFormula)entity, universe, dataSourceName, refFldOfFml);
        } else if (entity instanceof JetUQueriableField && entity instanceof JetUUDSField) {
            bRet = ((JetUUDSField)entity).getUDS() == this;
        }
        return bRet;
    }

    private boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName, refFldOfFml)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (uFormula instanceof JetUSummary && JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    @Override
    public int isPushDownGroupQuery() {
        return 2;
    }

    @Override
    public boolean canPushdownSort(String fieldMappingName) {
        return false;
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("maxRows", new Integer(1));
        nameIdx.put("Parameter", new Integer(2));
        nameIdx.put("ClassName", new Integer(3));
        nameIdx.put("Name", new Integer(4));
        nameIdx.put("maxDuration", new Integer(5));
        nameIdx.put("SpecifyMetadata", new Integer(6));
        grpDesc = new HashVector(1);
        String grpName = "anonymous";
        Vector<String> grpItems = new Vector<String>(8);
        grpItems.add("Description");
        grpItems.add("maxRows");
        grpItems.add("Parameter");
        grpItems.add("ClassName");
        grpItems.add("Name");
        grpItems.add("maxDuration");
        grpItems.add("SpecifyMetadata");
        grpDesc.put(grpName, grpItems);
    }
}

