/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.dataengine.util.DSLog;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUTransformRelationModel;
import jet.universe.JetUTransformRelationSchema;
import jet.universe.JetUWebServiceConnection;
import jet.universe.JetUXMLConnection;
import jet.universe.webservice.JetUQName;
import jet.universe.webservice.JetUWSElement;
import toolkit.db.TableInfo;

public class JetUWSOperationConnection
extends JetUXMLConnection {
    public JetUQName serviceName = new JetUQName(this, "ServiceName");
    public JetUQName portTypeName = new JetUQName(this, "PortTypeName");
    public JetUQName operationName = new JetUQName(this, "OperationName");
    public JetUQName inputMessageName = new JetUQName(this, "InputMessageName");
    public JetNumber timeout = new JetNumber(this, "TimeOut", 180);
    public JetBoolean useResponseStatus = new JetBoolean(this, "UseResponseStatus", false);
    private static DSLog log;

    public JetUWSElement[] getWSElements() {
        Vector children = this.getChildren();
        ArrayList<JetUWSElement> wsElements = new ArrayList<JetUWSElement>();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUWSElement)) continue;
            wsElements.add((JetUWSElement)children.get(i));
        }
        return wsElements.toArray(new JetUWSElement[wsElements.size()]);
    }

    public void setWSElements(JetUWSElement[] wsElements) {
        if (wsElements != null) {
            int i;
            Vector children = this.getChildren();
            for (i = 0; i < children.size(); ++i) {
                if (!(children.get(i) instanceof JetUWSElement)) continue;
                JetUWSElement child = (JetUWSElement)children.get(i);
                this.remove(child);
            }
            for (i = 0; i < wsElements.length; ++i) {
                this.add(wsElements[i]);
            }
        }
    }

    public QName getServiceName() {
        return this.serviceName.get();
    }

    public void setServiceName(QName serviceName) {
        this.serviceName.set(serviceName);
    }

    public QName getPortTypeName() {
        return this.portTypeName.get();
    }

    public void setPortTypeName(QName portTypeName) {
        this.portTypeName.set(portTypeName);
    }

    public QName getOperationName() {
        return this.operationName.get();
    }

    public void setOperationName(QName operationName) {
        this.operationName.set(operationName);
    }

    public QName getInputMessageName() {
        return this.inputMessageName.get();
    }

    public void setInputMessageName(QName inputMessageName) {
        this.inputMessageName.set(inputMessageName);
    }

    public int getTimeout() {
        return this.timeout.get();
    }

    public void setTimeout(int timeout) {
        this.timeout.set(timeout);
    }

    public String getUniqueName() {
        return null;
    }

    public void setUseResponseStatus(boolean useResponseStatus) {
        this.useResponseStatus.set(useResponseStatus);
    }

    public boolean getUseResponseStatus() {
        return this.useResponseStatus.get();
    }

    private boolean checkName(String name2) {
        return true;
    }

    @Override
    public String getInstancePrefix() {
        return "WSOperationConnection";
    }

    public void addTableViewsDirectly() {
        JetUTransformRelationSchema schema = this.getTransformRelationSchema();
        this.removeTableViews();
        if (schema != null) {
            String schemaName = schema.getResourceName();
            JetUTransformRelationModel[] models = schema.getJetUTransformRelationModels();
            for (int j = 0; j < models.length; ++j) {
                JetUTransformRelationModel model = models[j];
                String tableName = model.getResourceName();
                TableInfo ti = null;
                try {
                    ti = this.createTableInfo(null, schemaName, tableName, 1);
                }
                catch (SQLException e) {
                    logger.debug("Create tableInfo error with " + schemaName + " and " + tableName, e);
                }
                if (ti == null) continue;
                this.addTableView(tableName, ti);
            }
        }
    }

    private void removeTableViews() {
        boolean size = false;
        Vector children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUTableView)) continue;
            this.removeTableView((JetUTableView)children.get(i));
        }
    }

    public int getTableSize() {
        int size = 0;
        Vector children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUTableView)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public JetUConnection createNew() {
        JetUWSElement[] wsElement;
        JetUTransformRelationSchema schema;
        JetUWSOperationConnection newOpConn = new JetUWSOperationConnection();
        JetObject.copyProperties(newOpConn, this);
        MetadataContainerImpl xmlMetadata = this.getXMLMetadata();
        if (xmlMetadata != null) {
            newOpConn.setXMLMetadata((MetadataContainerImpl)xmlMetadata.deepDup());
        }
        if ((schema = this.getTransformRelationSchema()) != null) {
            newOpConn.setTransformRelationSchema((JetUTransformRelationSchema)schema.deepDup());
        }
        if ((wsElement = this.getWSElements()) != null) {
            JetUWSElement[] newElements = new JetUWSElement[wsElement.length];
            for (int i = 0; i < newElements.length; ++i) {
                newElements[i] = (JetUWSElement)wsElement[i].deepDup();
            }
            newOpConn.setWSElements(newElements);
        }
        JetUSupportInfo newSPInfo = this.getSupportInfo();
        newOpConn.add(newSPInfo.deepDup());
        return newOpConn;
    }

    @Override
    public boolean addTableView(JetUTableView tableview) {
        if (!this.isNameExist(tableview.getResourceName())) {
            this.add(tableview);
            tableview.InitAfterCreate(null);
            return true;
        }
        return false;
    }

    @Override
    public JetUDatabase getDatabase() {
        JetUWebServiceConnection websCon = (JetUWebServiceConnection)this.getParent();
        JetUDatabase db = null;
        if (websCon != null) {
            db = websCon.getDatabase();
        }
        return db;
    }

    public Vector getALLRefParamAndFml() {
        JetUDatabase db = this.getDatabase();
        Vector result = new Vector();
        JetUWSElement[] elements = this.getWSElements();
        for (int i = 0; i < elements.length; ++i) {
            this.getChildRefParamAndFml(db, elements[i], result);
        }
        return result;
    }

    private void getChildRefParamAndFml(JetUDatabase db, JetUWSElement elem, Vector result) {
        if (elem != null) {
            JetUResourceEntity resEntity;
            JetUWSElement element = elem;
            int valueType = element.getValueType().get();
            String value = element.getValue();
            if (valueType != 0 && (resEntity = db.getResourceByName(value)) != null) {
                result.add(resEntity);
            }
            Vector children = elem.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                JetUWSElement childElem = (JetUWSElement)children.get(i);
                this.getChildRefParamAndFml(db, childElem, result);
            }
        }
    }

    static {
        DSLog.getDSLog(JetUWSOperationConnection.class.getName());
    }
}

