/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.dataservice.api.wsdl20.Binding;
import com.jinfonet.dataservice.api.wsdl20.BindingOperation;
import com.jinfonet.dataservice.api.wsdl20.Description;
import com.jinfonet.dataservice.api.wsdl20.Direction;
import com.jinfonet.dataservice.api.wsdl20.Endpoint;
import com.jinfonet.dataservice.api.wsdl20.InterfaceMessageReference;
import com.jinfonet.dataservice.api.wsdl20.InterfaceOperation;
import com.jinfonet.dataservice.api.wsdl20.Service;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.InterfaceImpl;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.SimpleXMLCreator;
import com.jinfonet.dataservice.schema.relational.datasource.webservice.WSDLParser;
import com.jinfonet.webservice.policy.PolicyMap;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import jet.JRException;
import jet.controls.JetContainable;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetPassword;
import jet.controls.JetString;
import jet.dataengine.api.DSException;
import jet.dataengine.api.datasource.xml.ElementTreeNode;
import jet.dataengine.api.datasource.xml.InstanceSOAPInfo;
import jet.dataengine.api.datasource.xml.MetadataContainer;
import jet.dataengine.api.datasource.xml.ModelCreator;
import jet.dataengine.api.datasource.xml.ModelCreatorFactory;
import jet.dataengine.api.datasource.xml.SchemaSOAPInfo;
import jet.dataengine.api.datasource.xml.SchemaURIInfo;
import jet.dataengine.api.datasource.xml.XMLInstanceSource;
import jet.dataengine.api.datasource.xml.XMLModelSource;
import jet.dataengine.api.datasource.xml.XmlTransformationService;
import jet.dataengine.util.DSLog;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.dataengine8.core.queryengine.transform.SoapRespondToolkit;
import jet.universe.JetUConnection;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUTransformRelationSchema;
import jet.universe.JetUWSOperationConnection;
import jet.universe.JetUXMLSupportInfo;
import jet.universe.exception.AddTableViewException;
import jet.universe.webservice.JetUDescription;
import jet.universe.webservice.JetUWSElement;
import jet.universe.webservice.policy.JetUPolicyMap;
import jet.universe.webservice.wsdl_1.JetUBinding11;
import jet.universe.webservice.wsdl_1.JetUBindingOperation11;
import jet.universe.webservice.wsdl_1.JetUDefinitions;
import jet.universe.webservice.wsdl_1.JetUMessage;
import jet.universe.webservice.wsdl_1.JetUOperation;
import jet.universe.webservice.wsdl_1.JetUPart;
import jet.universe.webservice.wsdl_1.JetUPort;
import jet.universe.webservice.wsdl_1.JetUPortType;
import jet.universe.webservice.wsdl_1.JetUPortTypeMessageReference;
import jet.universe.webservice.wsdl_1.JetUService11;
import jet.util.HashVector;
import toolkit.db.TableInfo;

public class JetUWebServiceConnection
extends JetUConnection {
    public static final String defaultDateFormat = "yyyy-MM-dd";
    public static final String defaultTimeFormat = "hh:mm:ss";
    public static final String defaultTimestampFormat = "yyyy-MM-dd hh:mm:ss";
    public JetString uri = new JetString(this, "URI");
    public JetNumber timeOut = new JetNumber(this, "TimeOut", 180);
    public JetString user = new JetString(this, "User");
    public JetPassword password = new JetPassword(this, "Password");
    public JetString timeZone = new JetString(this, "TimeZone");
    public JetString language = new JetString(this, "Language");
    public JetString country = new JetString(this, "Country");
    public JetString variant = new JetString(this, "Variant");
    public JetString WSSecurityPolicy = new JetString(this, "WSSecurityPolicy");
    public static final int type_LocalFile = 1;
    public static final int type_URI = 2;
    public JetNumber uriType = new JetNumber(this, "URIType");
    public JetString securityUser = new JetString(this, "SecurityUser");
    public JetPassword securityPassword = new JetPassword(this, "SecurityPassword");
    public JetNumber keyStoreType = new JetNumber(this, "KeyStoreType", 0);
    private static final String str_KeyStoreType_DefValue = "JKS";
    private static final String str_KeyStoreType_Value = "PKCS12";
    public static final String WSDL_VERSION_11 = "11";
    public static final String WSDL_VERSION_20 = "20";
    public JetString keyStoreFile = new JetString(this, "KeyStoreFile");
    public JetPassword keyStorePassword = new JetPassword(this, "KeyStorePassword");
    public JetString signatureAliasName = new JetString(this, "SignatureAliasName");
    public JetPassword signatureAliasPassword = new JetPassword(this, "SignatureAliasPassword");
    public JetString serverKeyAliasName = new JetString(this, "ServerKeyAliasName");
    public JetPassword serverKeyAliasPassword = new JetPassword(this, "ServerKeyAliasPassword");
    public JetString wsdlVersion = new JetString(this, "WsdlVersion");
    private static DSLog log = DSLog.getDSLog(JetUWebServiceConnection.class.getName());
    private static final HashMap nameIdx = new HashMap(22);
    private static final HashVector grpDesc;

    public JetUWebServiceConnection() {
        this.initialize();
    }

    public JetUWebServiceConnection(String uri, int uriType, String userName, String password, int timeOut) throws DSException {
        super(uri, "");
        this.initialize();
        this.addWSDL(uri, uriType, userName, password);
        this.setUri(uri);
        this.setUser(userName);
        this.setPassword(password);
        if (timeOut <= 0) {
            this.setTimeOut(180);
        } else {
            this.setTimeOut(timeOut);
        }
    }

    private void initialize() {
        this.qualifiedNamePattern.set(new Integer(0));
        this.dateFormat.set(defaultDateFormat);
        this.timeFormat.set(defaultTimeFormat);
        this.timestampFormat.set(defaultTimestampFormat);
        this.encodingPattern.set(new Integer(0));
        this.keyStoreType.setCanChangeByBL(false);
        this.keyStoreType.setCanChangeByOthers(false);
        this.keyStoreType.setCanChangeByFmtt(false);
        this.keyStoreType.setEditorType(JetNumber.COMBO_EDITOR);
        Vector<Integer> choice = new Vector<Integer>(2);
        choice.add(0);
        choice.add(1);
        this.keyStoreType.setPropertyChoice(choice);
        this.keyStoreType.setEditFlag(0);
        this.keyStoreFile.setEditFlag(0);
        this.keyStorePassword.setEditFlag(0);
        this.securityUser.setEditFlag(0);
        this.securityPassword.setEditFlag(0);
        this.serverKeyAliasName.setEditFlag(0);
        this.serverKeyAliasPassword.setEditFlag(0);
        this.signatureAliasName.setEditFlag(0);
        this.signatureAliasPassword.setEditFlag(0);
        this.uri.setEditFlag(0);
    }

    public String getUri() {
        return this.uri.get();
    }

    public void setUri(String uri) {
        this.uri.set(uri);
    }

    public int getTimeOut() {
        return this.timeOut.get();
    }

    public void setTimeOut(int timeOut) {
        this.timeOut.set(timeOut);
    }

    public String getUser() {
        return this.user.get();
    }

    public void setUser(String user) {
        this.user.set(user);
    }

    public String getWsdlVersion() {
        return this.wsdlVersion.get();
    }

    public void setWsdlVersion(String user) {
        this.wsdlVersion.set(user);
    }

    public String getPassword() {
        return this.password.get();
    }

    public void setPassword(String password) {
        this.password.set(password);
    }

    public String getTimeZone() {
        return this.timeZone.get();
    }

    public void setTimeZone(String timeZone) {
        this.timeZone.set(timeZone);
    }

    public Locale getLocal() {
        return new Locale(this.language.get(), this.country.get(), this.variant.get());
    }

    public void setLocal(Locale local) {
        this.language.set(local.getLanguage());
        this.country.set(local.getCountry());
        this.variant.set(local.getVariant());
    }

    public String getWSSecurityPolicy() {
        return this.WSSecurityPolicy.get();
    }

    public void setWSSecurityPolicy(String securityPolicy) {
        this.WSSecurityPolicy.set(securityPolicy);
    }

    public int getUriType() {
        return this.uriType.get();
    }

    public void setUriType(int uriType) {
        this.uriType.set(uriType);
    }

    public JetString getSecurityUser() {
        return this.securityUser;
    }

    public void setSecurityUser(boolean isChangeByOther, String securityUser) {
        if (isChangeByOther) {
            this.securityUser.setChangeByObject(securityUser);
        } else {
            this.securityUser.setChangeByObject(null);
            this.securityUser.set(securityUser);
        }
    }

    public JetString getSecurityPassword() {
        return this.securityPassword;
    }

    public void setSecurityPassword(boolean isChangeByOther, String securityPassword) {
        if (isChangeByOther) {
            this.securityPassword.setChangeByObject(securityPassword);
        } else {
            this.securityPassword.setChangeByObject(null);
            this.securityPassword.set(securityPassword);
        }
    }

    public JetNumber getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(int keyStoreType) {
        this.keyStoreType.setInt(keyStoreType);
    }

    public JetString getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(boolean isChangeByOther, String keyStoreFile) {
        if (isChangeByOther) {
            this.keyStoreFile.setChangeByObject(keyStoreFile);
        } else {
            this.keyStoreFile.setChangeByObject(null);
            this.keyStoreFile.set(keyStoreFile);
        }
    }

    public JetString getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(boolean isChangeByOther, String keyStorePassword) {
        if (isChangeByOther) {
            this.keyStorePassword.setChangeByObject(keyStorePassword);
        } else {
            this.keyStorePassword.setChangeByObject(null);
            this.keyStorePassword.set(keyStorePassword);
        }
    }

    public JetString getSignatureAliasName() {
        return this.signatureAliasName;
    }

    public void setSignatureAliasName(boolean isChangeByOther, String signatureAliasName) {
        if (isChangeByOther) {
            this.signatureAliasName.setChangeByObject(signatureAliasName);
        } else {
            this.signatureAliasName.setChangeByObject(null);
            this.signatureAliasName.set(signatureAliasName);
        }
    }

    public JetString getSignatureAliasPassword() {
        return this.signatureAliasPassword;
    }

    public void setSignatureAliasPassword(boolean isChangeByOther, String signatureAliasPassword) {
        if (isChangeByOther) {
            this.signatureAliasPassword.setChangeByObject(signatureAliasPassword);
        } else {
            this.signatureAliasPassword.setChangeByObject(null);
            this.signatureAliasPassword.set(signatureAliasPassword);
        }
    }

    public JetString getServerKeyAliasName() {
        return this.serverKeyAliasName;
    }

    public void setServerKeyAliasName(boolean isChangeByOther, String serverKeyAliasName) {
        if (isChangeByOther) {
            this.serverKeyAliasName.setChangeByObject(serverKeyAliasName);
        } else {
            this.serverKeyAliasName.setChangeByObject(null);
            this.serverKeyAliasName.set(serverKeyAliasName);
        }
    }

    public JetString getServerKeyAliasPassword() {
        return this.serverKeyAliasPassword;
    }

    public void setServerKeyAliasPassword(boolean isChangeByOther, String serverKeyAliasPassword) {
        if (isChangeByOther) {
            this.serverKeyAliasPassword.setChangeByObject(serverKeyAliasPassword);
        } else {
            this.serverKeyAliasPassword.setChangeByObject(null);
            this.serverKeyAliasPassword.set(serverKeyAliasPassword);
        }
    }

    public static String getStrKeyStoreType(int type) {
        if (type == 0) {
            return str_KeyStoreType_DefValue;
        }
        if (type == 1) {
            return str_KeyStoreType_Value;
        }
        log.debug("Unknow key store type " + type);
        return null;
    }

    public JetUDescription getDescription() {
        Vector children = this.getChildren();
        JetUDescription jDescription = null;
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUDescription)) continue;
            jDescription = (JetUDescription)children.get(i);
            break;
        }
        return jDescription;
    }

    public void setDescription(JetUDescription description) {
        JetUDescription desc = this.getDescription();
        if (desc != null) {
            this.remove(desc);
        }
        this.add(description);
    }

    public Description getMemDescription() {
        JetUDescription jDesc = this.getDescription();
        Description desc = null;
        if (jDesc != null) {
            desc = jDesc.getDescription();
        }
        return desc;
    }

    public JetUDefinitions getDefinition() {
        Vector children = this.getChildren();
        JetUDefinitions jDef = null;
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUDefinitions)) continue;
            jDef = (JetUDefinitions)children.get(i);
            break;
        }
        return jDef;
    }

    public JetUWSOperationConnection[] getWSOperationConnections() {
        Vector children = this.getChildren();
        Vector<JetUWSOperationConnection> tempResult = new Vector<JetUWSOperationConnection>();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUWSOperationConnection)) continue;
            JetUWSOperationConnection opConn = (JetUWSOperationConnection)children.get(i);
            tempResult.add(opConn);
        }
        JetUWSOperationConnection[] operationConn = new JetUWSOperationConnection[tempResult.size()];
        tempResult.toArray(operationConn);
        return operationConn;
    }

    public void addOperatiponConnectionWithoutTableView(JetUWSOperationConnection wsOpCon) {
        if (wsOpCon != null) {
            this.add(wsOpCon);
        }
    }

    public JetUWSOperationConnection getWSOpConn(QName serviceName, QName operationName) {
        JetUWSOperationConnection[] wsops = this.getWSOperationConnections();
        JetUWSOperationConnection result = null;
        for (int i = 0; i < wsops.length; ++i) {
            JetUWSOperationConnection temp = wsops[i];
            if (!temp.getServiceName().equals(serviceName) || !temp.getOperationName().equals(operationName)) continue;
            result = temp;
            break;
        }
        return result;
    }

    public JetUWSOperationConnection getWSOpConn(QName serviceName, QName portTypeName, QName operationName) {
        JetUWSOperationConnection[] wsops = this.getWSOperationConnections();
        JetUWSOperationConnection result = null;
        for (int i = 0; i < wsops.length; ++i) {
            JetUWSOperationConnection temp = wsops[i];
            if (!temp.getServiceName().equals(serviceName) || !temp.getOperationName().equals(operationName) || !temp.getPortTypeName().equals(portTypeName)) continue;
            result = temp;
            break;
        }
        return result;
    }

    private void addWSDL(String wsdluri, int type, String user, String pwd) throws DSException {
        WSDLParser.ParseResult result = WSDLParser.parse(wsdluri, user, pwd);
        if (result.desc == null && result.def != null) {
            this.wsdlVersion.set(WSDL_VERSION_11);
            Definition def = result.def;
            JetUDefinitions jdef = new JetUDefinitions(def);
            this.add(jdef);
        } else {
            this.wsdlVersion.set(WSDL_VERSION_20);
            Description wsdl = result.desc;
            JetUDescription jwsdl = new JetUDescription();
            jwsdl.setDescription(wsdl);
            this.add(jwsdl);
        }
        PolicyMap po = result.policy;
        JetUPolicyMap uPolicyMap = new JetUPolicyMap(po);
        this.add(uPolicyMap);
        this.setUriType(type);
    }

    public void refreshWSDL(String wsdluri, int type, String user, String pwd) throws DSException {
        WSDLParser.ParseResult result = WSDLParser.parse(wsdluri, user, pwd);
        if (result.desc == null && result.def != null) {
            this.wsdlVersion.set(WSDL_VERSION_11);
            Definition def = result.def;
            JetUDefinitions jdef = new JetUDefinitions(def);
            for (Object child : this.children) {
                if (!(child instanceof JetUDefinitions)) continue;
                this.remove((JetObject)child);
                break;
            }
            this.add(jdef);
        } else {
            this.wsdlVersion.set(WSDL_VERSION_20);
            Description wsdl = result.desc;
            JetUDescription jwsdl = new JetUDescription();
            jwsdl.setDescription(wsdl);
            for (Object child : this.children) {
                if (!(child instanceof JetUDescription)) continue;
                this.remove((JetObject)child);
                break;
            }
            this.add(jwsdl);
        }
        PolicyMap po = result.policy;
        JetUPolicyMap uPolicyMap = new JetUPolicyMap(po);
        for (Object child : this.children) {
            if (!(child instanceof JetUPolicyMap)) continue;
            this.remove((JetObject)child);
            break;
        }
        this.add(uPolicyMap);
        this.setUriType(type);
    }

    public JetUWSOperationConnection createOperationConnection(QName serviceName, QName operationName) throws JRException {
        int i;
        if (this.getWSOpConn(serviceName, operationName) != null) {
            return null;
        }
        JetUWSElement in = null;
        Description description = this.getMemDescription();
        InterfaceOperation operation = description.getService(serviceName).getInterface().getInterfaceOperation(operationName);
        Vector<QName> endpoinds = new Vector<QName>();
        Vector<String> uris = new Vector<String>();
        Vector<String> soapActionUris = new Vector<String>();
        this.getURIs(operation, endpoinds, uris, soapActionUris);
        InterfaceMessageReference[] ifmrs = operation.getInterfaceMessageReferences();
        JetUWSOperationConnection conn = null;
        for (i = 0; i < ifmrs.length; ++i) {
            if (!ifmrs[i].getDirection().equals(Direction.IN) || ifmrs[i].getElementDeclaration() == null) continue;
            in = SimpleXMLCreator.deriveXMLFromXSD(description.getXmlSchemas(), ifmrs[i].getElementDeclaration().getName());
        }
        for (i = 0; i < ifmrs.length; ++i) {
            if (!ifmrs[i].getDirection().equals(Direction.OUT)) continue;
            QName ref = ifmrs[i].getElementDeclaration().getName();
            SchemaSOAPInfo ssi = new SchemaSOAPInfo();
            ssi.setXmlSchemas(description.getXmlSchemas());
            ModelCreator mcr = ModelCreatorFactory.create(new XMLModelSource(ssi));
            mcr.setRootDocs(ref);
            mcr.process();
            conn = new JetUWSOperationConnection();
            conn.getSupportInfo();
            MetadataContainer mc = mcr.getMetadataContainer();
            InstanceSOAPInfo sopinfo = new InstanceSOAPInfo(serviceName, operationName, endpoinds, uris, new Vector(), soapActionUris);
            mc.setInstanceSource(new XMLInstanceSource(sopinfo, this.timeZone.get()));
            conn.setXMLMetadata((MetadataContainerImpl)mc);
            conn.setResourceName(mc.getSchemaURI());
            XmlTransformationService ts = new XmlTransformationService(conn);
            ElementTreeNode node = null;
            ElementTreeNode[] nodeList = mc.getTreeList();
            for (int j = 0; j < nodeList.length; ++j) {
                if (!nodeList[j].getName().equals(ref.getLocalPart())) continue;
                node = nodeList[j];
                break;
            }
            JetUTransformRelationSchema relationSchema = ts.automaticTransfrom(node, "TransformedSchema");
            conn.setTransformRelationSchema(relationSchema);
            conn.setWSElements(new JetUWSElement[]{in});
            conn.setServiceName(serviceName);
            conn.setOperationName(operationName);
            conn.getXMLMetadata().removeall();
        }
        return conn;
    }

    public JetUWSOperationConnection createOperationConnection(QName serviceName, QName portTypeName, QName operationName) throws JRException {
        if (this.getWSOpConn(serviceName, portTypeName, operationName) != null) {
            return null;
        }
        JetUWSOperationConnection conn = new JetUWSOperationConnection();
        conn.getSupportInfo();
        JetUWSElement[] in = null;
        JetUDefinitions def = this.getDefinition();
        JetUPortType jPortType = def.getPortType(portTypeName);
        JetUOperation operation = jPortType.getOperation(operationName);
        conn.setServiceName(serviceName);
        conn.setPortTypeName(portTypeName);
        conn.setOperationName(operationName);
        Vector<QName> ports = new Vector<QName>();
        Vector vURI = new Vector();
        Vector vStyle = new Vector();
        Vector vSoapURI = new Vector();
        this.getUriAndStyles(portTypeName, operationName, ports, vURI, vStyle, vSoapURI);
        Vector relatedMessageRefs = operation.getRelatedMessageRefs();
        JetUPortTypeMessageReference[] ifmrs = new JetUPortTypeMessageReference[relatedMessageRefs.size()];
        relatedMessageRefs.toArray(ifmrs);
        JetUMessage inputMsg = null;
        for (int i = 0; i < ifmrs.length; ++i) {
            if (ifmrs[i].getMessageLabel().equals("in")) {
                inputMsg = def.getMessage(ifmrs[i].getRefMessage());
                in = SimpleXMLCreator.deriveXMLFromXSD(def.getXmlSchemas(), inputMsg);
                conn.setWSElements(in);
                conn.setInputMessageName(inputMsg.getQName());
                continue;
            }
            if (!ifmrs[i].getMessageLabel().equals("out")) continue;
            JetUMessage msg = def.getMessage(ifmrs[i].getRefMessage());
            SchemaSOAPInfo ssi = new SchemaSOAPInfo();
            ssi.setXmlSchemas(def.getXmlSchemas());
            ssi.setOperationQName(operationName);
            String style = "";
            if (vStyle.size() == 1) {
                style = vStyle.elementAt(0).toString();
            } else if (vStyle.size() > 0) {
                for (int styleSize = 0; styleSize < vStyle.size(); ++styleSize) {
                    if ("".equals(vStyle.elementAt(styleSize).toString())) continue;
                    style = vStyle.elementAt(styleSize).toString();
                    break;
                }
            }
            ssi.setStyle(style);
            ModelCreator mcr = ModelCreatorFactory.create(new XMLModelSource(ssi));
            mcr.setMessage(msg);
            mcr.process();
            MetadataContainer mc = mcr.getMetadataContainer();
            InstanceSOAPInfo sopinfo = new InstanceSOAPInfo(serviceName, operationName, ports, vURI, vStyle, vSoapURI);
            mc.setInstanceSource(new XMLInstanceSource(sopinfo, this.timeZone.get()));
            conn.setXMLMetadata((MetadataContainerImpl)mc);
            conn.setResourceName(mc.getSchemaURI());
            XmlTransformationService ts = new XmlTransformationService(conn);
            ElementTreeNode[] nodeList = mc.getTreeList();
            ElementTreeNode node = this.getElementTreeNode(nodeList, msg, operationName, style);
            JetUTransformRelationSchema relationSchema = ts.automaticTransfrom(node, "TransformedSchema");
            conn.setTransformRelationSchema(relationSchema);
            conn.getXMLMetadata().removeall();
        }
        return conn;
    }

    public void refreshConSchema(JetUWSOperationConnection operationConnection, boolean checkStatus) throws JRException {
        boolean responseStatus = operationConnection.getUseResponseStatus();
        if (checkStatus != responseStatus) {
            if (checkStatus) {
                this.buildSoapRespondSchema(operationConnection);
            } else {
                this.buildNormalSchema(operationConnection);
            }
        }
    }

    private void buildSoapRespondSchema(JetUWSOperationConnection conn) throws JRException {
        SoapRespondToolkit soapKit = new SoapRespondToolkit();
        String xmlcontent = soapKit.getSoapRespond(this.getUniverse(), this.getDatabase().getResourceName(), conn);
        SchemaURIInfo sui = new SchemaURIInfo(xmlcontent, 1, true);
        ModelCreator mcr = ModelCreatorFactory.create(new XMLModelSource(sui));
        mcr.process();
        conn.removeTransformRelationSchema();
        MetadataContainer mc = mcr.getMetadataContainer();
        mc.setInstanceSource(conn.getXMLMetadata().getInstSource());
        conn.setXMLMetadata((MetadataContainerImpl)mc);
        conn.setResourceName(mc.getSchemaURI());
        XmlTransformationService ts = new XmlTransformationService(conn);
        ElementTreeNode node = null;
        ElementTreeNode[] nodeList = mc.getTreeList();
        if (nodeList.length > 0) {
            node = nodeList[0];
            JetUTransformRelationSchema relationSchema = ts.automaticTransfrom(node, "TransformedSchema");
            conn.setTransformRelationSchema(relationSchema);
        }
        conn.setUseResponseStatus(true);
    }

    private void buildNormalSchema(JetUWSOperationConnection conn) throws JRException {
        QName portTypeName = conn.getPortTypeName();
        QName operationName = conn.getOperationName();
        JetUDefinitions def = this.getDefinition();
        JetUOperation operation = null;
        Vector<String> vStyle = new Vector<String>();
        this.getStyles(portTypeName, operationName, vStyle);
        JetUPortType jPortType = def.getPortType(portTypeName);
        operation = jPortType.getOperation(operationName);
        JetUMessage msg = def.getMessage(conn.getInputMessageName());
        SchemaSOAPInfo ssi = new SchemaSOAPInfo();
        ssi.setXmlSchemas(def.getXmlSchemas());
        ssi.setOperationQName(operationName);
        String style = "";
        if (vStyle.size() == 1) {
            style = vStyle.elementAt(0).toString();
        } else if (vStyle.size() > 0) {
            for (int styleSize = 0; styleSize < vStyle.size(); ++styleSize) {
                if ("".equals(vStyle.elementAt(styleSize).toString())) continue;
                style = vStyle.elementAt(styleSize).toString();
                break;
            }
        }
        ssi.setStyle(style);
        ModelCreator mcr = ModelCreatorFactory.create(new XMLModelSource(ssi));
        mcr.setMessage(msg);
        mcr.process();
        MetadataContainer mc = mcr.getMetadataContainer();
        mc.setInstanceSource(conn.getXMLMetadata().getInstSource());
        conn.setXMLMetadata((MetadataContainerImpl)mc);
        conn.setResourceName(mc.getSchemaURI());
        XmlTransformationService ts = new XmlTransformationService(conn);
        ElementTreeNode[] nodeList = mc.getTreeList();
        ElementTreeNode node = this.getElementTreeNode(nodeList, msg, operationName, style);
        JetUTransformRelationSchema relationSchema = ts.automaticTransfrom(node, "TransformedSchema");
        conn.setTransformRelationSchema(relationSchema);
        conn.setUseResponseStatus(false);
    }

    private ElementTreeNode getElementTreeNode(ElementTreeNode[] nodeList, JetUMessage msg, QName operationName, String style) {
        JetUPart[] parts;
        ElementTreeNode node = null;
        String qNameLocalPart = null;
        int nodeSize = nodeList.length;
        if (nodeSize == 1) {
            node = nodeList[0];
            return node;
        }
        if ("rpc".equals(style)) {
            qNameLocalPart = operationName.getLocalPart();
        } else if ("document".equals(style) && (parts = msg.getParts()) != null && parts.length > 0) {
            qNameLocalPart = parts[0].getRefQName().getLocalPart();
        }
        for (int j = 0; j < nodeSize; ++j) {
            if (!nodeList[j].getName().equals(qNameLocalPart)) continue;
            node = nodeList[j];
            break;
        }
        return node;
    }

    private void getUriAndStyles(QName portTypeName, QName operationName, Vector<QName> ports, Vector vURI, Vector vStyle, Vector vSoapURI) {
        JetUDefinitions jDef = this.getDefinition();
        Vector vServices = jDef.getServices();
        for (int i = 0; i < vServices.size(); ++i) {
            JetUService11 jService11 = (JetUService11)vServices.elementAt(i);
            Vector tempVPorts = jService11.getPorts();
            for (int j = 0; j < tempVPorts.size(); ++j) {
                JetUPort jPort = (JetUPort)tempVPorts.elementAt(j);
                JetUBinding11 jBinding11 = jDef.getBinding(jPort.getRefBinding());
                if (jBinding11 == null || !jBinding11.getRefPortType().equals(portTypeName)) continue;
                if (!jBinding11.getStyle().equals("")) {
                    vStyle.add(jBinding11.getStyle());
                }
                vURI.add(jPort.getUri().toString());
                ports.add(jPort.getQName());
                Vector childs = jBinding11.getBindingOperations();
                for (int k = 0; k < childs.size(); ++k) {
                    JetUBindingOperation11 jBindingOperation = (JetUBindingOperation11)childs.elementAt(k);
                    if ("".equals(jBindingOperation.getSoapAction()) || !jBindingOperation.getName().equals(operationName.getLocalPart())) continue;
                    vSoapURI.add(jBindingOperation.getSoapAction());
                }
            }
        }
    }

    private void getStyles(QName portTypeName, QName operationName, Vector<String> vStyle) {
        JetUDefinitions jDef = this.getDefinition();
        Vector vServices = jDef.getServices();
        for (int i = 0; i < vServices.size(); ++i) {
            JetUService11 jService11 = (JetUService11)vServices.elementAt(i);
            Vector tempVPorts = jService11.getPorts();
            for (int j = 0; j < tempVPorts.size(); ++j) {
                JetUPort jPort = (JetUPort)tempVPorts.elementAt(j);
                JetUBinding11 jBinding11 = jDef.getBinding(jPort.getRefBinding());
                if (jBinding11 == null || !jBinding11.getRefPortType().equals(portTypeName) || jBinding11.getStyle().equals("")) continue;
                vStyle.add(jBinding11.getStyle());
            }
        }
    }

    private void getURIs(InterfaceOperation operation, Vector<QName> endPoindVector, Vector<String> uris, Vector<String> soapActionUris) {
        InterfaceImpl inter = (InterfaceImpl)operation.getParent();
        QName interfaceName = inter.getName();
        Description desc = (Description)inter.getParent();
        Binding[] bindings = desc.getBindings();
        ArrayList<Binding> usefulBindings = new ArrayList<Binding>();
        for (int j = 0; j < bindings.length; ++j) {
            String version = bindings[j].getSoapVersion();
            if (version == null || version.equals("")) continue;
            BindingOperation[] bindingOperations = bindings[j].getBindingOperations();
            int length = bindingOperations.length;
            Object[] operationsFromBindingOperation = new InterfaceOperation[length];
            for (int index = 0; index < length; ++index) {
                operationsFromBindingOperation[index] = bindingOperations[index].getInterfaceOperation();
            }
            if (!this.contains(operationsFromBindingOperation, operation)) continue;
            usefulBindings.add(bindings[j]);
        }
        Object[] useBingdings = usefulBindings.toArray();
        Service[] services = desc.getServices();
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].getInterface().getName().equals(interfaceName)) continue;
            Endpoint[] endpoints = services[i].getEndpoints();
            int len = endpoints.length;
            for (int j = 0; j < len; ++j) {
                Binding bind = endpoints[j].getBinding();
                if (!this.contains(useBingdings, bind)) continue;
                URI uri = endpoints[j].getAddress();
                if (uri != null) {
                    uris.add(uri.toString());
                    endPoindVector.add(endpoints[j].getQName());
                }
                for (BindingOperation bo : bind.getBindingOperations()) {
                    String bindingOperationWsoapAction = bo.getWsoapAction();
                    if (!bo.getInterfaceOperation().equals(operation) || bindingOperationWsoapAction == null) continue;
                    soapActionUris.add(bindingOperationWsoapAction);
                }
            }
        }
    }

    private boolean contains(Object[] objects, Object o) {
        int lenth = objects.length;
        for (int i = 0; i < lenth; ++i) {
            if (objects[i] != o) continue;
            return true;
        }
        return false;
    }

    public void addOperationConnection(JetUWSOperationConnection conn) {
        this.add(conn);
        conn.addTableViewsDirectly();
    }

    public JetUPolicyMap getJetUPolicyMap() {
        JetUPolicyMap upm = null;
        Vector children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JetUPolicyMap)) continue;
            upm = (JetUPolicyMap)children.get(i);
            return upm;
        }
        return upm;
    }

    @Override
    public JetObject remove(JetObject child) {
        JetObject obj = super.remove(child);
        if (obj.getParent() != null) {
            JetUWSOperationConnection wsopCon;
            int size;
            JetContainable parent = obj.getParent();
            parent.remove(child);
            if (child instanceof JetUTableView && parent instanceof JetUWSOperationConnection && (size = (wsopCon = (JetUWSOperationConnection)parent).getTableSize()) == 0) {
                this.remove(wsopCon);
            }
        }
        return child;
    }

    @Override
    public Vector addTableViews(String strCatalogName, String schemaPattern, String tablePattern, int type) throws ClassNotFoundException, SQLException, AddTableViewException {
        return null;
    }

    @Override
    public boolean cnntToSameDB(JetUConnection cnnt) {
        return false;
    }

    @Override
    public JetUConnection createNew() {
        return (JetUConnection)this.deepDup();
    }

    @Override
    public TableInfo createTableInfo(String strQualifierName, String strOwnerName, String strTableName, int type) throws SQLException, ClassNotFoundException {
        return null;
    }

    @Override
    public void fetchSupportInfo() throws SQLException, ClassNotFoundException {
    }

    @Override
    public Vector getFieldsOfTable(String qualifier, String owner, String tablname) throws SQLException, ClassNotFoundException {
        return null;
    }

    @Override
    public JetUSupportInfo getSupportInfo() {
        Vector children = this.getChildren();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUXMLSupportInfo)) continue;
            return (JetUXMLSupportInfo)child;
        }
        JetUXMLSupportInfo suppInfo = new JetUXMLSupportInfo();
        this.add(suppInfo);
        return suppInfo;
    }

    @Override
    public Vector getTypeInfo() {
        return null;
    }

    @Override
    protected boolean isSQLTypeCaseSensitive(int type) {
        return false;
    }

    @Override
    public void updateSupportInfo() throws SQLException, ClassNotFoundException {
    }

    @Override
    public String getInstancePrefix() {
        return "WebServiceConnection";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    static {
        nameIdx.put("Name", new Integer(0));
        nameIdx.put("TimestampFormat", new Integer(1));
        nameIdx.put("EncodingPattern", new Integer(2));
        nameIdx.put("Description", new Integer(3));
        nameIdx.put("TimeFormat", new Integer(4));
        nameIdx.put("QualifiedNamePattern", new Integer(5));
        nameIdx.put("DateFormat", new Integer(6));
        nameIdx.put("URI", new Integer(7));
        nameIdx.put("User", new Integer(8));
        nameIdx.put("Password", new Integer(9));
        nameIdx.put("TimeOut", new Integer(10));
        nameIdx.put("WSSecurityPolicy", new Integer(11));
        nameIdx.put("SecurityUser", new Integer(12));
        nameIdx.put("SecurityPassword", new Integer(13));
        nameIdx.put("KeyStoreType", new Integer(14));
        nameIdx.put("KeyStoreFile", new Integer(15));
        nameIdx.put("KeyStorePassword", new Integer(16));
        nameIdx.put("SignatureAliasName", new Integer(17));
        nameIdx.put("SignatureAliasPassword", new Integer(18));
        nameIdx.put("ServerKeyAliasName", new Integer(19));
        nameIdx.put("ServerKeyAliasPassword", new Integer(20));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(12);
        grpItems.add("Name");
        grpItems.add("TimestampFormat");
        grpItems.add("Description");
        grpItems.add("TimeFormat");
        grpItems.add("QualifiedNamePattern");
        grpItems.add("DateFormat");
        grpItems.add("URI");
        grpItems.add("User");
        grpItems.add("Password");
        grpItems.add("TimeOut");
        grpItems.add("PushDownGroupQuery");
        grpDesc.put(grpName, grpItems);
        grpName = "SecurityConfiguration";
        grpItems = new Vector(9);
        grpItems.add("SecurityUser");
        grpItems.add("SecurityPassword");
        grpItems.add("KeyStoreType");
        grpItems.add("KeyStoreFile");
        grpItems.add("KeyStorePassword");
        grpItems.add("SignatureAliasName");
        grpItems.add("SignatureAliasPassword");
        grpItems.add("ServerKeyAliasName");
        grpItems.add("ServerKeyAliasPassword");
        grpDesc.put(grpName, grpItems);
    }
}

