/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUDatabase;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceContainer;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.psql.JetSCGroup;
import jet.util.HashVector;
import toolkit.db.DbTools;
import toolkit.db.PsqlQuery;

public class JetUWherePortion
extends JetUResourceContainer {
    private static JRLogger logger = JRLogger.getLogger(JetUWherePortion.class.getName());
    public JetBoolean structured = new JetBoolean(this, "Structured");
    public JetString wherePortion = new JetString(this, "WherePortion");
    public JetString queryName = new JetString(this, "QueryName");
    public JetString sourceName = new JetString(this, "DataSourceName");
    private static final HashMap nameIdx = new HashMap(6);
    private static final HashVector grpDesc;

    public JetUWherePortion() {
        this.addPG();
        this.structured.setEditFlag(0);
    }

    public JetUWherePortion(String strName, String strDescription, String strWherePortion) {
        super(strName, strDescription);
        this.addPG();
        this.wherePortion.set(strWherePortion);
        this.structured.setEditFlag(0);
    }

    private void addPG() {
        String GName = "General";
    }

    public JetUWherePortion(String strName, String strDescription, Vector vecGroups) {
        super(strName, strDescription);
        this.addPG();
        this.setGroups(vecGroups);
        this.structured.setEditFlag(0);
    }

    public JetUWherePortion cloneEntity() {
        JetUWherePortion ret;
        if (this.isStructured()) {
            Vector sourceGroupsVec = this.getGroups();
            Vector<Vector> destGroupsVec = null;
            if (sourceGroupsVec != null) {
                int iSize = sourceGroupsVec.size();
                destGroupsVec = new Vector<Vector>(iSize);
                for (int i = 0; i < iSize; ++i) {
                    Vector destChildGrp = (Vector)((Vector)sourceGroupsVec.elementAt(i)).clone();
                    destGroupsVec.addElement(destChildGrp);
                }
            }
            ret = new JetUWherePortion(this.getResourceName(), this.getDesc(), destGroupsVec);
        } else {
            ret = new JetUWherePortion(this.getResourceName(), this.getDesc(), this.getWherePortion());
        }
        JetObject.copyProperties(ret, this);
        return ret;
    }

    public void setGroups(Vector vecGroups) {
        this.removeall();
        this.structured.set(true);
        if (vecGroups != null) {
            int iSize = vecGroups.size();
            JetSCGroup jetSCGroup = null;
            for (int i = 0; i < iSize; ++i) {
                jetSCGroup = new JetSCGroup((Vector)vecGroups.elementAt(i));
                this.add(jetSCGroup, -1);
            }
        }
        this.wherePortion.set(this.getWherePortionString(vecGroups));
    }

    public Vector getGroups() {
        if (this.structured.get()) {
            Vector<Vector> vecGroups = null;
            Vector vecChildren = this.getChildren();
            int iSize = vecChildren.size();
            for (int i = 0; i < iSize; ++i) {
                Vector grp;
                JetObject child = (JetObject)vecChildren.elementAt(i);
                if (!(child instanceof JetSCGroup) || (grp = ((JetSCGroup)child).getGroup()) == null) continue;
                if (vecGroups == null) {
                    vecGroups = new Vector<Vector>();
                }
                vecGroups.addElement(grp);
            }
            return vecGroups;
        }
        return null;
    }

    public void setWherePortion(String strWherePortion) {
        this.removeall();
        this.structured.set(false);
        this.wherePortion.set(strWherePortion);
    }

    public String getWherePortion() {
        return this.wherePortion.get();
    }

    public String getQueryName() {
        return this.queryName.get();
    }

    public void setQueryName(String strQueryName) {
        this.queryName.set(strQueryName);
    }

    public String getSourceName() {
        return this.sourceName.get();
    }

    public void setSourceName(String source) {
        this.sourceName.set(source);
    }

    public boolean isStructured() {
        return this.structured.get();
    }

    protected String getWherePortionString(Vector vecGroups) {
        return PsqlQuery.getStringOfWPGroups(vecGroups);
    }

    @Override
    public JetUDatabase getDatabase() {
        return (JetUDatabase)this.getParent();
    }

    public boolean isValidToQuery(JetUQuery query) {
        JetUDatabase udb = this.getDatabase();
        Vector vecFields = JetUWherePortion.checkIfWhereportionValidToQuery(udb, query, this.getWherePortion());
        return vecFields.isEmpty();
    }

    public static Vector checkIfWhereportionValidToQuery(JetUDatabase udb, JetUQuery query, String strWherePortion) {
        Vector<String> vecInvalidField = new Vector<String>();
        if (query != null) {
            Vector vecField = DbTools.getMappingNamesInRawSql(strWherePortion);
            int fieldNumber = vecField.size();
            String strField = null;
            boolean bIsValid = true;
            for (int i = 0; i < fieldNumber; ++i) {
                strField = (String)vecField.elementAt(i);
                try {
                    bIsValid = query.isFieldValidToQuery(udb.getUniverse(), strField, udb.getResourceName());
                    if (bIsValid) continue;
                    vecInvalidField.addElement(strField);
                    continue;
                }
                catch (FormulaHasGrammarError e) {
                    vecInvalidField.addElement(strField);
                    continue;
                }
                catch (CannotFindFrmlRefFld e) {
                    vecInvalidField.addElement(strField);
                    continue;
                }
                catch (CannotFindEntity e) {
                    vecInvalidField.addElement(strField);
                }
            }
        }
        return vecInvalidField;
    }

    public Vector getMappingFields() {
        String strWP = this.getWherePortion();
        return strWP == null ? new Vector() : DbTools.getMappingNamesInRawSql(strWP);
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        return this.getClass().getName().equals(container.getClass().getName()) && this.name.equal(this.name) && this.wherePortion.equal(((JetUWherePortion)container).wherePortion) && this.isValidToQuery(this.getDatabase().GetQueryByResourceName(((JetUWherePortion)container).queryName.get()));
    }

    @Override
    public boolean isEqual(JetUResourceContainer container) {
        return this.getClass().getName().equals(container.getClass().getName()) && this.name.equal(this.name) && this.wherePortion.equal(((JetUWherePortion)container).wherePortion) && this.queryName.equal(((JetUWherePortion)container).queryName) && this.sourceName.equal(((JetUWherePortion)container).queryName);
    }

    @Override
    public String getInstancePrefix() {
        return "WherePortion";
    }

    @Override
    public String toString() {
        return "JetUWherePortion" + this.hashCode();
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("Structured", new Integer(1));
        nameIdx.put("Name", new Integer(2));
        nameIdx.put("DataSourceName", new Integer(3));
        nameIdx.put("QueryName", new Integer(4));
        nameIdx.put("WherePortion", new Integer(5));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(6);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("Structured");
        grpItems.add("DataSourceName");
        grpItems.add("QueryName");
        grpItems.add("WherePortion");
        grpDesc.put(grpName, grpItems);
    }
}

