/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JRelationModel;
import com.jinfonet.dataservice.schema.relational.TransformFieldJoin;
import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import com.jinfonet.dataservice.schema.relational.TransformRelationSchema;
import com.jinfonet.dataservice.schema.relational.datasource.ITransformToRelationRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.IXmlMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlMappingRule;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlTransformToRelationRule;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import jet.JRException;
import jet.JRProductConstants;
import jet.ReportEnv;
import jet.connect.DbColDesc;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.dataengine.api.datasource.xml.FieldJoinLoader;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.universe.JetUConnection;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUPrejoin;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUTransformDataField;
import jet.universe.JetUTransformRelationModel;
import jet.universe.JetUTransformRelationSchema;
import jet.universe.JetUXMLSupportInfo;
import jet.universe.exception.AddTableViewException;
import jet.util.HashVector;
import toolkit.db.TableInfo;

public class JetUXMLConnection
extends JetUConnection {
    public static final String defaultDateFormat = "yyyy-MM-dd";
    public static final String defaultTimeFormat = "hh:mm:ss";
    public static final String defaultTimestampFormat = "yyyy-MM-dd hh:mm:ss";
    public static final int unknow = 0;
    public static final int useLongName = 1;
    public static final int useShortName = 2;
    public JetNumber isUseLongName = new JetNumber(this, "isUseLongName", 0);
    private static final JetUPrejoin[] EmptyPrejoins = new JetUPrejoin[0];
    private static final HashMap nameIdx = new HashMap(8);
    private static final HashVector grpDesc;

    public JetUXMLConnection() {
        this.qualifiedNamePattern = new JetEnumeration(this, "QualifiedNamePattern", 83);
        this.initialize();
    }

    @Override
    public JetUConnection createNew() {
        JetUTransformRelationSchema schema;
        JetUXMLConnection conn = new JetUXMLConnection();
        JetObject.copyProperties(conn, this);
        MetadataContainerImpl xmlMetadata = this.getXMLMetadata();
        if (xmlMetadata != null) {
            conn.setXMLMetadata((MetadataContainerImpl)xmlMetadata.deepDup());
        }
        if ((schema = this.getTransformRelationSchema()) != null) {
            conn.setTransformRelationSchema((JetUTransformRelationSchema)schema.deepDup());
        }
        return conn;
    }

    private void initialize() {
        this.qualifiedNamePattern.set(new Integer(1));
        this.dateFormat.set(defaultDateFormat);
        this.timeFormat.set(defaultTimeFormat);
        this.timestampFormat.set(defaultTimestampFormat);
        this.encodingPattern.set(new Integer(0));
    }

    @Override
    public void InitAfterLoad() {
        super.InitAfterLoad();
        if (this.isUseLongName.get() == 0) {
            this.isUseLongName.set(1);
        }
        try {
            JetUTransformRelationSchema jetuSchema = this.getTransformRelationSchema();
            if (jetuSchema == null) {
                return;
            }
            TransformRelationSchema schema = jetuSchema.getTransformRelationSchema();
            MetadataContainerImpl metadata = this.getXMLMetadata();
            FieldJoinLoader.loadFieldJoin(metadata, schema);
            this.useMapRuleAccessTreeNodes(metadata);
        }
        catch (JRException e) {
            logger.error("load prejoin have error", e);
        }
    }

    private void useMapRuleAccessTreeNodes(MetadataContainerImpl metadata) throws JRException {
        JRelationModel[] rModels;
        JetUTransformRelationSchema rSchema = this.getTransformRelationSchema();
        if (rSchema == null) {
            return;
        }
        try {
            rModels = rSchema.getTransformRelationSchema().getRelationModels();
        }
        catch (DSException e) {
            return;
        }
        for (int i = 0; i < rModels.length; ++i) {
            ITransformToRelationRule[] rules = ((TransformRelationModel)rModels[i]).getTransformToRelation().getTransformRules();
            XmlTransformToRelationRule firstRule = (XmlTransformToRelationRule)rules[0];
            IXmlMappingRule[] mappingRules = firstRule.getXmlMappingRules();
            for (int j = 0; j < mappingRules.length; ++j) {
                if (mappingRules[j].getType() != 4) continue;
                String xPath = ((XmlMappingRule)mappingRules[j]).getXmlTransformSource().getAbsoluteXpath();
                try {
                    metadata.getTreeNodes(xPath);
                    continue;
                }
                catch (DSException e) {
                    // empty catch block
                }
            }
        }
    }

    public void connect() throws Exception {
    }

    public void disconnect() throws Exception {
    }

    @Override
    public Vector getFieldsOfTable(String qualifier, String owner, String tablname) throws SQLException {
        Vector<DbColDesc> columns = new Vector<DbColDesc>();
        JetUTransformRelationSchema schema = this.getTransformRelationSchema(owner);
        JetUTransformRelationModel model = schema.getJetUTransformRelationModel(tablname);
        for (JetUTransformDataField field : model.getJetUTransformDataFields()) {
            DbColDesc coldesc = this.createColDesc(field);
            columns.add(coldesc);
        }
        return columns;
    }

    private DbColDesc createColDesc(JetUTransformDataField field) {
        int sqltype = Types.typeToSQLType(field.getDataType());
        DbColDesc ret = new DbColDesc(field.getFldName(), sqltype, field.getPrecision(), field.getScale(), field.getNullable());
        ret.setCurrency(field.isCurrency());
        ret.setArray(ret.getSqlType() == 2003);
        if (ret.isArray()) {
            sqltype = Types.typeToSQLType(field.getBaseDataType());
            ret.setSqlType(sqltype);
        }
        ret.setIgnoreCase(false);
        ret.setEncode(false);
        return ret;
    }

    public boolean isConnecting() {
        return false;
    }

    @Override
    public boolean cnntToSameDB(JetUConnection cnnt) {
        if (cnnt != null || cnnt instanceof JetUXMLConnection) {
            JetUXMLConnection cn = (JetUXMLConnection)cnnt;
            String thisURI = this.getXMLMetadata().uriStr.get();
            String thatURI = cn.getXMLMetadata().uriStr.get();
            return thisURI.equalsIgnoreCase(thatURI);
        }
        return false;
    }

    public void setTransformRelationSchema(JetUTransformRelationSchema schema) {
        this.removeTransformRelationSchema();
        super.add(schema);
    }

    public JetUTransformRelationSchema getTransformRelationSchema() {
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject jetChild = (JetObject)this.children.elementAt(i);
            if (!(jetChild instanceof JetUTransformRelationSchema)) continue;
            return (JetUTransformRelationSchema)jetChild;
        }
        return null;
    }

    private JetUTransformRelationSchema getTransformRelationSchema(String schemaName) {
        JetUTransformRelationSchema schema = this.getTransformRelationSchema();
        if (schema == null) {
            return null;
        }
        if (schema.getResourceName().equals(schemaName)) {
            return schema;
        }
        return null;
    }

    public void removeTransformRelationSchema() {
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject jetChild = (JetObject)vecChildren.elementAt(i);
            if (!(jetChild instanceof JetUTransformRelationSchema)) continue;
            this.remove(jetChild);
        }
    }

    public String getSchemaName() {
        JetUTransformRelationSchema schema = this.getTransformRelationSchema();
        if (schema == null) {
            return null;
        }
        return schema.getResourceName();
    }

    public String[] getAllTableNames(String schemaName) throws JRException {
        JetUTransformRelationSchema schema = this.getTransformRelationSchema(schemaName);
        if (schema == null) {
            return new String[0];
        }
        JetUTransformRelationModel[] rms = schema.getJetUTransformRelationModels();
        String[] ret = new String[rms.length];
        int len = rms.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = rms[i].getResourceName();
        }
        return ret;
    }

    public void setXMLMetadata(MetadataContainerImpl xmlMetadata) {
        this.removeXMLMetadata();
        super.add(xmlMetadata);
    }

    public MetadataContainerImpl getXMLMetadata() {
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject jetChild = (JetObject)this.children.elementAt(i);
            if (!(jetChild instanceof MetadataContainerImpl)) continue;
            if (ReportEnv.productid == JRProductConstants.PRODUCTIDFORSERVER) {
                ((MetadataContainerImpl)jetChild).removeall();
            }
            return (MetadataContainerImpl)jetChild;
        }
        return null;
    }

    public void removeXMLMetadata() {
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject jetChild = (JetObject)vecChildren.elementAt(i);
            if (!(jetChild instanceof MetadataContainerImpl)) continue;
            this.remove(jetChild);
        }
    }

    @Override
    public TableInfo createTableInfo(String strQualifierName, String strOwnerName, String strTableName, int iType) throws SQLException {
        TableInfo tableInfo = new TableInfo(strQualifierName, strOwnerName, strTableName, iType);
        Vector fields = this.getFieldsOfTable(strQualifierName, strOwnerName, strTableName);
        tableInfo.setColumns(fields);
        return tableInfo;
    }

    @Override
    public JetUSupportInfo getSupportInfo() {
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUXMLSupportInfo)) continue;
            return (JetUXMLSupportInfo)child;
        }
        JetUXMLSupportInfo suppInfo = new JetUXMLSupportInfo();
        this.add(suppInfo);
        return suppInfo;
    }

    @Override
    public void fetchSupportInfo() throws SQLException, ClassNotFoundException {
        JetUSupportInfo suppInfo = this.getSupportInfo();
    }

    @Override
    public void updateSupportInfo() throws SQLException, ClassNotFoundException {
        this.fetchSupportInfo();
    }

    @Override
    public JetUTableView addTableView(String strResourceName, TableInfo table) {
        String candidateResourceName;
        String resourceName = candidateResourceName = strResourceName;
        int index = 1;
        while (!this.getDatabase().IsTableNameOK(resourceName, null)) {
            resourceName = candidateResourceName + String.valueOf(index);
            ++index;
        }
        return this.addTableView(resourceName, table, null);
    }

    @Override
    public Vector addTableViews(String strCatalogName, String schemaPattern, String tablePattern, int iType) throws ClassNotFoundException, SQLException, AddTableViewException {
        Vector<String> tableNames = new Vector<String>();
        if (iType == 2) {
            return tableNames;
        }
        StringBuffer bufError = new StringBuffer();
        JetUTransformRelationSchema schema = this.getTransformRelationSchema(schemaPattern);
        for (JetUTransformRelationModel model : schema.getJetUTransformRelationModels()) {
            String candidateResourceName;
            String resourceName = candidateResourceName = model.getResourceName();
            int index = 1;
            while (this.getDatabase().IsTableNameOK(resourceName, null)) {
                resourceName = candidateResourceName + String.valueOf(index);
                ++index;
            }
            TableInfo tableInfo = this.createTableInfo("", schema.getResourceName(), model.getResourceName(), iType);
            JetUTableView table = this.addTableView(resourceName, tableInfo);
            if (table == null) {
                bufError.append("Catalog Name:  \nSchema Name: " + schema.getResourceName() + "\n" + "Table Name: " + model.getResourceName());
            }
            tableNames.add(resourceName);
        }
        if (bufError.length() > 0) {
            throw new AddTableViewException(0, bufError.toString());
        }
        return tableNames;
    }

    @Override
    public Vector getTypeInfo() {
        JetUSupportInfo supportinfo = this.getSupportInfo();
        return supportinfo.getTypeInfo();
    }

    @Override
    protected boolean isSQLTypeCaseSensitive(int iSQLType) {
        JetUJDBCTypeInfo typeInfo = this.getTypeInfo(iSQLType);
        return typeInfo == null ? true : typeInfo.CaseSensitive.get();
    }

    public JetUPrejoin[] getAllPrejoin() throws JRException {
        JetUTransformRelationSchema jetuSchema = this.getTransformRelationSchema();
        if (jetuSchema == null) {
            return EmptyPrejoins;
        }
        TransformRelationSchema schema = jetuSchema.getTransformRelationSchema();
        TransformFieldJoin[] nativeJoins = schema.getJoin();
        ArrayList<JetUPrejoin> preJoins = new ArrayList<JetUPrejoin>(nativeJoins.length);
        Set usingTableNames = this.getUsingTableNames();
        for (TransformFieldJoin nativejoin : nativeJoins) {
            String fromTable = nativejoin.getFirstRelationModel().getName();
            String toTable = nativejoin.getSecondRelationModel().getName();
            if (!usingTableNames.contains(fromTable) || !usingTableNames.contains(toTable)) continue;
            JetUPrejoin prejoin = new JetUPrejoin();
            prejoin.tableFrom.set(fromTable);
            prejoin.columnFrom.set(nativejoin.getFirstDataField().getName());
            prejoin.tableTo.set(toTable);
            prejoin.columnTo.set(nativejoin.getSecondDataField().getName());
            prejoin.operator.set(nativejoin.getOperator());
            int joinType = 0;
            if (nativejoin.isInnerJoin()) {
                joinType = 0;
            } else if (nativejoin.isFullOuter()) {
                joinType = 2;
            } else if (nativejoin.isLeftOuter()) {
                joinType = 4;
            } else if (nativejoin.isRightOuter()) {
                joinType = 1;
            } else if (nativejoin.isUnionJoin()) {
                joinType = 8;
            }
            prejoin.outerJoin.set(joinType);
            preJoins.add(prejoin);
        }
        return preJoins.toArray(new JetUPrejoin[preJoins.size()]);
    }

    private Set getUsingTableNames() {
        Vector vecChildren = this.getChildren();
        HashSet<String> tableNames = new HashSet<String>(vecChildren.size());
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject jetChild = (JetObject)vecChildren.elementAt(i);
            if (!(jetChild instanceof JetUTableView)) continue;
            tableNames.add(((JetUTableView)jetChild).getResourceName());
        }
        return tableNames;
    }

    @Override
    public String getInstancePrefix() {
        return "XMLConnection";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    public String getStartPoint() {
        JRelationModel[] rms = null;
        try {
            rms = this.getTransformRelationSchema().getTransformRelationSchema().getRelationModels();
        }
        catch (DSException e) {
        }
        catch (JRException e) {
            // empty catch block
        }
        if (rms != null && rms.length > 0) {
            XmlTransformToRelationRule rule = (XmlTransformToRelationRule)((TransformRelationModel)rms[0]).getTransformToRelation().getTransformRules()[0];
            return rule.getXmlTransformSource().getXpath();
        }
        return null;
    }

    static {
        nameIdx.put("Name", new Integer(0));
        nameIdx.put("TimestampFormat", new Integer(1));
        nameIdx.put("EncodingPattern", new Integer(2));
        nameIdx.put("Description", new Integer(3));
        nameIdx.put("TimeFormat", new Integer(4));
        nameIdx.put("QualifiedNamePattern", new Integer(5));
        nameIdx.put("DateFormat", new Integer(6));
        nameIdx.put("IsDefaultConnection", new Integer(7));
        grpDesc = new HashVector(1);
        String grpName = "anonymous";
        Vector<String> grpItems = new Vector<String>(9);
        grpItems.add("Name");
        grpItems.add("TimestampFormat");
        grpItems.add("Description");
        grpItems.add("TimeFormat");
        grpItems.add("QualifiedNamePattern");
        grpItems.add("DateFormat");
        grpItems.add("IsDefaultConnection");
        grpDesc.put(grpName, grpItems);
    }
}

