/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.ResourceStore;
import java.io.File;
import java.util.List;
import java.util.Vector;
import jet.Env;
import jet.controls.JetObject;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.lc.LCObject;
import jet.lc.io.LCObjectIO;
import jet.report.JetRptObject;
import jet.report.JetRptReportPanel;
import jet.reportLogic.objectLogic.DataSetLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.DataSet;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUUniverse;
import jet.universe.RefResourceException;
import jet.upgrade.JUpgradeException;
import jet.upgrade.UpgradeUtil;

public class RefReport
extends JetObject {
    private String fileName;
    private String path;
    private ResourceStore resourceStore;
    private JetObject rootObj = null;

    public RefReport(ResourceStore resourceStore, String strPath, String strFileName) {
        this.resourceStore = resourceStore;
        this.path = strPath;
        this.fileName = strFileName;
    }

    public RefReport(String strPath, String strFileName) {
        this(null, strPath, strFileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullName() {
        return this.path + this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.fileName;
    }

    protected static JetObject loadObject(String fillFileName, JetUUniverse uni, ResourceStore resourceStore) throws ReadFailureException, ResourceNotFoundException, ResourceLoadException, JUpgradeException, ClassCastException, UnsupportedOperationException {
        int type = Env.getFileType(fillFileName);
        if (type == 6 || type == 9 || type == 10) {
            JetObject object = null;
            object = resourceStore == null ? new LoaderNoCache(fillFileName).load() : resourceStore.getMemoryStore().loadReport(new File(fillFileName), null, null);
            if (!(object instanceof JetRptReportSet) && !(object instanceof JetRptReportPanel)) {
                throw new ClassCastException(object.getClass().getName());
            }
            object = UpgradeUtil.upgradeRpt((JetRptObject)object, uni, type);
            return object;
        }
        if (type == 8) {
            return (JetObject)((Object)LCObjectIO.loadLCObject(new File(fillFileName), uni, resourceStore));
        }
        throw new UnsupportedOperationException(fillFileName + "is not supportted");
    }

    public JetObject loadReport(JetUUniverse uni) throws RefResourceException {
        if (this.rootObj == null) {
            String name2 = uni.getFilePath() + this.fileName;
            try {
                this.rootObj = RefReport.loadObject(name2, uni, this.resourceStore);
            }
            catch (ReadFailureException e) {
                throw new RefResourceException("Load failed: " + name2, e);
            }
            catch (ResourceNotFoundException e) {
                throw new RefResourceException("Load failed: " + name2, e);
            }
            catch (ResourceLoadException e) {
                throw new RefResourceException("Load failed: " + name2, e);
            }
            catch (JUpgradeException e) {
                throw new RefResourceException("Load failed: " + name2 + " can't be upgrade!", e);
            }
            catch (ClassCastException e) {
                throw new RefResourceException("Load failed: " + name2 + " is error formated", e);
            }
            catch (UnsupportedOperationException e) {
                throw new RefResourceException("Load failed: " + e.getMessage());
            }
        }
        return this.rootObj;
    }

    public void setObject(JetObject object) {
        if (object instanceof LCObject || object instanceof JetRptReportSet) {
            this.rootObj = object;
        }
    }

    public JetObject getObject() {
        return this.rootObj;
    }

    public List<DataSet> getUsedAllDataSets() {
        Vector<DataSet> retList;
        block4: {
            block3: {
                retList = new Vector<DataSet>();
                if (!(this.rootObj instanceof JetRptReportSet)) break block3;
                JetRptReportSet reportSet = (JetRptReportSet)this.rootObj;
                DataSetLogic datasetLogic = ObjectLogicFactory.getDataSetLogic();
                String[] rptNames = reportSet.getAllReportsName();
                for (int i = 0; i < rptNames.length; ++i) {
                    List datasets = reportSet.getReport(rptNames[i]).getUsedDataSet();
                    for (DataSet ds : datasets) {
                        retList.add(ds);
                    }
                }
                break block4;
            }
            if (!(this.rootObj instanceof LCObject)) break block4;
            Vector children = ((LCObject)((Object)this.rootObj)).getContent().getDataSource().getChildren();
            DataSetLogic datasetLogic = ObjectLogicFactory.getDataSetLogic();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                Object o = children.get(i);
                if (!(o instanceof DataSet)) continue;
                retList.add((DataSet)o);
            }
        }
        return retList;
    }

    protected static void save(JetObject rootObj, String fileName, JetUUniverse uni, String rootName, ResourceStore resourceStore) throws UnsupportedOperationException, WriteFailureException {
        if (rootObj == null) {
            throw new UnsupportedOperationException("object is null, can not save: " + fileName);
        }
        if (rootObj instanceof JetRptReportSet) {
            ((JetRptReportSet)rootObj).beforeSave(uni, resourceStore);
            if (resourceStore == null) {
                LoaderNoCache.save(null, (JetRptReportSet)rootObj, rootName, fileName);
            } else {
                LoaderNoCache.save(resourceStore.getDiskStore(), (JetRptReportSet)rootObj, rootName, fileName);
            }
        } else if (rootObj instanceof LCObject) {
            LCObjectIO.saveLCObject((LCObject)((Object)rootObj), uni, new File(fileName), resourceStore);
        } else {
            throw new UnsupportedOperationException("This Object is not supported: " + rootObj.getClass());
        }
    }
}

