/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetReference;
import jet.controls.QueryInfoImpl;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedMultiExpression;
import jet.dataengine.util.StringTools;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.log.JRLogger;
import jet.report.JetRptDataSource;
import jet.report.JetRptParamLink;
import jet.report.JetRptQueryComponent;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSubLink;
import jet.report.JetRptSubLinkContainer;
import jet.report.JetRptSubReport;
import jet.report.JetRptSubReturnValue;
import jet.report.JetRptSubReturnValueContainer;
import jet.report.conditionallink.JetRptConditionalLinkItem;
import jet.report.link.ConditionalLinkValue;
import jet.report.link.Linkable;
import jet.report.link.MasterDetailLinkValue;
import jet.report.link.NormalLinkValue;
import jet.report.link.SimpleLinkValue;
import jet.report.link.ToReportValue;
import jet.report.mode.JetRptMode;
import jet.report.mode.actions.cusAct.JetRptCusBatchSetParameterActionParam;
import jet.report.mode.common.RptAction;
import jet.report.mode.common.RptAtomicAction;
import jet.report.mode.common.RptEventToActionItem;
import jet.report.mode.common.RptRenderer;
import jet.report.mode.common.argExpression.AtomicParamArgExp;
import jet.report.mode.common.argExpression.AtomicParamColArgExp;
import jet.report.mode.common.cusAction.CustomAtomicAction;
import jet.reportLogic.objectInfo.ObjectResourceInfo;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.DataSet;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHDSField;
import jet.universe.JetUHDSTable;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetURefQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUTable;
import jet.universe.JetUTableView;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.RefReport;
import jet.universe.RefResourceException;
import jet.universe.RenameTool;
import jet.universe.Replacement;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DTInformation;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.GroupInfo;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.impl.Aggregation;
import jet.universe.businesslogic.impl.BCFilter;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.BusinessView;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.Detail;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.Group;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.businesslogic.impl.Prefilter;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.businesslogic.impl.UpgradedUnifiedBusinessView;
import jet.util.ReferObject;
import jet.util.ReferRelationConstants;
import jet.util.TreeIterater;
import toolkit.db.DbTools;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.PsqlUnion;

public final class ReferTool
extends ReferRelationConstants {
    private static final Hashtable typeTable = new Hashtable();
    public static final String[] supportReportType = new String[]{".cls", ".rpt", ".cls.xml", ".wls", ".lc", ".va"};
    private static ReferTool instance;
    private static JRLogger logger;
    public static final String DB_FILE_SUFFIX = "_ref.script";

    private ReferTool() {
    }

    public static ReferTool getInstance() {
        return instance;
    }

    public boolean isJetUQueriable(ReferObject refObj) {
        int type = refObj.getType();
        return type == 4 || type == 6 || type == 3 || type == 7 || type == 5;
    }

    public boolean isTableOrView(ReferObject refObj) {
        int type = refObj.getType();
        return type == 1 || type == 2;
    }

    public boolean isReport(ReferObject refObj) {
        int type = refObj.getType();
        return type == 11;
    }

    public Integer getType(JetObject obj) throws RefResourceException {
        if (obj instanceof JetUTableView) {
            JetUTableView tableView = (JetUTableView)obj;
            int type = tableView.getTableType();
            if (type == 1) {
                return new Integer(1);
            }
            if (type == 2) {
                return new Integer(2);
            }
            throw new RefResourceException("UNKNOWN TABLEVIEW TYPE");
        }
        Class<?> referredByClass = obj.getClass();
        return this.getType(referredByClass);
    }

    public Integer getType(Class cls) throws RefResourceException {
        if (!typeTable.containsKey(cls)) {
            throw new RefResourceException("Not Found Defined Class: " + cls);
        }
        Integer correspondType = (Integer)typeTable.get(cls);
        return correspondType;
    }

    private Vector getReferringObject(JetUDBTreeNode uDBTreeNode) throws RefResourceException {
        if (uDBTreeNode instanceof JetUUserDataSource) {
            return this.getReferringObj((JetUUserDataSource)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUHierDataSource) {
            return this.getReferringObj((JetUHierDataSource)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUQuery) {
            return this.getReferringObj((JetUQuery)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUSummary) {
            return this.getReferringObjOfSum((JetUSummary)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUParameter) {
            return this.getReferringObj((JetUParameter)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUFormula) {
            return this.getReferringObj((JetUFormula)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUTable) {
            return this.getReferringObj((JetUTable)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUTableView) {
            return this.getReferringObj((JetUTableView)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUFileQuery) {
            return this.getReferringObj((JetUFileQuery)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUHDSTable) {
            return this.getReferringObj((JetUHDSTable)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUProcedure) {
            return this.getReferringObj((JetUProcedure)uDBTreeNode);
        }
        if (uDBTreeNode instanceof JetUDatabase) {
            Vector<JetUDatabase> db = new Vector<JetUDatabase>();
            db.addElement((JetUDatabase)uDBTreeNode);
            return db;
        }
        throw new RefResourceException("!!!WARNING: Unknown JetUDBTreeNode!: " + uDBTreeNode);
    }

    public Vector getReferringObj(JetObject obj, JetUUniverse uni, JetRptReportSet report) throws RefResourceException {
        if (obj instanceof RefReport) {
            return this.getRptReferringObj(uni, (RefReport)obj);
        }
        if (obj instanceof JetUDBTreeNode) {
            return this.getReferringObject((JetUDBTreeNode)obj);
        }
        if (obj instanceof IDataContainer) {
            return this.getReferringObjectFromDataContainer(uni, (IDataContainer)((Object)obj));
        }
        if (obj instanceof BLNodeImpl) {
            return this.getReferringObject(uni, (BLNodeImpl)obj);
        }
        throw new RefResourceException("!!!WARNING: Unknown JetObject!: " + obj);
    }

    private Vector getReferringObject(JetUUniverse uni, BLNodeImpl node) {
        Vector ret = new Vector();
        if (node instanceof DataElement) {
            String mappingName = ((DataElement)node).getRefMappingName();
            JetUDBTreeNode jo = node.getUbv().getQuery();
            String databaseName = null;
            if (jo instanceof JetUQueriable) {
                JetUQueriable queriable = jo;
                databaseName = queriable.getDatabase().name.get();
            }
            if ((jo = uni.getResourceByName(databaseName, null, mappingName)) != null) {
                ret.add(jo);
            }
        } else {
            if (node instanceof BusinessLogic) {
                JetUDatabase db;
                BusinessLogic bl = (BusinessLogic)node;
                String databaseName = null;
                JetUQueriable queriable = null;
                JetObject jetObj = bl.getQuery();
                if (jetObj instanceof JetUQueriable) {
                    queriable = (JetUQueriable)((Object)jetObj);
                    databaseName = queriable.getDatabase().getResourceName();
                }
                if ((db = uni.getDatabase(databaseName)) != null) {
                    jetObj = db.GetQueryByResourceName(queriable.getResourceName());
                    Vector ref = new Vector();
                    if (jetObj != null && jetObj instanceof JetUQuery) {
                        JetUQuery query = (JetUQuery)jetObj;
                        ref = this.getReferringObj(query);
                    }
                    if (ref.size() != 0) {
                        ret.addAll(ref);
                    }
                }
                return ret;
            }
            if (node instanceof Category) {
                Category category = (Category)node;
            } else if (node instanceof FilterInfo) {
                FilterInfo filter = (FilterInfo)((Object)node);
                ret = filter.getReferredResourceEntities();
                ret.addAll(filter.getReferredDataElements());
            }
        }
        return ret;
    }

    private void fillSubReferringObject(JetUUniverse universe, JetObject rootObj, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject(ROOT), START");
        }
        String path = this.getReportLevelResourcePath(rootObj, universe, false);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject(ROOT), ReportLevel resource path =" + path);
        }
        TreeIterater iter = new TreeIterater(rootObj, false, true);
        JetObject o = null;
        while ((o = (JetObject)iter.next()) != null) {
            SimpleLinkValue xLink;
            if (o instanceof JetRptSubReport) {
                this.fillSub_SubReport((JetRptSubReport)o, universe, path, rstMap);
                iter.skipBranch();
                continue;
            }
            if (o instanceof Linkable) {
                xLink = ((Linkable)((Object)o)).getSimpleLinkValue();
                if (xLink != null) {
                    this.fillSub_NormalLink(xLink.getNormalLinkValue(), universe, path, rstMap);
                    this.fillSub_MasterDetailLink(xLink.getMasterDetailLinkValue(), universe, path, rstMap);
                }
                iter.skipBranch();
                continue;
            }
            if (o instanceof JetRptConditionalLinkItem) {
                xLink = ((JetRptConditionalLinkItem)o).getLinkValue();
                if (xLink != null) {
                    this.fillSub_NormalLink(xLink.getNormalLinkValue(), universe, path, rstMap);
                }
                iter.skipBranch();
                continue;
            }
            if (!(o instanceof CustomAtomicAction)) continue;
            this.fillSub_ActionApplyToReport((CustomAtomicAction)((Object)o), universe, path, rstMap);
            iter.skipBranch();
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject(ROOT), END");
        }
    }

    private void fillSubReferringObject(JetUUniverse universe, IDataContainer idc, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject(IDC), START");
        }
        String path = this.getReportLevelResourcePath((JetObject)((Object)idc), universe, true);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject(IDC), ReportLevel resource path =" + path);
        }
        TreeIterater iter = new TreeIterater((JetObject)((Object)idc), false, true);
        JetObject o = null;
        HashSet<Object> loopedObj = new HashSet<Object>();
        while ((o = (JetObject)iter.next()) != null) {
            if (o instanceof JetRptSubReport) {
                this.fillSub_SubReport((JetRptSubReport)o, universe, path, rstMap);
                iter.skipBranch();
                continue;
            }
            if (o instanceof Linkable) {
                ConditionalLinkValue cLink;
                SimpleLinkValue xLink = ((Linkable)((Object)o)).getSimpleLinkValue();
                if (xLink != null) {
                    this.fillSub_NormalLink(xLink.getNormalLinkValue(), universe, path, rstMap);
                    this.fillSub_MasterDetailLink(xLink.getMasterDetailLinkValue(), universe, path, rstMap);
                }
                if ((cLink = ((Linkable)((Object)o)).getConditionalLinkValue()) != null) {
                    List items = cLink.getAllConditionalLinkItems();
                    for (ConditionalLinkValue.CLinkItem item : items) {
                        xLink = item.getSimpleLinkValue();
                        this.fillSub_NormalLink(xLink.getNormalLinkValue(), universe, path, rstMap);
                        this.fillSub_MasterDetailLink(xLink.getMasterDetailLinkValue(), universe, path, rstMap);
                    }
                    xLink = cLink.getDefaultLinkValue();
                    if (xLink != null) {
                        this.fillSub_NormalLink(xLink.getNormalLinkValue(), universe, path, rstMap);
                        this.fillSub_MasterDetailLink(xLink.getMasterDetailLinkValue(), universe, path, rstMap);
                    }
                }
                iter.skipBranch();
            }
            for (JetProperty p : o.getProperties().values()) {
                JetObject dest;
                if (!(p instanceof JetReference) || (dest = (JetObject)((JetReference)p).getObject()) == null || !(dest instanceof JetRptMode) || loopedObj.contains(dest)) continue;
                loopedObj.add(dest);
                this.fillSub_AllInMode((JetRptMode)dest, loopedObj, universe, path, rstMap);
            }
        }
        loopedObj.clear();
        loopedObj = null;
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject(IDC), END");
        }
    }

    private String getReportLevelResourcePath(JetObject obj, JetUUniverse unv, boolean checkRoot) {
        String path;
        if (obj instanceof JetRptReportSet) {
            path = ((JetRptReportSet)obj).getDefaultReportLevelResourcesPath();
            if (path == null || path.trim().isEmpty()) {
                path = unv != null ? unv.getFilePath() : null;
            }
        } else if (checkRoot) {
            JetObject rootObj = JetObject.getRoot(obj);
            path = rootObj != obj ? this.getReportLevelResourcePath(rootObj, unv, false) : (unv != null ? unv.getFilePath() : null);
        } else {
            String string = path = unv != null ? unv.getFilePath() : null;
        }
        if (path == null) {
            path = "";
        }
        return path;
    }

    private JetObject loadJetObjectFromFile(File theFile) {
        if (theFile == null || !theFile.exists()) {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "ReferTool#fillSubReferringObject,Sub or linked or applied file \"" + theFile + "\" failed to loaded, because file doest not found.");
            }
            return null;
        }
        try {
            return new LoaderNoCache(theFile.getAbsolutePath()).load();
        }
        catch (Throwable e) {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "ReferTool#fillSubReferringObject,Sub or linked or applied file \"" + theFile + "\" failed to loaded, because " + e.getMessage());
            }
            return null;
        }
    }

    private QueryInfo searchAndConvertDataSourceToQueryInfo(JetObject v7Object, List<?> searchObjs) {
        JetRptDataSource ds;
        QueryInfoImpl qInfo = null;
        if (searchObjs != null) {
            for (Object inst : searchObjs) {
                JetObject jObj = v7Object.nameToObject((String)inst);
                if (!(jObj instanceof JetRptQueryComponent) || (ds = ((JetRptQueryComponent)jObj).getDataSource(true)) == null) continue;
                qInfo = new QueryInfoImpl("", ds.getDataSourceName(), ds.getQueryName());
                break;
            }
        }
        if (qInfo == null) {
            Vector children = v7Object.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Object child = children.elementAt(i);
                if (!(child instanceof JetRptDataSource)) continue;
                ds = (JetRptDataSource)child;
                qInfo = new QueryInfoImpl("", ds.getDataSourceName(), ds.getQueryName());
                break;
            }
        }
        return qInfo;
    }

    private void fillSub_SubReport(JetRptSubReport subRptNode, JetUUniverse unv, String path, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject-SUBREPORT.START");
        }
        String fName = subRptNode.reportSet.get();
        String rName = subRptNode.report.get();
        File subFile = fName.isEmpty() ? new File(path, rName) : new File(path, fName);
        JetObject subRootObj = this.loadJetObjectFromFile(subFile);
        if (subRootObj != null) {
            if (subRootObj.getClass().getName().equals(JetRptReportPanel.class.getName())) {
                ObjectResourceInfo rInfo = null;
                QueryInfo qInfo = this.searchAndConvertDataSourceToQueryInfo(subRootObj, null);
                Vector children = subRptNode.getChildren();
                for (Object o : children) {
                    if (o instanceof JetRptParamLink) {
                        this._fill_IfParameter(((JetRptParamLink)o).getSubColumn(), unv, rstMap);
                        continue;
                    }
                    if (o instanceof JetRptSubReturnValue) {
                        this._fill_IfParameter(((JetRptSubReturnValue)o).getSubColumn(), unv, rstMap);
                        continue;
                    }
                    if (!(o instanceof JetRptSubLink)) continue;
                    if (rInfo == null) {
                        if (qInfo == null) continue;
                        rInfo = new ObjectResourceInfo();
                        rstMap.put(qInfo, rInfo);
                    }
                    rInfo.addMappingName(((JetRptSubLink)o).getSubColumn());
                }
            } else {
                Vector children = subRptNode.getChildren();
                for (Object o : children) {
                    if (o instanceof JetRptParamLink) {
                        this._fill_IfParameter(((JetRptParamLink)o).getSubColumn(), unv, rstMap);
                        continue;
                    }
                    if (o instanceof JetRptSubLinkContainer) {
                        this._fill((JetRptSubLinkContainer)o, unv, subRootObj, rstMap);
                        continue;
                    }
                    if (!(o instanceof JetRptSubReturnValueContainer)) continue;
                    this._fill((JetRptSubReturnValueContainer)o, unv, subRootObj, rstMap);
                }
            }
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject-SUBREPORT.END");
        }
    }

    private void _fill(JetRptSubLinkContainer sc, JetUUniverse unv, JetObject subRootObj, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        List sublinks = sc.getSubLinks();
        if (sublinks == null || sublinks.isEmpty()) {
            return;
        }
        QueryInfo qInfo = null;
        if (subRootObj.getClass().getName().equals(JetRptReportPanel.class.getName())) {
            qInfo = this.searchAndConvertDataSourceToQueryInfo(subRootObj, sc.targetCompInst.get());
        } else {
            Vector insts = sc.targetCompInst.get();
            for (Object inst : insts) {
                DataSet ds;
                JetObject jObj = subRootObj.nameToObject((String)inst);
                if (!(jObj instanceof IDataContainer) || (ds = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet((IDataContainer)((Object)jObj))) == null) continue;
                qInfo = ds.getQueryInfo();
                break;
            }
        }
        if (qInfo == null) {
            return;
        }
        ObjectResourceInfo rInfo = rstMap.get(qInfo);
        if (rInfo == null) {
            rInfo = new ObjectResourceInfo();
            rstMap.put(qInfo, rInfo);
        }
        for (JetRptSubLink l : sublinks) {
            rInfo.addMappingName(l.getSubColumn());
            rInfo.addBLColumnName(l.blSubColumn.get());
        }
    }

    private void _fill(JetRptSubReturnValueContainer svc, JetUUniverse unv, JetObject subRootObj, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        List slist = svc.getReturnVlaues();
        for (JetRptSubReturnValue s : slist) {
            String pName = s.getSubColumn();
            JetUResourceEntity o = unv.getAnyResourceByName(pName);
            if (!(o instanceof JetUParameter)) continue;
            JetUParameter p = (JetUParameter)o;
            String dsName = p.getDatabase().getResourceName();
            QueryInfoImpl qInfo = new QueryInfoImpl("", dsName, "", "", 3);
            ObjectResourceInfo rInfo = rstMap.get(qInfo);
            if (rInfo == null) {
                rInfo = new ObjectResourceInfo();
                rstMap.put(qInfo, rInfo);
            }
            rInfo.addMappingName(pName);
        }
    }

    private void fillSub_NormalLink(NormalLinkValue nLink, JetUUniverse unv, String path, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        if (nLink == null) {
            return;
        }
        if (nLink.getNormalLinkType() == 0 || nLink.getNormalLinkType() == 2) {
            ToReportValue toRpt;
            File subFile;
            JetObject subRootObj;
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "ReferTool#fillSubReferringObject-LINKREPORT.START");
            }
            if ((subRootObj = this.loadJetObjectFromFile(subFile = new File(path, (toRpt = (ToReportValue)nLink).getReportFileName()))) != null) {
                List paramLinks;
                List conditions = toRpt.getTargetConditions();
                if (conditions != null && conditions.size() > 0) {
                    for (JetRptSubLinkContainer sc : conditions) {
                        this._fill(sc, unv, subRootObj, rstMap);
                    }
                }
                if ((paramLinks = toRpt.getParameterLinks()) != null && paramLinks.size() > 0) {
                    for (Object obj : paramLinks) {
                        if (!(obj instanceof JetRptParamLink)) continue;
                        this._fill_IfParameter(((JetRptParamLink)obj).getSubColumn(), unv, rstMap);
                    }
                }
            }
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "ReferTool#fillSubReferringObject-LINKREPORT.END");
            }
        }
    }

    private void fillSub_MasterDetailLink(MasterDetailLinkValue nLink, JetUUniverse unv, String path, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        List params;
        List insts;
        if (nLink == null) {
            return;
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject-MDReport.START");
        }
        File subFile = new File(path, nLink.getReportFileName());
        JetObject subRootObj = this.loadJetObjectFromFile(subFile);
        QueryInfo qInfo = null;
        if (subRootObj.getClass().getName().equals(JetRptReportPanel.class.getName())) {
            insts = nLink.getTargetCompInstNames();
            qInfo = this.searchAndConvertDataSourceToQueryInfo(subRootObj, insts);
        } else {
            insts = nLink.getTargetCompInstNames();
            for (Object inst : insts) {
                DataSet ds;
                JetObject jObj = subRootObj.nameToObject((String)inst);
                if (!(jObj instanceof IDataContainer) || (ds = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet((IDataContainer)((Object)jObj))) == null) continue;
                qInfo = ds.getQueryInfo();
                break;
            }
        }
        MasterDetailLinkValue.Join j = nLink.getJoin();
        if (qInfo != null && j != null) {
            ObjectResourceInfo rInfo = rstMap.get(qInfo);
            if (rInfo == null) {
                rInfo = new ObjectResourceInfo();
                rstMap.put(qInfo, rInfo);
            }
            rInfo.addMappingName(j.getColumnInDetail());
        }
        List conditions = nLink.getConditions();
        if (qInfo != null && conditions != null && conditions.size() > 0) {
            ObjectResourceInfo rInfo = rstMap.get(qInfo);
            if (rInfo == null) {
                rInfo = new ObjectResourceInfo();
                rstMap.put(qInfo, rInfo);
            }
            for (MasterDetailLinkValue.Condition sc : conditions) {
                rInfo.addMappingName(sc.getColumnInDetail());
            }
        }
        if ((params = nLink.getParameters()) != null && params.size() > 0) {
            if (qInfo == null) {
                for (MasterDetailLinkValue.Parameter obj : params) {
                    this._fill_IfParameter(obj.getParamInDetail(), unv, rstMap);
                }
            } else {
                ObjectResourceInfo rInfo = rstMap.get(qInfo);
                if (rInfo == null) {
                    rInfo = new ObjectResourceInfo();
                    rstMap.put(qInfo, rInfo);
                }
                for (MasterDetailLinkValue.Parameter obj : params) {
                    rInfo.addMappingName(obj.getParamInDetail());
                }
            }
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#fillSubReferringObject-MDReport.END");
        }
    }

    private void fillSub_ActionApplyToReport(CustomAtomicAction actObj, JetUUniverse unv, String path, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        if (actObj.getCustomizeActionType() == 3 && actObj.getApplyToType() == 0) {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "ReferTool#fillSubReferringObject-BatchSetParamToReport.START");
            }
            AtomicParamArgExp exp = actObj.getApplyTo();
            List params = actObj.getAtomicParams();
            int size = params != null ? params.size() : 0;
            for (int i = 0; i < size; ++i) {
                JetRptCusBatchSetParameterActionParam param = (JetRptCusBatchSetParameterActionParam)params.get(i);
                exp = param.getParameterName();
                if (exp.getArgumentExpType() != 65541) continue;
                String pName = (String)((AtomicParamColArgExp)exp).getValue();
                this._fill_IfParameter(pName, unv, rstMap);
            }
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "ReferTool#fillSubReferringObject-BatchSetParamToReport.END");
            }
        }
    }

    private void _fill_IfParameter(String pName, JetUUniverse unv, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        JetUResourceEntity o = unv.getAnyResourceByName(pName);
        if (o instanceof JetUParameter) {
            JetUParameter p = (JetUParameter)o;
            String dsName = p.getDatabase().getResourceName();
            QueryInfoImpl qInfo = new QueryInfoImpl("", dsName, "", "", 3);
            ObjectResourceInfo rInfo = rstMap.get(qInfo);
            if (rInfo == null) {
                rInfo = new ObjectResourceInfo();
                rstMap.put(qInfo, rInfo);
            }
            rInfo.addMappingName(pName);
        }
    }

    private void fillSub_AllInMode(JetRptMode mode, Set<Object> loopedObj, JetUUniverse unv, String path, Map<QueryInfo, ObjectResourceInfo> rstMap) {
        Vector renders = mode.getChildren();
        if (renders.isEmpty()) {
            return;
        }
        for (JetObject o : renders) {
            RptRenderer render = (RptRenderer)((Object)o);
            Vector eaItems = render.getSupportEvents();
            int size = eaItems == null ? 0 : eaItems.size();
            for (int i = 0; i < size; ++i) {
                RptEventToActionItem item = (RptEventToActionItem)eaItems.get(i);
                RptAction act = item.getRefAction();
                if (act == null || loopedObj.contains(act)) continue;
                loopedObj.add(act);
                RptAtomicAction[] atomics = act.expandAndGetAllAtomicAction();
                if (atomics == null || atomics.length == 0) continue;
                for (RptAtomicAction atomic : atomics) {
                    if (loopedObj.contains(atomic)) continue;
                    loopedObj.add(atomic);
                    if (atomic.getAtomicType() != 4) continue;
                    this.fillSub_ActionApplyToReport((CustomAtomicAction)atomic, unv, path, rstMap);
                }
            }
        }
    }

    private Vector getReferringObjectFromDataContainer(JetUUniverse universe, IDataContainer obj) {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#getReferringObjectFromDataContainer, universe=" + universe + ",IDC =" + obj + ". START");
        }
        Map map = ObjectLogicFactory.getReportSetLogic().getUsedQueryResouces(universe, (JetObject)((Object)obj), false);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#getReferringObjectFromDataContainer, universe=" + universe + ",IDC =" + obj + ". 1/3");
        }
        this.fillSubReferringObject(universe, obj, (Map<QueryInfo, ObjectResourceInfo>)map);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#getReferringObjectFromDataContainer, universe=" + universe + ",IDC =" + obj + ". 2/3");
        }
        Vector result = new Vector();
        this.fillReferringObjectFromResMap(universe, map, result);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#getReferringObjectFromDataContainer, universe=" + universe + ",IDC =" + obj + ". 3/3(END)");
        }
        return result;
    }

    private void fillReferringObjectFromResMap(JetUUniverse unv, Map<QueryInfo, ObjectResourceInfo> map, Vector results) {
        Iterator<Map.Entry<QueryInfo, ObjectResourceInfo>> eIt = map.entrySet().iterator();
        StringBuilder msgSb = null;
        if (JRLog.isTrace(7)) {
            msgSb = new StringBuilder();
        }
        while (eIt.hasNext()) {
            Map.Entry<QueryInfo, ObjectResourceInfo> e = eIt.next();
            QueryInfo qInfo = e.getKey();
            ObjectResourceInfo info = e.getValue();
            List names = info.getBlColumnName();
            JetUDatabase database = unv.getDatabase(qInfo.getDatasourceName());
            if (database != null) {
                UnifiedBusinessView bv = database.getBusinessView(qInfo.getBLName());
                for (String qdn : names) {
                    BLNode node = null;
                    if (bv != null) {
                        node = bv.getByDisplayName(qdn);
                    }
                    if (node == null) {
                        node = database.getCustomMeasure(qdn);
                    }
                    if (node == null) continue;
                    results.add(node);
                    if (msgSb == null) continue;
                    msgSb.append("{").append(qdn).append("}");
                }
                if (bv != null) {
                    results.add(bv);
                }
                names = info.getMappingName();
                Vector refEntities = this.getRefEntitiesByNames(database, names);
                if (msgSb != null) {
                    msgSb.append("{").append(names).append("}");
                }
                results.addAll(refEntities);
                Vector refTables = this.getReferringTableInJetUField(refEntities);
                results.addAll(refTables);
                JetUQueriable q = database.getQueriableByResourceName(qInfo.getQueryName());
                if (q != null) {
                    results.add(q);
                }
            } else {
                names = info.getMappingName();
                for (String name2 : names) {
                    JetUResourceEntity entity = unv.getAnyResourceByName(name2);
                    if (entity == null) continue;
                    results.add(entity);
                    if (msgSb == null) continue;
                    msgSb.append("{").append(names).append("}");
                }
            }
            if (msgSb == null) continue;
            JRLog.trace(7, "ReferringObject.ITEM(" + qInfo + ")->(" + msgSb + ")");
            msgSb.setLength(0);
        }
    }

    private Vector getRptReferringObj(JetUUniverse universe, RefReport refRpt) {
        JetObject rootObj = refRpt.getObject();
        String fileName = refRpt.getFileName();
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#getReferringObjectFromObjectInReport, universe=" + universe + ",ROOT =" + rootObj + ",File=" + fileName + ". START");
        }
        Map map = ObjectLogicFactory.getReportSetLogic().getUsedQueryResouces(universe, rootObj, false);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#getReferringObjectFromObjectInReport, universe=" + universe + ",ROOT =" + rootObj + ",File=" + fileName + ". 1/3");
        }
        this.fillSubReferringObject(universe, rootObj, (Map<QueryInfo, ObjectResourceInfo>)map);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#getReferringObjectFromObjectInReport, universe=" + universe + ",ROOT =" + rootObj + ",File=" + fileName + ". 2/3");
        }
        Vector result = new Vector();
        this.fillReferringObjectFromResMap(universe, map, result);
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "ReferTool#getReferringObjectFromObjectInReport, universe=" + universe + ",ROOT =" + rootObj + ",File=" + fileName + ". 3/3(END)");
        }
        return result;
    }

    private Vector getReferringObj(JetUProcedure procedure) {
        Vector<JetObject> result = new Vector<JetObject>();
        Vector<String> paraNames = new Vector<String>();
        Enumeration children = procedure.getChildrenEnumeration();
        while (children.hasMoreElements()) {
            JetObject child = (JetObject)children.nextElement();
            if (child instanceof JetUProcField) {
                result.add(child);
                continue;
            }
            if (child instanceof JetUProcParameter) {
                JetUProcParameter uProcPara = (JetUProcParameter)child;
                paraNames.add(uProcPara.name.get());
                continue;
            }
            if (!logger.isErrorEnabled()) continue;
            logger.error("UNKNOWN TYPE IN JetUProcedure: " + procedure);
        }
        Vector paras = this.getRefEntitiesByNames(procedure.getDatabase(), paraNames);
        result.addAll(paras);
        return result;
    }

    private Vector getReferringObjOfSum(JetUSummary uSummary) {
        Vector refDbFld = uSummary.getRefDbFld();
        Vector refFormuFld = uSummary.getRefFormuFld();
        Vector refParamFld = uSummary.getRefParamFld();
        Vector result = new Vector();
        result.addAll(refDbFld);
        result.addAll(refFormuFld);
        result.addAll(refParamFld);
        result = this.getRefEntitiesByNames(uSummary.getDatabase(), result);
        return result;
    }

    private Vector getReferringObj(JetUFileQuery uFileQuery) {
        Vector result = new Vector();
        result.addAll(uFileQuery.getFields());
        String sql = uFileQuery.getSQLString();
        JetUDatabase udb = uFileQuery.getDatabase();
        Vector paraNames = DbTools.getMappingNamesInRawSql(sql);
        Vector uParameters = this.getRefEntitiesByNames(udb, paraNames);
        result.addAll(uParameters);
        return result;
    }

    private Vector getReferringObj(JetUParameter uPara) {
        ParamDesc paramDesc = uPara.getParamDesc();
        String bindingCol = paramDesc.getColumn();
        Vector displayCol = paramDesc.getColumns();
        Vector result = (Vector)displayCol.clone();
        if (bindingCol != null && !bindingCol.isEmpty()) {
            result.add(bindingCol);
        }
        result = this.getRefEntitiesByNames(uPara.getDatabase(), result);
        return result;
    }

    private Vector getReferringObj(JetUHierDataSource hds) {
        Enumeration children = hds.getChildrenEnumeration();
        Vector v = new Vector();
        while (children.hasMoreElements()) {
            v.add(children.nextElement());
        }
        return v;
    }

    private Vector getReferringObj(JetUHDSTable uHDSTable) {
        Enumeration children = uHDSTable.getChildrenEnumeration();
        Vector v = new Vector();
        while (children.hasMoreElements()) {
            v.add(children.nextElement());
        }
        return v;
    }

    private Vector getReferringObj(JetUQuery uQuery) {
        JetUQueryField qryField;
        Vector<JetUQueriable> result = new Vector<JetUQueriable>();
        Vector dbFields = uQuery.getDBFields();
        if (dbFields != null && dbFields.size() > 0 && (qryField = (JetUQueryField)dbFields.elementAt(0)) instanceof JetURefQueryField) {
            JetURefQueryField refField = (JetURefQueryField)qryField;
            result.add(refField.getRefQuery());
            result.addAll(dbFields);
            return result;
        }
        Vector uFields = this.convertJetUQueryFieldToJetUField(dbFields);
        Vector tables = this.getReferringTableInQuery(uQuery);
        Vector formulae = uQuery.getFormulas();
        formulae = this.convertJetUFmlQueryFieldToJetUFormula(formulae);
        Vector entityInFilter = this.getReferringInQueryFilter(uQuery);
        Vector unionQry = this.getReferringInQueryUnion(uQuery);
        Vector conditions = this.getReferringInQueryCondition(uQuery);
        Vector fieldsInJoin = this.getReferringInQueryJoin(uQuery);
        result.addAll(uFields);
        result.addAll(formulae);
        result.addAll(tables);
        result.addAll(entityInFilter);
        result.addAll(unionQry);
        result.addAll(conditions);
        result.addAll(fieldsInJoin);
        return result;
    }

    private void addReferenceSrc(Vector result, String databaseName, JetUUniverse universe, Vector des) {
        int iLen = des.size();
        for (int i = 0; i < iLen; ++i) {
            DataElementInfo de = (DataElementInfo)des.get(i);
            String mappingName = de.getRefMappingName();
            JetUResourceEntity node = universe.getResourceByName(databaseName, null, mappingName);
            if (node == null || result.contains(node)) continue;
            result.add(node);
        }
    }

    public Vector getDetails(CategoryInfo category, Vector ret) {
        CategoryInfo[] categoryInfo;
        DTInformation[] dtis = category.getDetails();
        if (dtis != null) {
            int iLen = dtis.length;
            for (int i = 0; i < iLen; ++i) {
                ret.add(dtis[i]);
            }
        }
        if ((categoryInfo = category.getCategories()) != null) {
            int iLen = categoryInfo.length;
            for (int i = 0; i < iLen; ++i) {
                this.getDetails(categoryInfo[i], ret);
            }
        }
        return ret;
    }

    public Vector getAggregations(CategoryInfo category, Vector ret) {
        CategoryInfo[] categoryInfo;
        AggregationInfo[] meas = category.getAggregations();
        if (meas != null) {
            int iLen = meas.length;
            for (int i = 0; i < iLen; ++i) {
                ret.add(meas[i]);
            }
        }
        if ((categoryInfo = category.getCategories()) != null) {
            int iLen = categoryInfo.length;
            for (int i = 0; i < iLen; ++i) {
                this.getAggregations(categoryInfo[i], ret);
            }
        }
        return ret;
    }

    public Vector getGroup(CategoryInfo category, Vector ret) {
        CategoryInfo[] categoryInfo;
        GroupInfo[] dims = category.getGroups();
        if (dims != null) {
            int iLen = dims.length;
            for (int i = 0; i < iLen; ++i) {
                ret.add(dims[i]);
            }
        }
        if ((categoryInfo = category.getCategories()) != null) {
            int iLen = categoryInfo.length;
            for (int i = 0; i < iLen; ++i) {
                this.getGroup(categoryInfo[i], ret);
            }
        }
        return ret;
    }

    public Vector getCategory(CategoryInfo category, Vector ret) {
        ret.add(category);
        CategoryInfo[] categoryInfo = category.getCategories();
        if (categoryInfo != null) {
            int iLen = categoryInfo.length;
            for (int i = 0; i < iLen; ++i) {
                this.getCategory(categoryInfo[i], ret);
            }
        }
        return ret;
    }

    private Vector getReferringTableInQuery(JetUQuery uQuery) {
        JetUDatabase udb = uQuery.getDatabase();
        Vector<JetUTableView> result = new Vector<JetUTableView>();
        Vector psqlTables = uQuery.psqlQuery.vTables;
        for (int i = 0; i < psqlTables.size(); ++i) {
            PsqlTable psqlTable = (PsqlTable)psqlTables.get(i);
            JetUTableView tableView = udb.GetTableOrViewByResourceName(psqlTable.mappingName);
            if (tableView == null) continue;
            result.add(tableView);
        }
        return result;
    }

    private Vector getReferringInQueryJoin(JetUQuery uQuery) {
        Vector<String> mappingNames = new Vector<String>();
        Vector join = uQuery.psqlQuery.vPsqlJoin;
        if (join != null) {
            for (int i = 0; i < join.size(); ++i) {
                PsqlJoin sqlJoin = (PsqlJoin)join.get(i);
                String fromMappingName = sqlJoin.getColumnFrom().getMappingName();
                String toMappingName = sqlJoin.getColumnTo().getMappingName();
                if (fromMappingName != null && !fromMappingName.equals("")) {
                    mappingNames.add(fromMappingName);
                }
                if (toMappingName == null || toMappingName.equals("")) continue;
                mappingNames.add(toMappingName);
            }
        }
        Vector entities = new Vector();
        if (mappingNames.size() > 0) {
            entities = this.getRefEntitiesByNames(uQuery.getDatabase(), mappingNames);
        }
        return entities;
    }

    private Vector getReferringInQueryCondition(JetUQuery uQuery) {
        Vector selCols = uQuery.psqlQuery.getSelColsVector();
        Vector<String> conditionNames = new Vector<String>();
        for (int i = 0; i < selCols.size(); ++i) {
            PsqlSelColumn selCol = (PsqlSelColumn)selCols.get(i);
            Vector conditions = selCol.vConditions;
            for (int j = 0; j < conditions.size(); ++j) {
                StringBuffer conBuff;
                String name2;
                String condition = (String)conditions.get(j);
                if (condition == null || (name2 = DbTools.getFirstParameterNameInString(conBuff = new StringBuffer(condition), new StringBuffer())) == null) continue;
                conditionNames.add(name2);
            }
        }
        Vector result = new Vector();
        if (conditionNames.size() > 0) {
            result = this.getRefEntitiesByNames(uQuery.getDatabase(), conditionNames);
        }
        return result;
    }

    private Vector getReferringInQueryUnion(JetUQuery uQuery) {
        Vector unions = uQuery.psqlQuery.vUnion;
        Vector<JetUQueriable> result = new Vector<JetUQueriable>();
        JetUDatabase udb = uQuery.getDatabase();
        for (int i = 0; i < unions.size(); ++i) {
            PsqlUnion union = (PsqlUnion)unions.get(i);
            String unionName = union.getUnionQuery();
            result.add(udb.getQueriableByResourceName(unionName));
        }
        return result;
    }

    private Vector getReferringInQueryFilter(JetUQuery uQuery) {
        String sAndExp;
        JetUDatabase udb;
        Vector result;
        Vector allMappingNames;
        block8: {
            allMappingNames = new Vector();
            result = new Vector();
            udb = uQuery.getDatabase();
            IExpression exp = uQuery.psqlQuery.getSearchConditionGroups();
            if (exp != null) {
                try {
                    IExpression[] subExps = null;
                    if (exp instanceof IUnCheckedMultiExpression) {
                        subExps = ExpressionToolKit.getSubExpsofMultiExp((IUnCheckedMultiExpression)exp);
                        for (int i = 0; i < subExps.length; ++i) {
                            String expStr = subExps[i].getStringValue(true);
                            Vector tempMapName = this.parseStatement(expStr, udb);
                            for (int j = 0; j < tempMapName.size(); ++j) {
                                allMappingNames.add(tempMapName.get(j));
                            }
                        }
                    } else {
                        String sExp = exp.getStringValue(true);
                        allMappingNames = this.parseStatement(sExp, udb);
                    }
                    Vector entitiesInExp = this.getRefEntitiesByNames(udb, allMappingNames);
                    result.addAll(entitiesInExp);
                }
                catch (ConditionException e) {
                    if (!logger.isErrorEnabled()) break block8;
                    logger.error(e.getMessage());
                }
            }
        }
        if ((sAndExp = uQuery.psqlQuery.sAndExpression) != null && !sAndExp.equals("")) {
            allMappingNames = this.resolveParaString(sAndExp);
        }
        Vector entitiesInAndExp = this.getRefEntitiesByNames(udb, allMappingNames);
        result.addAll(entitiesInAndExp);
        return result;
    }

    private Vector getReferringTableInJetUField(Vector uFields) {
        Vector<JetUTableView> result = new Vector<JetUTableView>();
        for (int i = 0; i < uFields.size(); ++i) {
            JetUField uField;
            JetUTableView tableView;
            if (!(uFields.elementAt(i) instanceof JetUField) || (tableView = (uField = (JetUField)uFields.elementAt(i)).getTable()) == null) continue;
            result.add(tableView);
        }
        return result;
    }

    private Vector getReferringObj(JetUTable uTable) {
        return uTable.getFields();
    }

    private Vector getReferringObj(JetUTableView uTableView) {
        return uTableView.getFields();
    }

    private Vector getReferringObj(JetUUserDataSource uds) {
        Vector result = new Vector();
        Vector fields = uds.getFields();
        String parameter = uds.getParameter();
        Vector names = new Vector();
        names = this.resolveParaString(parameter);
        Vector parasInUDS = this.getRefEntitiesByNames(uds.getDatabase(), names);
        result.addAll(fields);
        result.addAll(parasInUDS);
        return result;
    }

    private Vector resolveParaString(String strParameter) {
        Vector<String> result = new Vector<String>();
        StringBuffer strTemp = new StringBuffer(strParameter);
        StringBuffer strBefore = new StringBuffer();
        String strName = null;
        while ((strName = DbTools.getFirstParameterNameInString(strTemp, strBefore)) != null) {
            result.add(strName);
        }
        return result;
    }

    private Vector getReferringObj(JetUFormula uFormula) {
        Vector refDbFld = uFormula.getRefDbFld();
        Vector refFormuFld = uFormula.getRefFormuFld();
        Vector refParamFld = uFormula.getRefParamFld();
        Vector result = new Vector();
        result.addAll(refDbFld);
        result.addAll(refFormuFld);
        result.addAll(refParamFld);
        result = this.getRefEntitiesByNames(uFormula.getDatabase(), result);
        return result;
    }

    private Vector convertJetUQueryFieldToJetUField(Vector queryFields) {
        JetUQueryField qryField = null;
        Vector<JetUField> convertedFields = new Vector<JetUField>();
        for (int i = 0; i < queryFields.size(); ++i) {
            qryField = (JetUQueryField)queryFields.elementAt(i);
            if (qryField instanceof JetUCompColQueryField) {
                Vector includeFields = this.getReferingObj((JetUCompColQueryField)qryField);
                convertedFields.addAll(includeFields);
                continue;
            }
            if (qryField instanceof JetUFldQueryField) {
                JetUFldQueryField fldQueryField = (JetUFldQueryField)qryField;
                JetUField uField = fldQueryField.getRefField();
                if (uField == null) continue;
                convertedFields.add(uField);
                continue;
            }
            if (!logger.isErrorEnabled()) continue;
            Exception e = new Exception("\n!!!WARNING: Unknown JetUQueryField: " + qryField);
            logger.error(e);
        }
        return convertedFields;
    }

    private Vector getReferingObj(JetUCompColQueryField field) {
        JetUDatabase udb = field.getDatabase();
        String expression = field.getExpression();
        Vector fieldNames = this.parseStatement(expression, udb);
        return this.getRefEntitiesByNames(udb, fieldNames);
    }

    private Vector parseStatement(String expression, JetUDatabase udb) {
        Vector<String> mappingNames = new Vector<String>();
        if (expression == null) {
            return mappingNames;
        }
        int expLength = expression.length();
        StringBuffer stringbuffer = new StringBuffer();
        int j = 0;
        block4: while (j < expLength) {
            char c = expression.charAt(j);
            block0 : switch (c) {
                case '.': 
                case ':': {
                    char c2;
                    if (++j >= expLength) continue block4;
                    char c1 = expression.charAt(j);
                    stringbuffer.setLength(0);
                    if (c1 == '`') {
                        ++j;
                        while (j < expLength) {
                            c2 = expression.charAt(j);
                            if (c2 == '`') {
                                mappingNames.add(stringbuffer.toString());
                                break block0;
                            }
                            stringbuffer.append(c2);
                            ++j;
                        }
                        continue block4;
                    }
                    int k = j;
                    String tableName = expression.substring(0, k - 1);
                    while (j < expLength) {
                        char c3 = expression.charAt(j);
                        if (j == k && c3 >= '0' && c3 <= '9' || (c3 < 'a' || c3 > 'z') && (c3 < 'A' || c3 > 'Z') && c3 != '_' && (c3 < '0' || c3 > '9')) break;
                        stringbuffer.append(c3);
                        ++j;
                    }
                    if (stringbuffer.length() <= 0) continue block4;
                    String colName = stringbuffer.toString();
                    String fldMappingName = null;
                    String cnnName = udb.getConnection().name.get();
                    JetUTableView tblView = udb.GetTableOrViewByResourceName(cnnName, tableName);
                    JetUField uField = null;
                    if (tblView != null && (uField = tblView.getFieldByFieldName(colName)) != null) {
                        fldMappingName = uField.getResourceName();
                    }
                    if (fldMappingName != null && fldMappingName.length() > 0) {
                        mappingNames.add(fldMappingName);
                        break;
                    }
                    mappingNames.add(stringbuffer.toString());
                    if (!logger.isErrorEnabled()) continue block4;
                    logger.error(new RefResourceException("Can't find JetUField: " + tableName + "." + colName + " in UDB" + udb.getResourceName()));
                    break;
                }
                case '@': {
                    char c2;
                    if (++j >= expLength) continue block4;
                    char c1 = expression.charAt(j);
                    stringbuffer.setLength(0);
                    if (c1 == '\"') {
                        ++j;
                        while (j < expLength) {
                            c2 = expression.charAt(j);
                            if (c2 == '\"') {
                                mappingNames.add(stringbuffer.toString());
                                break block0;
                            }
                            stringbuffer.append(c2);
                            ++j;
                        }
                        continue block4;
                    }
                    int k = j;
                    while (j < expLength) {
                        char c3 = expression.charAt(j);
                        if (j == k && c3 >= '0' && c3 <= '9' || (c3 < 'a' || c3 > 'z') && (c3 < 'A' || c3 > 'Z') && c3 != '_' && (c3 < '0' || c3 > '9')) break;
                        stringbuffer.append(c3);
                        ++j;
                    }
                    if (stringbuffer.length() <= 0) continue block4;
                    mappingNames.add(stringbuffer.toString());
                    break;
                }
                default: {
                    ++j;
                }
            }
        }
        return mappingNames;
    }

    private Vector getRefEntitiesByNames(JetUDatabase udb, List names) {
        Vector<Object> result = new Vector<Object>();
        Object entity = null;
        for (int i = 0; i < names.size(); ++i) {
            String name2 = (String)names.get(i);
            entity = udb.getResourceByName(name2);
            if (entity == null) {
                entity = udb.GetQueryByResourceName(name2);
            }
            if (entity == null) {
                entity = udb.getQueriableByResourceName(name2);
            }
            if (entity == null) {
                Vector queriables = udb.getQueriables();
                for (int j = 0; j < queriables.size(); ++j) {
                    JetUQueriable queriable = (JetUQueriable)queriables.get(j);
                    entity = queriable.getFieldByResourceName(name2);
                    if (entity == null) continue;
                    if (entity instanceof JetUFldQueryField) {
                        entity = ((JetUFldQueryField)entity).getRefField();
                    }
                    break;
                }
            }
            if (entity == null) continue;
            result.add(entity);
        }
        return result;
    }

    private Vector convertJetUFmlQueryFieldToJetUFormula(Vector formulaFields) {
        Vector<JetUFormula> result = new Vector<JetUFormula>();
        for (int i = 0; i < formulaFields.size(); ++i) {
            JetUFmlQueryField uFmlQueryField = (JetUFmlQueryField)formulaFields.elementAt(i);
            result.add(uFmlQueryField.getFormula());
        }
        return result;
    }

    private JetObject getReportNode(String path, String rptFileName) {
        RefReport refRpt = new RefReport(path, rptFileName);
        return refRpt;
    }

    public Vector convertReferObjectToJetObject(Vector refObjs, JetUDatabase udb, JUnifiedBusinessView ubv) {
        Vector<JetObject> result = new Vector<JetObject>();
        for (int i = 0; i < refObjs.size(); ++i) {
            JetObject corrObj;
            ReferObject refObj = (ReferObject)refObjs.elementAt(i);
            try {
                corrObj = this.refObjectToJetObject(refObj, udb, ubv);
            }
            catch (RefResourceException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("", e);
                continue;
            }
            result.add(corrObj);
        }
        return result;
    }

    private JetObject refObjectToJetObject(ReferObject refObj, JetUDatabase udb, JUnifiedBusinessView ubv) throws RefResourceException {
        JetObject obj = null;
        if (this.isReport(refObj)) {
            obj = this.getReportNode(udb.getUniverse().getFilePath(), refObj.getName());
        } else if (this.isJetUQueriable(refObj)) {
            obj = (JetObject)((Object)udb.getQueriableByResourceName(refObj.getName()));
        } else if (this.isTableOrView(refObj)) {
            String cnnName = udb.getConnection().name.get();
            obj = udb.GetTableOrViewByResourceName(cnnName, refObj.getName());
        } else if (this.isCubeItem(refObj)) {
            if (refObj.getType() == 17) {
                UnifiedBusinessView bv = udb.getBusinessView(refObj.getName());
                obj = bv;
            } else {
                String blName = this.getBLNameFromCubeItemName(refObj.getName());
                String bvName = this.getQueryNameFromCubeItemName(refObj.getName());
                UnifiedBusinessView bv = udb.getBusinessView(bvName);
                obj = bv != null ? (JetObject)((Object)bv.getByDisplayName(blName)) : null;
            }
        } else if (this.isDataSource(refObj)) {
            String name2 = refObj.getName();
            JetUUniverse un = udb.getUniverse();
            JetUDatabase db = un.getDatabase(name2);
            obj = db;
        } else {
            obj = udb.getResourceByName(refObj.getName());
        }
        if (obj == null) {
            throw new RefResourceException("Not Found Corresponding Object " + refObj.getName() + " in JetUDatabase: " + udb);
        }
        return obj;
    }

    private boolean isDataSource(ReferObject refObj) {
        int type = refObj.getType();
        return type == 20;
    }

    private String getBLNameFromCubeItemName2(String name2) {
        String ret = null;
        if (!StringTools.isEmptyStringWithTrim(name2)) {
            ret = name2.substring(name2.indexOf(".") + 1);
            ret = ret.substring(ret.indexOf(".") + 1);
            ret = ret.substring(ret.indexOf(".") + 1);
        }
        return ret;
    }

    private String getQueryNameFromCubeItemName2(String name2) {
        String ret = null;
        if (!StringTools.isEmptyStringWithTrim(name2)) {
            ret = name2.substring(name2.indexOf(".") + 1);
            ret = ret.substring(ret.indexOf(".") + 1);
            ret = ret.substring(0, ret.indexOf("."));
        }
        return ret;
    }

    private String getBLNameFromCubeItemName(String name2) {
        String ret = null;
        if (!StringTools.isEmptyStringWithTrim(name2)) {
            ret = name2.substring(name2.indexOf(".") + 1);
            ret = ret.substring(ret.indexOf(".") + 1);
        }
        return ret;
    }

    private String getQueryNameFromCubeItemName(String name2) {
        String ret = null;
        if (!StringTools.isEmptyStringWithTrim(name2) && (ret = name2.substring(name2.indexOf(".") + 1)).indexOf(".") != -1) {
            ret = ret.substring(0, ret.indexOf("."));
        }
        return ret;
    }

    private boolean isCubeItem(ReferObject refObj) {
        int type = refObj.getType();
        return type == 12 || type == 13 || type == 14 || type == 17 || type == 16 || type == 19 || type == 18;
    }

    public Vector searchReportByCatPath(String catPath) {
        Vector<String> rptFiles = new Vector<String>();
        File dir = new File(catPath);
        String[] files = null;
        if (dir.exists() && dir.isDirectory()) {
            files = dir.list();
        }
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!this.isSupportReportType(fileName)) continue;
            rptFiles.add(fileName);
        }
        return rptFiles;
    }

    public boolean isSupportReportType(String reportName) {
        for (int i = 0; i < supportReportType.length; ++i) {
            String spptRptType = supportReportType[i];
            if (!reportName.toLowerCase().endsWith(spptRptType.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isEverCreatedDB(String catPath, String catName) {
        String fullName = catPath + catName + DB_FILE_SUFFIX;
        File testFile = new File(fullName);
        return testFile.exists() && testFile.isFile();
    }

    private Object renameReferredBy(RenameTool renameTool, JetObject renamedObj, JetObject updateObj, String newName, String oldName, Hashtable allOpenReferredReports, boolean isBVContext) {
        if (updateObj.getClass().equals(JetUFormula.class)) {
            JetUFormula uFormula = (JetUFormula)updateObj;
            renameTool.updateFormula(uFormula, oldName, newName);
            return updateObj;
        }
        if (updateObj.getClass().equals(JetUFileQuery.class)) {
            JetUFileQuery uFileQry = (JetUFileQuery)updateObj;
            if (renamedObj instanceof JetUFileQueryField && renamedObj.getParent().equals(uFileQry)) {
                renameTool.updateFileQueryField(uFileQry, oldName, newName);
                return updateObj;
            }
            renameTool.updateFileQuery(uFileQry, oldName, newName);
            return updateObj;
        }
        if (updateObj.getClass().equals(JetUSummary.class)) {
            JetUSummary uSummary = (JetUSummary)updateObj;
            renameTool.updateSummary(uSummary, oldName, newName);
            return updateObj;
        }
        if (updateObj.getClass().equals(JetUQuery.class) || updateObj.getClass().equals(JetUDemandQuery.class)) {
            JetUQuery uQuery = (JetUQuery)updateObj;
            this.renameReferredByQuery(renameTool, renamedObj, uQuery, oldName, newName);
            return updateObj;
        }
        if (updateObj.getClass().equals(JetUUserDataSource.class) && renamedObj.getClass().equals(JetUParameter.class)) {
            JetUUserDataSource uds = (JetUUserDataSource)updateObj;
            renameTool.updateUDSParameter(uds, oldName, newName);
            return updateObj;
        }
        if (updateObj.getClass().equals(JetUProcedure.class) && renamedObj.getClass().equals(JetUParameter.class)) {
            JetUProcedure uProc = (JetUProcedure)updateObj;
            renameTool.updateProcedureParameter(uProc, oldName, newName);
            return updateObj;
        }
        if (updateObj.getClass().equals(Dimension.class)) {
            if (renamedObj instanceof JetUField || renamedObj instanceof JetUFormula || renamedObj instanceof JetUFileQueryField || renamedObj instanceof JetUUDSField || renamedObj instanceof JetUProcField) {
                Dimension dim = (Dimension)updateObj;
                dim.setRefMappingName(newName);
                JetUDemandQuery jo = dim.getUbv().getQuery();
                this.updateBCParent(renameTool, jo, oldName, newName);
            }
            return updateObj;
        }
        if (updateObj.getClass().equals(DetailInfo.class)) {
            if (renamedObj instanceof JetUField || renamedObj instanceof JetUFormula || renamedObj instanceof JetUFileQueryField || renamedObj instanceof JetUUDSField || renamedObj instanceof JetUProcField) {
                DetailInfo dti = (DetailInfo)updateObj;
                dti.setRefMappingName(newName);
                JetUDemandQuery jo = dti.getUbv().getQuery();
                this.updateBCParent(renameTool, jo, oldName, newName);
            }
            return updateObj;
        }
        if (updateObj.getClass().equals(UnifiedBusinessView.class)) {
            UnifiedBusinessView bv = (UnifiedBusinessView)updateObj;
            JetUDemandQuery uQuery = bv.getQuery();
            if (renamedObj instanceof JetUField || renamedObj instanceof JetUFormula || renamedObj instanceof JetUFileQueryField || renamedObj instanceof JetUUDSField || renamedObj instanceof JetUProcField || renamedObj instanceof JetUTableView) {
                this.renameReferredByQuery(renameTool, renamedObj, uQuery, oldName, newName);
            } else if (renamedObj instanceof JetUQueriable) {
                uQuery.replaceTabName(oldName, newName);
            }
            return updateObj;
        }
        if (updateObj instanceof FilterInfo) {
            FilterInfo filter = (FilterInfo)((Object)updateObj);
            filter.updateReferenceName(oldName, newName);
            return updateObj;
        }
        if (updateObj.getClass().equals(Group.class)) {
            if (renamedObj instanceof JetUField || renamedObj instanceof JetUFormula || renamedObj instanceof JetUFileQueryField || renamedObj instanceof JetUUDSField || renamedObj instanceof JetUProcField) {
                Group grp = (Group)updateObj;
                grp.setRefMappingName(newName);
                JetUDemandQuery jo = grp.getUbv().getQuery();
                this.updateBCParent(renameTool, jo, oldName, newName);
            }
            return updateObj;
        }
        if (updateObj.getClass().equals(Aggregation.class)) {
            JetUFormula uf;
            Measure m;
            if (renamedObj instanceof JetUField || renamedObj instanceof JetUFormula || renamedObj instanceof JetUFileQueryField || renamedObj instanceof JetUUDSField || renamedObj instanceof JetUProcField) {
                Aggregation agg = (Aggregation)updateObj;
                agg.setRefMappingName(newName);
                JetUDemandQuery jo = agg.getUbv().getQuery();
                this.updateBCParent(renameTool, jo, oldName, newName);
            } else if ((renamedObj instanceof Group || renamedObj instanceof Detail || renamedObj instanceof Aggregation) && (m = (Measure)updateObj).isCustomized() && (uf = m.getJetUFormula()) != null) {
                String oldExp = uf.getExpression();
                JetRptFormula rptFormula = uf.getRptFormula();
                renameTool.updateFormula(rptFormula, oldName, newName);
                String newExp = rptFormula.getExpression();
                uf.setExpression(newExp);
                try {
                    m.getUbv().generJavaFormula();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return updateObj;
        }
        if (updateObj.getClass().equals(Detail.class)) {
            if (renamedObj instanceof JetUField || renamedObj instanceof JetUFormula || renamedObj instanceof JetUFileQueryField || renamedObj instanceof JetUUDSField || renamedObj instanceof JetUProcField) {
                Detail detail = (Detail)updateObj;
                detail.setRefMappingName(newName);
                JetUDemandQuery jo = detail.getUbv().getQuery();
                this.updateBCParent(renameTool, jo, oldName, newName);
            }
            return updateObj;
        }
        if (updateObj.getClass().equals(UnifiedBusinessView.class)) {
            block37: {
                if (renamedObj instanceof UnifiedBusinessView) {
                    UnifiedBusinessView bl = (UnifiedBusinessView)updateObj;
                    try {
                        renameTool.updateBusinessLogic(bl, oldName, newName);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block37;
                        logger.debug("update businessView error. ", e);
                    }
                }
            }
            if (renamedObj instanceof JetUField || renamedObj instanceof JetUFormula || renamedObj instanceof JetUFileQueryField || renamedObj instanceof JetUUDSField || renamedObj instanceof JetUProcField) {
                JetUQuery uQuery = (JetUQuery)((BusinessView)updateObj).getQuery();
                this.renameReferredByQuery(renameTool, renamedObj, uQuery, oldName, newName);
            }
            return updateObj;
        }
        if (updateObj.getClass().equals(RefReport.class)) {
            block38: {
                RefReport report = (RefReport)updateObj;
                if (allOpenReferredReports.containsKey(report.getFileName())) {
                    report.setObject((JetObject)allOpenReferredReports.get(report.getFileName()));
                }
                try {
                    this.renameReferredByReport(renameTool, renamedObj, report, oldName, newName, isBVContext);
                }
                catch (RefResourceException e) {
                    if (!logger.isErrorEnabled()) break block38;
                    logger.error("Rename ReferredBy Report failed: " + report);
                }
            }
            return null;
        }
        if (updateObj.getClass().equals(JetUDatabase.class)) {
            JetUDatabase db = (JetUDatabase)updateObj;
            db.rename(newName);
            renameTool.updateQueryDBName(db, newName);
            return updateObj;
        }
        if (!renamedObj.getParent().equals(updateObj) && logger.isErrorEnabled()) {
            logger.error("UNKNOWN Type To Rename, renamedObj: " + renamedObj + " ,updateObj: " + updateObj);
        }
        return null;
    }

    private void renameReferredByReport(RenameTool renameTool, JetObject renamedObj, RefReport refRpt, String oldName, String newName, boolean isBVContext) throws RefResourceException {
        JetObject panel = refRpt.getObject();
        try {
            boolean isQueriable = false;
            if (renamedObj instanceof JetUQuery) {
                isQueriable = true;
            } else if (renamedObj instanceof JUnifiedBusinessView) {
                isQueriable = true;
            }
            if (panel == null) {
                renameTool.replace(refRpt.getFullName(), (Boolean)isQueriable, oldName, newName, isBVContext);
            } else {
                renameTool.replace(panel, (Boolean)isQueriable, oldName, newName, isBVContext);
            }
        }
        catch (ReadFailureException e) {
            throw new RefResourceException("save report failed: " + refRpt.getFullName());
        }
        catch (WriteFailureException e) {
            throw new RefResourceException("save report failed: " + refRpt.getFullName());
        }
    }

    private void renameReferredByQuery(RenameTool renameTool, JetObject renamedObj, JetUQuery uQuery, String oldName, String newName) {
        if (renamedObj.getClass().equals(JetUFormula.class)) {
            renameTool.updateQueryFormula(uQuery, oldName, newName);
        } else if (renamedObj.getClass().equals(JetUField.class)) {
            renameTool.updateQueryField(uQuery, oldName, newName);
        } else if (renamedObj.getClass().equals(JetUParameter.class)) {
            renameTool.updateQueryParameter(uQuery, oldName, newName);
        } else if (renamedObj.getClass().equals(JetUTableView.class) || renamedObj.getClass().equals(JetUTable.class)) {
            renameTool.updateQueryTable(uQuery, oldName, newName);
        } else if (renamedObj instanceof JetUQueriable) {
            if (this.isUnion(renamedObj, uQuery)) {
                renameTool.updateQueryUnion(uQuery, oldName, newName);
            } else {
                JetUQueryField qryField;
                Vector dbFields = uQuery.getDBFields();
                if (dbFields != null && dbFields.size() > 0 && (qryField = (JetUQueryField)dbFields.elementAt(0)) instanceof JetURefQueryField) {
                    uQuery.replaceTabName(oldName, newName);
                    return;
                }
                renameTool.updateQuerySubquery(uQuery, oldName, newName);
            }
        } else if (logger.isErrorEnabled()) {
            logger.error("Rename ReferredBy JetUQuery, Unknown type: " + renamedObj);
        }
    }

    private boolean isUnion(JetObject unionQuery, JetUQuery hostQuery) {
        if (!(unionQuery instanceof JetUQuery)) {
            return false;
        }
        JetUQuery unionQry = (JetUQuery)unionQuery;
        Vector unions = hostQuery.psqlQuery.vUnion;
        for (int i = 0; i < unions.size(); ++i) {
            PsqlUnion union = (PsqlUnion)unions.get(i);
            if (!union.getUnionQuery().equalsIgnoreCase(unionQry.name.get())) continue;
            return true;
        }
        return false;
    }

    public boolean isRequired(JetObject obj, Vector requiredTypes) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof JetUTableView) {
            return this.isRequiredTableOrView((JetUTableView)obj, requiredTypes);
        }
        Class<?> cls = obj.getClass();
        return this.isRequired(cls, requiredTypes);
    }

    private boolean isRequiredTableOrView(JetUTableView tableView, Vector requiredTypes) {
        int type = tableView.getTableType();
        if (type == 1) {
            return this.isRequired(1, requiredTypes);
        }
        if (type == 2) {
            return this.isRequired(2, requiredTypes);
        }
        return false;
    }

    public boolean isRequired(int type, Vector requiredTypes) {
        return requiredTypes.contains(new Integer(type));
    }

    public boolean isRequired(Class cls, Vector requiredTypes) {
        Integer correspondType;
        try {
            correspondType = this.getType(cls);
        }
        catch (RefResourceException e) {
            return false;
        }
        if (correspondType.equals(new Integer(0))) {
            try {
                return this.isRequiredField(cls, requiredTypes);
            }
            catch (RefResourceException e) {
                return false;
            }
        }
        return this.isRequired(correspondType, requiredTypes);
    }

    private boolean isRequiredField(Class cls, Vector requiredTypes) throws RefResourceException {
        if (cls.equals(JetUField.class) || cls.equals(JetUFldQueryField.class) || cls.equals(JetURefQueryField.class)) {
            return this.isRequired(1, requiredTypes) || this.isRequired(2, requiredTypes) || this.isRequired(7, requiredTypes);
        }
        if (cls.equals(JetUProcField.class)) {
            return this.isRequired(3, requiredTypes);
        }
        if (cls.equals(JetUFileQueryField.class)) {
            return this.isRequired(4, requiredTypes);
        }
        if (cls.equals(JetUUDSField.class)) {
            return this.isRequired(5, requiredTypes);
        }
        if (cls.equals(JetUHDSField.class)) {
            return this.isRequired(6, requiredTypes);
        }
        throw new RefResourceException("Not support Field Type: " + cls);
    }

    public Vector renameReferredEntities(JetObject renamedObj, Vector referredEntities, String newName, String oldName, JetUDatabase udb, Hashtable allOpenReport, boolean isBVContext) {
        RenameTool renameTool = null;
        Replacement rmt = new Replacement(udb.getUniverse());
        if (renamedObj instanceof BLNodeImpl) {
            UnifiedBusinessView ubv = (UnifiedBusinessView)((BLNodeImpl)renamedObj).getUbv();
            renameTool = new RenameTool(ubv, rmt);
        } else {
            renameTool = new RenameTool(udb, rmt);
        }
        Vector<Object> updatedObjects = new Vector<Object>();
        referredEntities = this.sortFormula(referredEntities);
        for (int i = 0; i < referredEntities.size(); ++i) {
            JetObject node = (JetObject)referredEntities.elementAt(i);
            Object updated = this.renameReferredBy(renameTool, renamedObj, node, newName, oldName, allOpenReport, isBVContext);
            if (updated == null) continue;
            updatedObjects.add(updated);
        }
        return updatedObjects;
    }

    private Vector sortFormula(Vector referredEntities) {
        Vector result = new Vector();
        for (int i = 0; i < referredEntities.size(); ++i) {
            Object obj = referredEntities.get(i);
            if (obj instanceof JetUFormula) {
                result.insertElementAt(obj, 0);
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public String cutStringTail(String oriStr, String toBeCut) {
        if (oriStr == null || oriStr == "" || toBeCut == null || toBeCut == "") {
            return oriStr;
        }
        if (oriStr.endsWith(toBeCut)) {
            int pos = oriStr.length() - toBeCut.length();
            return oriStr.substring(0, pos);
        }
        return oriStr;
    }

    public void updateBCParent(RenameTool renameTool, JetObject object, String oldName, String newName) {
        if (object instanceof JetUQuery) {
            JetUQuery jetUQuery = (JetUQuery)object;
            renameTool.updateQueryField(jetUQuery, oldName, newName);
        } else if (object instanceof JetUFileQuery) {
            JetUFileQuery jetUFileQuery = (JetUFileQuery)object;
            renameTool.updateFileQueryField(jetUFileQuery, oldName, newName);
        }
    }

    static {
        typeTable.put(JetUField.class, new Integer(0));
        typeTable.put(JetURefQueryField.class, new Integer(0));
        typeTable.put(JetUFileQueryField.class, new Integer(0));
        typeTable.put(JetUUDSField.class, new Integer(0));
        typeTable.put(JetUHDSField.class, new Integer(0));
        typeTable.put(JetUProcField.class, new Integer(0));
        typeTable.put(JetUTable.class, new Integer(1));
        typeTable.put(JetUTableView.class, new Integer(2));
        typeTable.put(JetUProcedure.class, new Integer(3));
        typeTable.put(JetUFileQuery.class, new Integer(4));
        typeTable.put(JetUUserDataSource.class, new Integer(5));
        typeTable.put(JetUHierDataSource.class, new Integer(6));
        typeTable.put(JetUHDSTable.class, new Integer(6));
        typeTable.put(JetUQuery.class, new Integer(7));
        typeTable.put(JetUDemandQuery.class, new Integer(7));
        typeTable.put(JetUFormula.class, new Integer(8));
        typeTable.put(JetUSummary.class, new Integer(9));
        typeTable.put(JetUParameter.class, new Integer(10));
        typeTable.put(RefReport.class, new Integer(11));
        typeTable.put(Category.class, new Integer(16));
        typeTable.put(BCFilter.class, new Integer(18));
        typeTable.put(Prefilter.class, new Integer(19));
        typeTable.put(Group.class, new Integer(12));
        typeTable.put(Aggregation.class, new Integer(13));
        typeTable.put(Detail.class, new Integer(14));
        typeTable.put(UnifiedBusinessView.class, new Integer(17));
        typeTable.put(UpgradedUnifiedBusinessView.class, new Integer(17));
        typeTable.put(JetUDatabase.class, new Integer(20));
        instance = new ReferTool();
        logger = JRLogger.getLogger(ReferTool.class.getName());
    }
}

