/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import jet.controls.JetObject;
import jet.exception.FormulaSyntaxErrorException;
import jet.formula.FormulatoJava;
import jet.formula.JetRptFormula;
import jet.formula.crossref.NameCollector;
import jet.ireport.IDataContainer;
import jet.log.JRLogger;
import jet.reportset.DataSet;
import jet.reportset.JetRptReportSet;
import jet.universe.IReferenceListener;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUField;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.RefReport;
import jet.universe.RefResourceException;
import jet.universe.ReferTool;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DTInformation;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.GroupInfo;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.impl.Aggregation;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Group;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.util.CrossRefException;
import jet.util.CrossRefManager;
import jet.util.ReferObject;
import jet.util.ReferRelation;

public class ReferenceResource {
    private Vector allListeners = new Vector();
    private CrossRefManager refManager = null;
    private JetUUniverse currUniverse = null;
    private ReferTool refTool = null;
    private static ReferenceResource instance = null;
    private static final boolean bRealTimeUpdateReport = true;
    private static JRLogger logger = JRLogger.getLogger(ReferenceResource.class.getName());
    private Vector updatedObjects = new Vector();
    QDNameCollector nc = new QDNameCollector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ReferenceResource getInstance(JetUUniverse uni) throws RefResourceException {
        if (uni == null) {
            throw new RefResourceException("Universe is null, can not initialize ReferenceResource");
        }
        if (instance == null) {
            instance = new ReferenceResource(uni);
        } else if (!ReferenceResource.instance.currUniverse.equals(uni)) {
            if (instance.isCreated()) {
                try {
                    ReferenceResource.instance.refManager.exit();
                }
                catch (CrossRefException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error("refManager.exit() failed", e);
                    }
                }
                finally {
                    instance = null;
                }
            }
            instance = new ReferenceResource(uni);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exit() {
        if (this.isCreated()) {
            try {
                this.refManager.exit();
                return;
            }
            catch (CrossRefException e) {
                if (!logger.isErrorEnabled()) return;
                logger.error("exit failed", e);
                return;
            }
            finally {
                this.refManager = null;
                instance = null;
            }
        } else {
            this.refManager = null;
            this.currUniverse = null;
            instance = null;
        }
    }

    private ReferenceResource(JetUUniverse uni) throws RefResourceException {
        this.currUniverse = uni;
        this.initializeRefManager();
    }

    private void initializeRefManager() throws RefResourceException {
        this.refTool = ReferTool.getInstance();
        String catPath = this.currUniverse.getFilePath();
        String catName = this.currUniverse.getName();
        if (this.refManager == null && this.refTool.isEverCreatedDB(catPath, catName)) {
            try {
                this.refManager = this.getOldRefManagerFromFile();
            }
            catch (CrossRefException e) {
                throw new RefResourceException("Load CrossRefManager failed", e);
            }
        }
    }

    public Vector getCfgDsNames() {
        Vector ds = (Vector)this.refManager.getDataSources().clone();
        return ds;
    }

    public Vector getCfgTypes() {
        Vector types = (Vector)this.refManager.getReferTypes().clone();
        this.removeFieldType(types);
        return types;
    }

    public void insert(JetObject obj) throws RefResourceException {
        if (!this.isValidToUpdate(obj)) {
            return;
        }
        Vector allReferring = this.refTool.getReferringObj(obj, this.currUniverse, null);
        allReferring = this.filterByTypes(allReferring, this.refManager.getReferTypes());
        Vector referRelations = new Vector();
        String dsName = this.getDataSourceName(obj);
        if (obj instanceof BLNodeImpl) {
            BLNodeImpl node = (BLNodeImpl)obj;
            int iLen = allReferring.size();
            for (int i = 0; i < iLen; ++i) {
                Object o = allReferring.get(i);
                if (!(o instanceof JetUFormula) && !(o instanceof JetUField) && !(o instanceof JetUParameter) && !(o instanceof JetUFileQueryField) && !(o instanceof JetUUDSField) && !(o instanceof JetUProcField)) continue;
                Vector v = new Vector();
                v.add(o);
                JUnifiedBusinessView ubv = node.getUbv();
                referRelations.addAll(this.getReferRelations(ubv.getQuery(), v, dsName));
            }
        }
        referRelations.addAll(this.getReferRelations(obj, allReferring, dsName));
        this.keepUnique(referRelations);
        try {
            this.refManager.importReferences(referRelations);
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Insert to CrossRefManager failed", e);
        }
        this.notifyRefChanged();
    }

    private List getDataSourceNames(RefReport rpt) {
        Vector<String> result = new Vector<String>();
        if (rpt == null) {
            return result;
        }
        List<DataSet> datasets = rpt.getUsedAllDataSets();
        for (DataSet dataset : datasets) {
            result.add(dataset.getDataSourceName());
        }
        return result;
    }

    private String getDataSourceName(JetObject obj) throws RefResourceException {
        return this.getDatabase((JetObject)obj).name.get();
    }

    private boolean isValidToUpdate(JetObject obj) {
        if (!this.isCreated()) {
            return false;
        }
        Vector types = this.refManager.getReferTypes();
        if (!this.refTool.isRequired(obj, types)) {
            return false;
        }
        Vector allDs = this.refManager.getDataSources();
        if (obj instanceof RefReport) {
            List dsNames = this.getDataSourceNames((RefReport)obj);
            return allDs.containsAll(dsNames);
        }
        String dsName = null;
        try {
            dsName = this.getDataSourceName(obj);
        }
        catch (RefResourceException e) {
            if (logger.isErrorEnabled()) {
                logger.error(e);
            }
            return false;
        }
        return allDs.contains(dsName);
    }

    public void remove(JetObject obj) throws RefResourceException {
        if (!this.isValidToUpdate(obj)) {
            return;
        }
        String name2 = null;
        String dsName = this.getDataSourceName(obj);
        int type = this.refTool.getType(obj);
        if (obj instanceof UnifiedBusinessView) {
            CategoryInfo[] cs;
            DTInformation[] dts;
            AggregationInfo[] aggs;
            GroupInfo[] gis;
            UnifiedBusinessView ubv = (UnifiedBusinessView)obj;
            Vector<BLNode> refNodes = new Vector<BLNode>();
            for (GroupInfo gi : gis = ubv.getGroups()) {
                refNodes.add(gi);
            }
            for (AggregationInfo agg : aggs = ubv.getAggregations()) {
                refNodes.add(agg);
            }
            for (DTInformation dt : dts = ubv.getDetails()) {
                refNodes.add(dt);
            }
            for (CategoryInfo c : cs = ubv.getCategories()) {
                refNodes.add(c);
            }
            JetObject tmpo = null;
            int iLen = refNodes.size();
            for (int i = 0; i < iLen; ++i) {
                tmpo = (JetObject)refNodes.get(i);
                name2 = this.getName(tmpo);
                type = this.refTool.getType(tmpo);
                try {
                    this.refManager.delObject(name2, type, dsName);
                    continue;
                }
                catch (CrossRefException e) {
                    throw new RefResourceException("Remove object from CrossRefManager failed", e);
                }
            }
            name2 = this.getName(obj);
            try {
                this.refManager.delObject(name2, type, dsName);
            }
            catch (CrossRefException e) {
                throw new RefResourceException("Remove object from CrossRefManager failed", e);
            }
            JetUDemandQuery query = ubv.getQuery();
            name2 = this.getName(query);
            try {
                this.refManager.delObject(name2, this.refTool.getType(query), dsName);
            }
            catch (CrossRefException e) {
                throw new RefResourceException("Remove object from CrossRefManager failed", e);
            }
        }
        name2 = this.getName(obj);
        try {
            this.refManager.delObject(name2, type, dsName);
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Remove object from CrossRefManager failed", e);
        }
        this.notifyRefChanged();
    }

    public void modify(JetObject obj) throws RefResourceException {
        this.removeRefferring(obj);
        this.insert(obj);
        this.notifyRefChanged();
    }

    private void removeRefferring(JetObject obj) throws RefResourceException {
        if (!this.isValidToUpdate(obj)) {
            return;
        }
        String dsName = this.getDataSourceName(obj);
        String name2 = this.getName(obj);
        int type = this.refTool.getType(obj);
        try {
            Vector referrings = this.refManager.getReferObjects(name2, type, dsName);
            if (referrings == null || referrings.size() <= 0) {
                return;
            }
            for (int i = 0; i < referrings.size(); ++i) {
                ReferObject referringObj = (ReferObject)referrings.elementAt(i);
                this.refManager.delReference(name2, type, referringObj.getName(), referringObj.getType(), dsName);
            }
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Remove object from CrossRefManager failed", e);
        }
    }

    public void insertIntoReport(Object obj, JetRptReportSet reportpanel) throws RefResourceException {
        Vector referobjs = new Vector();
        String rptName = reportpanel.getFullFileName();
        if (rptName == null || rptName.trim().isEmpty()) {
            String inst = reportpanel.getInstName();
            rptName = inst + ".cls";
        } else {
            rptName = new File(rptName).getName();
        }
        if (obj instanceof IDataContainer) {
            referobjs = ReferTool.getInstance().getReferringObj((JetObject)obj, this.currUniverse, reportpanel);
            for (int i = 0; i < referobjs.size(); ++i) {
                this.insertIntoReport(reportpanel, rptName, (JetObject)referobjs.elementAt(i));
            }
        } else {
            this.insertIntoReport(reportpanel, rptName, (JetObject)obj);
        }
    }

    private void insertIntoReport(JetRptReportSet rptSet, String rptName, JetObject obj) throws RefResourceException {
        if (!this.isValidToUpdate(obj)) {
            return;
        }
        if (!this.refTool.isSupportReportType(rptName)) {
            return;
        }
        RefReport refRpt = new RefReport(this.currUniverse.getFilePath(), rptName);
        refRpt.setObject(rptSet);
        String ObjDsName = this.getDataSourceName(obj);
        try {
            this.refManager.addReference(rptName, this.refTool.getType(refRpt), this.getName(obj), this.refTool.getType(obj), ObjDsName);
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Remove object from report " + rptName + " failed", e);
        }
        catch (RefResourceException e) {
            throw new RefResourceException("Remove object from report " + rptName + " failed", e);
        }
        this.notifyRefChanged();
    }

    public void removeReport(String rptName) throws RefResourceException {
        if (!this.refTool.isSupportReportType(rptName)) {
            return;
        }
        RefReport refRpt = new RefReport(this.currUniverse.getFilePath(), rptName);
        JetObject rptSet = refRpt.loadReport(this.currUniverse);
        if (!this.isValidToUpdate(refRpt)) {
            return;
        }
        String dsName = "";
        int type = -1;
        List<DataSet> datasets = refRpt.getUsedAllDataSets();
        for (DataSet dataset : datasets) {
            dsName = dataset.getDataSourceName();
            type = this.refTool.getType(refRpt);
            try {
                this.refManager.delObject(rptName, type, dsName);
                this.refManager.saveReport(rptName);
            }
            catch (CrossRefException e) {
                throw new RefResourceException("Remove object from CrossRefManager failed", e);
            }
        }
        this.notifyRefChanged();
    }

    public void removeFromReport(JetObject obj, JetRptReportSet reportpanel) throws RefResourceException {
        Vector referobjs = new Vector();
        String rptName = null;
        String ff = reportpanel.getFullFileName();
        rptName = ff == null || ff.trim().isEmpty() ? reportpanel.getInstName() + ".cls" : new File(ff).getName();
        if (obj instanceof IDataContainer) {
            referobjs = ReferTool.getInstance().getReferringObj(obj, this.currUniverse, reportpanel);
            for (int i = 0; i < referobjs.size(); ++i) {
                this.removeFromReport(reportpanel, rptName, (JetObject)referobjs.elementAt(i));
            }
        } else {
            this.removeFromReport(reportpanel, rptName, obj);
        }
    }

    private void removeFromReport(JetRptReportSet rptSet, String rptName, JetObject obj) throws RefResourceException {
        if (!this.isValidToUpdate(obj)) {
            return;
        }
        if (!this.refTool.isSupportReportType(rptName)) {
            return;
        }
        RefReport refRpt = new RefReport(this.currUniverse.getFilePath(), rptName);
        refRpt.setObject(rptSet);
        if (!this.isValidToUpdate(refRpt)) {
            return;
        }
        String[] dataSetIds = rptSet.getDataSetIds();
        for (int i = 0; i < dataSetIds.length; ++i) {
            String dsName = rptSet.getDataSet(dataSetIds[i]).getDataSourceName();
            int type = this.refTool.getType(refRpt);
            try {
                this.refManager.delReference(rptName, type, this.getName(obj), this.refTool.getType(obj), dsName);
                continue;
            }
            catch (CrossRefException e) {
                throw new RefResourceException("Remove object from report " + rptName + " failed", e);
            }
        }
        this.notifyRefChanged();
    }

    public void renameRefBeforeAction(JetObject objWithOldName, String newName, boolean renameReferredBy, Hashtable allOpenReferredReports, boolean isBVContext) throws RefResourceException {
        String oldName = this.getName(objWithOldName);
        String dsName = this.getDataSourceName(objWithOldName);
        boolean isValid = this.isValidToUpdate(objWithOldName);
        if (renameReferredBy) {
            this.renameAllReferredBy(objWithOldName, oldName, newName, renameReferredBy, allOpenReferredReports, isBVContext);
        }
        if (!isValid) {
            return;
        }
        int type = this.refTool.getType(objWithOldName);
        try {
            if (!renameReferredBy) {
                Vector referringObjs = this.refManager.getReferObjects(oldName, type, dsName);
                for (int i = 0; i < referringObjs.size(); ++i) {
                    ReferObject refObj = (ReferObject)referringObjs.elementAt(i);
                    this.refManager.delReference(oldName, type, refObj.getName(), refObj.getType(), dsName);
                    this.refManager.addReference(newName, type, refObj.getName(), refObj.getType(), dsName);
                }
            } else if (objWithOldName instanceof JetUDatabase) {
                this.refManager.updataDataSource(oldName, newName);
            } else {
                String nName = newName;
                if (objWithOldName instanceof BLNodeImpl) {
                    nName = this.getBVPrefix((BLNodeImpl)objWithOldName) + nName;
                }
                this.refManager.alterObjName(oldName, type, nName, dsName);
            }
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Rename RefObject in CrossRefManager failed", e);
        }
    }

    public Vector getUpdatedObjects() {
        return this.updatedObjects;
    }

    private void renameAllReferredBy(JetObject renamedObj, String oldName, String newName, boolean renameReferredBy, Hashtable allOpenReport, boolean isBVContext) throws RefResourceException {
        if (!renameReferredBy) {
            return;
        }
        Vector entities = this.getReferredEntityFromManager(renamedObj);
        if (renamedObj instanceof BLNodeImpl) {
            oldName = ((BLNodeImpl)renamedObj).getQualifyDisplayName();
        }
        this.updatedObjects = this.refTool.renameReferredEntities(renamedObj, entities, newName, oldName, this.getDatabase(renamedObj), allOpenReport, isBVContext);
    }

    private JetUDatabase getDatabase(JetObject renamedObj) {
        if (renamedObj instanceof JetUDBTreeNode) {
            return ((JetUDBTreeNode)renamedObj).getDatabase();
        }
        if (renamedObj instanceof BLNodeImpl) {
            return ((BLNodeImpl)renamedObj).getDatabase();
        }
        throw new IllegalArgumentException();
    }

    public Vector getReferredEntityFromManager(JetObject dbTreeNode) throws RefResourceException {
        Vector objs = null;
        Vector objSet = null;
        Vector dbReport = new Vector();
        if (dbTreeNode instanceof JetUDatabase) {
            JetUDatabase db = (JetUDatabase)dbTreeNode;
            dbReport = this.getReferedFromManager(db);
        }
        objSet = this.getReferedFromManager(dbTreeNode);
        for (int i = 0; i < dbReport.size(); ++i) {
            objSet.add(dbReport.get(i));
        }
        if (dbTreeNode instanceof JetUDBTreeNode) {
            objs = this.refTool.convertReferObjectToJetObject(objSet, ((JetUDBTreeNode)dbTreeNode).getDatabase(), null);
        } else if (dbTreeNode instanceof BLNodeImpl) {
            JUnifiedBusinessView ubv = ((BLNodeImpl)dbTreeNode).getUbv();
            objs = this.refTool.convertReferObjectToJetObject(objSet, ubv.getQuery().getDatabase(), ubv);
        }
        return objs;
    }

    public void exportToFile(String fullFileName) throws RefResourceException {
        try {
            this.refManager.exportReferences(fullFileName);
        }
        catch (CrossRefException e) {
            throw new RefResourceException("export to file: " + fullFileName + " failed", e);
        }
    }

    public void CreateCatalog(Vector allDS, Vector types) throws RefResourceException {
        this.addFiledTypes(types);
        try {
            this.loadCrossRefManager(allDS, types);
            this.insertAllRefObjects(allDS, types);
            this.refManager.saveCatalog();
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Create CrossRef Table failed", e);
        }
        this.notifyRefChanged();
    }

    private void addCubeTypes(Vector types) {
        Integer detType;
        Integer aggType;
        Integer gpType;
        Integer bvType;
        Integer cType = new Integer(16);
        if (!types.contains(cType)) {
            types.add(cType);
        }
        if (!types.contains(bvType = new Integer(17))) {
            types.add(bvType);
        }
        if (!types.contains(gpType = new Integer(12))) {
            types.add(gpType);
        }
        if (!types.contains(aggType = new Integer(13))) {
            types.add(aggType);
        }
        if (!types.contains(detType = new Integer(14))) {
            types.add(detType);
        }
    }

    public void RefreshCatalog() throws RefResourceException {
        if (!this.isCreated()) {
            return;
        }
        this.CreateCatalog(this.getCfgDsNames(), this.getCfgTypes());
    }

    private void addFiledTypes(Vector types) {
        Integer fieldType = new Integer(0);
        if (!types.contains(fieldType)) {
            types.add(fieldType);
        }
    }

    private void removeFieldType(Vector types) {
        Integer fieldType = new Integer(0);
        if (types.contains(fieldType)) {
            types.remove(fieldType);
        }
    }

    private void insertAllRefObjects(Vector ds, Vector types) throws CrossRefException {
        Vector refRelations = new Vector();
        refRelations.addAll(this.getReferRelations(ds, types));
        Vector allRefRpt = this.getAllRefReport();
        int i = allRefRpt.size();
        while (i-- > 0) {
            refRelations.addAll(this.getReferRealtion(ds, types, (RefReport)allRefRpt.remove(i)));
        }
        this.keepUnique(refRelations);
        this.refManager.importReferences(refRelations);
    }

    private Vector getReferRelations(Vector ds, Vector requiredTypes) {
        Vector result = new Vector();
        Vector allDS = this.currUniverse.getAllDatabases();
        Vector relationsInUDB = null;
        for (int i = 0; i < allDS.size(); ++i) {
            JetUDatabase udb = (JetUDatabase)allDS.elementAt(i);
            String dsName = udb.getResourceName();
            if (!ds.contains(dsName)) continue;
            try {
                relationsInUDB = this.getReferRelations(udb, requiredTypes);
            }
            catch (RefResourceException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error(e);
                continue;
            }
            result.addAll(relationsInUDB);
        }
        return result;
    }

    private Vector getReferRelations(JetUDatabase udb, Vector requiredTypes) throws RefResourceException {
        Vector relations = new Vector();
        String udbName = udb.name.get();
        Enumeration dbChildren = udb.getChildrenEnumeration();
        Vector cnns = udb.getConnections();
        for (int i = 0; i < cnns.size(); ++i) {
            JetUConnection conn = (JetUConnection)cnns.elementAt(i);
            Vector tables = conn.getTables();
            Vector views = conn.getViews();
            Vector procedures = conn.getProcedures();
            Vector fileQrys = conn.getFileQueries();
            Vector<JetUDatabase> database = new Vector<JetUDatabase>();
            database.add(udb);
            relations.addAll(this.getReferRelations(database, requiredTypes, udbName));
            relations.addAll(this.getReferRelations(tables, requiredTypes, udbName));
            relations.addAll(this.getReferRelations(views, requiredTypes, udbName));
            relations.addAll(this.getReferRelations(procedures, requiredTypes, udbName));
            relations.addAll(this.getReferRelations(fileQrys, requiredTypes, udbName));
        }
        while (dbChildren.hasMoreElements()) {
            JetObject dbChild = (JetObject)dbChildren.nextElement();
            if (dbChild instanceof JetUJDBCConnection || !this.refTool.isRequired(dbChild, requiredTypes)) continue;
            Vector referringObjs = this.refTool.getReferringObj(dbChild, this.currUniverse, null);
            referringObjs = this.filterByTypes(referringObjs, requiredTypes);
            relations.addAll(this.getReferRelations(dbChild, referringObjs, udbName));
            if (!(dbChild instanceof JUnifiedBusinessView)) continue;
            UnifiedBusinessView bv = (UnifiedBusinessView)dbChild;
            JetUDemandQuery q = bv.getQuery();
            Vector<JetUQueriable> rqs = q.getRefQueriables();
            if (rqs.size() > 0) {
                relations.addAll(this.getReferRelations(bv, rqs, udbName));
            }
            this.addBLNode(udbName, udb, relations, bv);
            this.addPrefilters(udb, relations, udbName, bv);
        }
        return relations;
    }

    private void addBLNode(String udbName, JetUDatabase udb, Vector relations, BLContainer blc) {
        BLNode[] nodes = blc.getBLChildren();
        JUnifiedBusinessView ubv = blc.getUbv();
        for (BLNode n : nodes) {
            boolean isCustomized = false;
            if (n instanceof DataElement) {
                Vector<JetUResourceEntity> tmp = new Vector<JetUResourceEntity>();
                isCustomized = n instanceof Measure ? ((Measure)n).isCustomized() : false;
                if (isCustomized) {
                    JetRptFormula rptFormula;
                    Measure m = (Measure)n;
                    JetUFormula uf = m.getJetUFormula();
                    if (uf == null || (rptFormula = uf.getRptFormula()) == null) continue;
                    rptFormula.setNameCollector(this.nc);
                    this.nc.setContext(ubv, m, udbName, relations);
                    try {
                        rptFormula.parseFormula(new FormulatoJava("temp", null));
                    }
                    catch (FormulaSyntaxErrorException e) {}
                    continue;
                }
                DataElement element = (DataElement)n;
                JetUResourceEntity o = udb.getResourceByName(null, element.getRefMappingName());
                if (o == null) continue;
                tmp.add(o);
                Vector rf = this.getReferRelations(element, tmp, udbName);
                relations.addAll(rf);
                continue;
            }
            if (!(n instanceof BLContainer)) continue;
            this.addBLNode(udbName, udb, relations, (BLContainer)n);
        }
    }

    private void addPrefilters(JetUDatabase udb, Vector relations, String udbName, JUnifiedBusinessView bl) {
        Vector tmp = null;
        FilterInfo[] prefilters = bl.getPrefilterInfo();
        if (prefilters != null) {
            for (int j = 0; j < prefilters.length; ++j) {
                tmp = this.getReferRelations((JetObject)((Object)prefilters[j]), prefilters[j].getReferredResourceEntities(), udbName);
                relations.addAll(tmp);
                tmp = this.getReferRelations((JetObject)((Object)prefilters[j]), prefilters[j].getReferredDataElements(), udbName);
                relations.addAll(tmp);
            }
        }
    }

    private Vector getReferRelations(Vector dbTreeNodes, Vector requiredTypes, String udbName) throws RefResourceException {
        Vector result = new Vector();
        for (int i = 0; i < dbTreeNodes.size(); ++i) {
            JetUDBTreeNode dbChild = (JetUDBTreeNode)dbTreeNodes.elementAt(i);
            if (!this.refTool.isRequired(dbChild, requiredTypes)) continue;
            Vector referringObjs = this.refTool.getReferringObj(dbChild, this.currUniverse, null);
            referringObjs = this.filterByTypes(referringObjs, requiredTypes);
            result.addAll(this.getReferRelations(dbChild, referringObjs, udbName));
        }
        return result;
    }

    private Vector getReferRelations(Vector ds, Vector requiredTypes, Vector allReports) {
        Vector relations = new Vector();
        if (!this.refTool.isRequired(11, requiredTypes)) {
            return relations;
        }
        for (int i = 0; i < allReports.size(); ++i) {
            RefReport refRpt = (RefReport)allReports.elementAt(i);
            relations.addAll(this.getReferRealtion(ds, requiredTypes, refRpt));
        }
        return relations;
    }

    private Vector getReferRealtion(Vector ds, Vector requiredTypes, RefReport refRpt) {
        Vector relations = new Vector();
        JetObject rptobj = null;
        try {
            rptobj = refRpt.loadReport(this.currUniverse);
        }
        catch (RefResourceException e) {
            if (logger.isErrorEnabled()) {
                logger.error(e);
            }
            return relations;
        }
        refRpt.setObject(rptobj);
        List<DataSet> datasets = refRpt.getUsedAllDataSets();
        for (DataSet dataset : datasets) {
            String dsName = dataset.getDataSourceName();
            if (!ds.contains(dsName)) continue;
            Vector rptReferringObjs = null;
            try {
                rptReferringObjs = this.refTool.getReferringObj(refRpt, this.currUniverse, null);
                rptReferringObjs = this.filterByTypes(rptReferringObjs, requiredTypes);
                relations.addAll(this.getReferRelations(refRpt, rptReferringObjs, dsName));
            }
            catch (RefResourceException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("Load Report Panel failed", e);
            }
        }
        return relations;
    }

    private Vector filterByTypes(Vector referringObjs, Vector requiredTypes) {
        Vector<JetObject> requiredObjs = new Vector<JetObject>();
        for (int i = 0; i < referringObjs.size(); ++i) {
            JetObject obj = (JetObject)referringObjs.elementAt(i);
            if (obj == null || !this.refTool.isRequired(obj, requiredTypes)) continue;
            requiredObjs.add(obj);
        }
        return requiredObjs;
    }

    private void keepUnique(Vector objects) {
        for (int i = 0; i < objects.size() - 1; ++i) {
            int j = i + 1;
            while (j < objects.size()) {
                Object second;
                Object first = objects.elementAt(i);
                if (first.equals(second = objects.elementAt(j))) {
                    objects.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private ReferObject getReferredByObject(BLNodeImpl node) throws RefResourceException {
        String name2 = this.getName(node);
        if (node instanceof Category) {
            return new ReferObject(name2, 16);
        }
        if (node instanceof Group) {
            return new ReferObject(name2, 12);
        }
        if (node instanceof Aggregation) {
            return new ReferObject(name2, 13);
        }
        if (node instanceof DetailInfo) {
            return new ReferObject(name2, 14);
        }
        throw new RefResourceException("Unknow Node Type!");
    }

    private Vector getReferRelations(JetObject from, Vector referringObjs, String dsName) {
        Vector<ReferRelation> result = new Vector<ReferRelation>();
        for (int i = 0; i < referringObjs.size(); ++i) {
            JetObject obj = (JetObject)referringObjs.elementAt(i);
            ReferRelation relation = null;
            try {
                relation = this.convertToRefReferlation(from, obj, dsName);
            }
            catch (RefResourceException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error(e);
                continue;
            }
            result.add(relation);
        }
        return result;
    }

    private ReferRelation convertToRefReferlation(JetObject from, JetObject to, String dsName) throws RefResourceException {
        String fromName = this.getName(from);
        int fromType = this.refTool.getType(from);
        String toName = this.getName(to);
        int toType = this.refTool.getType(to);
        return new ReferRelation(dsName, fromName, fromType, toName, toType);
    }

    private String getBVPrefix(BLNodeImpl dataElement) {
        JUnifiedBusinessView ubv = dataElement.getUbv();
        JetUDatabase udb = ubv.getDatabase();
        return udb.name.get() + "." + ubv.getDisplayName() + ".";
    }

    private String getName(JetObject obj) throws RefResourceException {
        String name2 = null;
        if (obj instanceof JetUDemandQuery) {
            name2 = ((JetUDemandQuery)obj).name.get();
        } else if (obj instanceof BLNodeImpl) {
            BLNodeImpl dataElement = (BLNodeImpl)obj;
            name2 = dataElement instanceof JUnifiedBusinessView ? dataElement.getQualifyDisplayName() : this.getBVPrefix(dataElement) + dataElement.getQualifyDisplayName();
        } else if (obj instanceof JetUDBTreeNode) {
            name2 = ((JetUDBTreeNode)obj).getResourceName();
        } else if (obj instanceof RefReport) {
            name2 = ((RefReport)obj).getFileName();
        } else {
            RefResourceException e = new RefResourceException("Can not get Name of Unknown type: " + obj);
            throw e;
        }
        return name2;
    }

    private void loadCrossRefManager(Vector dataSources, Vector requiredTypes) throws CrossRefException {
        String catName;
        String catPath = this.currUniverse.getFilePath();
        this.refManager = this.refTool.isEverCreatedDB(catPath, catName = this.currUniverse.getName()) ? this.loadOldRefManager(dataSources, requiredTypes) : this.createNewRefManager(dataSources, requiredTypes);
    }

    private void refreshRefManager(CrossRefManager referManager, Vector dataSources, Vector requiredTypes) {
        int i;
        for (i = 0; i < dataSources.size(); ++i) {
            String dsName = (String)dataSources.elementAt(i);
            referManager.addDataSource(dsName);
        }
        for (i = 0; i < requiredTypes.size(); ++i) {
            Integer type = (Integer)requiredTypes.elementAt(i);
            referManager.addType(type);
        }
    }

    private void clearRefManager(CrossRefManager referManager) throws CrossRefException {
        Vector existAllDS = (Vector)referManager.getDataSources().clone();
        for (int i = 0; i < existAllDS.size(); ++i) {
            String dsName = (String)existAllDS.elementAt(i);
            referManager.delDataSource(dsName);
        }
        Vector existTypes = (Vector)referManager.getReferTypes().clone();
        for (int i = 0; i < existTypes.size(); ++i) {
            Integer type = (Integer)existTypes.elementAt(i);
            referManager.delType(type);
        }
    }

    private CrossRefManager createNewRefManager(Vector dataSources, Vector requiredTypes) throws CrossRefException {
        String catPath = this.currUniverse.getFilePath();
        String catName = this.currUniverse.getName();
        CrossRefManager referManager = new CrossRefManager(catName, catPath, dataSources, requiredTypes);
        return referManager;
    }

    private CrossRefManager getOldRefManagerFromFile() throws CrossRefException {
        String catPath = this.currUniverse.getFilePath();
        String catName = this.currUniverse.getName();
        CrossRefManager referManager = new CrossRefManager(catName, catPath);
        return referManager;
    }

    private CrossRefManager loadOldRefManager(Vector dataSources, Vector requiredTypes) throws CrossRefException {
        CrossRefManager referManager = null;
        referManager = this.isCreated() ? this.refManager : this.getOldRefManagerFromFile();
        this.clearRefManager(referManager);
        this.refreshRefManager(referManager, dataSources, requiredTypes);
        return referManager;
    }

    public boolean isCreated() {
        return this.refManager != null;
    }

    public Vector getReferredBy(DefaultMutableTreeNode refereeNode) throws RefResourceException {
        if (!this.isCreated()) {
            throw new RefResourceException("No usable CrossRefManager!");
        }
        JetObject dbTreeNode = (JetObject)refereeNode.getUserObject();
        if (!this.isValidToUpdate(dbTreeNode)) {
            return new Vector();
        }
        Vector objs = this.getReferredEntityFromManager(dbTreeNode);
        return objs;
    }

    private Vector getReferedFromManager(JetObject jobj) throws RefResourceException {
        String dsName = this.getDataSourceName(jobj);
        String objName = this.getName(jobj);
        int objType = this.refTool.getType(jobj);
        Vector allReferredBy = null;
        try {
            allReferredBy = this.refManager.getReferredByObject(objName, objType, dsName);
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Get RefferredBy from CrossRefManager failed", e);
        }
        Vector cubeNode = new Vector();
        if (jobj instanceof Category) {
            Category category = (Category)jobj;
            this.refTool.getCategory(category, cubeNode);
            this.refTool.getGroup(category, cubeNode);
            this.refTool.getAggregations(category, cubeNode);
            this.refTool.getDetails(category, cubeNode);
            int iLen = cubeNode.size();
            for (int i = 0; i < iLen; ++i) {
                allReferredBy.add(this.getReferredByObject((BLNodeImpl)cubeNode.get(i)));
            }
        }
        return allReferredBy;
    }

    public boolean isRequired(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JetObject)) {
            return false;
        }
        if (!this.isCreated()) {
            return false;
        }
        Vector requiredTypes = this.refManager.getReferTypes();
        return this.refTool.isRequired((JetObject)obj, requiredTypes);
    }

    private Vector getAllRefReport() {
        Vector<RefReport> allRefRpt = new Vector<RefReport>();
        Vector allFileNames = this.refTool.searchReportByCatPath(this.currUniverse.getFilePath());
        for (int i = 0; i < allFileNames.size(); ++i) {
            String fileName = (String)allFileNames.elementAt(i);
            RefReport refRpt = new RefReport(this.currUniverse.getFilePath(), fileName);
            allRefRpt.add(refRpt);
        }
        return allRefRpt;
    }

    public void closeReport(JetRptReportSet rptSet, String reportName, boolean shouldSave) throws RefResourceException {
        if (!this.isCreated()) {
            return;
        }
        if (!this.refTool.isSupportReportType(reportName)) {
            return;
        }
        RefReport refRpt = new RefReport(this.currUniverse.getFilePath(), reportName);
        refRpt.setObject(rptSet);
        if (!this.isValidToUpdate(refRpt)) {
            return;
        }
        try {
            this.refManager.closeReport(reportName, shouldSave);
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Closing report in Reference Table failed: " + reportName, e);
        }
    }

    public void saveCatalog() throws RefResourceException {
        if (!this.isCreated()) {
            return;
        }
        try {
            this.refManager.saveCatalog();
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Save Catalog To CrossRef Table failed", e);
        }
    }

    public void saveAsReport(JetObject rptSet, String newRptName, String oldRptName) throws RefResourceException {
        RefReport refRpt;
        block5: {
            if (!this.isCreated()) {
                return;
            }
            if (!this.refTool.isSupportReportType(newRptName)) {
                return;
            }
            refRpt = new RefReport(this.currUniverse.getFilePath(), newRptName);
            refRpt.setObject(rptSet);
            if (!this.isValidToUpdate(refRpt)) {
                return;
            }
            try {
                this.refManager.closeReport(oldRptName, false);
            }
            catch (CrossRefException e) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error(e);
            }
        }
        this.saveAsReport(newRptName, refRpt);
    }

    public void saveReport(JetObject rptSet, String reportName) throws RefResourceException {
        if (!this.isCreated()) {
            return;
        }
        if (!this.refTool.isSupportReportType(reportName)) {
            return;
        }
        RefReport refRpt = new RefReport(this.currUniverse.getFilePath(), reportName);
        refRpt.setObject(rptSet);
        if (!this.isValidToUpdate(refRpt)) {
            return;
        }
        try {
            this.refManager.saveReport(reportName);
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Save report " + reportName + " To CrossRef Table failed", e);
        }
    }

    private void saveAsReport(String reportName, RefReport refRpt) throws RefResourceException {
        Vector allReferring = this.refTool.getReferringObj(refRpt, this.currUniverse, null);
        allReferring = this.filterByTypes(allReferring, this.refManager.getReferTypes());
        List<DataSet> datasets = refRpt.getUsedAllDataSets();
        for (DataSet ds : datasets) {
            String dsName = ds.getDataSourceName();
            Vector referRelations = this.getReferRelations(refRpt, allReferring, dsName);
            this.keepUnique(referRelations);
            try {
                this.refManager.importReferences(referRelations);
            }
            catch (CrossRefException e) {
                throw new RefResourceException("Saveas report failed: " + reportName, e);
            }
        }
        this.notifyRefChanged();
    }

    public void addRefListener(IReferenceListener listener) {
        if (!this.allListeners.contains(listener)) {
            this.allListeners.add(listener);
        }
    }

    public void removeRefListener(IReferenceListener listener) {
        if (this.allListeners.contains(listener)) {
            this.allListeners.remove(listener);
        }
    }

    public void notifyRefChanged() {
        for (int i = 0; i < this.allListeners.size(); ++i) {
            IReferenceListener listener = (IReferenceListener)this.allListeners.elementAt(i);
            listener.refRefresh();
        }
    }

    public static void deleteDatabase() {
        if (instance == null || ReferenceResource.instance.currUniverse == null || !instance.isCreated()) {
            return;
        }
        String catPath = ReferenceResource.instance.currUniverse.getFilePath();
        String catName = ReferenceResource.instance.currUniverse.getName();
        String suffix = "_ref";
        String delStr = catPath + catName + suffix;
        instance.exit();
        CrossRefManager.deleteDatabase(delStr);
    }

    private Vector getReferedFromManager(JetUDatabase jobj) throws RefResourceException {
        String dsName = this.getDataSourceName(jobj);
        String objName = this.getName(jobj);
        int objType = this.refTool.getType(jobj);
        Vector allReferredBy = null;
        try {
            allReferredBy = this.refManager.getReportByDataSourceName(objName, objType, dsName);
            this.keepUnique(allReferredBy);
        }
        catch (CrossRefException e) {
            throw new RefResourceException("Get RefferredBy from CrossRefManager failed", e);
        }
        return allReferredBy;
    }

    public void delReferenceResource(String datasourceName, String fromObj, int fromObjType) {
        try {
            if (this.refManager != null) {
                this.refManager.delReferResource(datasourceName, fromObj, fromObjType);
            }
        }
        catch (CrossRefException e) {
            // empty catch block
        }
    }

    class QDNameCollector
    implements NameCollector {
        private JUnifiedBusinessView ubv;
        private Measure m;
        private String udbName;
        private Vector relations;
        Vector tmp = new Vector();

        QDNameCollector() {
        }

        public void setContext(JUnifiedBusinessView ubv, Measure m, String udbName, Vector relations) {
            this.ubv = ubv;
            this.m = m;
            this.udbName = udbName;
            this.relations = relations;
        }

        @Override
        public void startParse(String formulaExp) {
            this.tmp.clear();
        }

        @Override
        public void foundName(String name2, boolean isCTF) {
            BLNode bln = this.ubv.getByDisplayName(name2);
            if (bln != null) {
                this.tmp.add(bln);
            }
        }

        @Override
        public void endParse(boolean hasError) {
            Vector v = ReferenceResource.this.getReferRelations(this.m, this.tmp, this.udbName);
            this.relations.addAll(v);
        }
    }
}

