/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.Vector;
import jet.controls.JetObject;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine.api.expression.variable.IUnCheckedVariableExpression;
import jet.dataengine.util.StringTools;
import jet.formula.FormulaContainer;
import jet.formula.JetRptFormula;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.universe.DefaultNameCollector;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUProcParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQuery;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.Replacement;
import jet.universe.SyntaxTreeCreator;
import jet.universe.UniverseUtil;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.psql.FileQuery;
import jet.universe.psql.RptPsqlFormulaColumn;
import jet.universe.psql.RptPsqlQuery;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlUnion;

public class RenameTool {
    private SyntaxTreeCreator syntaxTree;
    Replacement replacer = null;
    DefaultNameCollector nc = null;

    public RenameTool(JetUDatabase database, Replacement replacer) {
        this((FormulaContainer)database, replacer);
    }

    public RenameTool(FormulaContainer fc, Replacement replacer) {
        this.nc = new DefaultNameCollector();
        this.syntaxTree = new SyntaxTreeCreator(fc, this.nc);
        this.replacer = replacer;
    }

    public RenameTool() {
    }

    public void updateFormula(JetUFormula formulaToUpdate, String oldName, String newName) {
        String oldExp = formulaToUpdate.getExpression();
        this.nc.setNames(oldName, newName);
        this.syntaxTree.parseFormula(formulaToUpdate.getResourceName());
        if (this.syntaxTree.hasError()) {
            return;
        }
        String newExpression = this.nc.getNewFormulaExp();
        if (!newExpression.equalsIgnoreCase(oldExp)) {
            formulaToUpdate.setExpression(newExpression);
        }
    }

    public void updateFormula(JetRptFormula rptFormula, String oldName, String newName) {
        String oldExp = rptFormula.getExpression();
        this.nc.setNames(oldName, newName);
        this.syntaxTree.parseFormula(rptFormula);
        if (this.syntaxTree.hasError()) {
            return;
        }
        rptFormula.setExpression(this.nc.getNewFormulaExp());
    }

    public void updateSummary(JetUSummary summaryToUpdate, String oldName, String newName) {
        String groupBy;
        if (summaryToUpdate.getFieldName().equalsIgnoreCase(oldName)) {
            summaryToUpdate.setFieldName(newName);
        }
        if ((groupBy = summaryToUpdate.getGroupByFld()) == null) {
            return;
        }
        if (groupBy.equalsIgnoreCase(oldName)) {
            summaryToUpdate.setGroupByFld(newName);
        }
    }

    public void updateQueryDBName(JetUDatabase database, String newName) {
        JetUUniverse univer = database.getUniverse();
        JetUDatabase db = database;
        Enumeration dbChildren = db.getChildrenEnumeration();
        while (dbChildren.hasMoreElements()) {
            Object o = dbChildren.nextElement();
            if (!(o instanceof JetUQuery)) continue;
            JetUQuery query = (JetUQuery)o;
            RptPsqlQuery rpsqlQuery = query.getPsqlQuery();
            rpsqlQuery.setUniverse(univer, newName);
        }
    }

    private void updateQuerySearchGroup(JetUQuery queryToUpdate, String oldName, String newName) {
        RptPsqlQuery psqlQuery = queryToUpdate.psqlQuery;
        Vector searchGroups = psqlQuery.vSCGrps;
        if (searchGroups != null) {
            for (int i = 0; i < searchGroups.size(); ++i) {
                Vector v = (Vector)searchGroups.elementAt(i);
                for (int j = 0; j < v.size(); ++j) {
                    String right;
                    String[] andCondition = (String[])v.elementAt(j);
                    String left = andCondition[0];
                    if (left.startsWith("@") && left.substring(1).equalsIgnoreCase(oldName)) {
                        andCondition[0] = left = "@" + newName;
                    }
                    if ((right = andCondition[2]).startsWith("@") && right.substring(1).equalsIgnoreCase(oldName)) {
                        andCondition[2] = right = "@" + newName;
                    }
                    v.set(j, andCondition);
                }
            }
        }
    }

    public void updateQueryField(JetUQuery queryToUpdate, String oldName, String newName) {
        queryToUpdate.replaceFldName(oldName, newName);
        RptPsqlQuery psqlQuery = queryToUpdate.psqlQuery;
        Vector selectedColumns = psqlQuery.vSelCols;
        for (int i = 0; i < selectedColumns.size(); ++i) {
            String expression;
            PsqlSelColumn selColumn = (PsqlSelColumn)selectedColumns.elementAt(i);
            if (!selColumn.isCompCol() || selColumn instanceof RptPsqlFormulaColumn || (expression = selColumn.sExpression) == null || (expression = UniverseUtil.replaceName(expression, oldName, newName)) == null) continue;
            selColumn.sExpression = expression;
        }
        String oldName_U = oldName.toUpperCase();
        Vector c = psqlQuery.getPsqlJoinsVector();
        int iLen = c.size();
        for (int i = 0; i < iLen; ++i) {
            if (!(c.get(i) instanceof PsqlJoin)) continue;
            PsqlJoin join = (PsqlJoin)c.get(i);
            IExpression joinExp = join.getJoinCondition();
            IUnCheckedVariableExpression[] vars = ExpressionToolKit.getUnCheckedVariableExpressions((IUnCheckedExpression)joinExp);
            int kLen = vars.length;
            for (int k = 0; k < kLen; ++k) {
                String s = vars[k].getValue().toUpperCase();
                String fn = s.substring(s.lastIndexOf(46) + 1);
                if (StringTools.isEmptyStringWithTrim(fn) || !fn.equals(oldName_U)) continue;
                String pfix = s.substring(0, s.lastIndexOf(46) + 1);
                String nn = pfix + newName;
                vars[k].setValue(nn);
            }
            join.setJoinCondition(joinExp);
        }
        queryToUpdate.setPsqlQuery(queryToUpdate.psqlQuery);
    }

    public void updateQueryTable(JetUQuery queryToUpdate, String oldName, String newName) {
        queryToUpdate.replaceTabName(oldName, newName);
        queryToUpdate.setPsqlQuery(queryToUpdate.psqlQuery);
    }

    public void updateQueryFPQ(JetUQuery queryToUpdate, String oldName, String newName) {
        RptPsqlQuery psqlQuery = queryToUpdate.psqlQuery;
        Vector selectedColumns = psqlQuery.vSelCols;
        for (int i = 0; i < selectedColumns.size(); ++i) {
            String expression;
            PsqlSelColumn selColumn = (PsqlSelColumn)selectedColumns.elementAt(i);
            Vector QBEConditions = selColumn.getConditionsVector();
            if (QBEConditions != null) {
                for (int j = 0; j < QBEConditions.size(); ++j) {
                    int index;
                    String gridCondition = (String)QBEConditions.elementAt(j);
                    if (gridCondition == null || (index = gridCondition.indexOf("@")) < 0) continue;
                    String substr = gridCondition.substring(0, index + 1);
                    gridCondition = substr + newName;
                    QBEConditions.set(j, gridCondition);
                }
            }
            if (selColumn instanceof RptPsqlFormulaColumn) {
                if (!selColumn.name.equalsIgnoreCase(oldName)) continue;
                selColumn.mappingName = newName;
                selColumn.name = newName;
                continue;
            }
            if (!selColumn.isCompCol() || (expression = selColumn.sExpression) == null || (expression = UniverseUtil.replaceName(expression, oldName, newName)) == null) continue;
            selColumn.sExpression = expression;
        }
        this.updateQuerySearchGroup(queryToUpdate, oldName, newName);
        IUnCheckedExpression expression = (IUnCheckedExpression)psqlQuery.getSearchConditionGroups();
        ExpressionToolKit.replaceAllName(expression, oldName, newName);
        queryToUpdate.setPsqlQuery(queryToUpdate.psqlQuery);
    }

    public void updateQueryFormula(JetUQuery queryToUpdate, String oldName, String newName) {
        this.updateQueryFPQ(queryToUpdate, oldName, newName);
    }

    public void updateQueryParameter(JetUQuery queryToUpdate, String oldName, String newName) {
        this.updateQueryFPQ(queryToUpdate, oldName, newName);
    }

    public void updateQuerySubquery(JetUQuery queryToUpdate, String oldName, String newName) {
        this.updateQueryFPQ(queryToUpdate, oldName, newName);
    }

    public void updateQueryUnion(JetUQuery queryToUpdate, String oldName, String newName) {
        RptPsqlQuery psqlQuery = queryToUpdate.psqlQuery;
        Vector unions = psqlQuery.getUnionVector();
        for (int i = 0; i < unions.size(); ++i) {
            PsqlUnion theUnion = (PsqlUnion)unions.elementAt(i);
            if (!theUnion.getUnionQuery().equalsIgnoreCase(oldName)) continue;
            theUnion.setUnionQuery(newName);
        }
        queryToUpdate.setPsqlQuery(queryToUpdate.psqlQuery);
    }

    protected String replaceParamName(String rawString, String oldName, String newName, String prefix) {
        String tmpStr = rawString;
        String updatedStr = "";
        String paramName = null;
        int index = tmpStr.indexOf(prefix);
        while (index >= 0) {
            updatedStr = updatedStr + tmpStr.substring(0, index + 1);
            if ((tmpStr = tmpStr.substring(index + 1)).length() < oldName.length()) break;
            paramName = tmpStr.substring(0, oldName.length());
            if (paramName.equalsIgnoreCase(oldName)) {
                if (tmpStr.length() == oldName.length()) {
                    updatedStr = updatedStr + newName;
                    tmpStr = "";
                } else {
                    char c = tmpStr.charAt(oldName.length());
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9')) {
                        updatedStr = updatedStr + newName;
                        tmpStr = tmpStr.substring(oldName.length());
                    }
                }
            }
            index = tmpStr.indexOf(prefix);
        }
        if (tmpStr != null) {
            updatedStr = updatedStr + tmpStr;
        }
        return updatedStr;
    }

    public void updateFileQuery(JetUFileQuery fQueryToUpdate, String oldName, String newName) {
        FileQuery fileQuery = fQueryToUpdate.fileQuery;
        fileQuery.update(oldName, newName);
        String sqlStatement = fileQuery.getOriginalStatement();
        if (sqlStatement == null || sqlStatement.length() == 0) {
            sqlStatement = fileQuery.getStatement();
        }
        sqlStatement = this.replaceParamName(sqlStatement, oldName, newName, "@");
        sqlStatement = this.replaceParamName(sqlStatement, oldName, newName, ":");
        fileQuery.setStatement(sqlStatement);
        fQueryToUpdate.objectModified();
        JetUUniverse.objectChanged(fQueryToUpdate.getUniverse(), fQueryToUpdate, 1002);
    }

    public void updateFileQueryField(JetUFileQuery fQueryToUpdate, String oldName, String newName) {
        Vector selColumns = fQueryToUpdate.getFields();
        for (int i = 0; i < selColumns.size(); ++i) {
            JetUFileQueryField col = (JetUFileQueryField)selColumns.elementAt(i);
            if (!col.getResourceName().equalsIgnoreCase(oldName)) continue;
            col.setResourceName(newName);
        }
    }

    public void updateUDSParameter(JetUUserDataSource uds, String oldName, String newName) {
        String param = uds.getParameter();
        param = this.replaceParamName(param, oldName, newName, "@");
        uds.setParameter(param);
    }

    public void updateProcedureParameter(JetUProcedure procToUpdate, String oldName, String newName) {
        Vector paramVec = procToUpdate.getParameters();
        for (int i = 0; i < paramVec.size(); ++i) {
            JetUProcParameter procParam = (JetUProcParameter)paramVec.elementAt(i);
            if (!procParam.getResourceName().equalsIgnoreCase(oldName)) continue;
            procParam.setResourceName(newName);
        }
    }

    public void replace(JetObject root, Boolean isQueriable, String oldVal, String newVal, boolean isBVContext) {
        if (this.replacer == null) {
            return;
        }
        String prop = "Name_";
        this.replacer.replace(root, null, prop, oldVal, newVal, isQueriable, isBVContext);
    }

    public void replace(String src, Boolean isQueriable, String oldVal, String newVal, boolean isBVContext) throws ReadFailureException, WriteFailureException {
        if (this.replacer == null) {
            return;
        }
        String prop = "Name_";
        this.replacer.replace(src, src, null, prop, oldVal, newVal, isQueriable, isBVContext);
    }

    public void updateReportDBField(JetObject reportToUpdate, String oldName, String newName, boolean isBVContext) {
        this.replace(reportToUpdate, (Boolean)false, oldName, newName, isBVContext);
    }

    public void updateReportParameter(JetObject reportToUpdate, String oldName, String newName, boolean isBVContext) {
        this.replace(reportToUpdate, (Boolean)false, oldName, newName, isBVContext);
    }

    public void updateReportFormula(JetObject reportToUpdate, String oldName, String newName, boolean isBVContext) {
        this.updateReportDBField(reportToUpdate, oldName, newName, isBVContext);
    }

    public void updateCategory(Category category, String oldName, String newName) throws Exception {
        category.setName(newName);
    }

    public void updateBusinessLogic(UnifiedBusinessView bl, String oldName, String newName) throws Exception {
        bl.setName(newName);
    }
}

