/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import chart.ChartDefinition;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetBLColumnable;
import jet.controls.JetColumnName;
import jet.controls.JetColumnable;
import jet.controls.JetMappingTable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.formula.JetRptFormula;
import jet.ireport.IDataContainer;
import jet.ireport.IReport;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.report.ChartDefine;
import jet.report.JetChartProperty;
import jet.report.JetLink;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptSubLink;
import jet.report.SubReportLinks;
import jet.report.chart.JetRptChartPlatform;
import jet.report.conditionalFormatting.JetRptReportFormulaClassSet;
import jet.report.conditionalFormatting.JetRptReportUFormulaSet;
import jet.report.crosstabFormula.compiler.CrosstabFormulaCompiler;
import jet.report.crosstabFormula.compiler.CrosstabFormulaContainer;
import jet.report.filter.JetFilterExpression;
import jet.report.filter.variable.JetFormulaExpression;
import jet.report.filter.variable.JetParameterExpression;
import jet.report.filter.variable.JetReferenceExpression;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.formula.compiler.AbstractFormulaContainer;
import jet.report.link.URLPattern;
import jet.report.mode.actions.argExp.JetRptAtomicParamColumnArgExp;
import jet.report.onTheFlyFormula.DCScope;
import jet.report.onTheFlyFormula.JetRptFlyFormulaMeasureSet;
import jet.report.onTheFlyFormula.JetRptFlyMeasure;
import jet.report.onTheFlyFormula.Scope;
import jet.report.onTheFlyFormula.compiler.OnTheFlyFormulaCompiler;
import jet.report.onTheFlyFormula.compiler.OnTheFlyFormulaContainer;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.universe.JetUFormula;
import jet.universe.JetUUniverse;
import jet.universe.RefReport;
import jet.universe.RenameTool;
import jet.util.LinkPar;
import jet.util.TreeIterater;

public class Replacement {
    static final Hashtable<String, String> mapping = new Hashtable();
    private ResourceStore resourceStore;
    private final JetUUniverse unvInst;

    public Replacement(JetUUniverse unv) {
        this(unv, null);
    }

    public Replacement(JetUUniverse unv, ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
        this.unvInst = unv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String src, String dest, String cat, String infos) throws ReadFailureException, WriteFailureException, IOException, ClassNotFoundException {
        JetObject root = null;
        try {
            root = RefReport.loadObject(src, this.unvInst, this.resourceStore);
        }
        catch (ReadFailureException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ReadFailureException(e);
        }
        FileReader fr = null;
        BufferedReader reader = null;
        try {
            String line;
            fr = new FileReader(new File(infos));
            reader = new LineNumberReader(fr);
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                Vector<String> tokens = this.parse(line);
                int size = tokens.size();
                if (size == 3) {
                    this.replace(root, null, tokens.elementAt(0), tokens.elementAt(1), tokens.elementAt(2), false, false);
                    continue;
                }
                this.replace(root, this.getClass(tokens.elementAt(0)), tokens.elementAt(1), tokens.elementAt(2), tokens.elementAt(3), false, false);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                }
                finally {
                    reader = null;
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable e) {
                }
                finally {
                    fr = null;
                }
            }
        }
        if (src.equals(dest)) {
            this.saveToBack(src);
        }
        this.save(root, dest);
    }

    public void replace(String src, String dest, Class obj, String prop, String oldVal, String newVal, Boolean isQueriable, boolean isBVContext) throws ReadFailureException, WriteFailureException {
        JetObject root = null;
        try {
            root = RefReport.loadObject(src, this.unvInst, this.resourceStore);
        }
        catch (ReadFailureException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ReadFailureException(e);
        }
        this.replace(root, obj, prop, oldVal, newVal, isQueriable, isBVContext);
        if (src.equals(dest)) {
            this.saveToBack(src);
        }
        this.save(root, dest);
    }

    public void replace(JetObject root, Class obj, String prop, String oldVal, String newVal, boolean isBVorQNameOnly, boolean isBVContext) {
        this.replaceImpl(root, obj, oldVal, newVal, isBVorQNameOnly, isBVContext);
    }

    private void replaceImpl(JetObject root, Class obj, String oldVal, String newVal, boolean isBVorQNameOnly, boolean isBVContext) {
        String key;
        Hashtable properties;
        JetObject o;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Replacement#replace(" + root + "," + obj + "," + oldVal + "," + newVal + "," + isBVorQNameOnly + "," + isBVContext + ") with unv= " + this.unvInst + ", START");
        }
        TreeIterater iter = new TreeIterater(root, false, true);
        Vector<Object> noChgByProperties = new Vector<Object>();
        Vector<JetObject> flyResources = new Vector<JetObject>();
        if (isBVorQNameOnly) {
            while ((o = (JetObject)iter.next()) != null) {
                Map.Entry entry;
                if (obj != null && !obj.isInstance(o)) continue;
                properties = o.getProperties();
                Iterator iterator = properties.entrySet().iterator();
                if (isBVContext) {
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        key = (String)entry.getKey();
                        if (!(key = key.toLowerCase()).contains("blname") && !key.contains("bvname") && !key.contains("rcname") && !key.contains("bcname")) continue;
                        noChgByProperties.add(entry.getValue());
                    }
                    continue;
                }
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    key = (String)entry.getKey();
                    if (!(key = key.toLowerCase()).contains("queryname")) continue;
                    noChgByProperties.add(entry.getValue());
                }
            }
        } else {
            while ((o = (JetObject)iter.next()) != null) {
                if (obj != null && !obj.isInstance(o)) continue;
                if (o instanceof JetFilterExpression) {
                    this.replaceImpl_RefNameInJetExpression((JetFilterExpression)o, oldVal, newVal, isBVContext);
                } else if (o instanceof JetRptChartPlatform) {
                    this.replaceImpl_ChartDefinition((JetRptChartPlatform)o, oldVal, newVal, isBVContext);
                } else if (o instanceof JetRptFlyFormulaMeasureSet) {
                    flyResources.add((JetRptFlyFormulaMeasureSet)o);
                } else if (o instanceof JetRptAtomicParamColumnArgExp) {
                    this.replaceImpl_CusActArgumentExp((JetRptAtomicParamColumnArgExp)o, oldVal, newVal);
                    iter.skipBranch();
                }
                properties = o.getProperties();
                for (Map.Entry entry : properties.entrySet()) {
                    boolean isAutoNow;
                    String oStr;
                    key = (String)entry.getKey();
                    JetProperty property = (JetProperty)entry.getValue();
                    String lkey = key.toLowerCase();
                    if (lkey.contains("dsname") || lkey.contains("datasourcename")) {
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (key.equals("additionalMappingNames")) {
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (key.equals("BindColumn")) {
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (key.equals("BindDataName")) {
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (key.equals("ParentCol")) {
                        noChgByProperties.add(property);
                    } else if (key.equals("ChildCol")) {
                        noChgByProperties.add(property);
                    } else if (key.equals("BasedOnSpecified") || key.equals("ShowValueName")) {
                        noChgByProperties.add(property);
                    }
                    if (isBVContext) {
                        if (property.isChangeByBL()) {
                            oStr = (String)property.getChangeByBL();
                            if (!oStr.equalsIgnoreCase(oldVal)) continue;
                            isAutoNow = property.isCurrentAutoValue();
                            property.setChangeByBL(newVal, property.getChangeByBLType());
                            if (isAutoNow) {
                                property.setAsAutoValue(true);
                            }
                            if (!JRLog.isTrace(6)) continue;
                            JRLog.trace(6, "Replacement#" + property.getParent() + "'s " + property.getName() + " has updated ChangedBy(OTH) from \"" + oStr + "\" to \"" + oldVal + "\"");
                            continue;
                        }
                        if (property instanceof JetBLColumnable) {
                            noChgByProperties.add(property);
                            continue;
                        }
                        if (!(property instanceof JetLink)) continue;
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (property.isChangeByOther()) {
                        oStr = (String)property.getChangeByObject();
                        if (!oStr.equalsIgnoreCase(oldVal)) continue;
                        isAutoNow = property.isCurrentAutoValue();
                        property.setChangeByObject(newVal, property.getChangeByBLType());
                        if (isAutoNow) {
                            property.setAsAutoValue(true);
                        }
                        if (!JRLog.isTrace(6)) continue;
                        JRLog.trace(6, "Replacement#" + property.getParent() + "'s " + property.getName() + " has updated ChangedBy(BL) from \"" + oStr + "\" to \"" + oldVal + "\"");
                        continue;
                    }
                    if (property instanceof JetColumnable) {
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (property instanceof JetLink) {
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (key.contains("DetailJoin")) {
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (key.contains("DetailCols")) {
                        noChgByProperties.add(property);
                        continue;
                    }
                    if (!key.contains("SubColumn")) continue;
                    noChgByProperties.add(property);
                }
            }
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "Replacement#replace(" + root + "," + obj + "," + oldVal + "," + newVal + "," + isBVorQNameOnly + "," + isBVContext + ") with unv= " + this.unvInst + ", 1/4");
        }
        for (JetProperty jetProperty : noChgByProperties) {
            if (jetProperty instanceof JetLink) {
                this.replaceImpl_LinkProperties((JetLink)jetProperty, oldVal, newVal, isBVContext);
                continue;
            }
            if (jetProperty instanceof JetChartProperty) {
                this.replaceImpl_ChartPropertyOnly((JetChartProperty)jetProperty, oldVal, newVal);
                continue;
            }
            if (jetProperty instanceof JetString) {
                this.replaceImpl_StringProperty((JetString)jetProperty, oldVal, newVal);
                continue;
            }
            if (!(jetProperty instanceof JetVector)) continue;
            this.replaceImpl_ListProperty((JetVector)jetProperty, oldVal, newVal);
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "Replacement#replace(" + root + "," + obj + "," + oldVal + "," + newVal + "," + isBVorQNameOnly + "," + isBVContext + ") with unv= " + this.unvInst + ", 2/4");
        }
        if (root instanceof JetRptReportSet) {
            JetRptReportSet jetRptReportSet = (JetRptReportSet)root;
            String[] rptNames = jetRptReportSet.getAllReportsName();
            for (int i = 0; i < rptNames.length; ++i) {
                JetRptReport rpt = jetRptReportSet.getReport(rptNames[i]);
                if (rpt == null) continue;
                this.processConditionalFormatting(rpt);
            }
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "Replacement#replace(" + root + "," + obj + "," + oldVal + "," + newVal + "," + isBVorQNameOnly + "," + isBVContext + ") with unv= " + this.unvInst + ", 3/4");
        }
        this.processFlyResource(flyResources, oldVal, newVal, isBVContext);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Replacement#replace(" + root + "," + obj + "," + oldVal + "," + newVal + "," + isBVorQNameOnly + "," + isBVContext + ") with unv= " + this.unvInst + ", END");
        }
    }

    private void replaceImpl_LinkProperties(JetLink linkProp, String oldVal, String newVal, boolean isBVContext) {
        int type = linkProp.getLinkType();
        if (type == 0 || type == 2) {
            JetObject linkOwner;
            JetMappingTable linkCondi;
            SubReportLinks l;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Replacement#" + linkProp.getParent().getInstNameDirectly() + "'s LinkToREPORT/LC/FILTER START!");
            }
            if ((l = linkProp.getLink()) != null && l.links != null) {
                JetRptSubLink sub;
                int i;
                if (isBVContext) {
                    for (i = 0; i < l.links.size(); ++i) {
                        sub = (JetRptSubLink)l.links.elementAt(i);
                        this.replaceImpl_StringProperty(sub.blMainColumn, oldVal, newVal);
                        this.replaceImpl_StringProperty(sub.blSubColumn, oldVal, newVal);
                    }
                } else {
                    for (i = 0; i < l.links.size(); ++i) {
                        sub = (JetRptSubLink)l.links.elementAt(i);
                        this.replaceImpl_StringProperty(sub.mainColumn, oldVal, newVal);
                        this.replaceImpl_StringProperty(sub.subColumn, oldVal, newVal);
                    }
                }
            }
            if ((linkCondi = (JetMappingTable)(linkOwner = linkProp.getParent()).nameToProperty("LinkTargetCompCondition")) != null) {
                Map condiMap = linkCondi.getMappingHash();
                Iterator mapIt = condiMap.entrySet().iterator();
                boolean hasOne = false;
                while (mapIt.hasNext()) {
                    Map.Entry entry = mapIt.next();
                    List condiStrVec = (List)entry.getValue();
                    for (int cI = 0; cI < condiStrVec.size(); ++cI) {
                        String s = (String)condiStrVec.get(cI);
                        if (s == null || s.trim().length() == 0) continue;
                        LinkPar par = new LinkPar(s);
                        if (!par.left.startsWith("[") && par.left.equalsIgnoreCase(oldVal)) {
                            par.left = newVal;
                            hasOne = true;
                        }
                        if (par.right.equalsIgnoreCase(oldVal)) {
                            par.right = newVal;
                            hasOne = true;
                        }
                        condiStrVec.set(cI, par.toString());
                    }
                }
                if (hasOne && JRLog.isTrace(6)) {
                    JRLog.trace(6, "Replacement#" + linkProp.getParent().getInstNameDirectly() + "'s LinkCondition Updated!");
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Replacement#" + linkProp.getParent().getInstNameDirectly() + "'s LinkToREPORT/LC/FILTER END!");
            }
        } else {
            List patterns = linkProp.getURLPatternList();
            if (patterns != null) {
                boolean isHasOne = false;
                Vector<URLPattern> newPatterns = new Vector<URLPattern>(patterns.size());
                for (URLPattern p : patterns) {
                    String name2;
                    if (p.getPatternType() == 2) {
                        if (isBVContext) {
                            name2 = p.getBLPatternValue();
                            if (oldVal.equalsIgnoreCase(name2)) {
                                newPatterns.add(new URLPattern(p.getPatternValue(), newVal.toUpperCase()));
                                isHasOne = true;
                                continue;
                            }
                            newPatterns.add(p);
                            continue;
                        }
                        name2 = p.getPatternValue();
                        if (oldVal.equalsIgnoreCase(name2)) {
                            newPatterns.add(new URLPattern(newVal.toUpperCase(), p.getBLPatternValue()));
                            isHasOne = true;
                            continue;
                        }
                        newPatterns.add(p);
                        continue;
                    }
                    if (p.getPatternType() == 4) {
                        name2 = p.getPatternValue();
                        if (oldVal.equalsIgnoreCase(name2)) {
                            newPatterns.add(new URLPattern(4, newVal, new String[0]));
                            isHasOne = true;
                            continue;
                        }
                        newPatterns.add(p);
                        continue;
                    }
                    newPatterns.add(p);
                }
                if (isHasOne) {
                    linkProp.setURLPatternList(newPatterns);
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "Replacement#" + linkProp.getParent().getInstNameDirectly() + ",s LinkToURL/Mail has updated!");
                    }
                }
            }
        }
    }

    private void replaceImpl_ChartPropertyOnly(JetChartProperty chartProp, String oldVal, String newVal) {
        ChartDefine c = (ChartDefine)chartProp.getObject();
        boolean hasOne = false;
        if (c != null && c.x != null && c.x.equalsIgnoreCase(oldVal)) {
            c.x = newVal;
            hasOne = true;
        }
        if (c != null && c.y != null && c.y.equalsIgnoreCase(oldVal)) {
            c.y = newVal;
            hasOne = true;
        }
        if (c != null && c.b3D && c.z != null && c.z.equalsIgnoreCase(oldVal)) {
            c.z = newVal;
            hasOne = true;
        }
        if (hasOne && JRLog.isTrace(6)) {
            JRLog.trace(6, "Replacement#" + chartProp.getParent() + "'s " + chartProp.getName() + "(ChartProperty) has updated!");
        }
    }

    private void replaceImpl_StringProperty(JetString strProp, String oldVal, String newVal) {
        String oStr = strProp.toUnitString();
        if (oStr == null) {
            return;
        }
        if (oStr.equalsIgnoreCase(oldVal)) {
            newVal = strProp instanceof JetColumnName ? newVal.toUpperCase() : newVal;
            boolean isAutoNow = strProp.isCurrentAutoValue();
            strProp.setUnitValue(newVal);
            if (isAutoNow) {
                strProp.setAsAutoValue(true);
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Replacement#" + strProp.getParent() + "'s " + strProp.getName() + " has updated from \"" + oStr + "\" to \"" + newVal + "\"");
            }
        }
    }

    private void replaceImpl_ListProperty(JetVector listProp, String oldVal, String newVal) {
        int osize;
        Vector oVec = listProp.get();
        int n = osize = oVec == null ? 0 : oVec.size();
        if (osize == 0) {
            return;
        }
        boolean hasOne = false;
        Vector<String> nVec = new Vector<String>(osize);
        for (int i = 0; i < osize; ++i) {
            String oItem = (String)oVec.get(i);
            if (oItem != null && oItem.equalsIgnoreCase(oldVal)) {
                nVec.add(newVal);
                hasOne = true;
                continue;
            }
            nVec.add(oItem);
        }
        if (hasOne) {
            boolean isAutoNow = listProp.isCurrentAutoValue();
            listProp.set(nVec);
            if (isAutoNow) {
                listProp.setAsAutoValue(true);
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Replacement#" + listProp.getParent() + "'s " + listProp.getName() + " has updated from " + oVec + " to " + nVec);
            }
        }
    }

    private void processConditionalFormatting(JetRptReport rpt) {
        try {
            rpt.getConditionalFormattingManager().forceRecompile(true);
            rpt.getConditionalFormattingManager().compileCfFormula(null, null);
        }
        catch (Exception e) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, e);
            }
            Vector chd = rpt.getChildren();
            for (int i = 0; i < chd.size(); ++i) {
                Object o = chd.get(i);
                if (o instanceof JetRptReportFormulaClassSet) {
                    ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)o);
                    continue;
                }
                if (!(o instanceof JetRptReportUFormulaSet)) continue;
                ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)o);
            }
        }
    }

    private void processFlyResource(List<JetObject> flyResources, String oldVal, String newVal, boolean isBVContext) {
        for (JetObject jObj : flyResources) {
            if (!(jObj instanceof JetRptFlyFormulaMeasureSet)) continue;
            JetRptFlyFormulaMeasureSet set = (JetRptFlyFormulaMeasureSet)jObj;
            if (isBVContext ? set.getDataSourceType() != 2 : set.getDataSourceType() != 0) continue;
            Vector children = set.getChildren();
            Vector<JetRptAbstractFormula> fmls = new Vector<JetRptAbstractFormula>();
            Vector<JetObject> toDelObjs = new Vector<JetObject>();
            for (int i = 0; i < children.size(); ++i) {
                JetObject o = (JetObject)children.get(i);
                if (o instanceof JetRptAbstractFormula) {
                    fmls.add((JetRptAbstractFormula)o);
                    continue;
                }
                if (o instanceof JetRptFlyMeasure) {
                    String ostr;
                    JetRptFlyMeasure m = (JetRptFlyMeasure)o;
                    if (isBVContext) {
                        ostr = m.getBasedFieldName();
                        if (!ostr.equalsIgnoreCase(oldVal)) continue;
                        m.nameToProperty("BasedFieldName").set(newVal);
                        if (!JRLog.isTrace(6)) continue;
                        JRLog.trace(6, "Replacement#FlyMeasure(" + m.getName() + ")'s BasedFieldName has updated from \"" + ostr + "\" to \"" + newVal + "\"");
                        continue;
                    }
                    ostr = m.getRefMappingName();
                    if (!ostr.equalsIgnoreCase(oldVal)) continue;
                    m.nameToProperty("BasedMappingName").set(newVal);
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, "Replacement#FlyMeasure(" + m.getName() + ")'s BasedMappingName has updated from \"" + ostr + "\" to \"" + newVal + "\"");
                    continue;
                }
                toDelObjs.add(o);
            }
            if (fmls.size() > 0) {
                AbstractFormulaContainer fc = null;
                Scope scope = null;
                if (set.getParent() instanceof IDataContainer) {
                    scope = new DCScope(this.unvInst, (IDataContainer)set.getParent());
                    fc = set.getParent() instanceof JetRptCTCrossTab ? new CrosstabFormulaContainer((DCScope)scope, true) : new OnTheFlyFormulaContainer(scope, true);
                } else {
                    IReport rpt = ObjectLogicFactory.getBasicComponentLogic().getIReportOf(set);
                    scope = new Scope(rpt, this.unvInst, set.getQueryInfo());
                    fc = new OnTheFlyFormulaContainer(scope, true);
                }
                Vector<JetRptFormula> rptFormulas = new Vector<JetRptFormula>();
                for (JetRptAbstractFormula f : fmls) {
                    JetRptFormula rptf = new JetRptFormula(f.getMappingName(), f.getFormulaExpression(), fc);
                    rptFormulas.add(rptf);
                }
                fc.setWaitForCompileFormulaList(rptFormulas);
                RenameTool tool = new RenameTool(fc, this);
                boolean hasOne = false;
                for (JetRptAbstractFormula f : fmls) {
                    JetUFormula ufml = f.getJetUFormula();
                    String oStr = ufml.getExpression();
                    tool.updateFormula(ufml, oldVal, newVal);
                    String nStr = ufml.getExpression().trim();
                    if (oStr.equalsIgnoreCase(nStr)) continue;
                    hasOne = true;
                    f.modify(nStr, nStr);
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, "Replacement#UFormula(" + f.getName() + ")'s expression from {" + oStr + "} to {" + nStr + "}");
                }
                if (!hasOne) continue;
                if (set.getParent() instanceof JetRptCTCrossTab) {
                    new CrosstabFormulaCompiler((DCScope)scope, this.resourceStore).compileCTFormulas();
                    continue;
                }
                new OnTheFlyFormulaCompiler(scope, this.resourceStore).compileOnTheFlyFormulas(true);
                continue;
            }
            for (JetObject dObj : toDelObjs) {
                ObjectLogicFactory.getBasicComponentLogic().remove(dObj);
            }
        }
    }

    private void replaceImpl_ChartDefinition(JetRptChartPlatform chart, String oldVal, String newVal, boolean isBVContext) {
        ChartDefinition def = chart.getChartDefinition();
        if (def.isBVData() == isBVContext) {
            def.processReplaceChartDefinition(oldVal, newVal);
            chart.setDefinition(def);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Replacement#" + chart.getInstNameDirectly() + "'s ChartDefinition has looped!");
            }
        }
    }

    private void replaceImpl_RefNameInJetExpression(JetFilterExpression jetFilter, String oldVal, String newVal, boolean isBVContext) {
        switch (jetFilter.getType()) {
            case 32776: {
                Vector oVec = ((JetParameterExpression)jetFilter).getParaValue();
                Vector<String> nVec = new Vector<String>();
                boolean changed = false;
                for (int i = 0; i < oVec.size(); ++i) {
                    String value = (String)oVec.get(i);
                    if (value != null && value.equalsIgnoreCase(oldVal)) {
                        nVec.add(newVal);
                        changed = true;
                        continue;
                    }
                    nVec.add(value);
                }
                if (!changed) break;
                ((JetParameterExpression)jetFilter).setParaValue(oVec);
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "Replacement#IPExp has updated from @PV(" + oVec + ") To @PV(" + nVec + ")");
                break;
            }
            case 32772: 
            case 32896: 
            case 33024: {
                String ext;
                JetFormulaExpression f = (JetFormulaExpression)jetFilter;
                if (f.isQualifyName() != isBVContext || !(ext = f.getFormulaName()).equalsIgnoreCase(oldVal)) break;
                f.setFormulaName(newVal);
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "Replacement#IFexp has updated from @F(" + ext + ") To @F(" + newVal + ")");
                break;
            }
            case 32769: 
            case 32800: 
            case 32832: {
                String ext;
                JetReferenceExpression f = (JetReferenceExpression)jetFilter;
                if (f.isQualifyName() != isBVContext || !(ext = f.getAtrributeName()).equalsIgnoreCase(oldVal)) break;
                f.setAttributeName(newVal);
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "Replacement#IRexp has updated from @R(" + ext + ") To @R(" + newVal + ")");
                break;
            }
        }
    }

    private void replaceImpl_CusActArgumentExp(JetRptAtomicParamColumnArgExp argExp, String oldVal, String newVal) {
        String oStr = (String)argExp.getValue();
        if (oldVal.equalsIgnoreCase(oStr)) {
            argExp.setConst(newVal);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "Replacement#CusAction's Columnabe-Argument from \"" + oldVal + "\" to \"" + newVal + "\"");
            }
        }
    }

    public Class getClass(String name2) throws ClassNotFoundException {
        String temp = mapping.get(name2);
        return Class.forName(temp == null ? name2 : temp);
    }

    Vector<String> parse(String line) {
        int state = 0;
        Vector<String> tokens = new Vector<String>();
        int index = line.length();
        while (index != -1 && index > 0) {
            while (line.length() > 0) {
                char c = line.charAt(0);
                state = c;
                if (c != ' ') break;
                line = line.substring(1);
            }
            if (state == 34) {
                index = 1;
                while ((index = line.indexOf(34, index)) != -1 && line.charAt(index - 1) == '\\') {
                    line = line.substring(0, index - 1) + line.substring(index);
                }
                if (index != -1) {
                    tokens.addElement(line.substring(1, index));
                    line = line.substring(index + 1);
                }
            } else {
                index = line.indexOf(32, 1);
                if (index != -1) {
                    tokens.addElement(line.substring(0, index));
                    line = line.substring(index + 1);
                }
            }
            if (index != -1 || line.length() <= 0) continue;
            tokens.addElement(line);
        }
        return tokens;
    }

    void saveToBack(String src) {
        File f = new File(src);
        File tmp = new File(src + ".bak");
        f.renameTo(tmp);
    }

    void save(JetObject root, String dest) throws WriteFailureException {
        String rootName = null;
        if (root instanceof JetRptReportSet) {
            rootName = ((JetRptReportSet)root).getInstNameDirectly();
        }
        try {
            RefReport.save(root, dest, this.unvInst, rootName, this.resourceStore);
        }
        catch (UnsupportedOperationException e) {
            throw new WriteFailureException();
        }
    }

    static {
        mapping.put("Report", "jet.report.JetRptReportPanel");
        mapping.put("SubReport", "jet.report.JetRptSubReport");
        mapping.put("ReportHeader", "jet.report.JetRptHeaderPanel");
        mapping.put("ReportFooter", "jet.report.JetRptFooterPanel");
        mapping.put("Page", "jet.report.JetRptPagePanel");
        mapping.put("PageHeader", "jet.report.JetRptPageHeaderPanel");
        mapping.put("PageFooter", "jet.report.JetRptPageFooterPanel");
        mapping.put("Group", "jet.report.JetRptGroupPanel");
        mapping.put("GroupHeader", "jet.report.JetRptGroupHeaderPanel");
        mapping.put("GroupFooter", "jet.report.JetRptGroupFooterPanel");
        mapping.put("Detail", "jet.report.JetRptDetail");
        mapping.put("Arc", "jet.report.JetRptArcShape");
        mapping.put("Box", "jet.report.JetRptGTBox");
        mapping.put("Line", "jet.report.JetRptLine");
        mapping.put("Oval", "jet.report.JetRptOvalShape");
        mapping.put("RoundBox", "jet.report.JetRptRoundBoxShape");
        mapping.put("Label", "jet.report.JetRptTextField");
        mapping.put("DBField", "jet.report.JetRptDBField");
        mapping.put("MediaField", "jet.report.JetRptMediaField");
        mapping.put("SystemField", "jet.report.JetRptSystemField");
        mapping.put("Parameter", "jet.report.JetRptParameterField");
        mapping.put("Image", "jet.report.JetRptPicture");
        mapping.put("Text", "jet.report.JetRptTextObject");
        mapping.put("ChartPlatform", "jet.report.JetRptChartPlatform");
        mapping.put("ChartCoordinatepaper", "jet.report.JetRptChartCoordinatepaper");
        mapping.put("ChartLabel", "jet.report.JetRptChartLabel");
        mapping.put("ChartLegend", "jet.report.JetRptChartLegend");
        mapping.put("CrossTab", "jet.report.JetRptCTCrossTab");
        mapping.put("CTAggField", "jet.report.JetRptCTAggField");
        mapping.put("CTAggInfo", "jet.report.JetRptCTAggInfo");
        mapping.put("CTDBField", "jet.report.JetRptCTDBField");
        mapping.put("CTHdDBField", "jet.report.JetRptCTHdDBField");
        mapping.put("CTHdTextField", "jet.report.JetRptCTHdTextField");
    }
}

