/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.exception.ParseFormulaFailedException;
import jet.formula.FormulaCompiler;
import jet.formula.FormulaCompilerListener;
import jet.formula.FormulaContainer;
import jet.formula.JetRptFormula;
import jet.formula.crossref.NameCollector;

public class SyntaxTreeCreator
implements FormulaCompilerListener {
    private FormulaContainer fc;
    private FormulaCompiler compiler;
    private NameCollector nc;
    private boolean hasError = false;
    private JetRptFormula curFormula;

    public SyntaxTreeCreator(FormulaContainer fc, NameCollector nc) {
        this.fc = fc;
        this.compiler = new FormulaCompiler(this, null);
        this.nc = nc;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void parseFormula(String formulaName) {
        this.curFormula = this.fc.getFormula(formulaName);
        this.parseFormula(this.curFormula);
    }

    public void parseFormula(JetRptFormula f) {
        Vector<JetRptFormula> v = new Vector<JetRptFormula>();
        v.add(f);
        f.setNameCollector(this.nc);
        try {
            this.compiler.checkFormulas(v);
            this.hasError = false;
        }
        catch (ParseFormulaFailedException e) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "parse formula failed:", (Throwable)e);
            }
            this.hasError = true;
        }
    }

    @Override
    public void translateComplete(Vector arg0) {
    }
}

