/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.log.JRLogger;
import jet.universe.JetUProcParameter;
import jet.universe.JetUResourceEntity;

public class UMapTable {
    protected Hashtable mapTable = new Hashtable();
    protected Vector names = new Vector();
    private static JRLogger logger = JRLogger.getLogger(UMapTable.class.getName());

    public final void addElement(JetUResourceEntity node) {
        if (node instanceof JetUProcParameter) {
            return;
        }
        String key = node.getResourceNameInUpperCase();
        this.mapTable.put(key, node);
        this.names.addElement(key);
    }

    public final void removeElement(JetUResourceEntity node) {
        if (node instanceof JetUProcParameter) {
            return;
        }
        String key = node.getResourceNameInUpperCase();
        this.mapTable.remove(key);
        this.names.removeElement(key);
    }

    public final void updateElementName(JetUResourceEntity node, String strOldName) {
        if (this.mapTable.contains(node)) {
            String oldKey = strOldName;
            this.mapTable.remove(oldKey);
            this.names.removeElement(oldKey);
            String newKey = node.getResourceNameInUpperCase();
            this.mapTable.put(newKey, node);
            this.names.addElement(newKey);
        }
    }

    public final int getElementCount() {
        return this.mapTable.size();
    }

    public final JetUResourceEntity getElementByIndex(int iIndex) {
        return (JetUResourceEntity)this.mapTable.get((String)this.names.elementAt(iIndex));
    }

    public final JetUResourceEntity getElementByName(String name2) {
        return (JetUResourceEntity)this.mapTable.get(name2);
    }

    public final JetUResourceEntity getResourceByName(String name2) {
        return (JetUResourceEntity)this.mapTable.get(name2);
    }

    public final boolean IsMappingNameExist(String name2) {
        return this.mapTable.containsKey(name2);
    }

    public final boolean IsElementExist(JetUResourceEntity node) {
        return this.mapTable.contains(node);
    }

    public Enumeration elements() {
        return this.mapTable.elements();
    }

    public String toString() {
        return this.names.toString();
    }

    public void clearMem() {
        this.mapTable.clear();
    }
}

