/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import jet.controls.JetObject;
import jet.export.xml.LoadXSDException;
import jet.export.xml.ObjectToXML;
import jet.export.xml.XMLToObject;
import jet.jetc.JetCReader;
import jet.jetc.JetCWriter;
import jet.jetc.JetRptReportIOException;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.universe.JetUColumnInfo;
import jet.universe.JetUConnection;
import jet.universe.JetUField;
import jet.universe.JetUPath;
import jet.universe.JetUPrejoin;
import jet.universe.JetUPrejoins;
import jet.universe.JetUQueriable;
import jet.universe.JetUTableInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.Prejoin;
import prejoin.Join;
import prejoin.JoinsSet;
import prejoin.Loop;
import prejoin.Path;
import prejoin.PathFinder;
import toolkit.db.PsqlJoin;

public class UniverseEditor {
    JetUUniverse unv;
    Hashtable<String, JetUPrejoins> joins = new Hashtable();

    public UniverseEditor(JetUUniverse unv) throws ReadFailureException {
        this.unv = unv;
        JetCReader reader = new JetCReader();
        String unvFullName = unv.getFullFileName();
        boolean isXML = unvFullName.endsWith(".cat.xml");
        Vector names = unv.getAllDatabaseNames();
        for (int i = 0; i < names.size(); ++i) {
            String name2 = (String)names.elementAt(i);
            String fname = JetUUniverse.getCatNameFromFileName(unvFullName) + name2 + (isXML ? ".pre.xml" : ".pre");
            if (new File(fname).exists()) {
                JetUPrejoins pjoins;
                if (!isXML) {
                    pjoins = (JetUPrejoins)reader.read(fname);
                } else {
                    try {
                        pjoins = (JetUPrejoins)XMLToObject.toObject(fname);
                    }
                    catch (LoadXSDException e) {
                        throw new ReadFailureException(e);
                    }
                }
                this.joins.put(name2, pjoins);
                continue;
            }
            this.init(name2);
        }
    }

    void init(String name2) {
        JetUPrejoins pjoins = new JetUPrejoins();
        pjoins.x.set(100);
        pjoins.y.set(100);
        pjoins.width.set(640);
        pjoins.height.set(480);
        Vector conns = this.unv.getDatabase(name2).getConnections();
        for (JetUConnection conn : conns) {
            if (conn == null) continue;
            Vector tables = conn.getTableViews();
            int sz = tables.size();
            int hgap = 10;
            int vgap = 10;
            int width = 100;
            int height = 100;
            int interval = 20;
            int maxWidth = 600;
            int x = hgap;
            int y = vgap;
            for (int i = 0; i < sz; ++i) {
                JetUTableView table = (JetUTableView)tables.elementAt(i);
                JetUTableInfo tinfo = new JetUTableInfo();
                tinfo.tableName.set(table.tableName.get());
                Vector cols = table.getFields();
                for (int j = 0; j < cols.size(); ++j) {
                    JetUField field = (JetUField)cols.elementAt(j);
                    JetUColumnInfo column = new JetUColumnInfo();
                    column.columnName.set(field.colName.get());
                    tinfo.add(column);
                }
                if (x + width > maxWidth) {
                    x = hgap;
                    y += height + interval;
                }
                tinfo.x.set(x);
                tinfo.y.set(y);
                tinfo.width.set(width);
                tinfo.height.set(height);
                x += width + interval;
                pjoins.add(tinfo);
            }
            this.joins.put(name2, pjoins);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveToFile(String sourceName) throws WriteFailureException {
        String unvFile = this.unv.getFullFileName();
        if (unvFile.endsWith(".cat.xml")) {
            String preFile = unvFile.substring(0, unvFile.length() - ".cat.xml".length());
            if (sourceName != null && sourceName.length() > 0) {
                preFile = preFile + sourceName;
            }
            try {
                JetUPrejoins join = this.joins.get(sourceName);
                if (join == null) return;
                ObjectToXML toXML = new ObjectToXML(join, preFile);
                return;
            }
            catch (JetRptReportIOException e) {
                throw new WriteFailureException(e);
            }
        } else {
            JetCWriter writer = new JetCWriter();
            String file = JetUUniverse.getCatNameFromFileName(this.unv.getFullFileName()) + sourceName + ".pre";
            JetUPrejoins p = this.joins.get(sourceName);
            if (p == null) return;
            writer.write((JetObject)p, file, "JetUPrejoins");
        }
    }

    public boolean finish(String sourceName, Hashtable tables, Vector pjs, Rectangle bounds, boolean modPath) {
        JetUPrejoins pjoins = this.joins.remove(sourceName);
        if (pjoins != null) {
            boolean bChanged;
            boolean bl = bChanged = pjoins.x.get() != bounds.x || pjoins.y.get() != bounds.y || pjoins.width.get() != bounds.width || pjoins.height.get() != bounds.height;
            if (bChanged) {
                pjoins.x.set(bounds.x);
                pjoins.y.set(bounds.y);
                pjoins.width.set(bounds.width);
                pjoins.height.set(bounds.height);
            }
            boolean dChanged = pjoins.update(tables, pjs);
            this.unv.setModified(bChanged || dChanged || modPath);
            this.joins.put(sourceName, pjoins);
            return dChanged;
        }
        return false;
    }

    public void addTableView(JetUTableView tableview, String sourceName) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins == null) {
            this.init(sourceName);
        }
        this.joins.get(sourceName).addTableView(tableview);
    }

    public void addQueriable(JetUQueriable queriable, String sourceName) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins == null) {
            this.init(sourceName);
            pjoins = this.joins.get(sourceName);
            if (pjoins == null) {
                return;
            }
        }
        pjoins.addQueriable(queriable);
    }

    public void removeTableView(String tableview, String sourceName) {
        JetUPrejoins p = this.joins.get(sourceName);
        if (p != null) {
            p.removeTableView(tableview);
        }
    }

    public void addPrejoin(JetUPrejoin join, String sourceName) {
        JetUPrejoins p = this.joins.get(sourceName);
        if (p != null) {
            p.add(join);
        }
    }

    public void removePrejoin(JetUPrejoin join, String sourceName) {
        JetUPrejoins p = this.joins.get(sourceName);
        if (p != null) {
            p.remove(join);
        }
    }

    public JetUPath[] getPaths(Vector nj, String[] tables) {
        return this.convertPath(new PathFinder().getPaths(this.convertJoin(nj), tables));
    }

    public Vector getPrejoins(String sourceName) {
        JetUPrejoins p = this.joins.get(sourceName);
        if (p != null) {
            return p.getPrejoins();
        }
        return null;
    }

    public Vector getUPrejoins(String sourceName) {
        JetUPrejoins p = this.joins.get(sourceName);
        if (p != null) {
            Vector children = p.getChildren();
            Vector ujoins = new Vector();
            for (int i = 0; i < children.size(); ++i) {
                Object o = children.elementAt(i);
                if (!(o instanceof JetUPrejoin)) continue;
                ujoins.addElement(o);
            }
            return ujoins;
        }
        return null;
    }

    public Hashtable getTables(String sourceName) {
        JetUPrejoins p = this.joins.get(sourceName);
        if (p != null) {
            return p.getTables();
        }
        return null;
    }

    public Vector getPaths(String sourceName) {
        JetUPrejoins p = this.joins.get(sourceName);
        if (p != null) {
            return p.getPaths();
        }
        return null;
    }

    public JetUPath getPath(String sourceName, String pathName) {
        Vector paths = this.getPaths(sourceName);
        if (paths != null) {
            for (int i = 0; i < paths.size(); ++i) {
                JetUPath path = (JetUPath)paths.elementAt(i);
                if (!path.pathName.get().equals(pathName)) continue;
                return path;
            }
        }
        return null;
    }

    public JetUPath getPath(Vector joins, Vector tables, JetUPath path) {
        joins = this.convertSqlJoin(joins);
        Object[] table = new String[tables.size()];
        PathFinder finder = new PathFinder();
        Path np = this.convertUPath(path);
        tables.copyInto(table);
        JetUPath up = this.convertPath(finder.getPaths(np, (String[])table, joins));
        return up;
    }

    public void setPaths(Vector paths, String sourceName) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins != null) {
            pjoins.setPaths(paths);
        }
    }

    public void addPath(String sourceName, JetUPath path) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins != null) {
            Vector paths = pjoins.getPaths();
            int size = paths.size();
            for (int i = 0; i < size; ++i) {
                JetUPath p = (JetUPath)paths.get(i);
                if (!p.equal(path)) continue;
                return;
            }
            pjoins.add(path);
        }
    }

    public void addPath(String sourceName, JetUPath path, int idx) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins != null) {
            pjoins.add(path, idx);
        }
    }

    public void removePath(String sourceName, JetUPath path) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins != null) {
            pjoins.remove(path);
        }
    }

    public void removeAllPaths(String sourceName) {
        Vector paths;
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins != null && (paths = pjoins.getPaths()) != null) {
            for (int i = 0; i < paths.size(); ++i) {
                JetUPath path = (JetUPath)paths.elementAt(i);
                pjoins.remove(path);
            }
        }
    }

    public Rectangle getPrejoinsBounds(String sourceName) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins == null) {
            pjoins = new JetUPrejoins();
            pjoins.x.set(100);
            pjoins.y.set(100);
            pjoins.width.set(640);
            pjoins.height.set(480);
        }
        return new Rectangle(pjoins.x.get(), pjoins.y.get(), pjoins.width.get(), pjoins.height.get());
    }

    public Vector getPaths(Vector tables, String sourceName) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins != null) {
            Vector allPaths = pjoins.getPaths();
            Vector tabPaths = new Vector();
            if (allPaths.size() > 0) {
                for (int i = 0; i < allPaths.size(); ++i) {
                    Vector children = ((JetUPath)allPaths.elementAt(i)).getChildren();
                    Vector<String> tabs = new Vector<String>();
                    for (int j = 0; j < children.size(); ++j) {
                        if (!(children.elementAt(j) instanceof JetUPrejoin)) continue;
                        JetUPrejoin join = (JetUPrejoin)children.elementAt(j);
                        String tabf = join.tableFrom.get();
                        String tabt = join.tableTo.get();
                        if (!tabs.contains(tabf)) {
                            tabs.addElement(tabf);
                        }
                        if (tabs.contains(tabt)) continue;
                        tabs.addElement(tabt);
                    }
                    boolean c = true;
                    if (tabs.size() > 0) {
                        for (int j = 0; j < tables.size(); ++j) {
                            if (tabs.contains(tables.elementAt(j))) continue;
                            c = false;
                            break;
                        }
                    }
                    if (!c) continue;
                    tabPaths.addElement(allPaths.elementAt(i));
                }
            }
            return tabPaths;
        }
        return null;
    }

    Vector convertJoin(Vector prejoins) {
        Vector<Join> joins = new Vector<Join>();
        if (prejoins != null) {
            for (int i = 0; i < prejoins.size(); ++i) {
                Prejoin join = (Prejoin)prejoins.elementAt(i);
                String[] joinInfo = join.getJoinInfo();
                joins.addElement(new Join(joinInfo[0], joinInfo[1], joinInfo[4], joinInfo[2], joinInfo[3], Integer.parseInt(joinInfo[6])));
            }
        }
        return joins;
    }

    Vector convertSqlJoin(Vector joins) {
        Vector<Join> ret = new Vector<Join>();
        for (int i = 0; joins != null && i < joins.size(); ++i) {
            PsqlJoin join = (PsqlJoin)joins.elementAt(i);
            ret.add(new Join(join.getTableFrom().getName(), join.getColumnFrom().getName(), join.getOperator(), join.getTableTo().getName(), join.getColumnTo().getName(), join.getOuterJoin()));
        }
        return ret;
    }

    JetUPath[] convertPath(Path[] path) {
        JetUPath[] up = new JetUPath[path.length];
        for (int i = 0; i < up.length; ++i) {
            up[i] = this.convertPath(path[i]);
        }
        if (up.length == 1 && up[0].getChildren().size() == 0) {
            up = new JetUPath[]{};
        }
        return up;
    }

    JetUPath convertPath(Path path) {
        JetUPath up = new JetUPath();
        if (path != null) {
            Join[] joins = path.getJoins();
            for (int i = 0; i < joins.length; ++i) {
                JetUPrejoin join = new JetUPrejoin();
                join.tableFrom.set(joins[i].getFromTable());
                join.tableTo.set(joins[i].getToTable());
                join.columnFrom.set(joins[i].getFromColumn());
                join.columnTo.set(joins[i].getToColumn());
                join.operator.set(joins[i].getOperator());
                join.outerJoin.set(joins[i].getOuterJoinType());
                up.add(join);
            }
        }
        return up;
    }

    Path convertUPath(JetUPath up) {
        Path path = new Path();
        if (up != null) {
            path.setName(up.pathName.get());
            Vector prejoins = up.getChildren();
            Vector<Join> temp = new Vector<Join>();
            Vector<String> tables = new Vector<String>();
            if (prejoins != null) {
                for (int i = 0; i < prejoins.size(); ++i) {
                    JetUPrejoin join = (JetUPrejoin)prejoins.elementAt(i);
                    temp.addElement(new Join(join.tableFrom.get(), join.columnFrom.get(), join.operator.get(), join.tableTo.get(), join.columnTo.get(), join.outerJoin.get()));
                    if (!tables.contains(join.tableFrom.get())) {
                        tables.addElement(join.tableFrom.get());
                    }
                    if (tables.contains(join.tableTo.get())) continue;
                    tables.addElement(join.tableTo.get());
                }
                path.setJoins(temp);
                path.setTables(tables);
            }
        }
        return path;
    }

    private Hashtable colJoins(Vector joins, Vector joinSets) {
        Hashtable<String, HashSet<String>> hashJoins = new Hashtable<String, HashSet<String>>();
        JoinsSet js = null;
        for (int i = 0; i < joins.size(); ++i) {
            Join join = (Join)joins.elementAt(i);
            String fromTab = join.getFromTable();
            String toTab = join.getToTable();
            HashSet<String> cnntabs = (HashSet<String>)hashJoins.get(fromTab);
            if (cnntabs == null) {
                cnntabs = new HashSet<String>();
                hashJoins.put(fromTab, cnntabs);
            }
            cnntabs.add(toTab);
            cnntabs = (HashSet<String>)hashJoins.get(toTab);
            if (cnntabs == null) {
                cnntabs = new HashSet<String>();
                hashJoins.put(toTab, cnntabs);
            }
            cnntabs.add(fromTab);
            boolean b = true;
            for (int j = 0; j < joinSets.size(); ++j) {
                js = (JoinsSet)joinSets.elementAt(j);
                if (!js.equals(fromTab, toTab)) continue;
                b = false;
                break;
            }
            if (b) {
                js = new JoinsSet(fromTab, toTab);
                joinSets.addElement(js);
            }
            js.add(join);
        }
        return hashJoins;
    }

    public JetUPath filterUPath(JetUPath fullPath, Vector tables) {
        Path path = this.convertUPath(fullPath);
        Vector joins = path.getAllJoins();
        Vector joinSets = new Vector();
        Hashtable hashJoins = this.colJoins(joins, joinSets);
        Hashtable bks = (Hashtable)hashJoins.clone();
        Vector blocks = this.getBlocks(bks, true);
        Hashtable<Hashtable, Vector<String>> addHash = new Hashtable<Hashtable, Vector<String>>();
        for (int i = 0; i < tables.size(); ++i) {
            String tab = (String)tables.elementAt(i);
            boolean b = false;
            Hashtable tmp = null;
            for (int j = 0; j < blocks.size(); ++j) {
                tmp = (Hashtable)blocks.elementAt(j);
                if (!tmp.containsKey(tab)) continue;
                b = true;
                break;
            }
            if (!b) continue;
            Vector<String> tabs = (Vector<String>)addHash.get(tmp);
            if (tabs == null) {
                tabs = new Vector<String>();
                addHash.put(tmp, tabs);
            }
            tabs.addElement(tab);
        }
        Vector res = new Vector();
        Enumeration e = addHash.keys();
        while (e.hasMoreElements()) {
            Hashtable tmp = (Hashtable)e.nextElement();
            Vector v = (Vector)addHash.get(tmp);
            if (v.size() <= 1) continue;
            String fir = (String)v.remove(0);
            for (int i = 0; i < v.size(); ++i) {
                Stack<String> stack = new Stack<String>();
                stack.push(fir);
                String to = (String)v.elementAt(i);
                Vector jointabs = new Vector();
                this.searchPath(to, stack, tmp, jointabs);
                if (jointabs.size() <= 0) continue;
                res.addElement(jointabs);
            }
        }
        Path fpath = new Path();
        if (res.size() > 0) {
            Vector<Join> fin = new Vector<Join>();
            for (int i = 0; i < res.size(); ++i) {
                Vector v = (Vector)res.elementAt(i);
                int sz = v.size() - 1;
                for (int j = 0; j < sz; ++j) {
                    String tab1 = (String)v.elementAt(j);
                    String tab2 = (String)v.elementAt(j + 1);
                    for (int k = 0; k < joinSets.size(); ++k) {
                        JoinsSet js = (JoinsSet)joinSets.elementAt(k);
                        if (!js.equals(tab1, tab2)) continue;
                        Vector c = js.getJoins();
                        for (int l = 0; l < c.size(); ++l) {
                            Join jn = (Join)c.elementAt(l);
                            if (fin.contains(jn)) continue;
                            fin.addElement(jn);
                        }
                    }
                }
            }
            fpath.setJoins(fin);
            return this.convertPath(fpath);
        }
        return null;
    }

    private void searchPath(String to, Stack sk, Hashtable hash, Vector jointabs) {
        String key = (String)sk.peek();
        HashSet set = (HashSet)hash.get(key);
        Iterator it = set.iterator();
        while (it.hasNext() && jointabs.size() == 0) {
            String val = (String)it.next();
            if (val.equals(to)) {
                for (int i = 0; i < sk.size(); ++i) {
                    jointabs.addElement(sk.elementAt(i));
                }
                jointabs.add(to);
                break;
            }
            int idx = sk.indexOf(val);
            if (idx == -1) {
                sk.push(val);
                this.searchPath(to, sk, hash, jointabs);
            } else if (idx == sk.size() - 2) continue;
            sk.pop();
        }
    }

    public Vector getPrejoinLoops(Vector joinInStrings) {
        Vector joins = this.convertJoin(joinInStrings);
        Vector joinSets = new Vector();
        Hashtable hashJoins = this.colJoins(joins, joinSets);
        Hashtable bks = (Hashtable)hashJoins.clone();
        Vector blocks = this.getBlocks(bks, false);
        Vector loops = new Vector();
        for (int i = 0; i < blocks.size(); ++i) {
            Hashtable bk = (Hashtable)blocks.elementAt(i);
            Vector keys = new Vector();
            Enumeration e = bk.keys();
            while (e.hasMoreElements()) {
                keys.addElement(e.nextElement());
            }
            Stack stack = new Stack();
            stack.push(keys.elementAt(0));
            this.searchLoops(bk, loops, stack, joinSets);
        }
        return loops;
    }

    private void viewLoops(Vector loops) {
        if (loops.size() > 0) {
            for (int l = 0; l < loops.size(); ++l) {
                Loop loop = (Loop)loops.elementAt(0);
                System.out.println("loop====" + l);
                Vector jos = loop.getJoins();
                for (int j = 0; j < jos.size(); ++j) {
                    JoinsSet js = (JoinsSet)jos.elementAt(j);
                    Vector jss = js.getJoins();
                    for (int k = 0; k < jss.size(); ++k) {
                        Join theJoin = (Join)jss.elementAt(k);
                        System.out.println(theJoin.getFromTable() + "." + theJoin.getFromColumn() + theJoin.getOperator() + theJoin.getToTable() + "." + theJoin.getToColumn());
                    }
                }
            }
        }
    }

    public boolean getLoops(Vector nj) {
        Vector joins = this.convertJoin(nj);
        Vector joinSets = new Vector();
        Hashtable hashJoins = this.colJoins(joins, joinSets);
        Hashtable bks = (Hashtable)hashJoins.clone();
        Vector blocks = this.getBlocks(bks, false);
        Vector loops = new Vector();
        for (int i = 0; i < blocks.size(); ++i) {
            Hashtable bk = (Hashtable)blocks.elementAt(i);
            Vector keys = new Vector();
            Enumeration e = bk.keys();
            while (e.hasMoreElements()) {
                keys.addElement(e.nextElement());
            }
            Stack stack = new Stack();
            stack.push(keys.elementAt(0));
            this.searchLoops(bk, loops, stack, joinSets);
            if (loops.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void searchLoops(Hashtable bk, Vector loops, Stack stack, Vector joinSets) {
        String key = (String)stack.peek();
        HashSet set = (HashSet)bk.get(key);
        if (!stack.isEmpty()) {
            for (String val : set) {
                int idx = stack.indexOf(val);
                if (idx == -1) {
                    if (((HashSet)bk.get(val)).size() <= 1) continue;
                    stack.push(val);
                    this.searchLoops(bk, loops, stack, joinSets);
                    continue;
                }
                if (idx == stack.size() - 2) continue;
                Vector v = new Vector();
                for (int i = idx; i < stack.size(); ++i) {
                    v.addElement(stack.elementAt(i));
                }
                Vector<JoinsSet> joins = new Vector<JoinsSet>();
                int sz = v.size();
                block2: for (int i = 0; i < sz; ++i) {
                    String tab1 = (String)v.elementAt(i);
                    String tab2 = i < sz - 1 ? (String)v.elementAt(i + 1) : (String)v.elementAt(0);
                    for (int j = 0; j < joinSets.size(); ++j) {
                        JoinsSet js = (JoinsSet)joinSets.elementAt(j);
                        if (!js.equals(tab1, tab2)) continue;
                        joins.addElement(js);
                        continue block2;
                    }
                }
                Loop loop = new Loop(v, joins);
                boolean b = true;
                for (int i = 0; i < loops.size(); ++i) {
                    Loop eloop = (Loop)loops.elementAt(i);
                    if (!eloop.equals(loop)) continue;
                    b = false;
                    break;
                }
                if (!b) continue;
                loops.addElement(loop);
            }
            stack.pop();
        }
    }

    private Vector getBlocks(Hashtable cpyKeys, boolean addsingle) {
        Vector blocks = new Vector();
        while (cpyKeys.size() > 0) {
            Enumeration e = cpyKeys.keys();
            String key = null;
            if (e.hasMoreElements()) {
                key = (String)e.nextElement();
            }
            if (key == null) continue;
            Stack tabs = new Stack();
            Hashtable<String, HashSet> b = new Hashtable<String, HashSet>();
            HashSet set = (HashSet)cpyKeys.remove(key);
            b.put(key, set);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                tabs.push(it.next());
            }
            this.searchBlock(cpyKeys, tabs, b);
            if (addsingle) {
                blocks.addElement(b);
                continue;
            }
            if (b.size() <= 2) continue;
            blocks.addElement(b);
        }
        return blocks;
    }

    private void searchBlock(Hashtable cpyKeys, Stack tabs, Hashtable b) {
        String tab = (String)tabs.pop();
        HashSet set = (HashSet)cpyKeys.remove(tab);
        if (set != null) {
            b.put(tab, set);
            for (String s : set) {
                if (!cpyKeys.containsKey(s) || tabs.search(s) != -1) continue;
                tabs.push(s);
            }
        }
        if (!tabs.empty()) {
            this.searchBlock(cpyKeys, tabs, b);
        }
    }

    public JetUUniverse getUniverse() {
        return this.unv;
    }

    public void updateTableNames(String oldName, String newName, String dbName) {
        JetUPrejoins prejoins = this.joins.get(dbName);
        Vector children = prejoins.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Object o = children.elementAt(i);
            if (o instanceof JetUTableInfo) {
                JetUTableInfo tinfo = (JetUTableInfo)o;
                if (!tinfo.tableName.get().equals(oldName)) continue;
                tinfo.tableName.set(newName);
                continue;
            }
            if (o instanceof JetUPrejoin) {
                this.updateTableName((JetUPrejoin)o, oldName, newName);
                continue;
            }
            if (!(o instanceof JetUPath)) continue;
            Vector c = ((JetUPath)o).getChildren();
            for (int j = 0; j < c.size(); ++j) {
                this.updateTableName((JetUPrejoin)c.elementAt(j), oldName, newName);
            }
        }
    }

    void updateTableName(JetUPrejoin prejoin, String oldName, String newName) {
        if (prejoin.tableFrom.get().equals(oldName)) {
            prejoin.tableFrom.set(newName);
        } else if (prejoin.tableTo.get().equals(oldName)) {
            prejoin.tableTo.set(newName);
        }
    }

    public void updateFieldNames(String tableName, String oldName, String newName, String dbName) {
        JetUPrejoins prejoins = this.joins.get(dbName);
        Vector children = prejoins.getChildren();
        Hashtable h = prejoins.getTables();
        block0: for (int i = 0; i < children.size(); ++i) {
            int j;
            Object o = children.elementAt(i);
            if (o instanceof JetUTableInfo) {
                if (!((JetUTableInfo)o).tableName.get().equals(tableName)) continue;
                Vector fields = ((JetUTableInfo)o).getChildren();
                for (j = 0; j < fields.size(); ++j) {
                    JetUColumnInfo colInfo = (JetUColumnInfo)fields.elementAt(j);
                    if (!colInfo.columnName.get().equals(oldName)) continue;
                    colInfo.columnName.set(newName);
                    continue block0;
                }
                continue;
            }
            if (o instanceof JetUPrejoin) {
                this.updateFieldName((JetUPrejoin)o, tableName, oldName, newName);
                continue;
            }
            if (!(o instanceof JetUPath)) continue;
            Vector c = ((JetUPath)o).getChildren();
            for (j = 0; j < c.size(); ++j) {
                this.updateFieldName((JetUPrejoin)c.elementAt(j), tableName, oldName, newName);
            }
        }
    }

    public void updateFieldName(JetUPrejoin prejoin, String tableName, String oldName, String newName) {
        if (prejoin.tableFrom.get().equals(tableName) && prejoin.columnFrom.get().equals(oldName)) {
            prejoin.columnFrom.set(newName);
        } else if (prejoin.tableTo.get().equals(tableName) && prejoin.columnTo.get().equals(oldName)) {
            prejoin.columnTo.set(newName);
        }
    }

    public void mergePrejoin(String sourceName, JetUPrejoin[] prejoins) {
        JetUPrejoins pjoins = this.joins.get(sourceName);
        if (pjoins == null) {
            this.init(sourceName);
            pjoins = this.joins.get(sourceName);
        }
        pjoins.mergePrejoin(prejoins);
    }

    public static JetUPrejoin[] getPrejoins(JetUPath[] paths) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < paths.length; ++i) {
            ret.addAll(paths[i].children);
        }
        return ret.toArray(new JetUPrejoin[ret.size()]);
    }
}

