/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.dataengine8.util.ArrayToolkit;
import jet.formula.ParamDesc;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUTable;
import jet.universe.JetUTableView;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUView;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.DTInformation;
import jet.universe.businesslogic.GroupInfo;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.tools.ParameterTool;
import jet.universe.tools.ParseParametersForQuery;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.StmtSelCol;

public class UniverseToolkit {
    public static int QUALIFIERTYPE_SQLS = 1;
    public static int QUALIFIERTYPE_PROCEDURES = 2;
    public static int QUALIFIERTYPE_TABLES = 4;
    public static int QUALIFIERTYPE_VIEWS = 8;
    private static DSLog logger = DSLog.getDSLog(UniverseToolkit.class.getName());

    public static void changeQualifierName(JetUUniverse universe, String databaseName, String newQualifierName, int changeType) {
        JetUDatabase database = universe.getDatabase(databaseName);
        if (database == null) {
            return;
        }
        JetUConnection connection = database.getConnection();
        if (connection == null) {
            return;
        }
        Vector children = connection.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            JetObject jo = (JetObject)children.get(i);
            if (jo instanceof JetUProcedure && UniverseToolkit.isChangePROCEDURES(changeType)) {
                JetUProcedure procedure = (JetUProcedure)jo;
                procedure.setQualifier(newQualifierName);
                continue;
            }
            if (jo instanceof JetUTable && UniverseToolkit.isChangeTABLES(changeType)) {
                JetUTable table = (JetUTable)jo;
                table.setQualifier(newQualifierName);
                continue;
            }
            if (jo instanceof JetUView && UniverseToolkit.isChangeVIEWS(changeType)) {
                JetUView view = (JetUView)jo;
                view.setQualifier(newQualifierName);
                continue;
            }
            if (jo instanceof JetUTableView) {
                JetUTableView tableView = (JetUTableView)jo;
                if (UniverseToolkit.isChangeTABLES(changeType) && tableView.getTableType() == 1) {
                    tableView.setQualifier(newQualifierName);
                }
                if (!UniverseToolkit.isChangeVIEWS(changeType) || tableView.getTableType() != 2) continue;
                tableView.setQualifier(newQualifierName);
                continue;
            }
            if (!(jo instanceof JetUFileQuery) || !UniverseToolkit.isChangeSQLS(changeType)) continue;
            JetUFileQuery fileQuery = (JetUFileQuery)jo;
            fileQuery.setQualifier(newQualifierName);
        }
        if (UniverseToolkit.isChangeTABLES(changeType) || UniverseToolkit.isChangeVIEWS(changeType) || UniverseToolkit.isChangeSQLS(changeType)) {
            Vector queries = universe.getQueriables(databaseName);
            for (int i = 0; i < queries.size(); ++i) {
                Object o;
                int j;
                Vector selCols;
                JetUQueriable jetUQueriable = (JetUQueriable)queries.get(i);
                if (jetUQueriable instanceof JetUQuery) {
                    JetUQuery jetUQuery = (JetUQuery)jetUQueriable;
                    selCols = jetUQuery.getPsqlQuery().getSelColsVector();
                    for (j = 0; j < selCols.size(); ++j) {
                        o = selCols.get(j);
                        if (!(o instanceof PsqlSelColumn)) continue;
                        PsqlSelColumn column = (PsqlSelColumn)o;
                        column.qualifier = newQualifierName;
                    }
                }
                if (!(jetUQueriable instanceof JetUFileQuery)) continue;
                JetUFileQuery jetUFileQuery = (JetUFileQuery)jetUQueriable;
                selCols = jetUFileQuery.getFileQuery().getColumns();
                for (j = 0; j < selCols.size(); ++j) {
                    o = selCols.get(j);
                    if (!(o instanceof StmtSelCol)) continue;
                    StmtSelCol selCol = (StmtSelCol)o;
                    selCol.qualifier = newQualifierName;
                }
            }
        }
    }

    public static void changeSchemaName(JetUUniverse universe, String databaseName, String newSchemaName, int changeType) {
        JetUDatabase database = universe.getDatabase(databaseName);
        if (database == null) {
            return;
        }
        JetUConnection connection = database.getConnection();
        if (connection == null) {
            return;
        }
        Vector children = connection.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            JetObject jo = (JetObject)children.get(i);
            if (jo instanceof JetUProcedure && UniverseToolkit.isChangePROCEDURES(changeType)) {
                JetUProcedure procedure = (JetUProcedure)jo;
                procedure.setOwner(newSchemaName);
                continue;
            }
            if (jo instanceof JetUTable && UniverseToolkit.isChangeTABLES(changeType)) {
                JetUTable table = (JetUTable)jo;
                table.setOwner(newSchemaName);
                continue;
            }
            if (jo instanceof JetUView && UniverseToolkit.isChangeVIEWS(changeType)) {
                JetUView view = (JetUView)jo;
                view.setOwner(newSchemaName);
                continue;
            }
            if (!(jo instanceof JetUTableView)) continue;
            JetUTableView tableView = (JetUTableView)jo;
            if (UniverseToolkit.isChangeTABLES(changeType) && tableView.getTableType() == 1) {
                tableView.setOwner(newSchemaName);
            }
            if (!UniverseToolkit.isChangeVIEWS(changeType) || tableView.getTableType() != 2) continue;
            tableView.setOwner(newSchemaName);
        }
        if (UniverseToolkit.isChangeTABLES(changeType) || UniverseToolkit.isChangeVIEWS(changeType) || UniverseToolkit.isChangeSQLS(changeType)) {
            Vector queries = universe.getQueriables(databaseName);
            for (int i = 0; i < queries.size(); ++i) {
                Object o;
                int j;
                Vector selCols;
                JetUQueriable jetUQueriable = (JetUQueriable)queries.get(i);
                if (jetUQueriable instanceof JetUQuery) {
                    JetUQuery jetUQuery = (JetUQuery)jetUQueriable;
                    selCols = jetUQuery.getPsqlQuery().getSelColsVector();
                    for (j = 0; j < selCols.size(); ++j) {
                        o = selCols.get(j);
                        if (!(o instanceof PsqlSelColumn)) continue;
                        PsqlSelColumn column = (PsqlSelColumn)o;
                        column.owner = newSchemaName;
                    }
                }
                if (!(jetUQueriable instanceof JetUFileQuery)) continue;
                JetUFileQuery jetUFileQuery = (JetUFileQuery)jetUQueriable;
                selCols = jetUFileQuery.getFileQuery().getColumns();
                for (j = 0; j < selCols.size(); ++j) {
                    o = selCols.get(j);
                    if (!(o instanceof StmtSelCol)) continue;
                    StmtSelCol selCol = (StmtSelCol)o;
                    selCol.owner = newSchemaName;
                }
            }
        }
    }

    private static boolean isChangeVIEWS(int changeType) {
        return (changeType & QUALIFIERTYPE_VIEWS) == QUALIFIERTYPE_VIEWS;
    }

    private static boolean isChangeTABLES(int changeType) {
        return (changeType & QUALIFIERTYPE_TABLES) == QUALIFIERTYPE_TABLES;
    }

    private static boolean isChangePROCEDURES(int changeType) {
        return (changeType & QUALIFIERTYPE_PROCEDURES) == QUALIFIERTYPE_PROCEDURES;
    }

    private static boolean isChangeSQLS(int changeType) {
        return (changeType & QUALIFIERTYPE_SQLS) == QUALIFIERTYPE_SQLS;
    }

    public static Vector validFormulaForBC(JetUUniverse universe, String datasourceName) {
        Vector<JetUFormula> validFormula = new Vector<JetUFormula>();
        JetUDatabase db = universe.getDatabase(datasourceName);
        if (db == null) {
            return new Vector();
        }
        Vector formulas = db.getFormulas();
        for (int i = 0; i < formulas.size(); ++i) {
            boolean flag = true;
            JetUFormula formula2 = (JetUFormula)formulas.get(i);
            Vector dbField = formula2.getRefAllDbFld();
            for (int j = 0; j < dbField.size(); ++j) {
                String name2 = dbField.get(j).toString();
                JetUResourceEntity entity = db.getResourceByName(name2);
                if (entity instanceof JetUField) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            validFormula.add(formula2);
        }
        return validFormula;
    }

    public static Vector getFieldResourceNames(JetUUniverse unv, String dataSourceName, String queryName) {
        Vector v = null;
        JetUQueriable queriable = unv.getQueriableByResourceName(dataSourceName, queryName);
        if (queriable instanceof JetUFileQuery) {
            v = UniverseToolkit.getFieldResourceNames((JetUFileQuery)queriable);
        } else if (!(queriable instanceof JetUHierDataSource)) {
            if (queriable instanceof JetUProcedure) {
                v = UniverseToolkit.getFieldResourceNames((JetUProcedure)queriable);
            } else if (queriable instanceof JetUQuery) {
                v = UniverseToolkit.getDbFieldResourceNames((JetUQuery)queriable);
            } else if (queriable instanceof JetUUserDataSource) {
                v = UniverseToolkit.getFieldResourceNames((JetUUserDataSource)queriable);
            } else {
                System.out.println("Invalid query class: " + queriable);
            }
        }
        return v;
    }

    private static Vector getFieldResourceNames(JetUFileQuery query) {
        Vector vField = query.getFields();
        Vector<String> vFieldName = new Vector<String>();
        if (vField != null) {
            for (int i = 0; i < vField.size(); ++i) {
                JetUFileQueryField field = (JetUFileQueryField)vField.elementAt(i);
                vFieldName.addElement(field.getResourceNameInUpperCase());
            }
        }
        return vFieldName;
    }

    private static Vector getFieldResourceNames(JetUProcedure query) {
        Vector vField = query.getFields();
        Vector<String> vFieldName = new Vector<String>();
        if (vField != null) {
            for (int i = 0; i < vField.size(); ++i) {
                JetUProcField field = (JetUProcField)vField.elementAt(i);
                vFieldName.addElement(field.getResourceNameInUpperCase());
            }
        }
        return vFieldName;
    }

    private static Vector getDbFieldResourceNames(JetUQuery query) {
        Vector vField = query.getDBFields();
        Vector<String> vFieldName = new Vector<String>();
        if (vField != null) {
            for (int i = 0; i < vField.size(); ++i) {
                JetUQueryField field = (JetUQueryField)vField.elementAt(i);
                vFieldName.addElement(field.getResourceNameInUpperCase());
            }
        }
        return vFieldName;
    }

    private static Vector getFieldResourceNames(JetUUserDataSource query) {
        Vector vField = query.getFields();
        Vector<String> vFieldName = new Vector<String>();
        if (vField != null) {
            for (int i = 0; i < vField.size(); ++i) {
                Object o = vField.elementAt(i);
                JetUUDSField field = (JetUUDSField)vField.elementAt(i);
                vFieldName.addElement(field.getResourceNameInUpperCase());
            }
        }
        return vFieldName;
    }

    public static ParamDesc getParamDesc(String paramName, JetUUniverse universe) {
        JetUResourceEntity entity = universe.getAnyResourceByName(paramName);
        if (entity == null || !(entity instanceof JetUParameter)) {
            return null;
        }
        ParamDesc pd = ((JetUParameter)entity).getParamDesc();
        UniverseToolkit.setBindColumn(pd);
        return pd;
    }

    public static ParamDesc getParamDesc(String paramName, JetUUniverse universe, String dataSourceName) {
        JetUDatabase db = universe.getDatabase(dataSourceName);
        if (db == null) {
            return null;
        }
        JetUParameter entity = db.getParameterByResourceName(paramName);
        if (entity == null || !(entity instanceof JetUParameter)) {
            return null;
        }
        ParamDesc pd = entity.getParamDesc();
        UniverseToolkit.setBindColumn(pd);
        return pd;
    }

    private static void setBindColumn(ParamDesc pd) {
        String colName;
        if (pd != null && (colName = pd.getColumn()) != null && colName.length() > 0) {
            pd.setBeColumn(4);
        }
    }

    public static Vector getAvlGroupFields(JetUUniverse unv, String dataSourceName) {
        Vector v = new Vector();
        JetUDatabase db = unv.getDatabase(dataSourceName);
        if (db == null) {
            return v;
        }
        Vector vQueriable = db.getQueriables();
        if (vQueriable != null) {
            for (int i = 0; i < vQueriable.size(); ++i) {
                JetUQueriable queriable = (JetUQueriable)vQueriable.elementAt(i);
                String queryName = queriable.getResourceName();
                Vector vField = UniverseToolkit.getAvlGroupFields(unv, dataSourceName, queryName);
                if (vField == null) continue;
                ArrayToolkit.merge(v, vField);
            }
        }
        return v;
    }

    private static Vector getAvlGroupFields(JetUUniverse universe, String dataSourceName, String uQueryName) {
        Vector<String> vecColumns = new Vector<String>();
        Vector vecAvailableColumns = universe.getAvailableResourceEntitys(dataSourceName, uQueryName);
        int iSize = vecAvailableColumns.size();
        for (int i = 0; i < iSize; ++i) {
            JetUResourceEntity re = (JetUResourceEntity)vecAvailableColumns.elementAt(i);
            if (re instanceof JetUDBField) {
                vecColumns.addElement(re.getResourceName());
                continue;
            }
            if (re instanceof JetUFmlQueryField) {
                vecColumns.addElement(re.getResourceName());
                continue;
            }
            if (!(re instanceof JetUFormula) || !((JetUFormula)re).canSummary()) continue;
            vecColumns.addElement(re.getResourceName());
        }
        return vecColumns;
    }

    public static boolean validUbvForCube(JetUUniverse universe, String datasourceName, String ubvName) {
        UnifiedBusinessView ubv = universe.getBV(datasourceName, ubvName);
        if (ubv != null) {
            JetUDemandQuery selfQuery = ubv.getQuery();
            Vector pTables = selfQuery.getPsqlQuery().getPsqlTablesVector();
            for (int i = 0; i < pTables.size(); ++i) {
                String queryName;
                PsqlTable psqlTable = (PsqlTable)pTables.get(i);
                if (!psqlTable.isQueriable() || UniverseToolkit.validQueryForCRD(universe, datasourceName, queryName = psqlTable.getMappingName())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean validQueryForCRD(JetUUniverse universe, String databaseName, String queryName) {
        JetUDatabase db = universe.getDatabase(databaseName);
        if (db == null) {
            return false;
        }
        JetUQueriable queriable = universe.getQueriableByResourceName(databaseName, queryName);
        if (queriable == null) {
            return false;
        }
        JetUConnection[] conns = queriable.getConnections();
        for (int i = 0; i < conns.length; ++i) {
            JetUConnection conn = conns[i];
            if (conn == null || !(conn instanceof JetUJDBCConnection) || StringTools.isEmptyStringWithTrim(((JetUJDBCConnection)conn).customQueryOptimizer.get())) continue;
            return false;
        }
        if (queriable instanceof JetUDemandQuery) {
            return false;
        }
        if (queriable instanceof JetUHierDataSource) {
            return false;
        }
        try {
            return !ParameterTool.isReferUserName(universe, databaseName, queryName);
        }
        catch (DSException e) {
            logger.error(0, new Object[]{"ParameterTool.getRefResourceNamesInQuery() + databaseName = " + databaseName + " queryName = " + queryName}, e);
            return false;
        }
    }

    public static boolean validParamForCRD(JetUUniverse universe, String databaseName, String paramName) {
        JetUDatabase db = universe.getDatabase(databaseName);
        if (db == null) {
            return false;
        }
        JetUParameter param = db.getParameterByResourceName(paramName);
        if (param == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Parameter: " + paramName + " can't be found.");
            }
            return false;
        }
        String rls = param.getSecurityEntry();
        if (rls != null && !"".equals(rls)) {
            logger.debug("Parameter: " + paramName + " has security entry.");
            return false;
        }
        if (!param.isCascading.get() && param.getParamDesc().getImportParams().size() != 0) {
            logger.debug("Parameter: " + paramName + " is manual cascading parameter .");
            return false;
        }
        return true;
    }

    public static Vector<String> getBusinessViews(JetUUniverse universe) {
        Vector<String> value = new Vector<String>();
        if (universe == null) {
            return null;
        }
        Vector dbs = universe.getAllDatabases();
        for (int i = 0; i < dbs.size(); ++i) {
            Vector<UnifiedBusinessView> bvs = ((JetUDatabase)dbs.get(i)).getBvs();
            for (UnifiedBusinessView unifiedBusinessView : bvs) {
                value.add(unifiedBusinessView.getDisplayName());
            }
        }
        return value;
    }

    public static String getAvailabelDriver(JetUUniverse uni, String databaseName, String queryName) {
        JetUConnection con;
        Hashtable conInfo = UniverseToolkit.getConInfoFromUDS(uni, databaseName, queryName);
        String driver = null;
        if (conInfo != null && !conInfo.isEmpty()) {
            driver = (String)conInfo.get("DRIVER");
        }
        if ((driver == null || driver.equals("")) && (con = uni.getDatabase(databaseName).getConnection()) instanceof JetUJDBCConnection) {
            JetUJDBCConnection jdbcCon = (JetUJDBCConnection)con;
            driver = jdbcCon.getJdbcDriver();
        }
        return driver;
    }

    private static Hashtable getConInfoFromUDS(JetUUniverse uni, String databaseName, String queryName) {
        if (uni == null || databaseName == null || queryName == null) {
            return new Hashtable();
        }
        Hashtable resultInfo = new Hashtable();
        JetUDatabase db = uni.getDatabase(databaseName);
        if (db == null) {
            return null;
        }
        JetUQueriable queriable = db.getQueriableByResourceName(queryName);
        if (queriable == null) {
            return null;
        }
        if (queriable instanceof JetUUserDataSource) {
            JetUUserDataSource uds = (JetUUserDataSource)queriable;
            String param = uds.getParameter();
            resultInfo = StringTools.parseStringConnectionInfo(param);
        }
        return resultInfo;
    }

    public static boolean isAllConstantFormula(JetUUniverse universe, String DataSourceName, String strQueryName, String[] MappingNames) {
        JetUDatabase db = universe.getDatabase(DataSourceName);
        for (int i = 0; i < MappingNames.length; ++i) {
            JetUResourceEntity re = db.getResourceByName(strQueryName, MappingNames[i]);
            if (re instanceof JetUFormula && ((JetUFormula)re).isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean BvUseMoreParameter(JetUUniverse universe, String dataSourceName, String ubvName) {
        DTInformation[] details;
        AggregationInfo[] aggs;
        GroupInfo[] gs;
        UnifiedBusinessView ubv = universe.getBV(dataSourceName, ubvName);
        String[] queryParaNames = null;
        try {
            queryParaNames = new ParseParametersForQuery(universe, dataSourceName, ubv.getQuery().getResourceName()).getParameterNamesInQuery(null, null);
        }
        catch (DSException e) {
            return true;
        }
        HashSet<String> queryParaNameSet = new HashSet<String>();
        for (String pName : queryParaNames) {
            queryParaNameSet.add(pName);
        }
        JetUDatabase db = universe.getDatabase(dataSourceName);
        ArrayList<String> mappingNames = new ArrayList<String>();
        for (GroupInfo groupInfo : gs = ubv.getAllGroups()) {
            mappingNames.add(groupInfo.getRefMappingName());
        }
        for (AggregationInfo aggregationInfo : aggs = ubv.getAllAggregations()) {
            mappingNames.add(aggregationInfo.getRefMappingName());
        }
        for (DTInformation detail : details = ubv.getAllDetails()) {
            mappingNames.add(detail.getRefMappingName());
        }
        for (String mappingName : mappingNames) {
            JetUResourceEntity entity = universe.getResourceByName(dataSourceName, null, mappingName);
            if (!(entity instanceof JetUFormula)) continue;
            Vector ps = ((JetUFormula)entity).getRefParamFld();
            for (String bvReferParameter : ps) {
                if (queryParaNameSet.contains(bvReferParameter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBuildinParameterName(String parameterName) {
        return "JRS_P_LOGOURL".equalsIgnoreCase(parameterName);
    }
}

