/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import com.jinfonet.security.api.AuthorizeManager;
import com.jinfonet.security.api.Permissions;
import com.jinfonet.security.api.PrincipalLoader;
import com.jinfonet.security.api.PrincipalManager;
import com.jinfonet.security.api.SecurityService;
import com.jinfonet.security.api.exception.InvalidResource;
import com.jinfonet.security.api.exception.NoPermissionException;
import com.jinfonet.security.control.JRGroup;
import com.jinfonet.security.control.JRRole;
import com.jinfonet.security.control.JRUser;
import com.jinfonet.security.util.FileNameToolkit;
import com.jinfonet.util.JWLog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParamBuildInFileQuery;
import jet.universe.JetUParamBuildInUQuery;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.PrincipalKey;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.MemberSecurityItem;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.convert.IExpression2Jet;
import jet.universe.businesslogic.filter.convert.Jet2IExpression;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.BusinessLogicToBusinessView;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.Detail;
import jet.universe.businesslogic.impl.FilterImpl;
import jet.universe.businesslogic.impl.UpgradedUnifiedBusinessView;
import jet.universe.psql.JetPsqlJoin;
import jet.universe.psql.JetRptPsqlQuery;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.psql.RptPsqlTools;
import jet.upgrade.UpgradeBV;
import jet.upgrade.UpgradeExpression;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;

public class UniverseUpdateTool {
    public static void updateToV13_5_unifiedBV(JetUUniverse universe) {
        Vector sources = universe.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
            int size2 = queriables.size();
            for (int j = 0; j < size2; ++j) {
                JBusinessView bv;
                JetUQueriable qs = queriables.get(j);
                JBusinessLogic bl = UpgradeBV.getBL(qs);
                if (qs instanceof JetUDemandQuery && bl == null) {
                    dataBase.remove((JetUDemandQuery)qs);
                }
                if (bl != null) {
                    UniverseUpdateTool.upgradeMLS(bl);
                    UpgradedUnifiedBusinessView uubv4bcrc = UniverseUpdateTool.createUpgradedUnifiedBusinessView4BCRC(dataBase, bl, qs);
                    UniverseUpdateTool.upgradeHierarchy(uubv4bcrc);
                    UniverseUpdateTool.upgradeFilter(uubv4bcrc, bl);
                    ((JetContainable)((Object)qs)).remove((JetObject)((Object)bl));
                }
                if ((bv = UpgradeBV.getBV(qs)) == null) continue;
                UniverseUpdateTool.upgradeMLS(bv);
                UpgradedUnifiedBusinessView uubv = UniverseUpdateTool.createUpgradedUnifiedBusinessView4BV(dataBase, bv, qs);
                UniverseUpdateTool.upgradeHierarchy(uubv);
                UniverseUpdateTool.upgradeFilter(uubv, bv);
                ((JetContainable)((Object)qs)).remove((JetObject)((Object)bv));
            }
        }
    }

    private static void upgradeHierarchy(UpgradedUnifiedBusinessView uubv) {
        HierarchyInfo[] hs;
        for (HierarchyInfo hierarchyInfo : hs = uubv.getAllHierarchies()) {
            String[] qNames = hierarchyInfo.getDimensionQDNames();
            ArrayList<String> dimQDNameList = new ArrayList<String>();
            for (int i = 0; i < qNames.length; ++i) {
                BLNode node = UpgradeBV.getBLNodeByQualifyName(uubv, qNames[i]);
                if (node == null) continue;
                dimQDNameList.add(node.getQualifyDisplayName());
            }
            String[] dimQDNames = new String[dimQDNameList.size()];
            dimQDNameList.toArray(dimQDNames);
            hierarchyInfo.setDimensions(dimQDNames);
        }
    }

    private static void upgradeFilter(UpgradedUnifiedBusinessView uubv, JBusinessLogic bl) {
        FilterInfo[] filters = uubv.getPrefilterInfo();
        for (int i = 0; i < filters.length; ++i) {
            try {
                Vector children = ((FilterImpl)filters[i]).getChildren();
                if (children.size() <= 0 || children.elementAt(0) == null) continue;
                UFilterExpression uFilter = (UFilterExpression)children.elementAt(0);
                IExpression exp = new Jet2IExpression().convert(uFilter, uubv.getDatabase().getUniverse(), uubv.getDatabase().getResourceName(), bl);
                ArrayList errorMsg = UpgradeExpression.replaceQN2QDN(uubv.getDatabase().getUniverse(), uubv.getDatabase().getResourceName(), uubv.oldQueryName.get(), uubv.oldBusinessType.get(), uubv.oldBusinessName.get(), exp, null);
                if (errorMsg == null || errorMsg.size() > 0) {
                    // empty if block
                }
                filters[i].setFilter(exp);
                continue;
            }
            catch (ConditionException e) {
                continue;
            }
            catch (DSException e) {
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void upgradeMLS(JBusinessLogic bl) {
        MemberSecurityEntry entry = bl.getMemberSecurityEntry();
        for (Object o : entry.getChildren()) {
            MemberSecurityItem msi = (MemberSecurityItem)o;
            String oldQName = msi.dimensionName.get();
            BLNode node = bl.get(oldQName);
            String qdName = "";
            if (node != null) {
                qdName = node.getQualifyDisplayName();
                msi.dimensionName.set(qdName);
            }
            String expOldName = oldQName;
            JetUDatabase udb = bl.getDatabase();
            JetUUniverse unv = (JetUUniverse)udb.getParent();
            UFilterExpression uAllowExp = (UFilterExpression)msi.children.get(0);
            IExpression allowExp = null;
            try {
                allowExp = new Jet2IExpression().convert(uAllowExp, unv, udb.getResourceName(), bl);
            }
            catch (ConditionException e) {
                // empty catch block
            }
            if (allowExp != null) {
                try {
                    ExpressionToolKit.rename(allowExp, expOldName, qdName);
                    UFilterExpression uAllowExp2 = new IExpression2Jet().convert(allowExp);
                    msi.children.set(0, uAllowExp2);
                    uAllowExp2.setParent(msi);
                }
                catch (ConditionException e) {
                }
                catch (DSException e) {
                    // empty catch block
                }
            }
            UFilterExpression uDenyExp = (UFilterExpression)msi.children.get(1);
            IExpression denyExp = null;
            try {
                denyExp = new Jet2IExpression().convert(uDenyExp, unv, udb.getResourceName(), bl);
            }
            catch (ConditionException e) {
                // empty catch block
            }
            if (denyExp == null) continue;
            try {
                ExpressionToolKit.rename(denyExp, expOldName, qdName);
                UFilterExpression uDenyExp2 = new IExpression2Jet().convert(denyExp);
                msi.children.set(1, uDenyExp2);
                uDenyExp2.setParent(msi);
            }
            catch (ConditionException e) {
            }
            catch (DSException e) {}
        }
    }

    private static UpgradedUnifiedBusinessView createUpgradedUnifiedBusinessView4BV(JetUDatabase dataBase, JBusinessView bv, JetUQueriable query) {
        String candidateName;
        UpgradedUnifiedBusinessView uubv = new UpgradedUnifiedBusinessView();
        uubv.prefetch.set(bv.isPrefetch());
        BLNode[] children = bv.getBLChildren();
        BLNode[] bvChildren = new BLNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            bvChildren[i] = children[i];
            try {
                uubv.addChild(bvChildren[i]);
                continue;
            }
            catch (BLDupleNameException e) {
                // empty catch block
            }
        }
        try {
            uubv.setName(bv.getName());
        }
        catch (BLDupleNameException e1) {
        }
        catch (BLIlegalNameException e1) {
            // empty catch block
        }
        String bvName = candidateName = bv.getDisplayName();
        int nameIndex = 1;
        while (dataBase.getBusinessView(bvName) != null) {
            bvName = candidateName + nameIndex;
            ++nameIndex;
        }
        uubv.setDisplayName4upgrade(bvName);
        uubv.oldQueryName.set(query.getResourceName());
        uubv.oldBusinessName.set(bv.getName());
        uubv.oldDisplayName.set(bv.getDisplayName());
        uubv.oldBusinessType.set(3);
        dataBase.add(uubv);
        RptPsqlQuery sqlQuery = new RptPsqlQuery();
        sqlQuery.setMappingName("");
        sqlQuery.setUniverse(dataBase.getUniverse(), dataBase.getResourceName());
        JetUDemandQuery uDemandQuery = new JetUDemandQuery("", sqlQuery.getCopy());
        uubv.add(uDemandQuery);
        uDemandQuery.setParent(uubv);
        PsqlTable psqlTable = RptPsqlTools.UQueryToPsqlTable(query);
        UniverseUpdateTool.addTable(sqlQuery, psqlTable);
        uDemandQuery.setPsqlQuery(sqlQuery);
        return uubv;
    }

    private static UpgradedUnifiedBusinessView createUpgradedUnifiedBusinessView4BCRC(JetUDatabase dataBase, JBusinessLogic bl, JetUQueriable query) {
        String candidateName;
        UpgradedUnifiedBusinessView uubv = BusinessLogicToBusinessView.unifyBusinessLogic(bl);
        uubv.setMemberSecurityEntry(bl.getMemberSecurityEntry());
        try {
            uubv.setName(bl.getName());
        }
        catch (BLDupleNameException e1) {
        }
        catch (BLIlegalNameException e1) {
            // empty catch block
        }
        String bvName = candidateName = bl.getDisplayName();
        int nameIndex = 1;
        while (dataBase.getBusinessView(bvName) != null) {
            bvName = candidateName + nameIndex;
            ++nameIndex;
        }
        uubv.setDisplayName4upgrade(bvName);
        uubv.oldQueryName.set(query.getResourceName());
        uubv.oldBusinessName.set(bl.getName());
        uubv.oldDisplayName.set(bl.getDisplayName());
        uubv.oldDisplayName.set(bl.getDisplayName());
        if (query instanceof JetUDemandQuery) {
            uubv.oldBusinessType.set(1);
        } else {
            uubv.oldBusinessType.set(2);
        }
        dataBase.add(uubv);
        if (query instanceof JetUDemandQuery) {
            JetUDemandQuery demandQuery = (JetUDemandQuery)query;
            dataBase.remove(demandQuery);
            uubv.add(demandQuery);
            demandQuery.setParent(uubv);
            FilterInfo bcFilterInfo = bl.getBCFilterInfo();
            if (bcFilterInfo != null) {
                try {
                    Vector children = ((FilterImpl)bcFilterInfo).getChildren();
                    if (children.size() > 0 && children.elementAt(0) != null) {
                        UFilterExpression uFilter = (UFilterExpression)children.elementAt(0);
                        IExpression bcFilter = new Jet2IExpression().convert(uFilter, uubv.getDatabase().getUniverse(), uubv.getDatabase().getResourceName(), bl);
                        IExpression queryFilter = demandQuery.getPsqlQuery().getSearchConditionGroups();
                        IExpression newFilter = queryFilter == null ? bcFilter : ExpressionToolKit.buildAndExpression(bcFilter, queryFilter);
                        demandQuery.getPsqlQuery().setSearchConditionGroups(ExpressionToolKit.buildUnCheckedExp(dataBase, newFilter));
                    }
                }
                catch (ConditionException e) {}
            }
        } else {
            RptPsqlQuery sqlQuery = new RptPsqlQuery();
            sqlQuery.setMappingName("");
            sqlQuery.setUniverse(dataBase.getUniverse(), dataBase.getResourceName());
            JetUDemandQuery uDemandQuery = new JetUDemandQuery("", sqlQuery.getCopy());
            uubv.add(uDemandQuery);
            uDemandQuery.setParent(uubv);
            PsqlTable psqlTable = RptPsqlTools.UQueryToPsqlTable(query);
            UniverseUpdateTool.addTable(sqlQuery, psqlTable);
            uDemandQuery.setPsqlQuery(sqlQuery);
        }
        return uubv;
    }

    private static void addTable(RptPsqlQuery sqlQuery, PsqlTable psqlTable) {
        int i;
        Vector<String> tableNameVec = new Vector<String>();
        int size = sqlQuery.getPsqlTables().size();
        Vector tables = (Vector)sqlQuery.getPsqlTables().clone();
        for (int i2 = 0; i2 < size; ++i2) {
            PsqlTable p = (PsqlTable)tables.elementAt(i2);
            tableNameVec.addElement(p.getMappingName());
        }
        if (psqlTable != null && !tableNameVec.contains(psqlTable.getMappingName())) {
            sqlQuery.vTables.addElement(psqlTable);
            Vector cols = psqlTable.getColumns();
            int colsSize = cols.size();
            for (int i3 = 0; i3 < colsSize; ++i3) {
                PsqlColumn psqlColumn = (PsqlColumn)cols.get(i3);
                UniverseUpdateTool.addSelColumnToTable(sqlQuery, psqlTable, psqlTable.getMappingName(), psqlColumn.getMappingName());
            }
            return;
        }
        int selColSize = sqlQuery.getSelColsVector().size();
        Vector selCols = sqlQuery.getSelColsVector();
        Vector<String> selColsName = new Vector<String>();
        for (i = 0; i < selColSize; ++i) {
            PsqlColumn selCol = (PsqlColumn)selCols.elementAt(i);
            JetUDatabase udb = sqlQuery.getDatabase();
            JetUResourceEntity object = udb.getResourceByName(selCol.getMappingName());
            if (object == null) {
                selCols.remove(i);
                --selColSize;
                --i;
                continue;
            }
            selColsName.addElement(selCol.getMappingName());
        }
        for (i = 0; i < psqlTable.getColumns().size(); ++i) {
            PsqlColumn psqlColumn = (PsqlColumn)psqlTable.getColumns().get(i);
            if (selColsName.contains(psqlColumn.getMappingName())) continue;
            UniverseUpdateTool.addSelColumnToTable(sqlQuery, psqlTable, psqlTable.getMappingName(), psqlColumn.getMappingName());
            selColsName.addElement(psqlColumn.getMappingName());
        }
    }

    public static void addSelColumnToTable(RptPsqlQuery psqlQuery, PsqlTable psqltable, String tableMappingName, String columnMappingName) {
        PsqlColumn newColumn = psqltable.getColumnByMappingName(columnMappingName);
        PsqlSelColumn psqlSelColumn = psqlQuery.addUFieldEntity(psqltable, newColumn);
        psqlSelColumn.setMappingName(columnMappingName);
        psqlSelColumn.setHide(false);
    }

    public static void updateToV13_1(JetUUniverse universe) {
        boolean updated = false;
        Vector sources = universe.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            String unvFileName;
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector cons = dataBase.getConnections();
            if (cons.size() > 0) {
                JetUConnection con = (JetUConnection)cons.get(0);
                con.setDefault();
                dataBase.initConnectionHandle();
                String connName = con.getResourceName();
                ArrayList<JetUFileQuery> uFileQueries = new ArrayList<JetUFileQuery>();
                ArrayList<JetUProcedure> uProcedure = new ArrayList<JetUProcedure>();
                Vector cs = con.getChildren();
                for (Object c : cs) {
                    if (c instanceof JetUFileQuery) {
                        uFileQueries.add((JetUFileQuery)c);
                    }
                    if (!(c instanceof JetUProcedure)) continue;
                    uProcedure.add((JetUProcedure)c);
                }
                for (JetUFileQuery f : uFileQueries) {
                    f.connectionName.set(connName);
                    con.remove(f);
                    dataBase.add(f);
                    f.AfterAdd();
                }
                for (JetUProcedure p : uProcedure) {
                    p.connectionName.set(connName);
                    con.remove(p);
                    dataBase.addProcedure(p);
                }
                dataBase.setPrejoin(con.preJoin.get());
            }
            Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
            JetUConnection conn = dataBase.getConnection();
            if (conn instanceof JetUJDBCConnection) {
                JetUJDBCConnection jdbcConn = (JetUJDBCConnection)conn;
                boolean sql92Flag = false;
                int size2 = queriables.size();
                for (int j = 0; j < size2; ++j) {
                    JetUQueriable qs = queriables.get(j);
                    if (!(qs instanceof JetUQuery) || !UniverseUpdateTool.upgradeOuterJoinMarker((JetUQuery)qs, jdbcConn)) continue;
                    sql92Flag = true;
                    break;
                }
                if (!sql92Flag) {
                    jdbcConn.setOuterJoinMarker(1);
                }
            }
            if ((unvFileName = universe.getFullFileName()) == null || "".equals(unvFileName)) {
                return;
            }
            AuthorizeManager authorizeManager = SecurityService.getInstance().getCubeAuthorizeManager(unvFileName, false);
            HashSet<PrincipalKey> principals = UniverseUpdateTool.getPrincipals(unvFileName);
            for (PrincipalKey key : principals) {
                int size2 = queriables.size();
                for (int j = 0; j < size2; ++j) {
                    JetUQueriable qs = queriables.get(j);
                    UniverseUpdateTool.upgradeAccessVisible(UpgradeBV.getBL(qs), key);
                    UniverseUpdateTool.upgradeAccessVisible(UpgradeBV.getBV(qs), key);
                }
            }
        }
    }

    private static boolean upgradeOuterJoinMarker(JetUQuery uQuery, JetUJDBCConnection jetUConnection) {
        Vector children = uQuery.getChildren();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetRptPsqlQuery)) continue;
            JetRptPsqlQuery jetPsqlQuery = (JetRptPsqlQuery)child;
            Vector children2 = jetPsqlQuery.getChildren();
            for (Object object : children2) {
                if (!(object instanceof JetPsqlJoin)) continue;
                JetPsqlJoin join = (JetPsqlJoin)object;
                if (join.isOrcl.get()) continue;
                jetUConnection.setOuterJoinMarker(0);
                return true;
            }
        }
        return false;
    }

    private static void update2MultiConnection(JetUDatabase dataBase) {
        dataBase.getConnection().setDefault();
    }

    private static void upgradeAccessVisible(JBusinessLogic bl, PrincipalKey key) {
        MemberSecurityItem[] sItems;
        if (bl == null) {
            return;
        }
        int type = key.type;
        String name2 = key.name;
        if (!"everyone".equals(name2)) {
            return;
        }
        MemberSecurityEntry sEntry = bl.getMemberSecurityEntry();
        for (MemberSecurityItem sItem : sItems = sEntry.getSecurityItem(type, name2)) {
            sItem.setPermission_access_allow(true);
        }
    }

    public static boolean updateToV13(JetUUniverse universe) {
        String unvFileName = universe.getFullFileName();
        if (unvFileName == null || "".equals(unvFileName)) {
            return false;
        }
        Vector sources = universe.getAllDatabases();
        AuthorizeManager authorizeManager = SecurityService.getInstance().getCubeAuthorizeManager(unvFileName, false);
        HashSet<PrincipalKey> principals = UniverseUpdateTool.getPrincipals(unvFileName);
        boolean updated = false;
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
            for (PrincipalKey key : principals) {
                int size2 = queriables.size();
                for (int j = 0; j < size2; ++j) {
                    JetUQueriable qs = queriables.get(j);
                    if (UniverseUpdateTool.setBLrootPermissionVisible(UpgradeBV.getBL(qs), key)) {
                        updated = true;
                    }
                    if (!UniverseUpdateTool.setBLrootPermissionVisible(UpgradeBV.getBV(qs), key)) continue;
                    updated = true;
                }
            }
        }
        return updated;
    }

    private static boolean setBLrootPermissionVisible(JBusinessLogic bl, PrincipalKey key) {
        boolean ret = false;
        if (bl == null) {
            return ret;
        }
        int type = key.type;
        String name2 = key.name;
        MemberSecurityEntry sEntry = bl.getMemberSecurityEntry();
        MemberSecurityItem sItem = sEntry.getSecurityItem(type, name2, bl.getBLQualifyName());
        if (sItem == null) {
            MemberSecurityItem newItem = new MemberSecurityItem(type, name2, bl.getBLQualifyName());
            newItem.setPermission_visible(true);
            sEntry.addSecurityItem(newItem);
            ret = true;
        }
        return ret;
    }

    public static boolean updateToV12021(JetUUniverse universe) {
        String unvFileName = universe.getFullFileName();
        if (unvFileName == null || "".equals(unvFileName)) {
            return false;
        }
        Vector sources = universe.getAllDatabases();
        AuthorizeManager authorizeManager = SecurityService.getInstance().getCubeAuthorizeManager(unvFileName, false);
        HashSet<PrincipalKey> principals = UniverseUpdateTool.getPrincipals(unvFileName);
        boolean updated = false;
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
            for (PrincipalKey key : principals) {
                int size2 = queriables.size();
                for (int j = 0; j < size2; ++j) {
                    JetUQueriable qs = queriables.get(j);
                    if (UniverseUpdateTool.reversePermissionVisible(UpgradeBV.getBL(qs), key)) {
                        updated = true;
                    }
                    if (!UniverseUpdateTool.reversePermissionVisible(UpgradeBV.getBV(qs), key)) continue;
                    updated = true;
                }
            }
        }
        return updated;
    }

    public static void updateToV91(JetUUniverse universe) {
        Vector sources = universe.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
            int size2 = queriables.size();
            for (int j = 0; j < size2; ++j) {
                JetUQueriable q = queriables.get(j);
                if (!(q instanceof JetUQuery)) continue;
                JetUQuery uQuery = (JetUQuery)q;
                RptPsqlQuery pQuery = uQuery.getPsqlQuery();
                Vector ts = pQuery.getPsqlTables();
                for (int k = 0; k < ts.size(); ++k) {
                    PsqlTable pTable = (PsqlTable)ts.get(k);
                    String aliasName = pTable.getCorrelationName();
                    String tableResourceName = pTable.getMappingName();
                    String dbRealName = pTable.getName();
                    if (aliasName == null) continue;
                    Vector cons = dataBase.getConnections();
                    JetUConnection con = (JetUConnection)cons.get(0);
                    JetUTableView tv = con.GetTableOrViewByResourceName(aliasName);
                    if (tv != null) {
                        tv.tableType.set(tv.tableType.intValue() | 4);
                    } else {
                        tv = new JetUTableView(tableResourceName, "", 5, pTable.getQualifier(), pTable.getOwner(), dbRealName);
                        con.addTableView(tv);
                    }
                    Vector cols = pTable.getColumns();
                    int size = cols.size();
                    for (int l = 0; l < size; ++l) {
                        PsqlColumn pCol = (PsqlColumn)cols.get(l);
                        if (tv.getFieldByResourceName(pCol.getMappingName()) != null) continue;
                        JetUField uField = new JetUField(pCol.getMappingName(), "", pCol.getName(), pCol.getType(), pCol.getPrecision(), pCol.getScale(), pCol.getNullable());
                        tv.addField(uField);
                    }
                }
            }
        }
    }

    private static HashSet<PrincipalKey> getPrincipals(String unvFileName) {
        HashSet<PrincipalKey> principals = new HashSet<PrincipalKey>();
        PrincipalManager principalManager = SecurityService.getInstance().getPrincipalManager();
        int loaderType = principalManager.getLoaderType();
        if (loaderType == -1) {
            loaderType = 4;
        }
        PrincipalLoader principalLoader = null;
        try {
            Properties prop;
            String fileName;
            principalLoader = principalManager.getPrincipalLoader(loaderType);
            if (loaderType == 4) {
                fileName = FileNameToolkit.buildAuthFileName(unvFileName, "principals");
                prop = new Properties();
                prop.put("input_path", fileName);
                principalLoader.preLoad(prop);
            } else if (loaderType == 1) {
                fileName = FileNameToolkit.buildAuthFileName(unvFileName, "principals");
                prop = new Properties();
                prop.put("load_from_locale", "true");
                prop.put("system_path", fileName);
                principalLoader.preLoad(prop);
            }
        }
        catch (Exception e) {
            if (JWLog.isError(2)) {
                JWLog.error(2, e);
            }
            return principals;
        }
        Vector users = principalLoader.getUsers();
        for (JRUser user : users) {
            principals.add(new PrincipalKey(1, user.getName()));
        }
        Vector roles = principalLoader.getRoles();
        for (JRRole role : roles) {
            principals.add(new PrincipalKey(2, role.getName()));
        }
        Vector groups = principalLoader.getGroups();
        for (JRGroup group : groups) {
            principals.add(new PrincipalKey(3, group.getName()));
        }
        return principals;
    }

    private static boolean reversePermissionVisible(JBusinessLogic bl, PrincipalKey key) {
        boolean ret = false;
        if (bl == null) {
            return ret;
        }
        int type = key.type;
        String name2 = key.name;
        MemberSecurityEntry sEntry = bl.getMemberSecurityEntry();
        ArrayList<BLNode> nodes = UniverseUpdateTool.gatherNodes(bl);
        for (int i = 0; i < nodes.size(); ++i) {
            boolean find = false;
            MemberSecurityItem[] sItems = sEntry.getSecurityItem(type, name2);
            for (int k = 0; k < sItems.length; ++k) {
                if (!sItems[k].dimensionName.get().equals(nodes.get(i).getBLQualifyName())) continue;
                find = true;
                break;
            }
            if (find) continue;
            MemberSecurityItem newItem = new MemberSecurityItem(type, name2, nodes.get(i).getBLQualifyName());
            newItem.setPermission_visible(true);
            sEntry.addSecurityItem(newItem);
            ret = true;
        }
        return ret;
    }

    private static ArrayList<BLNode> gatherNodes(JBusinessLogic bl) {
        ArrayList<BLNode> nodes = new ArrayList<BLNode>();
        nodes.add(bl);
        DetailInformation[] details = bl.getAllDetailInfos();
        for (int i = 0; i < details.length; ++i) {
            nodes.add(details[i]);
        }
        MeasureInfo[] ms = bl.getAllMeasures();
        for (int i = 0; i < ms.length; ++i) {
            nodes.add(ms[i]);
        }
        DimensionInfo[] ds = bl.getAllDimensions();
        for (int i = 0; i < ds.length; ++i) {
            nodes.add(ds[i]);
        }
        CategoryInfo[] cs = bl.getAllCategories();
        for (int i = 0; i < cs.length; ++i) {
            nodes.add(cs[i]);
        }
        return nodes;
    }

    private static void gatherPrincipal(JBusinessLogic bl, HashSet<PrincipalKey> principals) {
        if (bl == null) {
            return;
        }
        MemberSecurityEntry sEntry = bl.getMemberSecurityEntry();
        for (Object o : sEntry.getChildren()) {
            MemberSecurityItem msi = (MemberSecurityItem)o;
            if (msi.getPermission_visible().booleanValue()) continue;
            int type = msi.principalType.get();
            String name2 = msi.principalName.get();
            principals.add(new PrincipalKey(type, name2));
        }
    }

    public static boolean updateToV1202(JetUUniverse universe) {
        String unvFileName = universe.getFullFileName();
        if (unvFileName == null || "".equals(unvFileName)) {
            return false;
        }
        Vector sources = universe.getAllDatabases();
        AuthorizeManager authorizeManager = SecurityService.getInstance().getCubeAuthorizeManager(unvFileName, false);
        boolean updated = false;
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
            int size2 = queriables.size();
            for (int j = 0; j < size2; ++j) {
                JBusinessView bv;
                JetUQueriable qs = queriables.get(j);
                JBusinessLogic bl = UpgradeBV.getBL(qs);
                if (UniverseUpdateTool.updateBL(authorizeManager, bl)) {
                    updated = true;
                }
                if (UniverseUpdateTool.upgradeDimension(bl)) {
                    updated = true;
                }
                if (UniverseUpdateTool.updateBL(authorizeManager, bv = UpgradeBV.getBV(qs))) {
                    updated = true;
                }
                if (!UniverseUpdateTool.upgradeDimension(bv)) continue;
                updated = true;
            }
        }
        return updated;
    }

    private static boolean upgradeDimension(CategoryInfo cat) {
        boolean ret = false;
        if (cat == null) {
            return ret;
        }
        DimensionInfo[] ds = cat.getDimensions();
        for (int i = 0; i < ds.length; ++i) {
            int sqlType;
            DbColDesc colDesc;
            String mappingName = ds[i].getRefMappingName();
            JetUQueriable query = (JetUQueriable)((Object)cat.getBusinessLogic().getQuery());
            JetUDatabase dataBase = query.getDatabase();
            JetUResourceEntity res = dataBase.getResourceByName(mappingName);
            if (res == null || (colDesc = res.getColDesc()) == null || DataTypeUtils.isCompareAble(sqlType = colDesc.getSqlType())) continue;
            ret = true;
            cat.removeChildByName(ds[i].getName());
            Detail detail = new Detail();
            try {
                detail.setName(ds[i].getName());
                detail.setDisplayName(ds[i].getDisplayName());
                detail.setRefMappingName(mappingName);
                ((Category)cat).add(detail);
                continue;
            }
            catch (BLDupleNameException e) {
                continue;
            }
            catch (BLIlegalNameException e) {
                // empty catch block
            }
        }
        CategoryInfo[] cats = cat.getCategories();
        for (int i = 0; i < cats.length; ++i) {
            if (!UniverseUpdateTool.upgradeDimension(cats[i])) continue;
            ret = true;
        }
        return ret;
    }

    private static boolean updateBL(AuthorizeManager authorizeManager, JBusinessLogic bl) {
        boolean ret = false;
        if (bl == null) {
            return ret;
        }
        MemberSecurityEntry sEntry = bl.getMemberSecurityEntry();
        ArrayList<BLNode> nodes = UniverseUpdateTool.gatherNodes(bl);
        int size3 = nodes.size();
        for (int i = 0; i < size3; ++i) {
            Hashtable[] permissions = null;
            try {
                permissions = authorizeManager.getPermissions("jinfonet-designer-operator", nodes.get(i).getBLQualifyName());
            }
            catch (NoPermissionException e) {
            }
            catch (InvalidResource e) {
                // empty catch block
            }
            if (permissions == null) continue;
            void userPermission = permissions[0];
            Enumeration keys = userPermission.keys();
            while (keys.hasMoreElements()) {
                MemberSecurityItem[] sItems;
                boolean find;
                String userName = (String)keys.nextElement();
                Vector permissionValue = (Vector)userPermission.get(userName);
                if (permissionValue != null && permissionValue.size() > 0 && permissionValue.get(0) != Permissions.P_VISIBLE || permissionValue != null && permissionValue.size() == 0) {
                    ret = true;
                    find = false;
                    sItems = sEntry.getSecurityItem(1, userName);
                    for (int k = 0; k < sItems.length; ++k) {
                        if (!sItems[k].dimensionName.get().equals(nodes.get(i).getBLQualifyName())) continue;
                        sItems[k].setPermission_visible(false);
                        find = true;
                    }
                    if (find) continue;
                    MemberSecurityItem newItem = new MemberSecurityItem(1, userName, nodes.get(i).getBLQualifyName());
                    newItem.setPermission_visible(false);
                    sEntry.addSecurityItem(newItem);
                    continue;
                }
                ret = true;
                find = false;
                sItems = sEntry.getSecurityItem(1, userName);
                for (int k = 0; k < sItems.length; ++k) {
                    if (!sItems[k].dimensionName.get().equals(nodes.get(i).getBLQualifyName())) continue;
                    sItems[k].setPermission_visible(true);
                    find = true;
                }
                if (find) continue;
                MemberSecurityItem newItem = new MemberSecurityItem(1, userName, nodes.get(i).getBLQualifyName());
                newItem.setPermission_visible(true);
                sEntry.addSecurityItem(newItem);
            }
            Hashtable rolePermission = permissions[1];
            keys = rolePermission.keys();
            while (keys.hasMoreElements()) {
                String roleName = (String)keys.nextElement();
                Vector permissionValue = (Vector)rolePermission.get(roleName);
                if (permissionValue == null || permissionValue.size() <= 0 || permissionValue.get(0) == Permissions.P_VISIBLE) continue;
                ret = true;
                boolean find = false;
                MemberSecurityItem[] sItems = sEntry.getSecurityItem(2, roleName);
                for (int k = 0; k < sItems.length; ++k) {
                    if (!sItems[k].dimensionName.get().equals(nodes.get(i).getBLQualifyName())) continue;
                    sItems[k].setPermission_visible(false);
                    find = true;
                }
                if (find) continue;
                MemberSecurityItem newItem = new MemberSecurityItem(2, roleName, nodes.get(i).getBLQualifyName());
                newItem.setPermission_visible(false);
                sEntry.addSecurityItem(newItem);
            }
            Hashtable groupPermission = permissions[2];
            keys = groupPermission.keys();
            while (keys.hasMoreElements()) {
                String groupName = (String)keys.nextElement();
                Vector permissionValue = (Vector)groupPermission.get(groupName);
                if (permissionValue == null || permissionValue.size() <= 0 || permissionValue.get(0) == Permissions.P_VISIBLE) continue;
                ret = true;
                boolean find = false;
                MemberSecurityItem[] sItems = sEntry.getSecurityItem(3, groupName);
                for (int k = 0; k < sItems.length; ++k) {
                    if (!sItems[k].dimensionName.get().equals(nodes.get(i).getBLQualifyName())) continue;
                    sItems[k].setPermission_visible(false);
                    find = true;
                }
                if (find) continue;
                MemberSecurityItem newItem = new MemberSecurityItem(3, groupName, nodes.get(i).getBLQualifyName());
                newItem.setPermission_visible(false);
                sEntry.addSecurityItem(newItem);
            }
        }
        return ret;
    }

    public static void fixbug4V13(JetUUniverse universe) {
        Vector sources = universe.getAllDatabases();
        int s = sources.size();
        for (int i = 0; i < s; ++i) {
            JetUDatabase dataBase = (JetUDatabase)sources.get(i);
            Vector<JetUQueriable> queriables = UniverseUpdateTool.originalGetQueriables(dataBase);
            int size2 = queriables.size();
            for (int j = 0; j < size2; ++j) {
                JetUQueriable qs = queriables.get(j);
                JBusinessLogic bl = UpgradeBV.getBL(qs);
                UniverseUpdateTool.eliminateDuplic(bl);
                JBusinessView bv = UpgradeBV.getBV(qs);
                UniverseUpdateTool.eliminateDuplic(bv);
            }
        }
    }

    public static Vector<JetUQueriable> originalGetQueriables(JetUDatabase dataBase) {
        Vector<JetUQueriable> ret = new Vector<JetUQueriable>();
        Vector children = dataBase.getChildren();
        for (Object object : children) {
            if (!(object instanceof JetUQueriable) || object instanceof JetUParamBuildInUQuery || object instanceof JetUParamBuildInFileQuery) continue;
            ret.add((JetUQueriable)object);
        }
        Vector conns = dataBase.getConnections();
        for (JetUConnection conn : conns) {
            UniverseUpdateTool.getQueriable(conn, ret);
        }
        return ret;
    }

    private static void getQueriable(JetUConnection conn, Vector<JetUQueriable> ret) {
        Vector children = conn.getChildren();
        for (Object object : children) {
            if (!(object instanceof JetUQueriable) || object instanceof JetUParamBuildInUQuery || object instanceof JetUParamBuildInFileQuery || ret.contains(object)) continue;
            ret.add((JetUQueriable)object);
        }
    }

    private static void eliminateDuplic(JBusinessLogic bl) {
        if (bl == null) {
            return;
        }
        MemberSecurityEntry entry = bl.getMemberSecurityEntry();
        BusinessLogic businessLogic = (BusinessLogic)bl;
        Vector c = businessLogic.getChildren();
        for (int i = c.size() - 1; i >= 0; --i) {
            JetObject child = (JetObject)c.get(i);
            if (!(child instanceof MemberSecurityEntry)) continue;
            c.remove(i);
        }
        businessLogic.add(entry);
        ArrayList<MemberSecurityItem> msis = new ArrayList<MemberSecurityItem>();
        for (Object o : entry.getChildren()) {
            MemberSecurityItem msi = (MemberSecurityItem)o;
            if (UniverseUpdateTool.contain(msis, msi)) continue;
            msis.add(msi);
        }
        entry.clear();
        for (int i = 0; i < msis.size(); ++i) {
            MemberSecurityItem m = msis.get(i);
            entry.addSecurityItem(m);
        }
    }

    private static boolean contain(ArrayList<MemberSecurityItem> msis, MemberSecurityItem msi) {
        int principalType = msi.principalType.get();
        String principalName = msi.principalName.get();
        String dimensionName = msi.dimensionName.get();
        for (int i = 0; i < msis.size(); ++i) {
            MemberSecurityItem m = msis.get(i);
            if (m.principalType.get() != principalType || !m.principalName.get().equals(principalName) || !m.dimensionName.get().equals(dimensionName)) continue;
            return true;
        }
        return false;
    }
}

