/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Vector;
import jet.log.JRLogger;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUWherePortion;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.JBusinessLogic;

public class UniverseUtil {
    private static JRLogger logger = JRLogger.getLogger(UniverseUtil.class.getName());

    public static boolean replaceMappedName(JetUFormula[] formulas, String oldName, String newName) {
        boolean bReplaced = false;
        for (JetUFormula formula2 : formulas) {
            if (formula2 instanceof JetUSummary) {
                JetUSummary summary = (JetUSummary)formula2;
                String fieldName = summary.getFieldName();
                String grpName = summary.getGroupByFld();
                if (fieldName.equalsIgnoreCase(oldName)) {
                    summary.setFieldName(newName);
                    bReplaced = true;
                }
                if (!grpName.equalsIgnoreCase(oldName)) continue;
                summary.setGroupByFld(newName);
                bReplaced = true;
                continue;
            }
            String expression = formula2.getExpression();
            String newExp = UniverseUtil.replaceName(expression, oldName, newName);
            if (newExp == null) continue;
            bReplaced = true;
            formula2.setExpression(newExp);
        }
        return bReplaced;
    }

    public static boolean replaceMappingName(JetUWherePortion[] wherePortions, String oldName, String newName) {
        boolean bReplaced = false;
        for (JetUWherePortion wherePortion : wherePortions) {
            String expression = wherePortion.getWherePortion();
            String newExp = UniverseUtil.replaceName(expression, oldName, newName);
            if (newExp == null) continue;
            bReplaced = true;
            wherePortion.setWherePortion(newExp);
        }
        return bReplaced;
    }

    public static String replaceParamName(String expression, String oldName, String newName) {
        StringBuffer buffer = new StringBuffer(JetUResourceEntity.qutoedWhenNeed(oldName));
        buffer.setCharAt(0, ':');
        oldName = buffer.toString().toUpperCase();
        buffer = new StringBuffer(JetUResourceEntity.qutoedWhenNeed(newName));
        buffer.setCharAt(0, ':');
        newName = buffer.toString().toUpperCase();
        String upperExpresison = expression.toUpperCase();
        int iIndex = upperExpresison.indexOf(oldName);
        if (iIndex >= 0) {
            String ret = UniverseUtil.replaceString(expression, oldName, newName);
            if (oldName.charAt(1) != '\"') {
                String searchStr2 = ":\"" + oldName.substring(1) + "\"";
                String newRet = UniverseUtil.replaceName(ret, searchStr2, newName);
                if (newRet != null) {
                    return newRet;
                }
                return ret;
            }
            return ret;
        }
        if (oldName.charAt(1) != '\"') {
            String searchStr2 = ":\"" + oldName.substring(1) + "\"";
            String ret = UniverseUtil.replaceString(expression, searchStr2, newName);
            return ret;
        }
        return null;
    }

    public static String replaceName(String expression, String oldName, String newName) {
        oldName = JetUResourceEntity.transferQuote(oldName.toUpperCase());
        oldName = JetUResourceEntity.qutoedWhenNeed(oldName);
        newName = JetUResourceEntity.transferQuote(newName.toUpperCase());
        newName = JetUResourceEntity.qutoedWhenNeed(newName);
        String upperExpresison = expression.toUpperCase();
        int iIndex = upperExpresison.indexOf(oldName);
        if (iIndex >= 0) {
            String ret = UniverseUtil.replaceString(expression, oldName, newName);
            if (oldName.charAt(1) != '\"') {
                String searchStr2 = oldName.substring(0, 1) + "\"" + oldName.substring(1) + "\"";
                String newRet = UniverseUtil.replaceName(ret, searchStr2, newName);
                if (newRet != null) {
                    return newRet;
                }
                return ret;
            }
            return ret;
        }
        if (oldName.charAt(1) != '\"') {
            String searchStr2 = oldName.substring(0, 1) + "\"" + oldName.substring(1) + "\"";
            return UniverseUtil.replaceString(expression, searchStr2, newName);
        }
        return null;
    }

    public static String replaceString(String expression, String oldName, String newName) {
        String upperExpresison = expression.toUpperCase();
        int iIndex = upperExpresison.indexOf(oldName);
        int nameLen = oldName.length();
        if (iIndex >= 0) {
            String ret = new String(expression.substring(0, iIndex));
            ret = ret + newName;
            String subString = expression.substring(iIndex + nameLen);
            String upperString = upperExpresison.substring(iIndex + nameLen);
            iIndex = upperString.indexOf(oldName);
            while (iIndex >= 0) {
                ret = ret + subString.substring(0, iIndex);
                ret = ret + newName;
                subString = subString.substring(iIndex + nameLen);
                upperString = upperString.substring(iIndex + nameLen);
                iIndex = upperString.indexOf(oldName);
            }
            if (subString != null) {
                ret = ret + subString;
            }
            return ret;
        }
        return null;
    }

    public static String replaceMappingName(String expression, String oldName, String newName, char sch) {
        boolean space;
        StringBuffer buf = new StringBuffer();
        String operators = " */-%+<>=|&!)}";
        int index = 0;
        int last = 0;
        int length = expression.length();
        boolean bl = space = newName.indexOf(32) != -1;
        while ((index = expression.indexOf(sch, last)) != -1) {
            int idx;
            buf.append(expression.substring(last, ++index));
            if (index >= length) continue;
            StringBuffer oName = new StringBuffer();
            char ch = expression.charAt(index);
            if (ch == '\"') {
                idx = expression.indexOf(34, ++index);
                buf.append(ch);
                oName.append(expression.substring(index, idx));
            } else {
                idx = index;
                while (operators.indexOf(ch) == -1) {
                    oName.append(ch);
                    if (idx < expression.length() - 1) {
                        ch = expression.charAt(++idx);
                        continue;
                    }
                    ++idx;
                    break;
                }
            }
            if (oName.toString().equalsIgnoreCase(oldName)) {
                if (space && ch != '\"') {
                    buf.append('\"').append(newName).append('\"');
                } else {
                    buf.append(newName);
                }
            } else {
                buf.append(oName);
            }
            last = idx;
        }
        buf.append(expression.substring(last));
        return buf.toString();
    }

    private static void getChildren(BLContainer container, String className, Vector ret) {
        BLNode[] bns = container.getBLChildren();
        for (int i = 0; i < bns.length; ++i) {
            BLNode bn = bns[i];
            if (bn instanceof BLContainer && (bn instanceof CategoryInfo || bn instanceof JBusinessLogic)) {
                BLContainer blContainer = (BLContainer)bn;
                UniverseUtil.getChildren(blContainer, className, ret);
            }
            if (!bn.getClass().getName().equals(className)) continue;
            ret.add(bn);
        }
    }
}

