/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.JRProductConstants;
import jet.ReportEnv;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.transform.ExpressionTransform;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.log.JRLogger;
import jet.universe.JetUDatabase;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.MemberSecurityItem;
import jet.universe.businesslogic.impl.BLContainerImpl;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.UnifiedBusinessView;

public class MemberSecurityEntry
extends BLContainerImpl {
    public static final int USER = 1;
    public static final int ROLE = 2;
    public static final int GROUP = 3;
    public static final int ENUMERATION = 1;
    public static final int EXPRESSION = 2;
    public static ISingleLogicExpression BOOLTRUE;
    public static ISingleLogicExpression BOOLFALSE;
    private static JRLogger logger;
    public static final int POSITIVE = 1;
    public static final int UNKNOWN = 0;
    public static final int NEGATIVE = -1;

    public MemberSecurityEntry() {
        try {
            BOOLTRUE = ExpressionFactoryCreator.getIExpressionFactory().getBooleanTrue();
            BOOLFALSE = ExpressionFactoryCreator.getIExpressionFactory().getBooleanFalse();
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
    }

    public MemberSecurityItem getSecurityItem(int principalType, String principalName, String dimensionName) {
        for (Object o : this.getChildren()) {
            MemberSecurityItem msi = (MemberSecurityItem)o;
            if (msi.principalType.get() != principalType || !msi.principalName.get().equals(principalName) || !msi.dimensionName.get().equals(dimensionName)) continue;
            return msi;
        }
        if (principalType == 2 && principalName.equals("everyone")) {
            MemberSecurityItem msi = new MemberSecurityItem(principalType, principalName, dimensionName);
            msi.setPermission_visible_allow(true);
            msi.setPermission_access_allow(true);
            msi.setParent(this);
            return msi;
        }
        return null;
    }

    public void updateSecurityItem(String oldDimensionName, String newDimensionName) {
        for (Object o : this.getChildren()) {
            IExpression denyExp;
            MemberSecurityItem msi = (MemberSecurityItem)o;
            if (!msi.dimensionName.get().equals(oldDimensionName)) continue;
            IExpression allowExp = msi.getAllowIExpression();
            if (allowExp != null) {
                try {
                    ExpressionToolKit.rename(allowExp, oldDimensionName, newDimensionName);
                    msi.setIExpressionDirectly(allowExp, 0);
                }
                catch (ConditionException e) {
                }
                catch (DSException e) {
                    // empty catch block
                }
            }
            if ((denyExp = msi.getDenyIExpression()) != null) {
                try {
                    ExpressionToolKit.rename(denyExp, oldDimensionName, newDimensionName);
                    msi.setIExpressionDirectly(denyExp, 1);
                }
                catch (ConditionException e) {
                }
                catch (DSException e) {
                    // empty catch block
                }
            }
            msi.dimensionName.set(newDimensionName);
        }
    }

    public MemberSecurityItem getSecurityItemForEdit(int principalType, String principalName, String dimensionName) {
        MemberSecurityItem msi = this.getSecurityItem(principalType, principalName, dimensionName);
        if (msi == null) {
            msi = new MemberSecurityItem(principalType, principalName, dimensionName);
            msi.setParent(this);
        }
        return msi;
    }

    public void addSecurityItem(MemberSecurityItem newMsi) {
        int principalType = newMsi.principalType.get();
        String principalName = newMsi.principalName.get();
        String dimensionName = newMsi.dimensionName.get();
        Vector children = this.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            Object o = children.get(i);
            MemberSecurityItem msi = (MemberSecurityItem)o;
            if (msi.principalType.get() != principalType || !msi.principalName.get().equals(principalName) || !msi.dimensionName.get().equals(dimensionName)) continue;
            children.remove(i);
        }
        this.add(newMsi);
    }

    public MemberSecurityItem[] getSecurityItem(int principalType, String principalName) {
        ArrayList<MemberSecurityItem> ret = new ArrayList<MemberSecurityItem>();
        for (Object o : this.getChildren()) {
            MemberSecurityItem msi = (MemberSecurityItem)o;
            if (msi.principalType.get() != principalType || !msi.principalName.get().equals(principalName)) continue;
            ret.add(msi);
        }
        return ret.toArray(new MemberSecurityItem[ret.size()]);
    }

    private boolean hasSecurity(int principalType, String principalName) {
        for (Object o : this.getChildren()) {
            MemberSecurityItem msi = (MemberSecurityItem)o;
            if (msi.principalType.get() != principalType || !msi.principalName.get().equals(principalName)) continue;
            return true;
        }
        return false;
    }

    public boolean removeSecurityItem(int principalType, String principalName) {
        boolean ret = false;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            MemberSecurityItem msi = (MemberSecurityItem)it.next();
            if (msi.principalType.get() != principalType || !msi.principalName.get().equals(principalName)) continue;
            it.remove();
            ret = true;
        }
        return ret;
    }

    public boolean removeInvalidSecurityItem(SecurityData sd) {
        boolean ret = false;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            MemberSecurityItem msi = (MemberSecurityItem)it.next();
            if (this.isValidPrincipal(msi.principalType.get(), msi.principalName.get(), sd)) continue;
            it.remove();
            ret = true;
        }
        return ret;
    }

    private boolean isValidPrincipal(int principalType, String principalName, SecurityData sd) {
        java.security.Principal principal = null;
        switch (principalType) {
            case 3: {
                principal = sd.getGroup(principalName);
                break;
            }
            case 2: {
                principal = sd.getRole(principalName);
                break;
            }
            case 1: {
                principal = sd.getUser(principalName);
            }
        }
        return principal != null;
    }

    public IExpression getSecurityFilter(SecurityData sd, String userName, MemberSecurityEntry dynamicSecurityEntry) {
        return this.getSecurityFilter(sd, userName, dynamicSecurityEntry, true);
    }

    public IExpression getSecurityFilter(SecurityData sd, String userName, MemberSecurityEntry dynamicSecurityEntry, boolean isMappingName) {
        if (ReportEnv.productid == JRProductConstants.PRODUCTIDFORDESIGNER) {
            return null;
        }
        if (sd == null || sd.getUser(userName) == null) {
            return null;
        }
        logger.outLine("MemberSecurityEntry.getSecurityFilter()   " + sd + "  userName = " + userName + " isMappingName =" + isMappingName);
        DimensionInfo[] dimensions = null;
        JetContainable parent = this.getParent();
        dimensions = parent instanceof BusinessLogic ? ((BusinessLogic)parent).getAllDimensions() : ((UnifiedBusinessView)parent).getAllDimensions();
        ArrayList<IExpression> retList = new ArrayList<IExpression>();
        try {
            for (DimensionInfo dimensionInfo : dimensions) {
                IExpression eachDimension = this.buildExp4dimension(sd, userName, dimensionInfo, dynamicSecurityEntry, isMappingName);
                if (eachDimension == null) continue;
                retList.add(eachDimension);
            }
            if (retList.size() == 0) {
                return null;
            }
            IExpression ret = this.buildAnd(retList.toArray(new IExpression[retList.size()]));
            if (BOOLTRUE.equals(ret)) {
                ret = null;
            }
            logger.outLine("MemberSecurityEntry.getSecurityFilter() =  " + (ret == null ? "null" : ret.toString()));
            return ret;
        }
        catch (ConditionException e) {
            logger.error("MemberSecurityEntry.getSecurityFilter()", e);
            return null;
        }
    }

    private IExpression buildExp4dimension(SecurityData sd, String userName, DimensionInfo dimensionInfo, MemberSecurityEntry dynamicSecurityEntry, boolean isMappingName) throws ConditionException {
        String dimensionName = dimensionInfo.getQualifyDisplayName();
        Principal principal = new Principal(1, userName);
        MemberSecurityItem item = dynamicSecurityEntry != null && dynamicSecurityEntry.hasSecurity(principal.type, principal.name) ? dynamicSecurityEntry.getSecurityItem(principal.type, principal.name, dimensionName) : this.getSecurityItem(principal.type, principal.name, dimensionName);
        boolean allowUnspecified = item == null ? true : item.isAllowUnspecified();
        IExpressionPair pair = this.buildExp(sd, principal, dimensionName, allowUnspecified, dynamicSecurityEntry, isMappingName);
        ArrayList<IExpressionPair> pairs = new ArrayList<IExpressionPair>();
        pairs.add(pair);
        return this.mergePair(pairs);
    }

    private IExpression mergePair(List<IExpressionPair> pairs) throws ConditionException {
        ArrayList<IExpression> allowExps = new ArrayList<IExpression>();
        ArrayList<IExpression> denyExps = new ArrayList<IExpression>();
        int size = pairs.size();
        for (int i = 0; i < size; ++i) {
            IExpressionPair pair = pairs.get(i);
            allowExps.add(pair.allowExp);
            denyExps.add(pair.DenyExp);
        }
        IExpression denyExp = this.buildOr(denyExps.toArray(new IExpression[denyExps.size()]));
        IExpression notDenyExp = null;
        notDenyExp = denyExp == BOOLTRUE ? BOOLFALSE : (denyExp == BOOLFALSE ? BOOLTRUE : ExpressionToolKit.buildNotExpression(denyExp));
        IExpression allowExp = this.buildOr(allowExps.toArray(new IExpression[allowExps.size()]));
        return this.buildAnd(new IExpression[]{notDenyExp, allowExp});
    }

    private IExpression buildOr(IExpression[] iExpressions) throws ConditionException {
        ArrayList<IExpression> temp = new ArrayList<IExpression>();
        for (int i = 0; i < iExpressions.length; ++i) {
            if (iExpressions[i] == BOOLTRUE) {
                return BOOLTRUE;
            }
            if (iExpressions[i] == BOOLFALSE) continue;
            temp.add(iExpressions[i]);
        }
        if (temp.size() == 0) {
            return BOOLFALSE;
        }
        if (temp.size() == 1) {
            return (IExpression)temp.get(0);
        }
        return ExpressionToolKit.buildOrExpression(temp.toArray(new IExpression[0]));
    }

    private IExpression buildAnd(IExpression[] iExpressions) throws ConditionException {
        ArrayList<IExpression> temp = new ArrayList<IExpression>();
        for (int i = 0; i < iExpressions.length; ++i) {
            if (iExpressions[i] == BOOLFALSE) {
                return BOOLFALSE;
            }
            if (iExpressions[i] == BOOLTRUE) continue;
            temp.add(iExpressions[i]);
        }
        if (temp.size() == 0) {
            return BOOLTRUE;
        }
        if (temp.size() == 1) {
            return (IExpression)temp.get(0);
        }
        return ExpressionToolKit.buildAndExpression(temp.toArray(new IExpression[0]));
    }

    private IExpressionPair buildExp(SecurityData sd, Principal principal, String dimensionName, boolean allowUnspecified, MemberSecurityEntry dynamicSecurityEntry, boolean isMappingName) throws ConditionException {
        MemberSecurityItem item;
        Principal[] principals = this.getParents(sd, principal);
        ArrayList<IExpressionPair> pairs = new ArrayList<IExpressionPair>();
        for (Principal principal2 : principals) {
            IExpressionPair ip = this.buildExp(sd, principal2, dimensionName, allowUnspecified, dynamicSecurityEntry, isMappingName);
            pairs.add(ip);
        }
        IExpression inheritedExp = null;
        inheritedExp = pairs.size() > 0 ? this.mergePair(pairs) : (allowUnspecified ? BOOLTRUE : BOOLFALSE);
        boolean useDynamicSecurity = false;
        if (dynamicSecurityEntry != null && dynamicSecurityEntry.hasSecurity(principal.type, principal.name)) {
            item = dynamicSecurityEntry.getSecurityItem(principal.type, principal.name, dimensionName);
            useDynamicSecurity = true;
        } else {
            item = this.getSecurityItem(principal.type, principal.name, dimensionName);
        }
        IExpression allowExp = null;
        IExpression denyExp = null;
        if (item == null) {
            allowExp = BOOLFALSE;
            denyExp = BOOLFALSE;
        } else {
            JetUUniverse unv = (JetUUniverse)MemberSecurityEntry.getRoot(this);
            UnifiedBusinessView ubv = (UnifiedBusinessView)this.getParent();
            JetUDatabase db = ubv.getDatabase();
            IExpression allowExpQName = item.getAllowIExpression();
            if (allowExpQName == BOOLFALSE || allowExpQName == BOOLTRUE) {
                allowExp = allowExpQName;
            } else {
                if (useDynamicSecurity) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("MemberSecurityEntry:useDynamicSecurity before" + allowExpQName.toString());
                    }
                    allowExpQName = ExpressionTransform.toQualifyName(allowExpQName, dimensionName);
                    if (logger.isDebugEnabled()) {
                        logger.debug("MemberSecurityEntry:useDynamicSecurity after" + allowExpQName.toString());
                    }
                }
                if (isMappingName) {
                    allowExp = ExpressionToolKit.newExpWithQualifyNameExp(unv, db.getResourceName(), ubv.getDisplayName(), allowExpQName);
                    if (logger.isDebugEnabled()) {
                        logger.debug("MemberSecurityEntry:QualifyNameExp to mappingExp " + allowExpQName.toString());
                        logger.debug("MemberSecurityEntry:QualifyNameExp to mappingExp " + allowExp.toString());
                    }
                } else {
                    allowExp = allowExpQName;
                }
            }
            IExpression denyExpQName = item.getDenyIExpression();
            if (denyExpQName == BOOLFALSE || denyExpQName == BOOLTRUE) {
                denyExp = denyExpQName;
            } else {
                if (useDynamicSecurity) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("MemberSecurityEntry:useDynamicSecurity before" + denyExpQName.toString());
                    }
                    denyExpQName = ExpressionTransform.toQualifyName(denyExpQName, dimensionName);
                    if (logger.isDebugEnabled()) {
                        logger.debug("MemberSecurityEntry:useDynamicSecurity after" + denyExpQName.toString());
                    }
                }
                if (isMappingName) {
                    denyExp = ExpressionToolKit.newExpWithQualifyNameExp(unv, db.getResourceName(), ubv.getDisplayName(), denyExpQName);
                    if (logger.isDebugEnabled()) {
                        logger.debug("MemberSecurityEntry:QualifyNameExp to mappingExp " + denyExpQName);
                        logger.debug("MemberSecurityEntry:QualifyNameExp to mappingExp " + denyExp);
                    }
                } else {
                    denyExp = denyExpQName;
                }
            }
        }
        return new IExpressionPair(this.buildOr(new IExpression[]{allowExp, inheritedExp}), denyExp);
    }

    private Principal[] getParents(SecurityData sd, Principal principal) {
        int principalType = principal.type;
        String principalName = principal.name;
        ArrayList<Principal> ret = new ArrayList<Principal>();
        switch (principalType) {
            case 3: {
                BaseGroup baseGroup = sd.getGroup(principalName);
                Vector gName = baseGroup.getParentGroupNames();
                int size = gName.size();
                for (int i = 0; i < size; ++i) {
                    ret.add(new Principal(3, (String)gName.get(i)));
                }
                Vector rName = baseGroup.getRoleNames();
                int size2 = rName.size();
                for (int i = 0; i < size2; ++i) {
                    ret.add(new Principal(2, (String)rName.get(i)));
                }
                break;
            }
            case 2: {
                BaseRole baseRole = sd.getRole(principalName);
                Vector rName = baseRole.getParentRoleNames();
                int size = rName.size();
                for (int i = 0; i < size; ++i) {
                    ret.add(new Principal(2, (String)rName.get(i)));
                }
                break;
            }
            case 1: {
                BaseUser baseUser = sd.getUser(principalName);
                Vector rName = baseUser.getParentRoleNames();
                int size = rName.size();
                for (int i = 0; i < size; ++i) {
                    ret.add(new Principal(2, (String)rName.get(i)));
                }
                Vector gName = baseUser.getGroupNames();
                int size3 = gName.size();
                for (int i = 0; i < size3; ++i) {
                    ret.add(new Principal(3, (String)gName.get(i)));
                }
                break;
            }
        }
        return ret.toArray(new Principal[0]);
    }

    public MemberSecurityEntry copy() {
        MemberSecurityEntry ret = new MemberSecurityEntry();
        JetObject.copyProperties(ret, this);
        Vector children = this.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            MemberSecurityItem msi = (MemberSecurityItem)children.get(i);
            ret.addSecurityItem(msi.copy());
        }
        return ret;
    }

    public boolean checkPermission_access(SecurityData sd, String userName, String bLNodeQDName, MemberSecurityEntry dynamicSecurityEntry) {
        if (sd == null || sd.getUser(userName) == null) {
            return true;
        }
        Principal principal = new Principal(1, userName);
        return this.checkPermission_access(sd, principal, bLNodeQDName, dynamicSecurityEntry) == 1;
    }

    private int checkPermission_access(SecurityData sd, Principal principal, String bLNodeQDName, MemberSecurityEntry dynamicSecurityEntry) {
        MemberSecurityItem item = null;
        item = dynamicSecurityEntry != null && dynamicSecurityEntry.hasSecurity(principal.type, principal.name) ? dynamicSecurityEntry.getSecurityItem(principal.type, principal.name, bLNodeQDName) : this.getSecurityItem(principal.type, principal.name, bLNodeQDName);
        if (item != null) {
            if (item.getPermission_access_allow().booleanValue()) {
                return 1;
            }
            if (item.getPermission_access_deny().booleanValue()) {
                return -1;
            }
        }
        int permission_access = 0;
        Principal[] principals = this.getParents(sd, principal);
        for (int i = 0; i < principals.length; ++i) {
            if (-1 == this.checkPermission_access(sd, principals[i], bLNodeQDName, dynamicSecurityEntry)) {
                return -1;
            }
            if (1 != this.checkPermission_access(sd, principals[i], bLNodeQDName, dynamicSecurityEntry)) continue;
            permission_access = 1;
        }
        return permission_access;
    }

    public boolean checkPermission_visible(SecurityData sd, String userName, String bLNodeQualifyName, MemberSecurityEntry dynamicSecurityEntry) {
        if (sd == null || sd.getUser(userName) == null) {
            return true;
        }
        Principal principal = new Principal(1, userName);
        return this.checkPermission_visible(sd, principal, bLNodeQualifyName, dynamicSecurityEntry) == 1;
    }

    private int checkPermission_visible(SecurityData sd, Principal principal, String bLNodeQualifyName, MemberSecurityEntry dynamicSecurityEntry) {
        int i;
        MemberSecurityItem item = null;
        item = dynamicSecurityEntry != null && dynamicSecurityEntry.hasSecurity(principal.type, principal.name) ? dynamicSecurityEntry.getSecurityItem(principal.type, principal.name, bLNodeQualifyName) : this.getSecurityItem(principal.type, principal.name, bLNodeQualifyName);
        if (item != null) {
            if (item.getPermission_visible_allow().booleanValue()) {
                logger.debug("Permission_visible is POSITIVE. MemberSecurityItem " + item + " " + principal + " bLNodeQualifyName = [" + bLNodeQualifyName + "]");
                return 1;
            }
            if (item.getPermission_visible_deny().booleanValue()) {
                logger.debug("Permission_visible is NEGATIVE. MemberSecurityItem " + item + " " + principal + " bLNodeQualifyName = [" + bLNodeQualifyName + "]");
                return -1;
            }
        }
        int permission_visible = 0;
        Principal[] principals = this.getParents(sd, principal);
        logger.debug("Permission_visible is UNKNOWN. sd = " + sd + " :: " + principal + " has Parents: ");
        for (i = 0; i < principals.length; ++i) {
            logger.debug(" " + principals[i]);
        }
        for (i = 0; i < principals.length; ++i) {
            if (-1 == this.checkPermission_visible(sd, principals[i], bLNodeQualifyName, dynamicSecurityEntry)) {
                return -1;
            }
            if (1 != this.checkPermission_visible(sd, principals[i], bLNodeQualifyName, dynamicSecurityEntry)) continue;
            permission_visible = 1;
        }
        return permission_visible;
    }

    static {
        logger = JRLogger.getLogger(MemberSecurityEntry.class.getName());
    }

    class Principal {
        int type;
        String name;

        public Principal(int type, String name2) {
            this.type = type;
            this.name = name2;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("Principal type = [");
            switch (this.type) {
                case 1: {
                    ret.append("USER");
                    break;
                }
                case 2: {
                    ret.append("ROLE");
                    break;
                }
                case 3: {
                    ret.append("GROUP");
                }
            }
            ret.append("]  name = [");
            ret.append(this.name);
            ret.append("]");
            return ret.toString();
        }
    }

    class IExpressionPair {
        IExpression allowExp;
        IExpression DenyExp;

        public IExpressionPair(IExpression allowExp, IExpression denyExp) {
            this.allowExp = allowExp;
            this.DenyExp = denyExp;
        }
    }
}

