/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic;

import com.jinfonet.dataservice.expression.tuple.BinaryConditionExpressionImpl;
import com.jinfonet.dataservice.expression.tuple.SingleLogicExpressionImpl;
import com.jinfonet.dataservice.expression.variable.ConstantImpl;
import com.jinfonet.dataservice.expression.variable.VariableListImpl;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.universe.JetUDatabase;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.convert.IExpression2Jet;
import jet.universe.businesslogic.filter.convert.Jet2IExpression;
import jet.universe.businesslogic.impl.UnifiedBusinessView;

public class MemberSecurityItem
extends JetUResourceContainer {
    public static final int ALLOWINDEX = 0;
    public static final int DENYINDEX = 1;
    public JetNumber principalType = new JetNumber(this, "PrincipalType");
    public JetString principalName = new JetString(this, "PrincipalName");
    public JetString dimensionName = new JetString(this, "DimensionName");
    public JetNumber allowIExpressionType = new JetNumber(this, "AllowIExpressionType");
    public JetNumber denyIExpressionType = new JetNumber(this, "DenyIExpressionType");
    public JetBoolean allowUnspecified = new JetBoolean(this, "AllowUnspecified", true);
    public JetBoolean permission_visible = new JetBoolean(this, "Permission_visible", false);
    public JetBoolean permission_visible_deny = new JetBoolean(this, "Permission_visible_deny", false);
    public JetBoolean permission_access_allow = new JetBoolean(this, "Permission_access_allow", false);
    public JetBoolean permission_access_deny = new JetBoolean(this, "Permission_access_deny", false);

    public MemberSecurityItem() {
        this.permission_visible.setEnableAutoValue(true);
        this.permission_visible.setAsAutoValue(true);
    }

    @Override
    public void InitAfterLoad() {
        if (this.permission_visible.isCurrentAutoValue()) {
            if (this.getDatabase().getUniverse().versionNumber.get() < 14) {
                this.permission_visible.set(true);
            } else {
                this.permission_visible.set(false);
            }
            this.permission_visible.setEnableAutoValue(false);
        }
    }

    public MemberSecurityItem(int principalType, String principalName, String dimensionName) {
        this.principalType.set(principalType);
        this.principalName.set(principalName);
        this.dimensionName.set(dimensionName);
        this.children.add(null);
        this.children.add(null);
        try {
            this.setAllowValueList(new DbValue[0]);
            this.setDenyValueList(new DbValue[0]);
        }
        catch (ConditionException e) {
            // empty catch block
        }
    }

    public IExpression getAllowIExpression() {
        UFilterExpression exp = (UFilterExpression)this.children.get(0);
        if (exp == null) {
            return null;
        }
        UnifiedBusinessView ubv = (UnifiedBusinessView)((JetObject)((Object)this.getParent())).getParent();
        JetUDatabase udb = ubv.getDatabase();
        JetUUniverse unv = (JetUUniverse)udb.getParent();
        IExpression ret = null;
        try {
            ret = new Jet2IExpression().convert(exp, unv, udb.getResourceName(), ubv);
        }
        catch (ConditionException e) {
            // empty catch block
        }
        if (MemberSecurityItem.isTrue(ret)) {
            return MemberSecurityEntry.BOOLTRUE;
        }
        if (MemberSecurityItem.isFalse(ret)) {
            return MemberSecurityEntry.BOOLFALSE;
        }
        return ret;
    }

    public void setAllowIExpression(IExpression exp) throws ConditionException {
        if (exp == null) {
            return;
        }
        this.allowIExpressionType.set(2);
        UFilterExpression child = new IExpression2Jet().convert(exp);
        this.children.set(0, child);
        child.setParent(this);
    }

    public IExpression getDenyIExpression() {
        UFilterExpression exp = (UFilterExpression)this.children.get(1);
        if (exp == null) {
            return null;
        }
        UnifiedBusinessView ubv = (UnifiedBusinessView)((JetObject)((Object)this.getParent())).getParent();
        JetUDatabase udb = ubv.getDatabase();
        JetUUniverse unv = (JetUUniverse)udb.getParent();
        IExpression ret = null;
        try {
            ret = new Jet2IExpression().convert(exp, unv, udb.getResourceName(), ubv);
        }
        catch (ConditionException e) {
            // empty catch block
        }
        if (MemberSecurityItem.isTrue(ret)) {
            return MemberSecurityEntry.BOOLTRUE;
        }
        if (MemberSecurityItem.isFalse(ret)) {
            return MemberSecurityEntry.BOOLFALSE;
        }
        return ret;
    }

    public void setDenyIExpression(IExpression exp) throws ConditionException {
        if (exp == null) {
            return;
        }
        this.denyIExpressionType.set(2);
        UFilterExpression child = new IExpression2Jet().convert(exp);
        this.children.set(1, child);
        child.setParent(this);
    }

    void setIExpressionDirectly(IExpression exp, int index) throws ConditionException {
        if (exp == null) {
            return;
        }
        UFilterExpression child = new IExpression2Jet().convert(exp);
        this.children.set(index, child);
        child.setParent(this);
    }

    public void setAllowValueList(DbValue[] valueList) throws ConditionException {
        this.allowIExpressionType.set(1);
        UFilterExpression child = this.ValueList2exp(valueList);
        this.children.set(0, child);
        child.setParent(this);
    }

    private UFilterExpression ValueList2exp(DbValue[] valueList) throws ConditionException {
        IBooleanExpression exp = null;
        if (valueList == null || valueList.length == 0) {
            exp = ExpressionFactoryCreator.getIExpressionFactory().getBooleanFalse();
        } else {
            UnifiedBusinessView ubv = (UnifiedBusinessView)((JetObject)((Object)this.getParent())).getParent();
            JetUDatabase udb = ubv.getDatabase();
            JetUUniverse unv = (JetUUniverse)udb.getParent();
            exp = ExpressionToolKit.buildExpression(this.dimensionName.get(), valueList, unv, udb.getResourceName(), ubv.getDisplayName());
        }
        UFilterExpression uFilterExpression = new IExpression2Jet().convert(exp);
        return uFilterExpression;
    }

    public DbValue[] getAllowValueList() throws ConditionException {
        IExpression exp = this.getAllowIExpression();
        return this.exp2DbValue(exp);
    }

    private DbValue[] exp2DbValue(IExpression exp) throws ConditionException {
        if (exp == null || exp instanceof SingleLogicExpressionImpl) {
            return new DbValue[0];
        }
        UnifiedBusinessView ubv = (UnifiedBusinessView)((MemberSecurityEntry)this.getParent()).getParent();
        DimensionInfo dimen = (DimensionInfo)ubv.getByDisplayName(this.dimensionName.get());
        String mappingName = dimen.getRefMappingName();
        JetUResourceEntity field = ubv.getDatabase().getResourceByName(mappingName);
        DbColDesc cd = field.getColDesc();
        DbValue dv = DbValue.makeDbValue(cd);
        IExpression right = ((BinaryConditionExpressionImpl)exp).getExpression2();
        if (right instanceof VariableListImpl) {
            VariableListImpl r = (VariableListImpl)right;
            DbValue[] ret = new DbValue[r.size()];
            for (int j = 0; j < r.size(); ++j) {
                IVariableExpression v = r.getVariableExp(j);
                dv.setValue(v.getStringValue(false));
                ret[j] = (DbValue)dv.clone();
            }
            return ret;
        }
        if (right instanceof ConstantImpl) {
            ConstantImpl v = (ConstantImpl)right;
            DbValue[] ret = new DbValue[]{(DbValue)dv.clone()};
            ret[0].setValue(v.getStringValue(false));
            return ret;
        }
        return new DbValue[0];
    }

    public void setAllowValueListAll() {
        this.allowIExpressionType.set(1);
        try {
            ISingleLogicExpression exp = ExpressionFactoryCreator.getIExpressionFactory().getBooleanTrue();
            UFilterExpression uFilterExpression = new IExpression2Jet().convert(exp);
            this.children.set(0, uFilterExpression);
            uFilterExpression.setParent(this);
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
    }

    public void setDenyValueListAll() {
        this.denyIExpressionType.set(1);
        try {
            ISingleLogicExpression exp = ExpressionFactoryCreator.getIExpressionFactory().getBooleanTrue();
            UFilterExpression uFilterExpression = new IExpression2Jet().convert(exp);
            this.children.set(1, uFilterExpression);
            uFilterExpression.setParent(this);
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
    }

    public boolean isAllowValueListAll() {
        return MemberSecurityItem.isTrue(this.getAllowIExpression());
    }

    public boolean isDenyValueListAll() {
        return MemberSecurityItem.isTrue(this.getDenyIExpression());
    }

    private static boolean isTrue(IExpression exp) {
        SingleLogicExpressionImpl sExp;
        IExpression inExp;
        if (exp instanceof SingleLogicExpressionImpl && (inExp = (sExp = (SingleLogicExpressionImpl)exp).getExpression()) instanceof ConstantImpl) {
            ConstantImpl v = (ConstantImpl)inExp;
            try {
                return v.getStringValue(false).equalsIgnoreCase("false");
            }
            catch (ConditionException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isFalse(IExpression exp) {
        SingleLogicExpressionImpl sExp;
        IExpression inExp;
        if (exp instanceof SingleLogicExpressionImpl && (inExp = (sExp = (SingleLogicExpressionImpl)exp).getExpression()) instanceof ConstantImpl) {
            ConstantImpl v = (ConstantImpl)inExp;
            try {
                return v.getStringValue(false).equalsIgnoreCase("true");
            }
            catch (ConditionException e) {
                // empty catch block
            }
        }
        return false;
    }

    public void setDenyValueList(DbValue[] valueList) throws ConditionException {
        this.denyIExpressionType.set(1);
        UFilterExpression child = this.ValueList2exp(valueList);
        this.children.set(1, child);
        child.setParent(this);
    }

    public DbValue[] getDenyValueList() throws ConditionException {
        IExpression exp = this.getDenyIExpression();
        return this.exp2DbValue(exp);
    }

    public boolean isAllowExpression() {
        return this.allowIExpressionType.get() == 2;
    }

    public boolean isDenyExpression() {
        return this.denyIExpressionType.get() == 2;
    }

    public boolean isAllowUnspecified() {
        return this.allowUnspecified.get();
    }

    public void setAllowUnspecified(boolean applyDeny) {
        this.allowUnspecified.set(applyDeny);
    }

    @Deprecated
    public Boolean getPermission_visible() {
        return this.getPermission_visible_allow();
    }

    @Deprecated
    public void setPermission_visible(Boolean visible) {
        this.setPermission_visible_allow(visible);
    }

    public Boolean getPermission_visible_allow() {
        return this.permission_visible.get();
    }

    public void setPermission_visible_allow(Boolean visible) {
        this.permission_visible.set(visible);
        if (visible.booleanValue()) {
            this.permission_visible_deny.set(false);
        }
    }

    public Boolean getPermission_visible_deny() {
        return this.permission_visible_deny.get();
    }

    public void setPermission_visible_deny(Boolean permission_visible_deny) {
        this.permission_visible_deny.set(permission_visible_deny);
        if (permission_visible_deny.booleanValue()) {
            this.permission_visible.set(false);
        }
    }

    public Boolean getPermission_access_allow() {
        return this.permission_access_allow.get();
    }

    public void setPermission_access_allow(Boolean permission_access_allow) {
        this.permission_access_allow.set(permission_access_allow);
        if (permission_access_allow.booleanValue()) {
            this.permission_access_deny.set(false);
        }
    }

    public Boolean getPermission_access_deny() {
        return this.permission_access_deny.get();
    }

    public void setPermission_access_deny(Boolean permission_access_deny) {
        this.permission_access_deny.set(permission_access_deny);
        if (permission_access_deny.booleanValue()) {
            this.permission_access_allow.set(false);
        }
    }

    public MemberSecurityItem copy() {
        MemberSecurityItem ret = new MemberSecurityItem();
        ret.permission_visible.setEnableAutoValue(false);
        ret.children.add(null);
        ret.children.add(null);
        try {
            ret.setAllowIExpression(this.getAllowIExpression());
            ret.setDenyIExpression(this.getDenyIExpression());
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        JetObject.copyProperties(ret, this);
        return ret;
    }

    @Override
    public String toString() {
        String ret = "principalName = " + this.principalName.get() + " dimensionName = " + this.dimensionName + " permission_visible_allow = " + this.permission_visible + " permission_visible_deny = " + this.permission_visible_deny + " permission_access_allow = " + this.permission_access_allow + " permission_access_deny = " + this.permission_access_deny;
        return ret;
    }
}

