/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.filter.convert;

import com.jinfonet.dataservice.expression.unchecked.UnCheckedOperatorImpl;
import java.util.Vector;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperator;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.IOperatorInforFactory;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine.api.expression.OperatorTypes;
import jet.dataengine.api.expression.calculate.ICalculateExpression;
import jet.dataengine.api.expression.calculate.op.IBinaryCalculateOperator;
import jet.dataengine.api.expression.calculate.op.ISingleCalculateOperator;
import jet.dataengine.api.expression.calculate.op.ITripleCalculateOperator;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.set.op.ITopNOperator;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.expression.tuple.op.IBinaryConditionOperator;
import jet.dataengine.api.expression.tuple.op.IMultiLogicOperator;
import jet.dataengine.api.expression.tuple.op.ISingleConditionOperator;
import jet.dataengine.api.expression.tuple.op.ISingleLogicOperator;
import jet.dataengine.api.expression.tuple.op.ITripleConditionOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.calculate.UBinaryCalculateExpression;
import jet.universe.businesslogic.filter.calculate.USingleCalculateExpression;
import jet.universe.businesslogic.filter.calculate.UTripleCalculateExpression;
import jet.universe.businesslogic.filter.set.USortExpression;
import jet.universe.businesslogic.filter.set.USortInfo;
import jet.universe.businesslogic.filter.set.UTopNSortExpression;
import jet.universe.businesslogic.filter.tuple.UBinaryConditionExpression;
import jet.universe.businesslogic.filter.tuple.UBinaryLogicExpression;
import jet.universe.businesslogic.filter.tuple.UMultiTupleExpression;
import jet.universe.businesslogic.filter.tuple.USingleConditionExpression;
import jet.universe.businesslogic.filter.tuple.USingleLogicExpression;
import jet.universe.businesslogic.filter.tuple.UTripleConditionExpression;
import jet.universe.businesslogic.filter.unchecked.UUnCheckedBinaryExpression;
import jet.universe.businesslogic.filter.unchecked.UUnCheckedMultiExpression;
import jet.universe.businesslogic.filter.unchecked.UUnCheckedSingleExpression;
import jet.universe.businesslogic.filter.unchecked.UUnCheckedTripleExpression;
import jet.universe.businesslogic.filter.unchecked.UUnCheckedVariableExpression;
import jet.universe.businesslogic.filter.variable.UConstantExpression;
import jet.universe.businesslogic.filter.variable.UFormulaExpression;
import jet.universe.businesslogic.filter.variable.UParameterExpression;
import jet.universe.businesslogic.filter.variable.UReferenceExpression;
import jet.universe.businesslogic.filter.variable.UVariableListExpression;

public class Jet2IExpression {
    private IExpressionFactory expFactory = null;
    private IOperatorFactory opFactory = null;
    private IOperatorInforFactory infoFactory = null;

    public IExpression convert(UFilterExpression exp, JetUUniverse unv, String udbName, BLNode bl) throws ConditionException {
        if (exp == null) {
            return null;
        }
        if (this.expFactory == null) {
            this.expFactory = ExpressionFactoryCreator.getIExpressionFactory(unv, udbName, bl);
        }
        if (this.opFactory == null) {
            this.opFactory = ExpressionFactoryCreator.getIOperatorFactory();
        }
        if (this.infoFactory == null) {
            this.infoFactory = ExpressionFactoryCreator.getIOperatorInforFactory();
        }
        boolean isParenthesized = exp.isParenthesized();
        IExpression resultIE = null;
        switch (exp.getType()) {
            case 0x600000: {
                UUnCheckedMultiExpression checkMultiE = (UUnCheckedMultiExpression)exp;
                UnCheckedOperatorImpl op = new UnCheckedOperatorImpl(checkMultiE.getOp());
                int multiSize = checkMultiE.getChildren().size();
                IUnCheckedExpression[] expression = new IUnCheckedExpression[multiSize];
                for (int i = 0; i < multiSize; ++i) {
                    expression[i] = (IUnCheckedExpression)this.convert((UFilterExpression)checkMultiE.getChildren().get(i), unv, udbName, bl);
                }
                resultIE = this.expFactory.createUnCheckedMultiExpression(op, expression);
                break;
            }
            case 0x301001: {
                UMultiTupleExpression mExp = (UMultiTupleExpression)exp;
                int type = mExp.getOperator();
                int mSize = mExp.getChildren().size();
                IExpression[] vExp = new IExpression[mSize];
                for (int i = 0; i < mSize; ++i) {
                    vExp[i] = this.convert((UFilterExpression)mExp.getChildren().get(i), unv, udbName, bl);
                }
                if (type == -2125463550) {
                    resultIE = ExpressionToolKit.buildAndExpression(vExp);
                    break;
                }
                if (type != -2125463548) break;
                resultIE = ExpressionToolKit.buildOrExpression(vExp);
                break;
            }
            case 0x480000: {
                UUnCheckedTripleExpression UCExp = (UUnCheckedTripleExpression)exp;
                IExpression exp1 = this.convert(UCExp.getExpression1(), unv, udbName, bl);
                IExpression exp2 = this.convert(UCExp.getExpression2(), unv, udbName, bl);
                IExpression exp3 = this.convert(UCExp.getExpression3(), unv, udbName, bl);
                UnCheckedOperatorImpl op = new UnCheckedOperatorImpl(UCExp.getOp());
                resultIE = this.expFactory.createUnCheckedTripleExpression(op, (IUnCheckedExpression)exp1, (IUnCheckedExpression)exp2, (IUnCheckedExpression)exp3);
                break;
            }
            case 32896: 
            case 0x408080: {
                UUnCheckedVariableExpression variableE = (UUnCheckedVariableExpression)exp;
                resultIE = this.expFactory.createUnCheckedVariableExpression(variableE.getValue(), variableE.isConstantValue());
                break;
            }
            case 0x420000: {
                UUnCheckedSingleExpression expSingle = (UUnCheckedSingleExpression)exp;
                IExpression expC = this.convert(expSingle.getExpression(), unv, udbName, bl);
                UnCheckedOperatorImpl op = new UnCheckedOperatorImpl(expSingle.getOp());
                resultIE = this.expFactory.createUnCheckedSingleExpression(op, (IUnCheckedExpression)expC);
                break;
            }
            case 0x440000: {
                UUnCheckedBinaryExpression UCExp = (UUnCheckedBinaryExpression)exp;
                IExpression exp1 = this.convert(UCExp.getExpression1(), unv, udbName, bl);
                IExpression exp2 = this.convert(UCExp.getExpression2(), unv, udbName, bl);
                UnCheckedOperatorImpl op = new UnCheckedOperatorImpl(UCExp.getOp());
                resultIE = this.expFactory.createUnCheckedBinaryExpression(op, (IUnCheckedExpression)exp1, (IUnCheckedExpression)exp2);
                break;
            }
            case 0x141001: {
                UBinaryLogicExpression tExp = (UBinaryLogicExpression)exp;
                IExpression exp1 = this.convert(tExp.getExpression1(), unv, udbName, bl);
                IExpression exp2 = this.convert(tExp.getExpression2(), unv, udbName, bl);
                IOperator op = this.getOperator(tExp.getOperator());
                if (ExpressionToolKit.isVariableExp(exp1.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                        IExpression[] iexp = new IExpression[]{(IVariableExpression)exp1, (IVariableExpression)exp2};
                        resultIE = this.expFactory.createMultiLogicExp((IMultiLogicOperator)op, iexp);
                        break;
                    }
                    if (!ExpressionToolKit.isBooleanExp(exp2.expressionType())) break;
                    IExpression[] iexp = new IExpression[]{(IVariableExpression)exp1, (IBooleanExpression)exp2};
                    resultIE = this.expFactory.createMultiLogicExp((IMultiLogicOperator)op, iexp);
                    break;
                }
                if (!ExpressionToolKit.isBooleanExp(exp1.expressionType())) break;
                if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                    IExpression[] iexp = new IExpression[]{(IBooleanExpression)exp1, (IVariableExpression)exp2};
                    resultIE = this.expFactory.createMultiLogicExp((IMultiLogicOperator)op, iexp);
                    break;
                }
                if (!ExpressionToolKit.isBooleanExp(exp2.expressionType())) break;
                IExpression[] iexp = new IExpression[]{(IBooleanExpression)exp1, (IBooleanExpression)exp2};
                resultIE = this.expFactory.createMultiLogicExp((IMultiLogicOperator)op, iexp);
                break;
            }
            case 1314818: {
                UBinaryConditionExpression tExp = (UBinaryConditionExpression)exp;
                IExpression exp1 = this.convert(tExp.getExpression1(), unv, udbName, bl);
                IExpression exp2 = this.convert(tExp.getExpression2(), unv, udbName, bl);
                IOperator op = this.getOperator(tExp.getOperator());
                if (ExpressionToolKit.isVariableExp(exp1.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                        resultIE = this.expFactory.createBinaryConditionExp((IBinaryConditionOperator)op, (IVariableExpression)exp1, (IVariableExpression)exp2);
                        break;
                    }
                    if (!ExpressionToolKit.isCalculateExp(exp2.expressionType())) break;
                    resultIE = this.expFactory.createBinaryConditionExp((IBinaryConditionOperator)op, (IVariableExpression)exp1, (ICalculateExpression)exp2);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp1.expressionType())) break;
                if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                    resultIE = this.expFactory.createBinaryConditionExp((IBinaryConditionOperator)op, (ICalculateExpression)exp1, (IVariableExpression)exp2);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp2.expressionType())) break;
                resultIE = this.expFactory.createBinaryConditionExp((IBinaryConditionOperator)op, (ICalculateExpression)exp1, (ICalculateExpression)exp2);
                break;
            }
            case 0x121001: {
                USingleLogicExpression tExp = (USingleLogicExpression)exp;
                IExpression exp1 = this.convert(tExp.getExpression(), unv, udbName, bl);
                IOperator op = this.getOperator(tExp.getOperator());
                if (ExpressionToolKit.isBooleanExp(exp1.expressionType())) {
                    resultIE = this.expFactory.createSingleLogicExp((ISingleLogicOperator)op, (IBooleanExpression)exp1);
                    break;
                }
                if (!ExpressionToolKit.isVariableExp(exp1.expressionType())) break;
                resultIE = this.expFactory.createSingleLogicExp((ISingleLogicOperator)op, (IVariableExpression)exp1);
                break;
            }
            case 0x121002: {
                USingleConditionExpression tExp = (USingleConditionExpression)exp;
                IExpression exp1 = this.convert(tExp.getExpression(), unv, udbName, bl);
                IOperator op = this.getOperator(tExp.getOperator());
                if (ExpressionToolKit.isCalculateExp(exp1.expressionType())) {
                    resultIE = this.expFactory.createSingleConditionExp((ISingleConditionOperator)op, (ICalculateExpression)exp1);
                    break;
                }
                if (!ExpressionToolKit.isVariableExp(exp1.expressionType())) break;
                resultIE = this.expFactory.createSingleConditionExp((ISingleConditionOperator)op, (IVariableExpression)exp1);
                break;
            }
            case 1576962: {
                UTripleConditionExpression tExp = (UTripleConditionExpression)exp;
                IExpression exp1 = this.convert(tExp.getExpression1(), unv, udbName, bl);
                IExpression exp2 = this.convert(tExp.getExpression2(), unv, udbName, bl);
                IExpression exp3 = this.convert(tExp.getExpression3(), unv, udbName, bl);
                IOperator op = this.getOperator(tExp.getOperator());
                if (ExpressionToolKit.isVariableExp(exp1.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                        if (ExpressionToolKit.isVariableExp(exp3.expressionType())) {
                            resultIE = this.expFactory.createTripleConditionExp((ITripleConditionOperator)op, (IVariableExpression)exp1, (IVariableExpression)exp2, (IVariableExpression)exp3);
                            break;
                        }
                        if (!ExpressionToolKit.isCalculateExp(exp3.expressionType())) break;
                        resultIE = this.expFactory.createTripleConditionExp((ITripleConditionOperator)op, (IVariableExpression)exp1, (IVariableExpression)exp2, (ICalculateExpression)exp3);
                        break;
                    }
                    if (!ExpressionToolKit.isCalculateExp(exp2.expressionType())) break;
                    if (ExpressionToolKit.isVariableExp(exp3.expressionType())) {
                        resultIE = this.expFactory.createTripleConditionExp((ITripleConditionOperator)op, (IVariableExpression)exp1, (ICalculateExpression)exp2, (IVariableExpression)exp3);
                        break;
                    }
                    if (!ExpressionToolKit.isCalculateExp(exp3.expressionType())) break;
                    resultIE = this.expFactory.createTripleConditionExp((ITripleConditionOperator)op, (IVariableExpression)exp1, (ICalculateExpression)exp2, (ICalculateExpression)exp3);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp1.expressionType())) break;
                if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(exp3.expressionType())) {
                        resultIE = this.expFactory.createTripleConditionExp((ITripleConditionOperator)op, (ICalculateExpression)exp1, (IVariableExpression)exp2, (IVariableExpression)exp3);
                        break;
                    }
                    if (!ExpressionToolKit.isCalculateExp(exp3.expressionType())) break;
                    resultIE = this.expFactory.createTripleConditionExp((ITripleConditionOperator)op, (ICalculateExpression)exp1, (IVariableExpression)exp2, (ICalculateExpression)exp3);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp2.expressionType())) break;
                if (ExpressionToolKit.isVariableExp(exp3.expressionType())) {
                    resultIE = this.expFactory.createTripleConditionExp((ITripleConditionOperator)op, (ICalculateExpression)exp1, (ICalculateExpression)exp2, (IVariableExpression)exp3);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp3.expressionType())) break;
                resultIE = this.expFactory.createTripleConditionExp((ITripleConditionOperator)op, (ICalculateExpression)exp1, (ICalculateExpression)exp2, (ICalculateExpression)exp3);
                break;
            }
            case 32772: {
                UFormulaExpression tExp = (UFormulaExpression)exp;
                IFormula expRet = this.expFactory.createFormula(tExp.getName());
                expRet.setDataType(tExp.getDataType());
                resultIE = expRet;
                break;
            }
            case 32776: {
                UParameterExpression tExp = (UParameterExpression)exp;
                IParameter param = this.expFactory.createParameter(tExp.getName(), tExp.isDirectRef());
                param.setDataType(tExp.getDataType());
                resultIE = param;
                break;
            }
            case 32769: {
                UReferenceExpression tExp = (UReferenceExpression)exp;
                IReference ref = this.expFactory.createReference(tExp.getName(), tExp.isQualifyName());
                ref.setCaseSensitive(tExp.isCaseSensitive());
                ref.setCurrency(tExp.isCurrency());
                ref.setDataType(tExp.getDataType());
                ref.setLength(tExp.getLength());
                ref.setNullable(tExp.isNullable());
                ref.setPrecision(tExp.getPrecision());
                ref.setScale(tExp.getScale());
                resultIE = ref;
                break;
            }
            case 32770: {
                UConstantExpression tExp = (UConstantExpression)exp;
                IConstant con = null;
                con = tExp.isSpecialField() ? this.expFactory.createConstant(tExp.getName(), tExp.isSpecialField()) : this.expFactory.createConstant(tExp.getValueString());
                con.setDataType(tExp.getDataType());
                con.setValue(tExp.getValueString());
                resultIE = con;
                break;
            }
            case 147456: {
                USingleCalculateExpression tExp = (USingleCalculateExpression)exp;
                IExpression exp1 = this.convert(tExp.getExpression(), unv, udbName, bl);
                IOperator op = this.getOperator(tExp.getOperator());
                if (ExpressionToolKit.isVariableExp(exp1.expressionType())) {
                    resultIE = this.expFactory.createSingleCalculateExp((ISingleCalculateOperator)op, (IVariableExpression)exp1);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp1.expressionType())) break;
                resultIE = this.expFactory.createSingleCalculateExp((ISingleCalculateOperator)op, (ICalculateExpression)exp1);
                break;
            }
            case 278528: {
                UBinaryCalculateExpression tExp = (UBinaryCalculateExpression)exp;
                IExpression exp1 = this.convert(tExp.getExpression1(), unv, udbName, bl);
                IExpression exp2 = this.convert(tExp.getExpression2(), unv, udbName, bl);
                IOperator op = this.getOperator(tExp.getOperator());
                if (ExpressionToolKit.isVariableExp(exp1.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                        resultIE = this.expFactory.createBinaryCalculateExp((IBinaryCalculateOperator)op, (IVariableExpression)exp1, (IVariableExpression)exp2);
                        break;
                    }
                    if (!ExpressionToolKit.isCalculateExp(exp2.expressionType())) break;
                    resultIE = this.expFactory.createBinaryCalculateExp((IBinaryCalculateOperator)op, (IVariableExpression)exp1, (ICalculateExpression)exp2);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp1.expressionType())) break;
                if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                    resultIE = this.expFactory.createBinaryCalculateExp((IBinaryCalculateOperator)op, (ICalculateExpression)exp1, (IVariableExpression)exp2);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp2.expressionType())) break;
                resultIE = this.expFactory.createBinaryCalculateExp((IBinaryCalculateOperator)op, (ICalculateExpression)exp1, (ICalculateExpression)exp2);
                break;
            }
            case 540672: {
                UTripleCalculateExpression tExp = (UTripleCalculateExpression)exp;
                IExpression exp1 = this.convert(tExp.getExpression1(), unv, udbName, bl);
                IExpression exp2 = this.convert(tExp.getExpression2(), unv, udbName, bl);
                IExpression exp3 = this.convert(tExp.getExpression3(), unv, udbName, bl);
                IOperator op = this.getOperator(tExp.getOperator());
                if (ExpressionToolKit.isVariableExp(exp1.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                        if (ExpressionToolKit.isVariableExp(exp3.expressionType())) {
                            resultIE = this.expFactory.createTripleCalculateExp((ITripleCalculateOperator)op, (IVariableExpression)exp1, (IVariableExpression)exp2, (IVariableExpression)exp3);
                            break;
                        }
                        if (!ExpressionToolKit.isCalculateExp(exp3.expressionType())) break;
                        resultIE = this.expFactory.createTripleCalculateExp((ITripleCalculateOperator)op, (IVariableExpression)exp1, (IVariableExpression)exp2, (ICalculateExpression)exp3);
                        break;
                    }
                    if (!ExpressionToolKit.isCalculateExp(exp2.expressionType())) break;
                    if (ExpressionToolKit.isVariableExp(exp3.expressionType())) {
                        resultIE = this.expFactory.createTripleCalculateExp((ITripleCalculateOperator)op, (IVariableExpression)exp1, (ICalculateExpression)exp2, (IVariableExpression)exp3);
                        break;
                    }
                    if (!ExpressionToolKit.isCalculateExp(exp3.expressionType())) break;
                    resultIE = this.expFactory.createTripleCalculateExp((ITripleCalculateOperator)op, (IVariableExpression)exp1, (ICalculateExpression)exp2, (ICalculateExpression)exp3);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp1.expressionType())) break;
                if (ExpressionToolKit.isVariableExp(exp2.expressionType())) {
                    if (ExpressionToolKit.isVariableExp(exp3.expressionType())) {
                        resultIE = this.expFactory.createTripleCalculateExp((ITripleCalculateOperator)op, (ICalculateExpression)exp1, (IVariableExpression)exp2, (IVariableExpression)exp3);
                        break;
                    }
                    if (!ExpressionToolKit.isCalculateExp(exp3.expressionType())) break;
                    resultIE = this.expFactory.createTripleCalculateExp((ITripleCalculateOperator)op, (ICalculateExpression)exp1, (IVariableExpression)exp2, (ICalculateExpression)exp3);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp2.expressionType())) break;
                if (ExpressionToolKit.isVariableExp(exp3.expressionType())) {
                    resultIE = this.expFactory.createTripleCalculateExp((ITripleCalculateOperator)op, (ICalculateExpression)exp1, (ICalculateExpression)exp2, (IVariableExpression)exp3);
                    break;
                }
                if (!ExpressionToolKit.isCalculateExp(exp3.expressionType())) break;
                resultIE = this.expFactory.createTripleCalculateExp((ITripleCalculateOperator)op, (ICalculateExpression)exp1, (ICalculateExpression)exp2, (ICalculateExpression)exp3);
                break;
            }
            case 139266: {
                UTopNSortExpression tExp = (UTopNSortExpression)exp;
                UFilterExpression temp = tExp.getExpression();
                IOperator op = this.getOperator(tExp.getTopNInfo(), tExp.getValue());
                if (temp == null) {
                    resultIE = this.expFactory.createTopNExp((ITopNOperator)op);
                    break;
                }
                IExpression exp1 = this.convert(temp, unv, udbName, bl);
                if (ExpressionToolKit.isTupleExp(exp1.expressionType())) {
                    resultIE = this.expFactory.createTopNExp((ITupleExpression)exp1, (ITopNOperator)op);
                    break;
                }
                if (!ExpressionToolKit.isSetExp(exp1.expressionType())) break;
                resultIE = this.expFactory.createTopNExp((ISetExpression)exp1, (ITopNOperator)op);
                break;
            }
            case 139265: {
                USortExpression tExp = (USortExpression)exp;
                UFilterExpression temp = tExp.getExpression();
                IOperator op = this.getOperator(tExp.getOperator(), tExp.getSortInfoList());
                if (temp == null) {
                    resultIE = this.expFactory.createSortExp((ISortOperator)op);
                    break;
                }
                IExpression exp1 = this.convert(temp, unv, udbName, bl);
                if (ExpressionToolKit.isTupleExp(exp1.expressionType())) {
                    resultIE = this.expFactory.createSortExp((ITupleExpression)exp1, (ISortOperator)op);
                    break;
                }
                if (!ExpressionToolKit.isSetExp(exp1.expressionType())) break;
                resultIE = this.expFactory.createSortExp((ISetExpression)exp1, (ISortOperator)op);
                break;
            }
            case 32784: {
                UVariableListExpression tExp = (UVariableListExpression)exp;
                int size = tExp.variableListSize();
                IVariableList iVarList = this.expFactory.createVariableList(tExp.getName());
                for (int i = 0; i < size; ++i) {
                    IExpression listItem = this.convert(tExp.getVariableListItem(i), unv, udbName, bl);
                    int type = listItem.expressionType();
                    if (ExpressionToolKit.isConstant(type)) {
                        iVarList.addConstant((IConstant)listItem);
                        continue;
                    }
                    if (ExpressionToolKit.isFormula(type)) {
                        iVarList.addFormula((IFormula)listItem);
                        continue;
                    }
                    if (ExpressionToolKit.isParameter(type)) {
                        iVarList.addParameter((IParameter)listItem);
                        continue;
                    }
                    if (!ExpressionToolKit.isCalculateExp(type)) continue;
                }
                resultIE = iVarList;
                break;
            }
        }
        resultIE.parenthesize(isParenthesized);
        return resultIE;
    }

    private IOperator getOperator(int opType) throws ConditionException {
        int opTypes = OperatorTypes.convertOpType(opType);
        if (opTypes != opType) {
            return this.opFactory.createMultiLogicOp(opTypes);
        }
        switch (opType) {
            case 603979904: {
                return this.opFactory.createSingleCalculateOp(opType);
            }
            case 0x11500001: {
                return this.opFactory.createNotOp();
            }
            case 0x11300001: 
            case 288358402: {
                return this.opFactory.createSingleConsitionOp(opType);
            }
            case 603979777: 
            case 0x24000002: 
            case 0x24000004: 
            case 603979784: 
            case 603979792: 
            case 0x24000020: 
            case 0x24000040: {
                return this.opFactory.createBinaryCalculateOp(opType);
            }
            case -2125463550: 
            case -2125463548: {
                return this.opFactory.createBinaryLogicOp(opType);
            }
            case 556793860: 
            case 556793864: 
            case 556793872: 
            case 556793888: 
            case 556793920: 
            case 556793984: 
            case 556794112: 
            case 556794368: {
                return this.opFactory.createBinaryConditionOp(opType);
            }
            case 556793857: {
                return this.opFactory.createInOp();
            }
            case 556793858: {
                return this.opFactory.createNotInOp();
            }
            case 1093664769: 
            case 1093664770: {
                return this.opFactory.createTripleConditionOp(opType);
            }
            case 671089664: {
                return this.opFactory.createCartesianOp();
            }
        }
        return null;
    }

    private IOperator getOperator(int type, int n) throws ConditionException {
        return this.opFactory.createTopNOp(this.infoFactory.createTopNInfo(type, n));
    }

    private IOperator getOperator(int opType, Vector infos) throws ConditionException {
        ISortInformationCollector tmpInfos = this.infoFactory.createSortInfoCollector();
        for (int i = 0; i < infos.size(); ++i) {
            USortInfo info = (USortInfo)infos.elementAt(i);
            tmpInfos.addSortInformation(this.infoFactory.createSortInfo(this.expFactory.createReference(info.getReference().getName()), info.getSortType(), info.isIgnoreCase()));
        }
        return this.opFactory.createSortOp(tmpInfos);
    }
}

