/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.filter.convert;

import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.calculate.UBinaryCalculateExpression;
import jet.universe.businesslogic.filter.calculate.USingleCalculateExpression;
import jet.universe.businesslogic.filter.calculate.UTripleCalculateExpression;
import jet.universe.businesslogic.filter.convert.UFilterExpressionObserver;
import jet.universe.businesslogic.filter.set.USortExpression;
import jet.universe.businesslogic.filter.set.UTopNSortExpression;
import jet.universe.businesslogic.filter.tuple.UBinaryConditionExpression;
import jet.universe.businesslogic.filter.tuple.UBinaryLogicExpression;
import jet.universe.businesslogic.filter.tuple.USingleConditionExpression;
import jet.universe.businesslogic.filter.tuple.USingleLogicExpression;
import jet.universe.businesslogic.filter.tuple.UTripleConditionExpression;
import jet.universe.businesslogic.filter.variable.UConstantExpression;
import jet.universe.businesslogic.filter.variable.UFormulaExpression;
import jet.universe.businesslogic.filter.variable.UParameterExpression;
import jet.universe.businesslogic.filter.variable.UReferenceExpression;
import jet.universe.businesslogic.filter.variable.UVariableListExpression;

public class UFilterExpressionTraverser {
    public void traverseExpressionTree(UFilterExpression exp, UFilterExpressionObserver observer) {
        if (exp == null) {
            return;
        }
        switch (exp.getType()) {
            case 0x141001: {
                UBinaryLogicExpression tExp = (UBinaryLogicExpression)exp;
                observer.findExpressionTreeNode(tExp);
                this.traverseExpressionTree(tExp.getExpression1(), observer);
                this.traverseExpressionTree(tExp.getExpression2(), observer);
                break;
            }
            case 1314818: {
                UBinaryConditionExpression tExp = (UBinaryConditionExpression)exp;
                observer.findExpressionTreeNode(tExp);
                this.traverseExpressionTree(tExp.getExpression1(), observer);
                this.traverseExpressionTree(tExp.getExpression2(), observer);
                break;
            }
            case 0x121001: {
                USingleLogicExpression tExp = (USingleLogicExpression)exp;
                observer.findExpressionTreeNode(tExp);
                this.traverseExpressionTree(tExp.getExpression(), observer);
                break;
            }
            case 0x121002: {
                USingleConditionExpression tExp = (USingleConditionExpression)exp;
                observer.findExpressionTreeNode(tExp);
                this.traverseExpressionTree(tExp.getExpression(), observer);
                break;
            }
            case 1576962: {
                UTripleConditionExpression tExp = (UTripleConditionExpression)exp;
                observer.findExpressionTreeNode(tExp);
                this.traverseExpressionTree(tExp.getExpression1(), observer);
                this.traverseExpressionTree(tExp.getExpression2(), observer);
                this.traverseExpressionTree(tExp.getExpression3(), observer);
                break;
            }
            case 32772: {
                UFormulaExpression tExp = (UFormulaExpression)exp;
                observer.findExpressionTreeNode(tExp);
                break;
            }
            case 32776: {
                UParameterExpression tExp = (UParameterExpression)exp;
                observer.findExpressionTreeNode(tExp);
                break;
            }
            case 32769: {
                UReferenceExpression tExp = (UReferenceExpression)exp;
                observer.findExpressionTreeNode(tExp);
                break;
            }
            case 32770: {
                UConstantExpression tExp = (UConstantExpression)exp;
                observer.findExpressionTreeNode(tExp);
                break;
            }
            case 147456: {
                USingleCalculateExpression tExp = (USingleCalculateExpression)exp;
                this.traverseExpressionTree(tExp.getExpression(), observer);
                observer.findExpressionTreeNode(tExp);
                break;
            }
            case 278528: {
                UBinaryCalculateExpression tExp = (UBinaryCalculateExpression)exp;
                observer.findExpressionTreeNode(tExp);
                this.traverseExpressionTree(tExp.getExpression1(), observer);
                this.traverseExpressionTree(tExp.getExpression2(), observer);
                break;
            }
            case 540672: {
                UTripleCalculateExpression tExp = (UTripleCalculateExpression)exp;
                observer.findExpressionTreeNode(tExp);
                this.traverseExpressionTree(tExp.getExpression1(), observer);
                this.traverseExpressionTree(tExp.getExpression2(), observer);
                this.traverseExpressionTree(tExp.getExpression3(), observer);
                break;
            }
            case 139266: {
                UTopNSortExpression tExp = (UTopNSortExpression)exp;
                observer.findExpressionTreeNode(tExp);
                UFilterExpression temp = tExp.getExpression();
                observer.findExpressionTreeNode(temp);
                break;
            }
            case 139265: {
                USortExpression tExp = (USortExpression)exp;
                observer.findExpressionTreeNode(tExp);
                UFilterExpression temp = tExp.getExpression();
                observer.findExpressionTreeNode(temp);
                break;
            }
            case 32784: {
                UVariableListExpression tExp = (UVariableListExpression)exp;
                observer.findExpressionTreeNode(tExp);
                int size = tExp.variableListSize();
                for (int i = 0; i < size; ++i) {
                    this.traverseExpressionTree(tExp.getVariableListItem(i), observer);
                }
                break;
            }
        }
    }
}

