/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.log.JRLogger;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.FilterImpl;
import jet.universe.businesslogic.impl.HierarchyContainerImpl;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.businesslogic.tools.BusinessLogicTools;

public abstract class BLContainerImpl
extends BLNodeImpl
implements BLContainer,
JetContainable {
    private static JRLogger logger = JRLogger.getLogger(BLContainerImpl.class.getName());
    private Vector theChildren = new Vector();

    @Override
    public BLNode[] getBLChildren() {
        Vector<BLNode> theSortedChildren = new Vector<BLNode>();
        BLNode firstNode = null;
        BLNode candidateFirstNode = null;
        int size = this.theChildren.size();
        for (int i = 0; i < size; ++i) {
            BLNode theNode;
            Object o = this.theChildren.get(i);
            if (!(o instanceof BLNode) || (theNode = (BLNode)o) instanceof HierarchyContainerImpl || theNode instanceof FilterImpl || theNode instanceof MemberSecurityEntry) continue;
            if (theNode.getPreviousNode() == null) {
                firstNode = theNode;
                break;
            }
            candidateFirstNode = theNode;
        }
        if (firstNode == null && candidateFirstNode != null) {
            firstNode = candidateFirstNode;
            firstNode.setPreviousNode(null);
            logger.warn("a circle was found in the children of BLContainerImpl, so choose the candidateFirstNode [" + candidateFirstNode + "] as the first node to rebuild order of businessView");
        }
        BLNode lastNode = firstNode;
        if (firstNode != null) {
            theSortedChildren.add(firstNode);
            while (lastNode.getNextNode() != null && !this.contain(theSortedChildren, lastNode.getNextNode())) {
                BLNode previous = lastNode;
                lastNode = lastNode.getNextNode();
                lastNode.setPreviousNode(previous);
                theSortedChildren.add(lastNode);
            }
            lastNode.setNextNode(null);
        }
        int size2 = this.theChildren.size();
        for (int i = 0; i < size2; ++i) {
            Object o = this.theChildren.get(i);
            if (!(o instanceof BLNode)) continue;
            BLNode hNode = (BLNode)o;
            if (hNode instanceof HierarchyContainerImpl || hNode instanceof FilterImpl || hNode instanceof MemberSecurityEntry) {
                theSortedChildren.add(hNode);
                continue;
            }
            if (this.contain(theSortedChildren, hNode)) continue;
            if (lastNode != null) {
                lastNode.setNextNode(hNode);
            }
            hNode.setPreviousNode(lastNode);
            hNode.setNextNode(null);
            lastNode = hNode;
            theSortedChildren.add(hNode);
        }
        BLNode[] ret = new BLNode[theSortedChildren.size()];
        theSortedChildren.toArray(ret);
        return ret;
    }

    private boolean contain(Vector theSortedChildren, BLNode nextNode) {
        int size = theSortedChildren.size();
        for (int i = 0; i < size; ++i) {
            BLNode node = (BLNode)theSortedChildren.get(i);
            if (!node.getName().equalsIgnoreCase(nextNode.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUsedName(String name2) {
        boolean ret = false;
        for (Object o : this.theChildren) {
            BLNode node;
            if (!(o instanceof BLNode) || !(node = (BLNode)o).getName().equalsIgnoreCase(name2)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @Override
    public BLNode getChildByName(String name2) {
        BLNode ret = null;
        for (Object o : this.theChildren) {
            BLNode node;
            if (!(o instanceof BLNode) || !(node = (BLNode)o).getName().equalsIgnoreCase(name2)) continue;
            ret = node;
            break;
        }
        return ret;
    }

    @Override
    public BLNode getChildByDisplayName(String name2) {
        BLNode ret = null;
        for (Object o : this.theChildren) {
            BLNode node;
            if (!(o instanceof BLNode) || !(node = (BLNode)o).getDisplayName().equalsIgnoreCase(name2)) continue;
            ret = node;
            break;
        }
        return ret;
    }

    public BLNode[] removeChildren() {
        BLNode[] ret = this.getBLChildren();
        for (int i = 0; i < ret.length; ++i) {
            ret[i].setBLParent(null);
        }
        this.theChildren.clear();
        return ret;
    }

    @Override
    @Deprecated
    public BLNode removeChildByName(String name2) {
        BLNode ret = this.getChildByName(name2);
        if (!(ret instanceof HierarchyContainerImpl) && !(ret instanceof FilterImpl)) {
            BLNode previousNode = ret.getPreviousNode();
            BLNode nextNode = ret.getNextNode();
            if (previousNode != null) {
                previousNode.setNextNode(nextNode);
            }
            if (nextNode != null) {
                nextNode.setPreviousNode(previousNode);
            }
        }
        this.theChildren.remove(ret);
        if (ret != null) {
            ret.setBLParent(null);
        }
        return ret;
    }

    @Override
    public BLNode removeChildByDisplayName(String DisplayName2) {
        BLNode ret = this.getChildByDisplayName(DisplayName2);
        if (!(ret instanceof HierarchyContainerImpl) && !(ret instanceof FilterImpl)) {
            BLNode previousNode = ret.getPreviousNode();
            BLNode nextNode = ret.getNextNode();
            if (previousNode != null) {
                previousNode.setNextNode(nextNode);
            }
            if (nextNode != null) {
                nextNode.setPreviousNode(previousNode);
            }
        }
        this.theChildren.remove(ret);
        if (ret != null) {
            ret.setBLParent(null);
        }
        return ret;
    }

    public void addChild(BLNode child) throws BLDupleNameException {
        if (child == null) {
            return;
        }
        UnifiedBusinessView ubv = (UnifiedBusinessView)this.getUbv();
        if (child instanceof HierarchyInfo && ubv != null && ubv.isUsedHierarchyName(child.getDisplayName())) {
            throw new BLDupleNameException(child.getDisplayName());
        }
        if (this.isUsedDisplayName(child.getDisplayName())) {
            throw new BLDupleNameException(child.getDisplayName());
        }
        if (!(child instanceof FilterInfo) && !(child instanceof HierarchyContainerImpl) && this.isUsedDisplayName(child.getDisplayName())) {
            throw new BLDupleNameException(child.getDisplayName());
        }
        this.theChildren.add(child);
        child.setBLParent(this);
    }

    @Override
    public Vector getChildren() {
        return this.theChildren;
    }

    @Override
    public JetObject add(JetObject child) {
        child.setParent(this);
        this.theChildren.add(child);
        return child;
    }

    @Override
    public JetObject remove(JetObject child) {
        if (child == null) {
            return null;
        }
        boolean ret = this.theChildren.remove(child);
        return child;
    }

    @Override
    public void broadcast(JetObject sender, int iMessage) {
        if (sender == null) {
            return;
        }
    }

    @Override
    public void clear() {
        this.theChildren.clear();
    }

    @Override
    public boolean isSimilar(BLNode node) {
        if (!super.isSimilar(node)) {
            return false;
        }
        BLContainer container = (BLContainer)node;
        BLNode[] node1 = this.getBLChildren();
        BLNode[] node2 = container.getBLChildren();
        return BLNodeImpl.isSimilar(node1, node2);
    }

    @Override
    public boolean isUsedDisplayName(String displayName) {
        boolean ret = false;
        for (Object o : this.theChildren) {
            BLNode node;
            if (!(o instanceof BLNode) || !(node = (BLNode)o).getDisplayName().equalsIgnoreCase(displayName)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @Override
    public String getRecommendedDisplayName(String displayName) {
        String ret = displayName;
        if (ret == null || ret.equals("")) {
            return ret;
        }
        String[] reserveWords = BusinessLogicTools.reserveCharsForDispName;
        for (int i = 0; i < reserveWords.length; ++i) {
            ret = ret.replace(reserveWords[i], "_");
        }
        int j = 1;
        String validDisName = ret;
        while (this.isUsedDisplayName(validDisName)) {
            validDisName = ret + j++;
        }
        return validDisName;
    }
}

