/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.HashMap;
import jet.controls.JetContainable;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.universe.JetUDatabase;
import jet.universe.JetUTreeNode;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.tools.BusinessLogicTools;
import jet.util.HashVector;

public abstract class BLNodeImpl
extends JetUTreeNode
implements BLNode {
    static int nameNum = 1;
    JetString theName = new JetString(this, "name", "NewBLNode" + nameNum++);
    private JetString theDescription = new JetString(this, "Description", "");
    private JetNumber theBLElementType = new JetNumber(this, "BLElementType", 0);
    protected JetString theDisplayName;
    static final String[] reserveWords = new String[]{"~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "-", "+", "=", "{", "}", "[", "]", "|", "\\", ":", ";", "\"", "'", "<", ",", ">", ".", "?", "/", " ", "\t", "\n"};
    static final String namePattern = "[_a-zA-Z][_a-zA-Z0-9]*";
    private static final HashMap nameIdx = new HashMap(3);

    private String cantainReserveWordDipl(String name2) {
        String[] reserveWords = new String[]{".", "\t", "\n"};
        for (int i = 0; i < reserveWords.length; ++i) {
            if (reserveWords[i].equals(" ") || name2.indexOf(reserveWords[i]) == -1) continue;
            return reserveWords[i];
        }
        return null;
    }

    @Override
    public void setDisplayName(String name2) throws BLDupleNameException, BLIlegalNameException {
        if (name2 == null) {
            throw new BLIlegalNameException(2, null);
        }
        if (name2.equalsIgnoreCase(this.getDisplayName())) {
            this.theDisplayName.set(name2);
            return;
        }
        BusinessLogicTools.isContainReservedCharacters(name2);
        BLContainer parent = this.getBLParent();
        if (parent != null && parent.isUsedDisplayName(name2)) {
            throw new BLDupleNameException(name2);
        }
        String oldQdName = this.getQualifyDisplayName();
        String newQdName = this.getNewQualifyDisplayName(name2);
        if (this.getUbv() != null) {
            HierarchyInfo[] hs = this.getUbv().getAllHierarchies();
            for (int i = 0; i < hs.length; ++i) {
                String[] qdNames = hs[i].getDimensionQDNames();
                for (int j = 0; j < qdNames.length; ++j) {
                    if (!qdNames[j].equals(oldQdName)) continue;
                    qdNames[j] = newQdName;
                }
                hs[i].setDimensions(qdNames);
            }
            MemberSecurityEntry entry = this.getUbv().getMemberSecurityEntry();
            if (entry != null) {
                entry.updateSecurityItem(oldQdName, newQdName);
            }
        }
        this.theDisplayName.set(name2);
    }

    @Override
    public String getNewQualifyDisplayName(String newDisplayName) throws BLDupleNameException, BLIlegalNameException {
        if (newDisplayName == null) {
            throw new BLIlegalNameException(2, null);
        }
        if (!newDisplayName.equalsIgnoreCase(this.getDisplayName())) {
            BusinessLogicTools.isContainReservedCharacters(newDisplayName);
            BLContainer parent = this.getBLParent();
            if (parent != null && parent.isUsedDisplayName(newDisplayName)) {
                throw new BLDupleNameException(newDisplayName);
            }
        }
        BLNode tParent = null;
        JetContainable par = this.getParent();
        if (par instanceof BLNode) {
            tParent = (BLNode)((Object)par);
        }
        StringBuffer qName = new StringBuffer(256);
        if (tParent != null && !(tParent instanceof JBusinessLogic) && !(tParent instanceof JUnifiedBusinessView)) {
            qName.append(tParent.getQualifyDisplayName());
            qName.append('.');
        }
        qName.append(newDisplayName);
        return qName.toString();
    }

    @Override
    public String getDisplayName() {
        if (this.theDisplayName.get().equals("")) {
            this.theDisplayName.set(this.getName());
        }
        return this.theDisplayName.get();
    }

    protected BLNodeImpl() {
        this.theBLElementType.setEditFlag(3);
        this.theDisplayName = new JetString(this, "DisplayName", "");
        this.addProperty(this.theName);
        this.addProperty(this.theDescription);
        this.addProperty(this.theBLElementType);
    }

    @Override
    public void setBLParent(BLContainer parent) {
        this.setParent((JetContainable)((Object)parent));
    }

    @Override
    public BLContainer getBLParent() {
        return (BLContainer)((Object)this.getParent());
    }

    @Override
    public int getElementType() {
        return this.theBLElementType.getInt();
    }

    protected boolean setElementType(int type) {
        boolean ret = false;
        switch (type) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                ret = true;
                this.theBLElementType.set(type);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public void setName(String name2) throws BLDupleNameException, BLIlegalNameException {
        if (name2 == null) {
            throw new BLIlegalNameException(2, null);
        }
        if (name2.equals(this.getName())) {
            return;
        }
        String rWord = this.cantainReserveWord(name2);
        if (rWord != null) {
            throw new BLIlegalNameException(3, new String[]{rWord});
        }
        if (!name2.matches(namePattern)) {
            throw new BLIlegalNameException(4, new String[]{namePattern});
        }
        BLContainer parent = this.getBLParent();
        if (parent != null && parent.isUsedName(name2)) {
            throw new BLDupleNameException(name2);
        }
        this.theName.set(name2);
    }

    private String cantainReserveWord(String name2) {
        for (int i = 0; i < reserveWords.length; ++i) {
            if (name2.indexOf(reserveWords[i]) == -1) continue;
            return reserveWords[i];
        }
        return null;
    }

    @Override
    public void setDescription(String description) {
        this.theDescription.set(description);
    }

    @Override
    public String getName() {
        return this.theName.get();
    }

    @Override
    public String getComment() {
        return this.theDescription.get();
    }

    @Override
    public String getBLQualifyName() {
        BLContainer tParent = this.getBLParent();
        StringBuffer qName = new StringBuffer(256);
        if (tParent != null) {
            qName.append(tParent.getBLQualifyName());
            qName.append('.');
        }
        qName.append(this.getName());
        return qName.toString();
    }

    @Override
    public void clear() {
    }

    @Override
    public JBusinessLogic getBusinessLogic() {
        JBusinessLogic ret = null;
        BLNode node = this;
        while (node.getBLParent() != null) {
            node = node.getBLParent();
        }
        if (node.getElementType() == 0 || node.getElementType() == 1) {
            ret = (JBusinessLogic)node;
        }
        return ret;
    }

    @Override
    public JUnifiedBusinessView getUbv() {
        for (BLNodeImpl node = this; node != null; node = (BLNodeImpl)((Object)node.getParent())) {
            if (node instanceof JUnifiedBusinessView) {
                return (JUnifiedBusinessView)((Object)node);
            }
            if (node instanceof JBusinessLogic) {
                return null;
            }
            if (node instanceof BLNodeImpl) {
                continue;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return this.getQualifyDisplayName();
    }

    @Override
    public boolean isSimilar(BLNode obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BLNode node = obj;
        if (!this.getName().equals(node.getName())) {
            return false;
        }
        if (!this.getComment().equals(node.getComment())) {
            return false;
        }
        return this.getElementType() == node.getElementType();
    }

    protected static boolean isSimilar(BLNode[] nodes1, BLNode[] nodes2) {
        if (nodes1.length != nodes2.length) {
            return false;
        }
        for (BLNode n1 : nodes1) {
            String name2 = n1.getName();
            boolean bfound = false;
            for (BLNode n2 : nodes2) {
                if (!n2.getName().equalsIgnoreCase(name2)) continue;
                if (n1.isSimilar(n2)) {
                    bfound = true;
                    break;
                }
                return false;
            }
            if (bfound) continue;
            return false;
        }
        return true;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropertyGroups() {
        HashVector grps = super.getPropertyGroups();
        if (grps == null || grps.size() == 0) {
            return null;
        }
        return grps;
    }

    @Override
    public BLNode getNextNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BLNode getPreviousNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNextNode(BLNode next) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreviousNode(BLNode previous) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getQualifyDisplayName() {
        BLNode tParent = null;
        JetContainable par = this.getParent();
        if (par instanceof BLNode) {
            tParent = (BLNode)((Object)par);
        }
        StringBuffer qName = new StringBuffer(256);
        if (tParent != null && !(tParent instanceof JBusinessLogic) && !(tParent instanceof JUnifiedBusinessView)) {
            qName.append(tParent.getQualifyDisplayName());
            qName.append('.');
        }
        qName.append(this.getDisplayName());
        return qName.toString();
    }

    @Override
    public String getDesc() {
        return null;
    }

    @Override
    public void setDesc(String strDesc) {
    }

    @Override
    public JetUDatabase getDatabase() {
        JetObject ret = this;
        while (!(ret instanceof JetUDatabase)) {
            if ((ret = (JetObject)((Object)ret.getParent())) != null) continue;
            return null;
        }
        return (JetUDatabase)ret;
    }

    static {
        nameIdx.put("name", new Integer(0));
        nameIdx.put("Description", new Integer(1));
    }
}

