/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNoSuchElementException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.HierarchyContainer;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.impl.BCFilter;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.Hierarchy;
import jet.universe.businesslogic.impl.HierarchyContainerImpl;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.businesslogic.impl.Prefilter;
import jet.universe.tools.ParseParametersForQueryFactory;

public class BusinessLogic
extends Category
implements JBusinessLogic {
    public BusinessLogic() {
        this.setElementType(0);
        try {
            this.setName("NewBusinessLogic");
        }
        catch (BLDupleNameException e) {
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            // empty catch block
        }
    }

    @Override
    public BLNode get(String qualifyName) {
        if (qualifyName == null) {
            return null;
        }
        String[] names = qualifyName.split("\\x2E");
        BLNode node = this;
        BusinessLogic ret = null;
        int position = 0;
        if (names[0].equalsIgnoreCase(this.getName())) {
            ++position;
            for (int i = 1; i < names.length && node instanceof BLContainer; ++i) {
                node = ((BLContainer)node).getChildByName(names[i]);
                ++position;
            }
        }
        ret = position == names.length ? node : null;
        return ret;
    }

    @Override
    public BLNode getByDisplayName(String qualifyDisplayName) {
        if (qualifyDisplayName == null) {
            return null;
        }
        String[] names = qualifyDisplayName.split("\\x2E");
        BLNode node = this;
        BusinessLogic ret = null;
        int position = 0;
        for (int i = 0; i < names.length && node instanceof BLContainer; ++i) {
            node = ((BLContainer)node).getChildByDisplayName(names[i]);
            ++position;
        }
        ret = position == names.length ? node : null;
        return ret;
    }

    @Override
    public BLNode getNewNode(int type) {
        BLNodeImpl ret = null;
        switch (type) {
            case 3: {
                ret = new Category();
                break;
            }
            case 4: {
                ret = new Dimension();
                break;
            }
            case 5: {
                ret = new Measure();
                break;
            }
            case 7: {
                ret = new DetailInfo();
                break;
            }
            case 9: {
                ret = new Hierarchy();
                break;
            }
            case 16: {
                ret = new BCFilter();
                break;
            }
            case 17: {
                ret = new Prefilter();
                break;
            }
        }
        return ret;
    }

    @Override
    public BLNode getNewNode(BLContainer base, int type) {
        BLNode ret = this.getNewNode(type);
        if (ret == null) {
            return null;
        }
        String name2 = null;
        switch (ret.getElementType()) {
            case 3: {
                CategoryInfo cfr_ignored_0 = (CategoryInfo)ret;
                name2 = "Category";
                break;
            }
            case 4: {
                DimensionInfo cfr_ignored_1 = (DimensionInfo)ret;
                name2 = "Dimension";
                break;
            }
            case 5: {
                MeasureInfo cfr_ignored_2 = (MeasureInfo)ret;
                name2 = "Measure";
                break;
            }
            case 16: 
            case 17: {
                FilterInfo cfr_ignored_3 = (FilterInfo)ret;
                name2 = "Filter";
                break;
            }
            case 7: {
                DetailInformation cfr_ignored_4 = (DetailInformation)ret;
                name2 = "DetailInfo";
                break;
            }
            case 9: {
                HierarchyInfo cfr_ignored_5 = (HierarchyInfo)ret;
                name2 = "Hierarchy";
                break;
            }
            default: {
                return null;
            }
        }
        int sufix = 1;
        String tmpName = name2 + sufix;
        if (ret.getElementType() == 9) {
            while (this.isUsedHierarchyName(tmpName)) {
                tmpName = name2 + ++sufix;
            }
        } else {
            while (base.isUsedName(tmpName)) {
                tmpName = name2 + ++sufix;
            }
        }
        name2 = tmpName;
        try {
            ret.setName(name2);
            ret.setDisplayName(name2);
        }
        catch (BLDupleNameException e) {
        }
        catch (BLIlegalNameException e) {
            // empty catch block
        }
        return ret;
    }

    public boolean isUsedHierarchyName(String tmpName) {
        HierarchyInfo[] his = this.getAllHierarchies();
        for (int i = 0; i < his.length; ++i) {
            HierarchyInfo hi = his[i];
            if (!hi.getName().equalsIgnoreCase(tmpName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsedHierarchyDisplayName(String displayName) {
        HierarchyInfo[] his = this.getAllHierarchies();
        for (int i = 0; i < his.length; ++i) {
            HierarchyInfo hi = his[i];
            if (!hi.getDisplayName().equalsIgnoreCase(displayName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BLNode addNode(String base, BLNode info) throws BLDupleNameException, BLNoSuchElementException {
        BLNode node = this.get(base);
        if (node == null) {
            throw new BLNoSuchElementException(base);
        }
        if (!(node instanceof BLContainer)) {
            throw new BLNoSuchElementException(base);
        }
        int infoType = info.getElementType();
        block0 : switch (node.getElementType()) {
            case 0: 
            case 3: {
                CategoryInfo parent = (CategoryInfo)node;
                switch (infoType) {
                    case 3: {
                        parent.addCategory((CategoryInfo)info);
                        break block0;
                    }
                    case 4: {
                        parent.addDimension((DimensionInfo)info);
                        break block0;
                    }
                    case 5: {
                        parent.addMeasure((MeasureInfo)info);
                        break block0;
                    }
                    case 7: {
                        parent.addDetailInformation((DetailInfo)info);
                        break block0;
                    }
                    case 16: {
                        this.addBCFilter((FilterInfo)info);
                        break block0;
                    }
                    case 17: {
                        this.addPrefilter((FilterInfo)info);
                        break block0;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 15: {
                HierarchyContainer parent = (HierarchyContainer)node;
                switch (infoType) {
                    case 9: {
                        parent.addHierarchy((HierarchyInfo)info);
                        break block0;
                    }
                }
                break;
            }
            default: {
                throw new BLNoSuchElementException(base);
            }
        }
        return info;
    }

    @Override
    public BLNode removeNode(String qualifyName) {
        BLNode ret = this.get(qualifyName);
        if (ret != null) {
            ret.getBLParent().removeChildByName(ret.getName());
        }
        return ret;
    }

    @Override
    public boolean isUsedName(String base, String name2) {
        boolean ret = false;
        BLNode node = this.get(base);
        if (node == null) {
            ret = true;
        } else if (node instanceof BLContainer) {
            ret = ((BLContainer)node).isUsedName(name2);
        } else {
            return true;
        }
        return ret;
    }

    @Override
    public BLContainer getBLParent() {
        return null;
    }

    @Override
    public JetObject getQuery() {
        return (JetObject)((Object)this.getParent());
    }

    @Override
    public void setQuery(JetObject parent) {
        this.setParent((JetContainable)((Object)parent));
    }

    @Override
    public String toString() {
        return this.getBLQualifyName();
    }

    @Override
    public boolean isSimilar(BLNode node) {
        return super.isSimilar(node);
    }

    @Override
    public JBusinessLogic copy() {
        JBusinessLogic bl = (JBusinessLogic)((Object)this.deepDup());
        bl.setQuery(this.getQuery());
        return bl;
    }

    @Override
    public String getInstancePrefix() {
        return "BusinessLogic";
    }

    @Override
    public FilterInfo getBCFilterInfo() {
        BLNode[] tmp = this.getBLChildren();
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 16) continue;
            return (FilterInfo)tmp[i];
        }
        return null;
    }

    @Override
    public FilterInfo[] getPrefilterInfo() {
        BLNode[] tmp = this.getBLChildren();
        FilterInfo[] retTmp = new FilterInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 17) continue;
            retTmp[size] = (FilterInfo)tmp[i];
            ++size;
        }
        FilterInfo[] ret = new FilterInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public FilterInfo addBCFilter(FilterInfo bcFilter) throws BLDupleNameException {
        if (this.getBCFilterInfo() != null) {
            return null;
        }
        this.addChild(bcFilter);
        return bcFilter;
    }

    @Override
    public FilterInfo addPrefilter(FilterInfo preFilter) throws BLDupleNameException {
        this.addChild(preFilter);
        return preFilter;
    }

    public void initAfterLoad() {
        Vector v = this.getChildren();
        for (BLNode node : v) {
            if (node.getElementType() != 15) continue;
            HierarchyContainerImpl hierarchyContainer = (HierarchyContainerImpl)node;
            HierarchyInfo[] hs = hierarchyContainer.getAllHierarchies();
            BLNode[] blChildren = this.getBLChildren();
            for (int i = 0; i < hs.length; ++i) {
                boolean alreadyAdd = false;
                for (int j = 0; j < blChildren.length; ++j) {
                    if (!(blChildren[j] instanceof HierarchyInfo) || !blChildren[j].getName().equalsIgnoreCase(hs[i].getName())) continue;
                    alreadyAdd = true;
                }
                if (alreadyAdd) continue;
                this.add((Hierarchy)hs[i]);
            }
            this.remove(hierarchyContainer);
            break;
        }
        if ("".equals(this.getDisplayName())) {
            try {
                this.setDisplayName(this.getName());
            }
            catch (BLDupleNameException e) {
            }
            catch (BLIlegalNameException bLIlegalNameException) {
                // empty catch block
            }
        }
    }

    @Override
    public MemberSecurityEntry getMemberSecurityEntry() {
        Vector children = this.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Object child = children.get(i);
            if (!(child instanceof MemberSecurityEntry)) continue;
            return (MemberSecurityEntry)child;
        }
        MemberSecurityEntry ret = new MemberSecurityEntry();
        this.setMemberSecurityEntry(ret);
        return ret;
    }

    @Override
    public void setMemberSecurityEntry(MemberSecurityEntry se) {
        if (se == null) {
            return;
        }
        Vector children = this.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            Object child = children.get(i);
            if (!(child instanceof MemberSecurityEntry)) continue;
            children.remove(i);
        }
        this.add(se);
    }

    @Override
    public DimensionInfo getDimension(String DimensionRefMappingName) {
        DimensionInfo[] ds = this.getAllDimensions();
        for (int i = 0; i < ds.length; ++i) {
            if (!ds[i].getRefMappingName().equalsIgnoreCase(DimensionRefMappingName)) continue;
            return ds[i];
        }
        return null;
    }

    @Override
    public JetUDatabase getDatabase() {
        JetObject ret = this;
        while (!(ret instanceof JetUDatabase)) {
            if ((ret = (JetObject)((Object)ret.getParent())) != null) continue;
            return null;
        }
        return (JetUDatabase)ret;
    }

    @Override
    public boolean isValid() {
        return this.getAllDimensions().length > 0;
    }

    public String[] getBvRefParameter() {
        DetailInformation[] details;
        MeasureInfo[] aggs;
        DimensionInfo[] gs;
        HashSet<String> retSet = new HashSet<String>();
        ArrayList<String> mappingNames = new ArrayList<String>();
        for (DimensionInfo groupInfo : gs = this.getAllDimensions()) {
            mappingNames.add(groupInfo.getRefMappingName());
        }
        for (MeasureInfo aggregationInfo : aggs = this.getAllMeasures()) {
            mappingNames.add(aggregationInfo.getRefMappingName());
        }
        for (DetailInformation detail : details = this.getAllDetailInfos()) {
            mappingNames.add(detail.getRefMappingName());
        }
        JetUDatabase db = this.getDatabase();
        for (String mappingName : mappingNames) {
            JetUResourceEntity entity = db.getResourceByName(null, mappingName);
            if (!(entity instanceof JetUFormula)) continue;
            Vector ps = ((JetUFormula)entity).getRefParamFld();
            for (String bvReferParameter : ps) {
                retSet.add(bvReferParameter);
            }
        }
        String[] ret = new String[retSet.size()];
        retSet.toArray(ret);
        return ret;
    }

    public String[] getBvAndQueryRefParameter() throws DSException {
        JetUQueriable query = (JetUQueriable)((Object)this.getQuery());
        JetUDatabase udb = this.getDatabase();
        JetUUniverse unv = (JetUUniverse)udb.getParent();
        String[] ps = ParseParametersForQueryFactory.CreateParseParametersForQuery(unv, udb.getResourceName(), query.getResourceName()).getParameterNamesInQuery();
        String[] bvPara = this.getBvRefParameter();
        HashSet<String> retSet = new HashSet<String>();
        for (String string : ps) {
            retSet.add(string);
        }
        for (String string : bvPara) {
            retSet.add(string);
        }
        String[] ret = new String[retSet.size()];
        retSet.toArray(ret);
        return ret;
    }
}

