/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import jet.controls.JetObject;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.HierarchyContainer;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.businesslogic.impl.Aggregation;
import jet.universe.businesslogic.impl.BusinessView;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.Detail;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.Group;
import jet.universe.businesslogic.impl.Hierarchy;
import jet.universe.businesslogic.impl.HierarchyContainerImpl;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.businesslogic.impl.UpgradedUnifiedBusinessView;

public class BusinessLogicToBusinessView {
    public static UpgradedUnifiedBusinessView unifyBusinessLogic(JBusinessLogic bl) {
        UpgradedUnifiedBusinessView uubv = new UpgradedUnifiedBusinessView();
        BLNode[] children = bl.getBLChildren();
        BLNode[] bvChildren = new BLNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            bvChildren[i] = BusinessLogicToBusinessView.convert(children[i]);
            try {
                uubv.addChild(bvChildren[i]);
                continue;
            }
            catch (BLDupleNameException e) {
                // empty catch block
            }
        }
        try {
            uubv.setDisplayName(bl.getDisplayName());
        }
        catch (BLDupleNameException e) {
        }
        catch (BLIlegalNameException e) {
            // empty catch block
        }
        return uubv;
    }

    public static JBusinessView convertBusinessLogic(JBusinessLogic bl) {
        BusinessView bv = new BusinessView();
        BLNode[] children = bl.getBLChildren();
        BLNode[] bvChildren = new BLNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            bvChildren[i] = BusinessLogicToBusinessView.convert(children[i]);
            try {
                bv.addChild(bvChildren[i]);
                continue;
            }
            catch (BLDupleNameException e) {
                // empty catch block
            }
        }
        try {
            bv.setName(bl.getName());
            bv.setDisplayName(bl.getDisplayName());
        }
        catch (BLDupleNameException e) {
        }
        catch (BLIlegalNameException e) {
            // empty catch block
        }
        return bv;
    }

    private static BLNode convert(BLNode node) {
        int type = node.getElementType();
        switch (type) {
            case 3: {
                BLNode[] cateChildren = ((Category)node).getBLChildren();
                Category cate = BusinessLogicToBusinessView.convertCategory((Category)node);
                for (int i = 0; i < cateChildren.length; ++i) {
                    cate.add((JetObject)((Object)BusinessLogicToBusinessView.convert(cateChildren[i])));
                }
                return cate;
            }
            case 4: {
                Group group = BusinessLogicToBusinessView.convertDimension((Dimension)node);
                return group;
            }
            case 5: {
                Aggregation agg = BusinessLogicToBusinessView.convertMeasure((Measure)node);
                return agg;
            }
            case 7: {
                return BusinessLogicToBusinessView.convertDetailInfo((DetailInfo)node);
            }
            case 6: 
            case 16: 
            case 17: {
                return node;
            }
            case 9: {
                return BusinessLogicToBusinessView.convertHierarchy((Hierarchy)node);
            }
            case 15: {
                HierarchyContainerImpl hc = BusinessLogicToBusinessView.convertHierarchyContainer((HierarchyContainerImpl)node);
                BLNode[] hierChildren = ((HierarchyContainer)node).getBLChildren();
                for (int i = 0; i < hierChildren.length; ++i) {
                    try {
                        hc.addHierarchy((Hierarchy)BusinessLogicToBusinessView.convert(hierChildren[i]));
                        continue;
                    }
                    catch (BLDupleNameException e) {
                        // empty catch block
                    }
                }
                return hc;
            }
        }
        return null;
    }

    private static HierarchyContainerImpl convertHierarchyContainer(HierarchyContainerImpl src) {
        HierarchyContainerImpl ret = new HierarchyContainerImpl();
        JetObject.copyProperties(ret, src);
        return ret;
    }

    private static Hierarchy convertHierarchy(Hierarchy src) {
        Hierarchy ret = new Hierarchy();
        JetObject.copyProperties(ret, src);
        return ret;
    }

    private static Category convertCategory(Category node) {
        Category category = new Category();
        JetObject.copyProperties(category, node);
        return category;
    }

    private static Group convertDimension(Dimension dim) {
        Group group = new Group();
        JetObject.copyProperties(group, dim);
        return group;
    }

    private static Aggregation convertMeasure(Measure measuer) {
        Aggregation agg = new Aggregation();
        JetObject.copyProperties(agg, measuer);
        return agg;
    }

    private static Detail convertDetailInfo(DetailInfo info) {
        Detail detail = new Detail();
        JetObject.copyProperties(detail, info);
        return detail;
    }
}

