/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.log.JRLogger;
import jet.universe.JetUDatabase;
import jet.universe.JetUQueriable;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNoSuchElementException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DTInformation;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.GroupInfo;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.impl.Aggregation;
import jet.universe.businesslogic.impl.BCFilter;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.Detail;
import jet.universe.businesslogic.impl.Group;
import jet.universe.businesslogic.impl.Hierarchy;
import jet.universe.businesslogic.impl.Prefilter;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.InvalidEntityException;
import jet.util.HashVector;

public class BusinessView
extends BusinessLogic
implements JBusinessView {
    public JetBoolean prefetch = new JetBoolean(this, "Prefetch", true);
    private static JRLogger logger = JRLogger.getLogger(BusinessView.class.getName());
    private static final HashMap nameIdx = new HashMap(3);
    private static final HashVector grpDesc;

    public BusinessView() {
        this.setElementType(1);
        try {
            this.setName("NewBusinessView");
        }
        catch (BLDupleNameException e) {
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            // empty catch block
        }
    }

    @Override
    public DimensionInfo[] getDimensions() {
        return this.getGroups();
    }

    @Override
    public MeasureInfo[] getMeasures() {
        return this.getAggregations();
    }

    @Override
    public DetailInformation[] getDetailInfos() {
        return this.getDetails();
    }

    @Override
    public BLNode getNewNode(int type) {
        BLNodeImpl ret = null;
        switch (type) {
            case 3: {
                ret = new Category();
                break;
            }
            case 4: {
                ret = new Group();
                break;
            }
            case 5: {
                ret = new Aggregation();
                break;
            }
            case 7: {
                ret = new Detail();
                break;
            }
            case 16: {
                ret = new BCFilter();
                break;
            }
            case 17: {
                ret = new Prefilter();
                break;
            }
            case 9: {
                ret = new Hierarchy();
                break;
            }
        }
        return ret;
    }

    @Override
    public BLNode getNewNode(BLContainer base, int type) {
        BLNode ret = this.getNewNode(type);
        if (ret == null) {
            return null;
        }
        String name2 = null;
        switch (ret.getElementType()) {
            case 3: {
                CategoryInfo cfr_ignored_0 = (CategoryInfo)ret;
                name2 = "Category";
                break;
            }
            case 4: {
                GroupInfo cfr_ignored_1 = (GroupInfo)ret;
                name2 = "Group";
                break;
            }
            case 5: {
                AggregationInfo cfr_ignored_2 = (AggregationInfo)ret;
                name2 = "Aggregation";
                break;
            }
            case 7: {
                DTInformation cfr_ignored_3 = (DTInformation)ret;
                name2 = "Detail";
                break;
            }
            case 16: 
            case 17: {
                FilterInfo cfr_ignored_4 = (FilterInfo)ret;
                name2 = "Filter";
                break;
            }
            case 9: {
                HierarchyInfo cfr_ignored_5 = (HierarchyInfo)ret;
                name2 = "Hierarchy";
                break;
            }
            default: {
                return null;
            }
        }
        int sufix = 1;
        String tmpName = name2 + sufix;
        if (ret.getElementType() == 9) {
            while (this.isUsedHierarchyName(tmpName)) {
                tmpName = name2 + ++sufix;
            }
        } else {
            while (base.isUsedName(tmpName)) {
                tmpName = name2 + ++sufix;
            }
        }
        name2 = tmpName;
        try {
            ret.setName(name2);
            ret.setDisplayName(name2);
        }
        catch (BLDupleNameException e) {
        }
        catch (BLIlegalNameException e) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public BLNode addNode(String base, BLNode info) throws BLDupleNameException, BLNoSuchElementException {
        BLNode node = this.get(base);
        if (node == null) {
            throw new BLNoSuchElementException(base);
        }
        if (!(node instanceof BLContainer)) {
            throw new BLNoSuchElementException(base);
        }
        int infoType = info.getElementType();
        block0 : switch (node.getElementType()) {
            case 1: 
            case 3: {
                CategoryInfo parent = (CategoryInfo)node;
                switch (infoType) {
                    case 3: {
                        parent.addCategory((CategoryInfo)info);
                        break block0;
                    }
                    case 4: {
                        parent.addGroup((GroupInfo)info);
                        break block0;
                    }
                    case 5: {
                        parent.addAggregation((AggregationInfo)info);
                        break block0;
                    }
                    case 7: {
                        parent.addDetail((DTInformation)info);
                        break block0;
                    }
                    case 16: {
                        this.addBCFilter((FilterInfo)info);
                        break block0;
                    }
                    case 17: {
                        this.addPrefilter((FilterInfo)info);
                        break block0;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new BLNoSuchElementException(base);
            }
        }
        return info;
    }

    @Override
    public String getInstancePrefix() {
        return "BusinessView";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public String[] getAllAvailableNodes() {
        int i;
        JetUQueriable jQuery = (JetUQueriable)((Object)this.getQuery());
        JetUDatabase jDatabase = jQuery.getDatabase();
        String queryName = jQuery.getResourceName();
        CategoryInfo[] categoryInfos = this.getCategories();
        GroupInfo[] groups = this.getGroups();
        DTInformation[] details = this.getDetails();
        AggregationInfo[] aggs = this.getAggregations();
        Vector<String> vAvailableNodes = new Vector<String>();
        if (categoryInfos != null && categoryInfos.length > 0) {
            for (i = 0; i < categoryInfos.length; ++i) {
                this.getCategoryInfoNodeMappingNames(categoryInfos[i], vAvailableNodes);
            }
        }
        if (groups != null && groups.length > 0) {
            for (i = 0; i < groups.length; ++i) {
                vAvailableNodes.add(groups[i].getRefMappingName());
            }
        }
        if (details != null && details.length > 0) {
            for (i = 0; i < details.length; ++i) {
                vAvailableNodes.add(details[i].getRefMappingName());
            }
        }
        if (aggs != null && aggs.length > 0) {
            for (i = 0; i < aggs.length; ++i) {
                vAvailableNodes.add(aggs[i].getRefMappingName());
            }
        }
        Vector<String> resultMappings = new Vector<String>();
        for (String mappingNameStr : vAvailableNodes) {
            boolean vaildResult;
            block13: {
                Vector<String> vMappingName = new Vector<String>();
                vMappingName.add(mappingNameStr);
                vaildResult = false;
                try {
                    vaildResult = jDatabase.checkIfMappingFldsValidToQuery(queryName, vMappingName);
                }
                catch (InvalidEntityException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error("", e);
                    }
                }
                catch (CannotFindQuery e) {
                    if (!logger.isErrorEnabled()) break block13;
                    logger.error("", e);
                }
            }
            if (!vaildResult || resultMappings.contains(mappingNameStr)) continue;
            resultMappings.add(mappingNameStr);
        }
        String[] mappingNames = new String[resultMappings.size()];
        resultMappings.toArray(mappingNames);
        return mappingNames;
    }

    private void getCategoryInfoNodeMappingNames(CategoryInfo categoryInfo, Vector<String> vMappingName) {
        int i;
        if (categoryInfo == null) {
            return;
        }
        CategoryInfo[] catInfos = categoryInfo.getCategories();
        if (catInfos != null) {
            for (int i2 = 0; i2 < catInfos.length; ++i2) {
                this.getCategoryInfoNodeMappingNames(catInfos[i2], vMappingName);
            }
        }
        GroupInfo[] grps = categoryInfo.getGroups();
        DTInformation[] details = categoryInfo.getDetails();
        AggregationInfo[] aggs = categoryInfo.getAggregations();
        if (grps != null) {
            for (i = 0; i < grps.length; ++i) {
                vMappingName.add(grps[i].getRefMappingName());
            }
        }
        if (details != null) {
            for (i = 0; i < details.length; ++i) {
                vMappingName.add(details[i].getRefMappingName());
            }
        }
        if (aggs != null) {
            for (i = 0; i < aggs.length; ++i) {
                vMappingName.add(aggs[i].getRefMappingName());
            }
        }
    }

    @Override
    public boolean isPrefetch() {
        return this.prefetch.get();
    }

    static {
        nameIdx.put("BLElementType", new Integer(0));
        nameIdx.put("Description", new Integer(1));
        nameIdx.put("DisplayName", new Integer(2));
        nameIdx.put("Prefetch", new Integer(3));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(3);
        grpItems.add("BLElementType");
        grpItems.add("Description");
        grpItems.add("DisplayName");
        grpItems.add("Prefetch");
        grpDesc.put(grpName, grpItems);
    }
}

