/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetString;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DTInformation;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.GroupInfo;
import jet.universe.businesslogic.HierarchyContainer;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.impl.BLContainerImpl;
import jet.universe.businesslogic.impl.HierarchyContainerImpl;
import jet.util.HashVector;

public class Category
extends BLContainerImpl
implements CategoryInfo {
    private JetString thePreviousNode = new JetString(this, "PreviousNode", "");
    private JetString theNextNode = new JetString(this, "NextNode", "");
    private HierarchyContainer theHierarchies;
    private static final HashMap nameIdx = new HashMap(4);
    private static final HashVector grpDesc;

    public Category() {
        this.setElementType(3);
    }

    @Override
    public DimensionInfo addDimension(DimensionInfo dim) throws BLDupleNameException {
        this.addChild(dim);
        return dim;
    }

    public HierarchyContainer getHierarchyContainer() {
        if (this.theHierarchies == null) {
            Vector v = this.getChildren();
            for (BLNode node : v) {
                if (node.getElementType() != 15) continue;
                this.theHierarchies = (HierarchyContainer)node;
            }
            if (this.theHierarchies == null) {
                this.theHierarchies = new HierarchyContainerImpl();
                try {
                    this.theHierarchies.setName("Hierarchies");
                    this.addChild(this.theHierarchies);
                }
                catch (BLDupleNameException e) {
                }
                catch (BLIlegalNameException bLIlegalNameException) {
                    // empty catch block
                }
            }
        }
        return this.theHierarchies;
    }

    @Override
    public DimensionInfo[] getDimensions() {
        BLNode[] tmp = this.getBLChildren();
        DimensionInfo[] retTmp = new DimensionInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 4) continue;
            retTmp[size] = (DimensionInfo)tmp[i];
            ++size;
        }
        DimensionInfo[] ret = new DimensionInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public HierarchyInfo[] getHierarchies() {
        BLNode[] tmp = this.getBLChildren();
        HierarchyInfo[] retTmp = new HierarchyInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 9) continue;
            retTmp[size] = (HierarchyInfo)tmp[i];
            ++size;
        }
        HierarchyInfo[] ret = new HierarchyInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public MeasureInfo addMeasure(MeasureInfo mea) throws BLDupleNameException {
        this.addChild(mea);
        return mea;
    }

    @Override
    public MeasureInfo[] getMeasures() {
        BLNode[] tmp = this.getBLChildren();
        MeasureInfo[] retTmp = new MeasureInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 5) continue;
            retTmp[size] = (MeasureInfo)tmp[i];
            ++size;
        }
        MeasureInfo[] ret = new MeasureInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public DetailInformation addDetailInformation(DetailInformation detail) throws BLDupleNameException {
        this.addChild(detail);
        return detail;
    }

    @Override
    public DetailInformation[] getDetailInfos() {
        BLNode[] tmp = this.getBLChildren();
        DetailInformation[] retTmp = new DetailInformation[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 7) continue;
            retTmp[size] = (DetailInformation)tmp[i];
            ++size;
        }
        DetailInformation[] ret = new DetailInformation[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public CategoryInfo addCategory(CategoryInfo cate) throws BLDupleNameException {
        this.addChild(cate);
        return cate;
    }

    @Override
    public CategoryInfo[] getCategories() {
        BLNode[] tmp = this.getBLChildren();
        CategoryInfo[] retTmp = new CategoryInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 3) continue;
            retTmp[size] = (CategoryInfo)tmp[i];
            ++size;
        }
        CategoryInfo[] ret = new CategoryInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    @Deprecated
    public BLNode removeChildByName(String name2) {
        BLNode ret = this.getChildByName(name2);
        String qName = ret.getBLQualifyName();
        ret = super.removeChildByName(name2);
        if (ret != null) {
            JBusinessLogic bl;
            if (ret.getElementType() == 4 && (bl = this.getBusinessLogic()) != null) {
                HierarchyInfo[] hs = bl.getAllHierarchies();
                for (int i = 0; i < hs.length; ++i) {
                    hs[i].removeDimension(qName);
                }
            }
            if (ret.getElementType() == 3) {
                DimensionInfo[] dis = ((CategoryInfo)ret).getAllDimensions();
                JBusinessLogic bl2 = this.getBusinessLogic();
                if (bl2 != null) {
                    HierarchyInfo[] hs = bl2.getAllHierarchies();
                    for (int i = 0; i < hs.length; ++i) {
                        for (int k = 0; k < dis.length; ++k) {
                            String DiQName = dis[k].getBLQualifyName();
                            hs[i].removeDimension(DiQName);
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public BLNode removeChildByDisplayName(String DisplayName2) {
        BLNode ret = this.getChildByDisplayName(DisplayName2);
        String qdName = ret.getQualifyDisplayName();
        ret = super.removeChildByDisplayName(DisplayName2);
        if (ret != null) {
            JBusinessLogic bl;
            if (ret.getElementType() == 4 && (bl = this.getBusinessLogic()) != null) {
                HierarchyInfo[] hs = bl.getAllHierarchies();
                for (int i = 0; i < hs.length; ++i) {
                    hs[i].removeDimension(qdName);
                }
            }
            if (ret.getElementType() == 3) {
                DimensionInfo[] dis = ((CategoryInfo)ret).getAllDimensions();
                JBusinessLogic bl2 = this.getBusinessLogic();
                if (bl2 != null) {
                    HierarchyInfo[] hs = bl2.getAllHierarchies();
                    for (int i = 0; i < hs.length; ++i) {
                        for (int k = 0; k < dis.length; ++k) {
                            String DiQDName = dis[k].getQualifyDisplayName();
                            hs[i].removeDimension(DiQDName);
                        }
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isSimilar(BLNode node) {
        if (!super.isSimilar(node)) {
            return false;
        }
        Category category = (Category)node;
        return this.getDisplayName().equals(category.getDisplayName());
    }

    @Override
    public String getInstancePrefix() {
        return "Category";
    }

    @Override
    public GroupInfo addGroup(GroupInfo group) throws BLDupleNameException {
        this.addChild(group);
        return group;
    }

    @Override
    public GroupInfo[] getGroups() {
        BLNode[] tmp = this.getBLChildren();
        GroupInfo[] retTmp = new GroupInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 4) continue;
            retTmp[size] = (GroupInfo)tmp[i];
            ++size;
        }
        GroupInfo[] ret = new GroupInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public AggregationInfo addAggregation(AggregationInfo agg) throws BLDupleNameException {
        this.addChild(agg);
        return agg;
    }

    @Override
    public AggregationInfo[] getAggregations() {
        BLNode[] tmp = this.getBLChildren();
        AggregationInfo[] retTmp = new AggregationInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 5) continue;
            retTmp[size] = (AggregationInfo)tmp[i];
            ++size;
        }
        AggregationInfo[] ret = new AggregationInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public DTInformation addDetail(DTInformation detail) throws BLDupleNameException {
        this.addChild(detail);
        return detail;
    }

    @Override
    public DTInformation[] getDetails() {
        BLNode[] tmp = this.getBLChildren();
        DTInformation[] retTmp = new DTInformation[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 7) continue;
            retTmp[size] = (DTInformation)tmp[i];
            ++size;
        }
        DTInformation[] ret = new DTInformation[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public BLNode getNextNode() {
        String name2 = this.theNextNode.get();
        return name2.length() == 0 ? null : this.getBLParent().getChildByName(name2);
    }

    @Override
    public BLNode getPreviousNode() {
        String name2 = this.thePreviousNode.get();
        return name2.length() == 0 ? null : this.getBLParent().getChildByName(name2);
    }

    @Override
    public void setNextNode(BLNode next) {
        this.theNextNode.set(next == null ? "" : next.getName());
    }

    @Override
    public void setPreviousNode(BLNode previous) {
        this.thePreviousNode.set(previous == null ? "" : previous.getName());
    }

    @Override
    public GroupInfo[] getAllGroups() {
        ArrayList<GroupInfo> retList = new ArrayList<GroupInfo>();
        for (GroupInfo groupInfo : this.getGroups()) {
            retList.add(groupInfo);
        }
        for (BLNode bLNode : this.getCategories()) {
            for (GroupInfo gi : bLNode.getAllGroups()) {
                retList.add(gi);
            }
        }
        GroupInfo[] ret = new GroupInfo[retList.size()];
        return retList.toArray(ret);
    }

    @Override
    public AggregationInfo[] getAllAggregations() {
        ArrayList<AggregationInfo> retList = new ArrayList<AggregationInfo>();
        for (AggregationInfo aggregationInfo : this.getAggregations()) {
            retList.add(aggregationInfo);
        }
        for (BLNode bLNode : this.getCategories()) {
            for (AggregationInfo agg : bLNode.getAllAggregations()) {
                retList.add(agg);
            }
        }
        AggregationInfo[] ret = new AggregationInfo[retList.size()];
        return retList.toArray(ret);
    }

    @Override
    public DTInformation[] getAllDetails() {
        ArrayList<DTInformation> retList = new ArrayList<DTInformation>();
        for (DTInformation dTInformation : this.getDetails()) {
            retList.add(dTInformation);
        }
        for (BLNode bLNode : this.getCategories()) {
            for (DTInformation di : bLNode.getAllDetails()) {
                retList.add(di);
            }
        }
        DTInformation[] ret = new DTInformation[retList.size()];
        return retList.toArray(ret);
    }

    @Override
    public HierarchyInfo[] getAllHierarchies() {
        ArrayList<HierarchyInfo> retList = new ArrayList<HierarchyInfo>();
        for (HierarchyInfo hierarchyInfo : this.getHierarchies()) {
            retList.add(hierarchyInfo);
        }
        for (BLNode bLNode : this.getCategories()) {
            for (HierarchyInfo h : bLNode.getAllHierarchies()) {
                retList.add(h);
            }
        }
        HierarchyInfo[] ret = new HierarchyInfo[retList.size()];
        return retList.toArray(ret);
    }

    @Override
    public DimensionInfo[] getAllDimensions() {
        ArrayList<DimensionInfo> retList = new ArrayList<DimensionInfo>();
        for (DimensionInfo dimensionInfo : this.getDimensions()) {
            retList.add(dimensionInfo);
        }
        for (BLNode bLNode : this.getCategories()) {
            for (DimensionInfo di : bLNode.getAllDimensions()) {
                retList.add(di);
            }
        }
        DimensionInfo[] ret = new DimensionInfo[retList.size()];
        return retList.toArray(ret);
    }

    @Override
    public CategoryInfo[] getAllCategories() {
        ArrayList<CategoryInfo> retList = new ArrayList<CategoryInfo>();
        for (CategoryInfo cat : this.getCategories()) {
            retList.add(cat);
            for (CategoryInfo ca : cat.getAllCategories()) {
                retList.add(ca);
            }
        }
        CategoryInfo[] ret = new CategoryInfo[retList.size()];
        return retList.toArray(ret);
    }

    @Override
    public MeasureInfo[] getAllMeasures() {
        ArrayList<MeasureInfo> retList = new ArrayList<MeasureInfo>();
        for (MeasureInfo measureInfo : this.getMeasures()) {
            retList.add(measureInfo);
        }
        for (BLNode bLNode : this.getCategories()) {
            for (MeasureInfo agg : bLNode.getAllMeasures()) {
                retList.add(agg);
            }
        }
        MeasureInfo[] ret = new MeasureInfo[retList.size()];
        return retList.toArray(ret);
    }

    @Override
    public DetailInformation[] getAllDetailInfos() {
        ArrayList<DetailInformation> retList = new ArrayList<DetailInformation>();
        for (DetailInformation detailInformation : this.getDetailInfos()) {
            retList.add(detailInformation);
        }
        for (BLNode bLNode : this.getCategories()) {
            for (DetailInformation di : bLNode.getAllDetailInfos()) {
                retList.add(di);
            }
        }
        DetailInformation[] ret = new DetailInformation[retList.size()];
        return retList.toArray(ret);
    }

    @Override
    public HierarchyInfo addHierarchy(HierarchyInfo hi) throws BLDupleNameException {
        this.addChild(hi);
        return hi;
    }

    public HierarchyInfo getHierarchy(String hierarchyName) {
        HierarchyInfo ret = (HierarchyInfo)this.getChildByName(hierarchyName);
        return ret;
    }

    @Override
    public HierarchyInfo[] getHierarchies(String dimension) {
        HierarchyInfo[] tmp = this.getAllHierarchies();
        HierarchyInfo[] tmpRet = new HierarchyInfo[tmp.length];
        int count = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (!tmp[i].containsDimension(dimension)) continue;
            tmpRet[count] = tmp[i];
            ++count;
        }
        HierarchyInfo[] ret = new HierarchyInfo[count];
        System.arraycopy(tmpRet, 0, ret, 0, count);
        return ret;
    }

    @Override
    public DataElementInfo[] getAllDataElement() {
        ArrayList<DataElementInfo> retList = new ArrayList<DataElementInfo>();
        for (DataElementInfo dataElementInfo : this.getDataElementInfo()) {
            retList.add(dataElementInfo);
        }
        for (BLNode bLNode : this.getCategories()) {
            for (DataElementInfo dei : bLNode.getAllDataElement()) {
                retList.add(dei);
            }
        }
        DataElementInfo[] ret = new DataElementInfo[retList.size()];
        return retList.toArray(ret);
    }

    public DataElementInfo[] getDataElementInfo() {
        BLNode[] tmp = this.getBLChildren();
        DataElementInfo[] retTmp = new DataElementInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 5 && tmp[i].getElementType() != 4 && tmp[i].getElementType() != 7) continue;
            retTmp[size] = (DataElementInfo)tmp[i];
            ++size;
        }
        DataElementInfo[] ret = new DataElementInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    static {
        nameIdx.put("name", new Integer(0));
        nameIdx.put("BLElementType", new Integer(1));
        nameIdx.put("Description", new Integer(2));
        nameIdx.put("DisplayName", new Integer(3));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(4);
        grpItems.add("name");
        grpItems.add("BLElementType");
        grpItems.add("Description");
        grpItems.add("DisplayName");
        grpDesc.put(grpName, grpItems);
    }
}

