/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetString;
import jet.dataengine.util.DSLog;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.util.HashVector;

public abstract class DataElement
extends BLNodeImpl
implements DataElementInfo {
    protected static DSLog logger = DSLog.getDSLog(DataElement.class.getName());
    private JetString thePrompt = new JetString(this, "Prompt");
    private JetString theRefMappingName = new JetString(this, "RefMappingName", "");
    private JetString thePreviousNode = new JetString(this, "PreviousNode", "");
    private JetString theNextNode = new JetString(this, "NextNode", "");
    public JetString dataMappingFile = new JetString(this, "DataMappingFile");
    private static final HashMap nameIdx = new HashMap(6);
    private static final HashVector grpDesc;

    protected DataElement() {
        this.dataMappingFile.setEnableAutoValue(true);
        this.dataMappingFile.setAsAutoValue(true);
        this.dataMappingFile.setCanChangeByOthers(false);
        this.dataMappingFile.setEditorType(JetString.COMBO_EDITOR);
    }

    @Override
    public void setPrompt(String prompt) {
        if (prompt != null) {
            this.thePrompt.set(prompt);
        }
    }

    @Override
    public String getPrompt() {
        return this.thePrompt.get();
    }

    @Override
    public void setRefMappingName(String mappingName) {
        if (mappingName != null) {
            this.theRefMappingName.set(mappingName.trim());
        }
    }

    @Override
    public String getRefMappingName() {
        return this.theRefMappingName.get();
    }

    @Override
    public boolean isSimilar(BLNode node) {
        if (!super.isSimilar(node)) {
            return false;
        }
        DataElementInfo element = (DataElementInfo)node;
        if (!this.getDisplayName().equals(element.getDisplayName())) {
            return false;
        }
        if (!this.getPrompt().equals(element.getPrompt())) {
            return false;
        }
        return this.getRefMappingName().equalsIgnoreCase(element.getRefMappingName());
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public BLNode getNextNode() {
        String name2 = this.theNextNode.get();
        return name2.length() == 0 ? null : this.getBLParent().getChildByName(name2);
    }

    @Override
    public BLNode getPreviousNode() {
        String name2 = this.thePreviousNode.get();
        return name2.length() == 0 ? null : this.getBLParent().getChildByName(name2);
    }

    @Override
    public void setNextNode(BLNode next) {
        this.theNextNode.set(next == null ? "" : next.getName());
    }

    @Override
    public void setPreviousNode(BLNode previous) {
        this.thePreviousNode.set(previous == null ? "" : previous.getName());
    }

    public String getDataMappingFile() {
        if (this.dataMappingFile.isCurrentAutoValue()) {
            if (logger.isDebugAll()) {
                String logMsg = "QualifyDisplayName = " + this.getQualifyDisplayName() + " dataMappingFile is<Auto>";
                logger.debugAll(logMsg);
            }
            String mappingName = this.getRefMappingName();
            JetUDemandQuery query = this.getUbv().getQuery();
            JetUResourceEntity resource = query.getDatabase().getResourceByName(mappingName);
            if (resource != null) {
                String ret = resource.getDataMappingFile();
                if (logger.isDebugAll()) {
                    String logMsg = "inherit from  " + resource + " dataMappingFile = " + ret;
                    logger.debugAll(logMsg);
                }
                return ret;
            }
            return "";
        }
        String ret = this.dataMappingFile.get();
        if (logger.isDebugAll()) {
            String logMsg = "QualifyDisplayName = " + this.getQualifyDisplayName() + " dataMappingFile = " + ret;
            logger.debugAll(logMsg);
        }
        return ret;
    }

    public void setDataMappingFile(String dataMappingFile) {
        if (logger.isDebugAll()) {
            String logMsg = "QualifyDisplayName = " + this.getQualifyDisplayName() + " setDataMappingFile = " + dataMappingFile;
            logger.debugAll(logMsg);
        }
        this.dataMappingFile.set(dataMappingFile);
    }

    static {
        nameIdx.put("name", new Integer(0));
        nameIdx.put("BLElementType", new Integer(1));
        nameIdx.put("Description", new Integer(2));
        nameIdx.put("DisplayName", new Integer(3));
        nameIdx.put("Prompt", new Integer(4));
        nameIdx.put("RefMappingName", new Integer(5));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(6);
        grpItems.add("name");
        grpItems.add("BLElementType");
        grpItems.add("Description");
        grpItems.add("Prompt");
        grpItems.add("RefMappingName");
        grpItems.add("DisplayName");
        grpItems.add("DataMappingFile");
        grpDesc.put(grpName, grpItems);
    }
}

