/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.universe.JetUDatabase;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.convert.IExpression2Jet;
import jet.universe.businesslogic.filter.convert.Jet2IExpression;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.DataElement;

public abstract class FilterImpl
extends BLNodeImpl
implements FilterInfo,
JetContainable {
    private JetString title = new JetString(this, "title");
    private IExpression2Jet ie2jet;
    private Jet2IExpression jet2ie;
    private Vector children = new Vector();
    private JetUUniverse unv;
    private JetUDatabase udb;
    private static final HashMap nameIdx = new HashMap(4);

    protected FilterImpl() {
        this.addProperty(this.title);
        this.ie2jet = new IExpression2Jet();
        this.jet2ie = new Jet2IExpression();
    }

    private JetUDatabase getUDB() {
        JetObject ret = this;
        while (!(ret instanceof JetUDatabase)) {
            if ((ret = (JetObject)((Object)ret.getParent())) != null) continue;
            return null;
        }
        return (JetUDatabase)ret;
    }

    private void initUDB() {
        this.udb = this.getUDB();
        this.unv = this.udb.getUniverse();
    }

    private String buildErrorMSG(String name2) {
        return "'" + name2 + "' in Filter '" + this.getTitle() + "' can't be found";
    }

    private String validateiReferences(UFilterExpression ue) {
        Vector<String> errors = new Vector<String>();
        String err = "";
        if (this.udb == null) {
            this.initUDB();
        }
        String[] mappingNames = ue.getReferencedMappingNames();
        for (int i = 0; i < mappingNames.length; ++i) {
            String name2 = mappingNames[i];
            JetUResourceEntity o = this.udb.getResourceByName(null, name2.toUpperCase());
            if (o != null) continue;
            if (err.length() > 0) {
                err = err + "\n";
            }
            err = err + this.buildErrorMSG(name2);
        }
        String[] qualifNames = ue.getReferencedQualifyNames();
        for (int i = 0; i < qualifNames.length; ++i) {
            String name3 = qualifNames[i];
            BLNode node = this.getUbv().getByDisplayName(name3);
            if (node != null) continue;
            if (err.length() > 0) {
                err = err + "\n";
            }
            err = err + this.buildErrorMSG(name3);
            errors.add(err);
        }
        return err;
    }

    @Override
    public IExpression getFilter() throws ConditionException {
        UFilterExpression fe;
        String err;
        if (this.children.size() == 0) {
            return null;
        }
        if (this.udb == null) {
            this.initUDB();
        }
        if ((err = this.validateiReferences(fe = (UFilterExpression)this.children.elementAt(0))).length() > 0) {
            throw new ConditionException(8495, new String[]{err});
        }
        IExpression ie = this.jet2ie.convert(fe, this.unv, this.udb.getResourceName(), this.getUbv());
        return ie;
    }

    @Override
    public void setFilter(IExpression ie) throws ConditionException {
        if (ie == null) {
            this.children.removeAllElements();
        } else {
            UFilterExpression fe = this.ie2jet.convert(ie);
            this.add(fe);
        }
    }

    @Override
    public void setTitle(String title) {
        this.title.set(title);
    }

    @Override
    public String getTitle() {
        return this.title.get();
    }

    @Override
    public JetObject add(JetObject filterExp) {
        if (!(filterExp instanceof UFilterExpression)) {
            throw new RuntimeException("unspported object type: " + filterExp.getClass().getName());
        }
        if (this.children.size() > 0) {
            this.children.removeAllElements();
        }
        filterExp.setParent(this);
        this.children.add(filterExp);
        return filterExp;
    }

    @Override
    public JetObject remove(JetObject arg0) {
        throw new RuntimeException("unspported method!");
    }

    @Override
    public void broadcast(JetObject arg0, int arg1) {
        throw new RuntimeException("unspported method!");
    }

    @Override
    public Vector getChildren() {
        return this.children;
    }

    @Override
    public Vector getReferredResourceEntities() {
        Vector<JetUResourceEntity> ret = new Vector<JetUResourceEntity>();
        if (this.children.size() == 0) {
            return ret;
        }
        if (this.udb == null) {
            this.initUDB();
        }
        UFilterExpression fe = (UFilterExpression)this.children.elementAt(0);
        String[] names = fe.getReferencedMappingNames();
        for (int i = 0; i < names.length; ++i) {
            String name2 = names[i];
            JetUResourceEntity o = this.udb.getResourceByName(null, name2.toUpperCase());
            if (o == null) continue;
            ret.add(o);
        }
        return ret;
    }

    @Override
    public Vector getReferredDataElements() {
        Vector<BLNode> ret = new Vector<BLNode>();
        if (this.children.size() == 0) {
            return ret;
        }
        if (this.udb == null) {
            this.initUDB();
        }
        UFilterExpression fe = (UFilterExpression)this.children.elementAt(0);
        String[] names = fe.getReferencedQualifyNames();
        for (int i = 0; i < names.length; ++i) {
            String name2 = names[i];
            BLNode node = this.getUbv().getByDisplayName(name2);
            if (node == null || !(node instanceof DataElement)) continue;
            ret.add(node);
        }
        return ret;
    }

    @Override
    public void updateReferenceName(String oldName, String newName) {
        if (this.children.size() == 0) {
            return;
        }
        UFilterExpression fe = (UFilterExpression)this.children.elementAt(0);
        fe.updateReferenceName(oldName, newName);
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("name", new Integer(0));
        nameIdx.put("title", new Integer(1));
        nameIdx.put("BLElementType", new Integer(2));
        nameIdx.put("Description", new Integer(3));
    }
}

