/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetVector;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.DataElement;
import jet.util.HashVector;

public class Hierarchy
extends DataElement
implements HierarchyInfo {
    private JetVector theDimensions = new JetVector(this, "Dimensions");
    private static final HashMap nameIdx = new HashMap(4);
    private static final HashVector grpDesc;

    public Hierarchy() {
        this.setElementType(9);
        this.theName.setEditFlag(3);
    }

    @Override
    public void setDimensions(String[] dimQualifyName) {
        if (dimQualifyName == null) {
            return;
        }
        this.theDimensions.clear();
        for (int i = 0; i < dimQualifyName.length; ++i) {
            this.theDimensions.add(dimQualifyName[i]);
        }
    }

    @Override
    public String[] getDimensionQDNames() {
        String[] ret = this.theDimensions.toStringArray();
        return ret;
    }

    @Override
    public void setDisplayName(String name2) throws BLDupleNameException, BLIlegalNameException {
        BusinessLogic bl = (BusinessLogic)this.getBusinessLogic();
        if (bl != null && bl.isUsedHierarchyDisplayName(name2)) {
            throw new BLDupleNameException(name2);
        }
        super.setDisplayName(name2);
    }

    @Override
    public String getDownLevelDimQDName(String dimQDName) {
        String ret = null;
        Vector dims = this.theDimensions.get();
        int curDimPosition = dims.indexOf(dimQDName);
        if (curDimPosition != -1 && curDimPosition + 1 < dims.size()) {
            ret = (String)dims.get(curDimPosition + 1);
        }
        return ret;
    }

    @Override
    public String getUpLevelDimQDName(String dimQDName) {
        String ret = null;
        Vector dims = this.theDimensions.get();
        int curDimPosition = dims.indexOf(dimQDName);
        if (curDimPosition > 0) {
            ret = (String)dims.get(curDimPosition - 1);
        }
        return ret;
    }

    @Override
    public boolean containsDimension(String dimName) {
        boolean ret = false;
        Vector dims = this.theDimensions.get();
        int curDimPosition = dims.indexOf(dimName);
        if (curDimPosition != -1) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void removeDimension(String dimQDName) {
        this.theDimensions.remove(dimQDName);
    }

    @Override
    public HierarchyInfo copy() {
        Hierarchy ret = new Hierarchy();
        try {
            ret.setName(this.getName());
            ret.setDisplayName(this.getDisplayName());
        }
        catch (BLException e) {
            // empty catch block
        }
        String[] dims = this.theDimensions.toStringArray();
        for (int i = 0; i < dims.length; ++i) {
            ret.theDimensions.add(dims[i]);
        }
        return ret;
    }

    @Override
    public boolean isSimilar(BLNode node) {
        String[] dimensions2;
        if (!super.isSimilar(node)) {
            return false;
        }
        HierarchyInfo hc = (HierarchyInfo)node;
        String[] dimensions1 = this.getDimensionQDNames();
        if (dimensions1.length != (dimensions2 = hc.getDimensionQDNames()).length) {
            return false;
        }
        for (String name1 : dimensions1) {
            boolean bfound = false;
            for (String name2 : dimensions2) {
                if (!name1.equalsIgnoreCase(name2)) continue;
                bfound = true;
            }
            if (bfound) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getInstancePrefix() {
        return "Hierarchy";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    static {
        nameIdx.put("name", new Integer(0));
        nameIdx.put("BLElementType", new Integer(1));
        nameIdx.put("Description", new Integer(2));
        nameIdx.put("Dimensions", new Integer(3));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(3);
        grpItems.add("Description");
        grpItems.add("Prompt");
        grpItems.add("DisplayName");
        grpDesc.put(grpName, grpItems);
    }
}

