/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.HierarchyContainer;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.impl.BLContainerImpl;
import jet.universe.businesslogic.impl.BLNodeImpl;

public class HierarchyContainerImpl
extends BLContainerImpl
implements HierarchyContainer {
    public HierarchyContainerImpl() {
        this.setElementType(15);
    }

    @Override
    public HierarchyInfo[] getAllHierarchies() {
        BLNode[] children = this.getBLChildren();
        int retLength = children.length;
        HierarchyInfo[] ret = new HierarchyInfo[retLength];
        for (int i = 0; i < retLength; ++i) {
            ret[i] = (HierarchyInfo)children[i];
        }
        return ret;
    }

    @Override
    public void addHierarchy(HierarchyInfo hierarchy) throws BLDupleNameException {
        this.addChild(hierarchy);
    }

    @Override
    public HierarchyInfo removeHierarchy(String hierarchyName) {
        HierarchyInfo ret = (HierarchyInfo)this.removeChildByName(hierarchyName);
        return ret;
    }

    @Override
    public HierarchyInfo getHierarchy(String hierarchyName) {
        HierarchyInfo ret = (HierarchyInfo)this.getChildByName(hierarchyName);
        return ret;
    }

    @Override
    public HierarchyInfo[] getHierarchies(String dimension) {
        HierarchyInfo[] tmp = this.getAllHierarchies();
        HierarchyInfo[] tmpRet = new HierarchyInfo[tmp.length];
        int count = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (!tmp[i].containsDimension(dimension)) continue;
            tmpRet[count] = tmp[i];
            ++count;
        }
        HierarchyInfo[] ret = new HierarchyInfo[count];
        System.arraycopy(tmpRet, 0, ret, 0, count);
        return ret;
    }

    @Override
    public boolean isSimilar(BLNode node) {
        if (!super.isSimilar(node)) {
            return false;
        }
        HierarchyContainer hc = (HierarchyContainer)node;
        BLNode[] hc1 = this.getAllHierarchies();
        BLNode[] hc2 = hc.getAllHierarchies();
        return BLNodeImpl.isSimilar(hc1, hc2);
    }

    @Override
    public String getInstancePrefix() {
        return "HierarchyContainerImpl";
    }
}

