/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.universe.JetUFormula;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.impl.DataElement;
import jet.util.HashVector;

public class Measure
extends DataElement
implements MeasureInfo,
JetContainable {
    private JetBoolean isCustomized = new JetBoolean(this, "IsCustomized", false);
    JetString theFunction;
    private static final HashMap nameIdx = new HashMap(7);
    private static final HashVector grpDesc;
    private Vector theChildren;

    public Measure() {
        this.dataMappingFile.setEnableAutoValue(false);
        this.theChildren = new Vector();
        this.setElementType(5);
        this.theFunction = new JetString(this, "AggregationFunction");
    }

    @Override
    public MeasureInfo copy() {
        Measure ret = new Measure();
        Measure.copyProperties(ret, this);
        if (this.isCustomized()) {
            JetUFormula formula2 = new JetUFormula();
            JetObject.copyProperties(formula2, this.getJetUFormula());
            formula2.setResourceName(this.getJetUFormula().getResourceName());
            ret.theChildren.add(formula2);
        }
        return ret;
    }

    @Override
    public void setAggFunction(String function) {
        this.theFunction.set(function);
    }

    @Override
    public String getAggFunction() {
        String ret = this.theFunction.get();
        return ret;
    }

    @Override
    public String getInstancePrefix() {
        return "Measure";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public boolean isCustomized() {
        return this.isCustomized.get() && this.theChildren.size() > 0;
    }

    @Override
    public void setCustomized(boolean isCustomized) {
        if (this.isCustomized() && isCustomized) {
            return;
        }
        this.isCustomized.set(isCustomized);
        this.theChildren.clear();
        if (isCustomized) {
            JetUFormula formula2 = new JetUFormula();
            formula2.setResourceName(this.getMappingName());
            this.theChildren.add(formula2);
            formula2.setParent(this);
            this.setRefMappingName("");
        }
    }

    @Override
    public JetUFormula getJetUFormula() {
        if (!this.isCustomized() || this.theChildren.size() == 0) {
            return null;
        }
        return (JetUFormula)this.theChildren.get(0);
    }

    @Override
    public void setDisplayName(String displayName) throws BLDupleNameException, BLIlegalNameException {
        super.setDisplayName(displayName);
        if (this.isCustomized()) {
            this.getJetUFormula().setResourceName(this.getMappingName());
        }
    }

    @Override
    public String getMappingName() {
        return "\u007fCM_" + this.getUbv().getDisplayName() + '.' + this.getQualifyDisplayName();
    }

    @Override
    public JetObject add(JetObject child) {
        child.setParent(this);
        this.theChildren.add(child);
        return child;
    }

    @Override
    public Vector getChildren() {
        return this.theChildren;
    }

    @Override
    public JetObject remove(JetObject child) {
        if (child == null) {
            return null;
        }
        boolean ret = this.theChildren.remove(child);
        return child;
    }

    @Override
    public void broadcast(JetObject sender, int iMessage) {
        if (sender == null) {
            return;
        }
    }

    static {
        nameIdx.put("name", new Integer(0));
        nameIdx.put("AggregationFunction", new Integer(1));
        nameIdx.put("BLElementType", new Integer(2));
        nameIdx.put("Description", new Integer(3));
        nameIdx.put("DisplayName", new Integer(4));
        nameIdx.put("Prompt", new Integer(5));
        nameIdx.put("RefMappingName", new Integer(6));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(7);
        grpItems.add("name");
        grpItems.add("AggregationFunction");
        grpItems.add("BLElementType");
        grpItems.add("Description");
        grpItems.add("Prompt");
        grpItems.add("RefMappingName");
        grpItems.add("DisplayName");
        grpDesc.put(grpName, grpItems);
    }
}

