/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.impl;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.UUID;
import java.util.Vector;
import jet.Env;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetBytes;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.api.DSException;
import jet.dataengine.api.config.JavaFormulaConfigImpl;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.DataTypeDef;
import jet.formula.FormulaCompiler;
import jet.formula.FormulaCompilerListener;
import jet.formula.FormulaContainer;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.formula.ParserOption;
import jet.formula.SymbolInfo;
import jet.formula.VarsTable;
import jet.formula.application.cm.Dimension;
import jet.formula.application.cm.ICubeNamespace;
import jet.formula.syntaxtree.Symbol;
import jet.log.JRLogger;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.UMapTable;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNoSuchElementException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DTInformation;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.GroupInfo;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.impl.Aggregation;
import jet.universe.businesslogic.impl.BCFilter;
import jet.universe.businesslogic.impl.BLNodeImpl;
import jet.universe.businesslogic.impl.BusinessView;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.Detail;
import jet.universe.businesslogic.impl.Group;
import jet.universe.businesslogic.impl.Hierarchy;
import jet.universe.businesslogic.impl.HierarchyContainerImpl;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.businesslogic.impl.Prefilter;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.InvalidEntityException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.tools.ParseParametersForQueryFactory;
import jet.util.HashVector;

public class UnifiedBusinessView
extends Category
implements JUnifiedBusinessView,
FormulaContainer,
FormulaCompilerListener {
    private static JRLogger logger = JRLogger.getLogger(BusinessView.class.getName());
    public JetString javaFormulaName = new JetString(this, "JavaFormulaName");
    public JetBytes javaFormulaBytes = new JetBytes(this, "JavaFormulaBytes");
    public JetBoolean prefetch = new JetBoolean(this, "Prefetch", true);
    private static final HashMap nameIdx = new HashMap(3);
    private static final HashVector grpDesc;
    static final String strBVFormulasClassNameBase = "BVF";
    private transient VarsTable gVarTable = new VarsTable();
    private ParserOption parserOption = new ParserOption();
    Hashtable globalVarContainer = new Hashtable();

    public UnifiedBusinessView() {
        this.setElementType(18);
    }

    public UnifiedBusinessView(String displayName, JetUUniverse unv, String datasourceName) throws BLDupleNameException, BLIlegalNameException {
        this.setDisplayName(displayName);
        this.setElementType(18);
        RptPsqlQuery sqlQuery = new RptPsqlQuery();
        sqlQuery.setMappingName("");
        sqlQuery.setUniverse(unv, datasourceName);
        JetUDemandQuery selfContainedQuery = new JetUDemandQuery("\u007fUBV~" + displayName, sqlQuery.getCopy());
        this.add(selfContainedQuery);
        selfContainedQuery.setParent(this);
    }

    @Override
    public BLNode getByDisplayName(String qualifyDisplayName) {
        if (qualifyDisplayName == null) {
            return null;
        }
        String[] names = qualifyDisplayName.split("\\x2E");
        BLNode node = this;
        UnifiedBusinessView ret = null;
        int position = 0;
        for (int i = 0; i < names.length; ++i) {
            if (node instanceof BLContainer) {
                node = ((BLContainer)node).getChildByDisplayName(names[i]);
            } else {
                if (!(node instanceof Group)) break;
                Vector c = ((Group)node).getChildren();
                for (Object o : c) {
                    if (!(o instanceof BLNode) || !((BLNode)o).getDisplayName().equalsIgnoreCase(names[i])) continue;
                    node = (BLNode)o;
                    break;
                }
            }
            ++position;
        }
        ret = position == names.length ? node : null;
        return ret;
    }

    public boolean isUsedHierarchyName(String tmpName) {
        HierarchyInfo[] his = this.getAllHierarchies();
        for (int i = 0; i < his.length; ++i) {
            HierarchyInfo hi = his[i];
            if (!hi.getName().equalsIgnoreCase(tmpName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsedHierarchyDisplayName(String displayName) {
        HierarchyInfo[] his = this.getAllHierarchies();
        for (int i = 0; i < his.length; ++i) {
            HierarchyInfo hi = his[i];
            if (!hi.getDisplayName().equalsIgnoreCase(displayName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BLContainer getBLParent() {
        return null;
    }

    @Override
    public JetUDemandQuery getQuery() {
        Vector children = this.getChildren();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUDemandQuery)) continue;
            return (JetUDemandQuery)child;
        }
        return null;
    }

    @Override
    public String toString() {
        return "UnifiedBusinessView: " + this.getQualifyDisplayName();
    }

    @Override
    public boolean isSimilar(BLNode node) {
        return super.isSimilar(node);
    }

    @Override
    public UnifiedBusinessView copy() {
        UnifiedBusinessView bl = (UnifiedBusinessView)this.deepDup();
        JetUDemandQuery query = bl.getQuery();
        query.rebuildMapTable();
        return bl;
    }

    @Override
    public String getInstancePrefix() {
        return "UnifiedBusinessView";
    }

    @Override
    public FilterInfo[] getPrefilterInfo() {
        BLNode[] tmp = this.getBLChildren();
        FilterInfo[] retTmp = new FilterInfo[tmp.length];
        int size = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].getElementType() != 17) continue;
            retTmp[size] = (FilterInfo)tmp[i];
            ++size;
        }
        FilterInfo[] ret = new FilterInfo[size];
        System.arraycopy(retTmp, 0, ret, 0, size);
        return ret;
    }

    @Override
    public FilterInfo addPrefilter(FilterInfo preFilter) throws BLDupleNameException {
        this.addChild(preFilter);
        return preFilter;
    }

    public void initAfterLoad() {
        Vector v = this.getChildren();
        for (BLNode node : v) {
            if (node.getElementType() != 15) continue;
            HierarchyContainerImpl hierarchyContainer = (HierarchyContainerImpl)node;
            HierarchyInfo[] hs = hierarchyContainer.getAllHierarchies();
            BLNode[] blChildren = this.getBLChildren();
            for (int i = 0; i < hs.length; ++i) {
                boolean alreadyAdd = false;
                for (int j = 0; j < blChildren.length; ++j) {
                    if (!(blChildren[j] instanceof HierarchyInfo) || !blChildren[j].getName().equalsIgnoreCase(hs[i].getName())) continue;
                    alreadyAdd = true;
                }
                if (alreadyAdd) continue;
                this.add((Hierarchy)hs[i]);
            }
            this.remove(hierarchyContainer);
            break;
        }
        if ("".equals(this.getDisplayName())) {
            try {
                this.setDisplayName(this.getName());
            }
            catch (BLDupleNameException e) {
            }
            catch (BLIlegalNameException bLIlegalNameException) {
                // empty catch block
            }
        }
    }

    @Override
    public MemberSecurityEntry getMemberSecurityEntry() {
        Vector children = this.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Object child = children.get(i);
            if (!(child instanceof MemberSecurityEntry)) continue;
            return (MemberSecurityEntry)child;
        }
        MemberSecurityEntry ret = new MemberSecurityEntry();
        this.setMemberSecurityEntry(ret);
        return ret;
    }

    @Override
    public void setMemberSecurityEntry(MemberSecurityEntry se) {
        if (se == null) {
            return;
        }
        Vector children = this.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            Object child = children.get(i);
            if (!(child instanceof MemberSecurityEntry)) continue;
            children.remove(i);
        }
        this.add(se);
    }

    @Override
    public DimensionInfo getDimension(String DimensionRefMappingName) {
        DimensionInfo[] ds = this.getAllDimensions();
        for (int i = 0; i < ds.length; ++i) {
            if (!ds[i].getRefMappingName().equalsIgnoreCase(DimensionRefMappingName)) continue;
            return ds[i];
        }
        return null;
    }

    @Override
    public JetUDatabase getDatabase() {
        JetObject ret = this;
        while (!(ret instanceof JetUDatabase)) {
            if ((ret = (JetObject)((Object)ret.getParent())) != null) continue;
            return null;
        }
        return (JetUDatabase)ret;
    }

    @Override
    public boolean isValid() {
        return this.getAllDimensions().length > 0;
    }

    public String[] getBvRefParameter() {
        DetailInformation[] details;
        MeasureInfo[] aggs;
        DimensionInfo[] gs;
        HashSet<String> retSet = new HashSet<String>();
        ArrayList<String> mappingNames = new ArrayList<String>();
        for (DimensionInfo groupInfo : gs = this.getAllDimensions()) {
            mappingNames.add(groupInfo.getRefMappingName());
        }
        for (MeasureInfo aggregationInfo : aggs = this.getAllMeasures()) {
            mappingNames.add(aggregationInfo.getRefMappingName());
        }
        for (DetailInformation detail : details = this.getAllDetailInfos()) {
            mappingNames.add(detail.getRefMappingName());
        }
        JetUDatabase db = this.getDatabase();
        for (String mappingName : mappingNames) {
            JetUResourceEntity entity = db.getResourceByName(null, mappingName);
            if (!(entity instanceof JetUFormula)) continue;
            Vector ps = ((JetUFormula)entity).getRefParamFld();
            for (String bvReferParameter : ps) {
                retSet.add(bvReferParameter);
            }
        }
        String[] ret = new String[retSet.size()];
        retSet.toArray(ret);
        return ret;
    }

    @Override
    public String[] getBvAndQueryRefParameter() throws DSException {
        JetUDemandQuery query = this.getQuery();
        JetUDatabase udb = this.getDatabase();
        JetUUniverse unv = (JetUUniverse)udb.getParent();
        String[] ps = ParseParametersForQueryFactory.CreateParseParametersForQuery(unv, udb.getResourceName(), query.getResourceName()).getParameterNamesInQuery();
        String[] bvPara = this.getBvRefParameter();
        HashSet<String> retSet = new HashSet<String>();
        for (String string : ps) {
            retSet.add(string);
        }
        for (String string : bvPara) {
            retSet.add(string);
        }
        String[] ret = new String[retSet.size()];
        retSet.toArray(ret);
        return ret;
    }

    @Override
    public BLNode getNewNode(int type) {
        BLNodeImpl ret = null;
        switch (type) {
            case 3: {
                ret = new Category();
                break;
            }
            case 4: {
                ret = new Group();
                break;
            }
            case 5: {
                ret = new Aggregation();
                break;
            }
            case 7: {
                ret = new Detail();
                break;
            }
            case 16: {
                ret = new BCFilter();
                break;
            }
            case 17: {
                ret = new Prefilter();
                break;
            }
            case 9: {
                ret = new Hierarchy();
                break;
            }
        }
        return ret;
    }

    @Override
    public BLNode getNewNode(BLContainer base, int type) {
        BLNode ret = this.getNewNode(type);
        if (ret == null) {
            return null;
        }
        String name2 = null;
        switch (ret.getElementType()) {
            case 3: {
                CategoryInfo cfr_ignored_0 = (CategoryInfo)ret;
                name2 = "Category";
                break;
            }
            case 4: {
                GroupInfo cfr_ignored_1 = (GroupInfo)ret;
                name2 = "Group";
                break;
            }
            case 5: {
                AggregationInfo cfr_ignored_2 = (AggregationInfo)ret;
                name2 = "Aggregation";
                break;
            }
            case 7: {
                DTInformation cfr_ignored_3 = (DTInformation)ret;
                name2 = "Detail";
                break;
            }
            case 16: 
            case 17: {
                FilterInfo cfr_ignored_4 = (FilterInfo)ret;
                name2 = "Filter";
                break;
            }
            case 9: {
                HierarchyInfo cfr_ignored_5 = (HierarchyInfo)ret;
                name2 = "Hierarchy";
                break;
            }
            default: {
                return null;
            }
        }
        int sufix = 1;
        String tmpName = name2 + sufix;
        if (ret.getElementType() == 9) {
            while (this.isUsedHierarchyDisplayName(tmpName)) {
                tmpName = name2 + ++sufix;
            }
        } else {
            while (base.isUsedDisplayName(tmpName)) {
                tmpName = name2 + ++sufix;
            }
        }
        name2 = tmpName;
        try {
            ret.setDisplayName(name2);
        }
        catch (BLDupleNameException e) {
        }
        catch (BLIlegalNameException e) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public String[] getAllAvailableNodes() {
        int i;
        JetUDemandQuery jQuery = this.getQuery();
        JetUDatabase jDatabase = jQuery.getDatabase();
        String queryName = jQuery.getResourceName();
        CategoryInfo[] categoryInfos = this.getCategories();
        GroupInfo[] groups = this.getGroups();
        DTInformation[] details = this.getDetails();
        AggregationInfo[] aggs = this.getAggregations();
        Vector<String> vAvailableNodes = new Vector<String>();
        if (categoryInfos != null && categoryInfos.length > 0) {
            for (i = 0; i < categoryInfos.length; ++i) {
                this.getCategoryInfoNodeMappingNames(categoryInfos[i], vAvailableNodes);
            }
        }
        if (groups != null && groups.length > 0) {
            for (i = 0; i < groups.length; ++i) {
                vAvailableNodes.add(groups[i].getRefMappingName());
            }
        }
        if (details != null && details.length > 0) {
            for (i = 0; i < details.length; ++i) {
                vAvailableNodes.add(details[i].getRefMappingName());
            }
        }
        if (aggs != null && aggs.length > 0) {
            for (i = 0; i < aggs.length; ++i) {
                vAvailableNodes.add(aggs[i].getRefMappingName());
            }
        }
        Vector<String> resultMappings = new Vector<String>();
        for (String mappingNameStr : vAvailableNodes) {
            boolean vaildResult;
            block13: {
                Vector<String> vMappingName = new Vector<String>();
                vMappingName.add(mappingNameStr);
                vaildResult = false;
                try {
                    vaildResult = jDatabase.checkIfMappingFldsValidToQuery(queryName, vMappingName);
                }
                catch (InvalidEntityException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error("", e);
                    }
                }
                catch (CannotFindQuery e) {
                    if (!logger.isErrorEnabled()) break block13;
                    logger.error("", e);
                }
            }
            if (!vaildResult || resultMappings.contains(mappingNameStr)) continue;
            resultMappings.add(mappingNameStr);
        }
        String[] mappingNames = new String[resultMappings.size()];
        resultMappings.toArray(mappingNames);
        return mappingNames;
    }

    private void getCategoryInfoNodeMappingNames(CategoryInfo categoryInfo, Vector<String> vMappingName) {
        int i;
        if (categoryInfo == null) {
            return;
        }
        CategoryInfo[] catInfos = categoryInfo.getCategories();
        if (catInfos != null) {
            for (int i2 = 0; i2 < catInfos.length; ++i2) {
                this.getCategoryInfoNodeMappingNames(catInfos[i2], vMappingName);
            }
        }
        GroupInfo[] grps = categoryInfo.getGroups();
        DTInformation[] details = categoryInfo.getDetails();
        AggregationInfo[] aggs = categoryInfo.getAggregations();
        if (grps != null) {
            for (i = 0; i < grps.length; ++i) {
                vMappingName.add(grps[i].getRefMappingName());
            }
        }
        if (details != null) {
            for (i = 0; i < details.length; ++i) {
                vMappingName.add(details[i].getRefMappingName());
            }
        }
        if (aggs != null) {
            for (i = 0; i < aggs.length; ++i) {
                vMappingName.add(aggs[i].getRefMappingName());
            }
        }
    }

    @Override
    public boolean isPrefetch() {
        return this.prefetch.get();
    }

    @Override
    public BLNode addNode(String base, BLNode info) throws BLDupleNameException, BLNoSuchElementException {
        return null;
    }

    @Override
    public JetUResourceEntity getResourceEntity(String mappingName) {
        JetUResourceEntity ret = this.getQuery().getResourceByName(mappingName);
        if (ret == null) {
            ret = this.getDatabase().getResourceByName(mappingName);
        }
        return ret;
    }

    @Override
    public BLNode getBlNodeByMappingName(String mappingName, int ... blnodeTypes) {
        block5: for (int i = 0; i < blnodeTypes.length; ++i) {
            switch (blnodeTypes[i]) {
                case 4: {
                    GroupInfo[] groups = this.getAllGroups();
                    for (int j = 0; j < groups.length; ++j) {
                        if (!groups[j].getRefMappingName().equalsIgnoreCase(mappingName)) continue;
                        return groups[j];
                    }
                    continue block5;
                }
                case 5: {
                    AggregationInfo[] aggs = this.getAllAggregations();
                    for (int j = 0; j < aggs.length; ++j) {
                        if (!aggs[j].getRefMappingName().equalsIgnoreCase(mappingName)) continue;
                        return aggs[j];
                    }
                    continue block5;
                }
                case 7: {
                    DTInformation[] details = this.getDetails();
                    for (int j = 0; j < details.length; ++j) {
                        if (!details[j].getRefMappingName().equalsIgnoreCase(mappingName)) continue;
                        return details[j];
                    }
                    continue block5;
                }
            }
        }
        return null;
    }

    @Override
    public AggregationInfo getAgginfo(String mappingName, String function) {
        AggregationInfo[] aggs = this.getAllAggregations();
        for (int j = 0; j < aggs.length; ++j) {
            if (!aggs[j].getRefMappingName().equalsIgnoreCase(mappingName) || !aggs[j].getAggFunction().equalsIgnoreCase(function)) continue;
            return aggs[j];
        }
        return null;
    }

    @Override
    public void setDisplayName(String displayName) throws BLDupleNameException, BLIlegalNameException {
        if (this.getDatabase() != null) {
            if (this.getDatabase().getBusinessView(displayName) != null) {
                throw new BLDupleNameException(displayName);
            }
            this.getDatabase().renameBusinessView(displayName, this);
        }
        super.setDisplayName(displayName);
        JetUDemandQuery selfContainQuery = this.getQuery();
        if (selfContainQuery != null) {
            selfContainQuery.setResourceName("\u007fUBV~" + displayName);
        }
    }

    public synchronized JavaFormula loadJavaFormula() throws LoadJavaFormulaException, IOException {
        if ("".equals(this.javaFormulaName.get()) || this.javaFormulaBytes.get().length == 0) {
            if (this.getRptFormulas().size() == 0) {
                return null;
            }
            this.generJavaFormula();
        }
        try {
            DynamicClassManager dc = DynamicClassManager.getInstance();
            Class theClass = dc.bytesToClass(this.javaFormulaName.get(), this.javaFormulaBytes.get());
            return (JavaFormula)theClass.newInstance();
        }
        catch (NoClassDefFoundError e) {
            if (logger.isErrorEnabled()) {
                logger.error(this, e);
            }
            LoadJavaFormulaException lfe = new LoadJavaFormulaException(1);
            lfe.initCause(e);
            throw lfe;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(this, e);
            }
            LoadJavaFormulaException lfe = new LoadJavaFormulaException(1);
            lfe.initCause(e);
            throw lfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generJavaFormula() throws LoadJavaFormulaException, IOException {
        this.maintainMapTable4CM();
        this.beforeParseFormulas();
        Vector<JetRptFormula> formulas = this.getRptFormulas();
        if (formulas.size() == 0) {
            return;
        }
        String className = strBVFormulasClassNameBase + UUID.randomUUID().toString().replace("-", "").toUpperCase();
        FormulaCompiler fc = new FormulaCompiler(this, new JavaFormulaConfigImpl(this.getDatabase().getUniverse().getResourceStore()));
        try {
            fc.compileFormulas(formulas, className, this);
        }
        catch (GenerateFormulasCodeException e) {
            Vector<GenerateFormulasCodeException> v = new Vector<GenerateFormulasCodeException>();
            v.add(e);
            ParseFormulaFailedException pffe = new ParseFormulaFailedException(v);
        }
        finally {
            this.afterParseFormulas();
        }
        this.javaFormulaName.set("jet.formula.javaformula." + className);
        String strDir = Env.getTemporaryPath();
        String string = strDir = strDir == null ? "" : strDir;
        if (!strDir.endsWith(File.separator)) {
            strDir = strDir + File.separator;
        }
        String classFileName = strDir + className + ".class";
        FileInputStream fi = new FileInputStream(classFileName);
        byte[] classcode = new byte[fi.available()];
        fi.read(classcode);
        fi.close();
        File classFile = new File(classFileName);
        classFile.delete();
        String javaFileName = strDir + className + ".java";
        File javaFile = new File(javaFileName);
        javaFile.delete();
        this.javaFormulaBytes.set(classcode);
    }

    private void beforeParseFormulas() {
        this.gVarTable.clear();
        MeasureInfo[] ms = this.getAllMeasures();
        for (int i = 0; i < ms.length; ++i) {
            if (!ms[i].isCustomized()) continue;
            ms[i].getJetUFormula().createRptFormula();
        }
    }

    private Vector<JetRptFormula> getRptFormulas() {
        Vector<JetRptFormula> ret = new Vector<JetRptFormula>();
        MeasureInfo[] ms = this.getAllMeasures();
        for (int i = 0; i < ms.length; ++i) {
            if (!ms[i].isCustomized()) continue;
            ret.add(ms[i].getJetUFormula().getRptFormula());
        }
        return ret;
    }

    private void maintainMapTable4CM() {
        UMapTable queryMapTable = this.getQuery().getMapTable();
        MeasureInfo[] ms = this.getAllMeasures();
        for (int i = 0; i < ms.length; ++i) {
            if (!ms[i].isCustomized()) continue;
            queryMapTable.addElement(ms[i].getJetUFormula());
        }
    }

    private void afterParseFormulas() {
        MeasureInfo[] ms = this.getAllMeasures();
        for (int i = 0; i < ms.length; ++i) {
            if (!ms[i].isCustomized()) continue;
            ms[i].getJetUFormula().HandleRptFormula();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFormulas(String formulaContent) throws FormulaRingException, ParseFormulaFailedException {
        this.beforeParseFormulas();
        Vector<JetRptFormula> formulas = this.getRptFormulas();
        JetUFormula temp = new JetUFormula("", "", formulaContent);
        temp.createRptFormula();
        JetRptFormula rptformula = temp.getRptFormula();
        rptformula.setDataSource(this);
        formulas.add(rptformula);
        FormulaCompiler fc = new FormulaCompiler(this, new JavaFormulaConfigImpl(this.getDatabase().getUniverse().getResourceStore()));
        try {
            fc.checkFormulas(formulas);
        }
        finally {
            this.afterParseFormulas();
        }
    }

    @Override
    public VarsTable getGVarTable() {
        return this.gVarTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFormulas(boolean bReparse) throws FormulaRingException, ParseFormulaFailedException {
        this.maintainMapTable4CM();
        this.beforeParseFormulas();
        Vector<JetRptFormula> formulas = this.getRptFormulas();
        if (formulas.size() == 0) {
            return;
        }
        FormulaCompiler fc = new FormulaCompiler(this, new JavaFormulaConfigImpl(this.getDatabase().getUniverse().getResourceStore()));
        try {
            fc.checkFormulas(formulas);
        }
        finally {
            this.afterParseFormulas();
        }
    }

    @Override
    public JetRptFormula getFormula(String qualifyDisplayName) {
        BLNode node = this.getByDisplayName(qualifyDisplayName);
        if (node instanceof DataElement && !(node instanceof Measure)) {
            DataElement dNode = (DataElement)node;
            String mappingName = dNode.getRefMappingName();
            JetUResourceEntity entity = this.getDatabase().getResourceByName(mappingName);
            if (entity instanceof JetUFormula) {
                JetUFormula f = (JetUFormula)entity;
                return f.getRptFormula();
            }
        }
        return null;
    }

    @Override
    public SymbolInfo getParameterType(String paramname) {
        return this.getDatabase().getParameterType(paramname);
    }

    @Override
    public SymbolInfo getMeasure(String measureQualifyDisplayName) {
        BLNode node = this.getByDisplayName(measureQualifyDisplayName);
        if (node instanceof Measure) {
            Measure measure = (Measure)node;
            if (measure.isCustomized()) {
                JetUFormula f = measure.getJetUFormula();
                return f.getFormulaInfo().getSymbolInfo();
            }
            String refMappingName = ((MeasureInfo)node).getRefMappingName();
            JetRptFormula f = this.getFormula(refMappingName);
            int datatype = 0;
            boolean isRunningTotal = false;
            MeasureInfo m = (MeasureInfo)node;
            int funcCode = jet.formula.Aggregation.getFunctionCode(m.getAggFunction());
            if (jet.formula.Aggregation.isRunningTotal(funcCode)) {
                isRunningTotal = true;
            }
            boolean isSum = true;
            if (f != null) {
                datatype = DataTypeDef.SqlToFml(f.getColDesc().getSqlType(), false);
            } else {
                int baseSqlType = this.getDatabase().getResourceByName(measure.getRefMappingName()).getColDesc().getSqlType();
                int sqlType = Types.getFuncSqlType(measure.getAggFunction(), baseSqlType);
                datatype = DataTypeDef.SqlToFml(sqlType, false);
            }
            String mappingName = measure.getMappingName();
            SymbolInfo sb = new SymbolInfo(mappingName, null, datatype, -1, 6, -1, isSum);
            sb.setIsRunningTotal(isRunningTotal);
            if (JRLog.isTrace(7)) {
                // empty if block
            }
            return sb;
        }
        return null;
    }

    @Override
    public DbColDesc getDbSQLType(String qualifyDisplayName) {
        BLNode node = this.getByDisplayName(qualifyDisplayName);
        if (node.getElementType() == 4 || node.getElementType() == 7) {
            DataElement dNode = (DataElement)node;
            String mappingName = dNode.getRefMappingName();
            JetUResourceEntity jure = this.getDatabase().getResourceByName(mappingName);
            if (jure != null && jure instanceof JetUDBField) {
                DbColDesc ret = jure.getColDesc();
                ret.setColName(mappingName);
                return ret;
            }
        }
        return null;
    }

    @Override
    public ParserOption getParserOption() {
        this.parserOption.setSupportGlobal(true);
        this.parserOption.setFormulaType(1);
        this.parserOption.setCubeNamespace(new ICubeNamespace(){

            public boolean isCoordinateValid(Vector<Dimension> coordinates, Vector errorMsg) {
                block4: for (int i = 0; i < coordinates.size(); ++i) {
                    Dimension dimension = coordinates.get(i);
                    switch (dimension.getDimensionType()) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            continue block4;
                        }
                        case 5: {
                            BLNode bvElement = UnifiedBusinessView.this.getByDisplayName(dimension.expName());
                            if (bvElement != null && bvElement.getElementType() == 4) continue block4;
                            return false;
                        }
                    }
                }
                return true;
            }

            @Override
            public boolean isValidField(String qualifyDisplayName) {
                return UnifiedBusinessView.this.getByDisplayName(qualifyDisplayName) != null;
            }
        });
        return this.parserOption;
    }

    @Override
    public Hashtable<String, Symbol> getGlobalVarContainer() {
        return this.globalVarContainer;
    }

    @Override
    public void translateComplete(Vector arg0) {
        for (int i = 0; i < arg0.size(); ++i) {
            logger.error(arg0.elementAt(i));
        }
    }

    static {
        nameIdx.put("BLElementType", new Integer(0));
        nameIdx.put("Description", new Integer(1));
        nameIdx.put("DisplayName", new Integer(2));
        nameIdx.put("Prefetch", new Integer(3));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(3);
        grpItems.add("BLElementType");
        grpItems.add("Description");
        grpItems.add("DisplayName");
        grpItems.add("Prefetch");
        grpDesc.put(grpName, grpItems);
    }
}

