/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import java.util.Iterator;

public class Combination
implements Iterator {
    private int[] lastResultIndex;
    private int[] previousResultIndex;
    private Object[] elements;
    private int subElemNum;
    private boolean returnNextFlag = false;

    public Combination(int elementsNum, int subElemNum) {
        int i;
        Combination.checkArguments(elementsNum, subElemNum);
        this.subElemNum = subElemNum;
        this.elements = new String[elementsNum];
        this.lastResultIndex = new int[subElemNum];
        this.previousResultIndex = new int[this.subElemNum];
        for (i = 0; i < this.subElemNum; ++i) {
            this.previousResultIndex[i] = i;
        }
        if (subElemNum > 0) {
            int n = this.previousResultIndex.length - 1;
            this.previousResultIndex[n] = this.previousResultIndex[n] - 1;
        }
        for (i = 0; i < elementsNum; ++i) {
            this.elements[i] = String.valueOf(i + 1);
        }
        i = elementsNum - subElemNum;
        int j = 0;
        while (i < elementsNum) {
            this.lastResultIndex[j] = i++;
            ++j;
        }
    }

    public Combination(Object[] elements, int subElemNum) {
        int i;
        Combination.checkArguments(subElemNum);
        this.subElemNum = subElemNum;
        this.elements = elements;
        this.lastResultIndex = new int[subElemNum];
        this.previousResultIndex = new int[this.subElemNum];
        for (i = 0; i < this.subElemNum; ++i) {
            this.previousResultIndex[i] = i;
        }
        if (subElemNum > 0) {
            int n = this.previousResultIndex.length - 1;
            this.previousResultIndex[n] = this.previousResultIndex[n] - 1;
        }
        i = elements.length - subElemNum;
        int j = 0;
        while (i < elements.length) {
            this.lastResultIndex[j] = i++;
            ++j;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.elements.length < this.subElemNum) {
            return false;
        }
        if (this.subElemNum == 0) {
            return !this.returnNextFlag;
        }
        for (int i = 0; i < this.lastResultIndex.length; ++i) {
            if (this.previousResultIndex[i] >= this.lastResultIndex[i]) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        String[] tem = new String[this.previousResultIndex.length];
        if (this.subElemNum == 0) {
            if (!this.returnNextFlag) {
                this.returnNextFlag = true;
                return tem;
            }
            return null;
        }
        if (!this.hasNext()) {
            return null;
        }
        int i = this.subElemNum - 1;
        int j = 0;
        while (i >= 0) {
            if (this.previousResultIndex[i] <= this.elements.length - 2 - j) {
                int n = i;
                this.previousResultIndex[n] = this.previousResultIndex[n] + 1;
                for (int n2 = i; n2 < this.subElemNum - 1; ++n2) {
                    this.previousResultIndex[n2 + 1] = this.previousResultIndex[n2] + 1;
                }
                break;
            }
            --i;
            ++j;
        }
        for (i = 0; i < tem.length; ++i) {
            tem[i] = this.elements[this.previousResultIndex[i]];
        }
        return tem;
    }

    public int[] nextIndex() {
        int[] indexArray = new int[this.previousResultIndex.length];
        if (this.subElemNum == 0) {
            if (!this.returnNextFlag) {
                this.returnNextFlag = true;
                return indexArray;
            }
            return null;
        }
        if (!this.hasNext()) {
            return null;
        }
        int i = this.subElemNum - 1;
        int j = 0;
        while (i >= 0) {
            if (this.previousResultIndex[i] <= this.elements.length - 2 - j) {
                int n = i;
                this.previousResultIndex[n] = this.previousResultIndex[n] + 1;
                for (int n2 = i; n2 < this.subElemNum - 1; ++n2) {
                    this.previousResultIndex[n2 + 1] = this.previousResultIndex[n2] + 1;
                }
                break;
            }
            --i;
            ++j;
        }
        for (i = 0; i < indexArray.length; ++i) {
            indexArray[i] = this.previousResultIndex[i];
        }
        return indexArray;
    }

    @Override
    public void remove() {
    }

    public static int calculateCombNum(int elementsNum, int subElemNum) {
        Combination.checkArguments(elementsNum, subElemNum);
        if (elementsNum == subElemNum) {
            return 1;
        }
        if (elementsNum < subElemNum) {
            return 0;
        }
        int num = 1;
        for (int i = 0; i < subElemNum; ++i) {
            num = num * (elementsNum - i) / (i + 1);
        }
        return num;
    }

    public int getCombinationCount() {
        return Combination.calculateCombNum(this.elements.length, this.subElemNum);
    }

    private static void checkArguments(int elementsNum, int subElemNum) {
        if (elementsNum < 0 || subElemNum < 0) {
            throw new IllegalArgumentException("(elementsNum < 0) or (subElemNum < 0)");
        }
    }

    private static void checkArguments(int subElemNum) {
        if (subElemNum < 0) {
            throw new IllegalArgumentException("subElemNum < 0");
        }
    }
}

