/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import java.util.ArrayList;
import jet.universe.businesslogic.joinpathtools.graph.Edge;
import jet.universe.businesslogic.joinpathtools.graph.Vertex;
import jet.universe.businesslogic.joinpathtools.graph.VertexList;

public class EdgeList
extends ArrayList {
    public String[][] toTwoDimensionArray() {
        int size = this.size();
        String[][] edges = new String[size][2];
        for (int i = 0; i < size; ++i) {
            Edge eTem = (Edge)this.get(i);
            edges[i][0] = eTem.startKey();
            edges[i][1] = eTem.endKey();
        }
        return edges;
    }

    @Override
    public boolean add(Edge edge) {
        return super.add(edge);
    }

    @Override
    public void add(int index, Edge edge) {
        super.add(index, edge);
    }

    public boolean addAll(EdgeList edgeList) {
        return super.addAll(edgeList);
    }

    public boolean addAll(int index, EdgeList edgeList) {
        return super.addAll(index, edgeList);
    }

    @Override
    public Edge set(int index, Edge edge) {
        return super.set(index, edge);
    }

    public boolean contains(Edge edge) {
        int size = this.size();
        Edge e = null;
        for (int i = 0; i < size; ++i) {
            e = (Edge)this.get(i);
            if (!edge.equals(e)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(Edge edge) {
        return super.indexOf(edge);
    }

    @Override
    public boolean equals(Object o) {
        int targetSize;
        if (o == null) {
            return false;
        }
        EdgeList target = (EdgeList)o;
        int thisSize = this.size();
        if (thisSize != (targetSize = target.size())) {
            return false;
        }
        for (int i = 0; i < thisSize; ++i) {
            Edge e = (Edge)target.get(i);
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public VertexList getUncontainsVertices(VertexList vertices) {
        VertexList uncontainsV = new VertexList();
        VertexList thisV = this.getVertices();
        int size = vertices.size();
        Vertex v = null;
        for (int i = 0; i < size; ++i) {
            v = (Vertex)vertices.get(i);
            if (thisV.contains(v)) continue;
            uncontainsV.add(v);
        }
        return uncontainsV;
    }

    public VertexList getVertices() {
        VertexList vertices = new VertexList();
        Edge e = null;
        Vertex v = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            e = (Edge)this.get(i);
            v = new Vertex(e.startKey());
            if (!vertices.contains(v)) {
                vertices.add(v);
            }
            if (vertices.contains(v = new Vertex(e.endKey()))) continue;
            vertices.add(v);
        }
        return vertices;
    }

    @Override
    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        int size = super.size();
        strBuf.append("[");
        for (int i = 0; i < size; ++i) {
            strBuf.append(((Edge)super.get(i)).getKey() + ", ");
        }
        strBuf.append("]");
        return strBuf.toString();
    }
}

