/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import jet.universe.businesslogic.joinpathtools.graph.Child;
import jet.universe.businesslogic.joinpathtools.graph.Combination;
import jet.universe.businesslogic.joinpathtools.graph.DSFRoot;
import jet.universe.businesslogic.joinpathtools.graph.Edge;
import jet.universe.businesslogic.joinpathtools.graph.EdgeHashMap;
import jet.universe.businesslogic.joinpathtools.graph.EdgeList;
import jet.universe.businesslogic.joinpathtools.graph.GraphElement;
import jet.universe.businesslogic.joinpathtools.graph.GraphLogicalException;
import jet.universe.businesslogic.joinpathtools.graph.NodeEdgeAdjacency;
import jet.universe.businesslogic.joinpathtools.graph.Path;
import jet.universe.businesslogic.joinpathtools.graph.PathList;
import jet.universe.businesslogic.joinpathtools.graph.TreeList;
import jet.universe.businesslogic.joinpathtools.graph.Vertex;
import jet.universe.businesslogic.joinpathtools.graph.VertexColor;
import jet.universe.businesslogic.joinpathtools.graph.VertexHashMap;
import jet.universe.businesslogic.joinpathtools.graph.VertexList;

public class Graph {
    VertexHashMap verList = new VertexHashMap();
    EdgeHashMap edgeList = new EdgeHashMap();
    private ArrayList dsfRoot = new ArrayList();
    private EdgeList eLoop = new EdgeList();
    private ArrayList loops = new ArrayList();
    private Hashtable loopVertex = new Hashtable();
    private Vertex vStart;
    private int time = 0;
    boolean runedDFSFlag = false;

    private boolean isVertexListContains(VertexHashMap vl, String vertexKey) {
        for (Vertex vSearch : vl.values()) {
            if (!vSearch.getKey().equals(vertexKey)) continue;
            return true;
        }
        return false;
    }

    public Graph getConnectedGraph(Path p) {
        String peerVertexKey;
        VertexHashMap vlResult = new VertexHashMap();
        EdgeHashMap elResult = new EdgeHashMap();
        VertexList vOfPath = p.getVertexList();
        for (Vertex v : vOfPath) {
            v = (Vertex)this.verList.get(v.getKey());
            vlResult.add(v);
        }
        Stack<GraphElement> vertexesTBP = new Stack<GraphElement>();
        for (Vertex v : vlResult.values()) {
            for (NodeEdgeAdjacency adjEdge : v.adjEdges.values()) {
                peerVertexKey = adjEdge.getVertexKey();
                if (this.isVertexListContains(vlResult, peerVertexKey)) continue;
                vertexesTBP.push(this.verList.get(peerVertexKey));
            }
        }
        while (!vertexesTBP.isEmpty()) {
            Vertex v;
            v = (Vertex)vertexesTBP.pop();
            for (NodeEdgeAdjacency nea : v.adjEdges.values()) {
                if (this.isVertexListContains(vlResult, nea.getVertexKey())) continue;
                Vertex vUnSolved = (Vertex)this.verList.get(nea.getVertexKey());
                vertexesTBP.push(vUnSolved);
            }
            vlResult.add(v);
        }
        for (Vertex v : vlResult.values()) {
            for (NodeEdgeAdjacency adjEdge : v.adjEdges.values()) {
                peerVertexKey = adjEdge.getVertexKey();
                Edge e1 = new Edge(v.getKey(), peerVertexKey);
                Edge e2 = new Edge(peerVertexKey, v.getKey());
                if (elResult.containsKey(e1.getKey()) || elResult.containsKey(e2.getKey())) continue;
                elResult.add(e1);
            }
        }
        return new Graph(elResult, vlResult);
    }

    public boolean removeEdge(Edge e) {
        for (Edge aEdge : this.edgeList.values()) {
            if (!aEdge.equals(e)) continue;
            this.edgeList.remove(aEdge.getKey());
            Vertex startVertex = (Vertex)this.verList.get(e.startKey());
            Vertex endVertex = (Vertex)this.verList.get(e.endKey());
            startVertex.removeAdjacentEdge(endVertex.getKey());
            endVertex.removeAdjacentEdge(startVertex.getKey());
            return true;
        }
        return false;
    }

    private void initGraph(EdgeHashMap edgeList, VertexHashMap vertexList) {
        Iterator edgeKeys = edgeList.keySet().iterator();
        for (String verKey : vertexList.keySet()) {
            this.verList.add(new Vertex(verKey));
        }
        while (edgeKeys.hasNext()) {
            Edge edgeTem = (Edge)edgeList.get((String)edgeKeys.next());
            String key1 = Edge.key(edgeTem.startKey(), edgeTem.endKey());
            String key2 = Edge.key(edgeTem.endKey(), edgeTem.startKey());
            if (edgeList.containsKey(key1) && edgeList.containsKey(key2)) continue;
            String startVerKey = edgeTem.startKey();
            String endVerKey = edgeTem.endKey();
            Edge edge = new Edge(startVerKey, endVerKey);
            edge.setPeerObjects(edgeTem.getPeerObjects());
            this.edgeList.add(edge);
            ((Vertex)this.verList.get(startVerKey)).addAdjacentEdge(new NodeEdgeAdjacency(endVerKey, edge.getKey()));
            ((Vertex)this.verList.get(endVerKey)).addAdjacentEdge(new NodeEdgeAdjacency(startVerKey, edge.getKey()));
        }
    }

    private void initGraph(String[] start, String[] end) {
        for (int i = 0; i < start.length; ++i) {
            String startVer = start[i];
            String endVer = end[i];
            String key1 = Edge.key(startVer, endVer);
            String key2 = Edge.key(endVer, startVer);
            if (startVer.equals(endVer) && !this.verList.containsKey(endVer)) {
                this.verList.add(new Vertex(startVer));
                continue;
            }
            if (this.edgeList.containsKey(key1) || this.edgeList.containsKey(key2)) continue;
            String edgeKey = key1;
            this.edgeList.add(new Edge(startVer, endVer));
            Vertex u = null;
            if (!this.verList.containsKey(startVer)) {
                u = new Vertex(startVer);
                this.verList.add(u);
            }
            u = (Vertex)this.verList.get(startVer);
            u.addAdjacentEdge(new NodeEdgeAdjacency(endVer, edgeKey));
            Vertex v = null;
            if (!this.verList.containsKey(endVer)) {
                v = new Vertex(endVer);
                this.verList.add(v);
            }
            v = (Vertex)this.verList.get(endVer);
            v.addAdjacentEdge(new NodeEdgeAdjacency(startVer, edgeKey));
        }
    }

    public Graph(String[][] edges) throws GraphLogicalException {
        String[] start = new String[edges.length];
        String[] end = new String[edges.length];
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i].length != 2) {
                throw new GraphLogicalException(7);
            }
            start[i] = edges[i][0];
            end[i] = edges[i][1];
        }
        this.initGraph(start, end);
    }

    public Graph(String[] start, String[] end) throws GraphLogicalException {
        if (start.length != end.length) {
            throw new GraphLogicalException(8);
        }
        this.initGraph(start, end);
    }

    public Graph(EdgeHashMap edgeList, VertexHashMap vertexList) {
        this.initGraph(edgeList, vertexList);
    }

    public Graph(String[][] edgeList, String[] vertexList) throws GraphLogicalException {
        int i;
        EdgeHashMap edgeListTem = new EdgeHashMap();
        VertexHashMap vertexListTem = new VertexHashMap();
        for (i = 0; i < edgeList.length; ++i) {
            if (edgeList[i].length != 2) {
                throw new GraphLogicalException(9);
            }
            edgeListTem.add(new Edge(edgeList[i][0], edgeList[i][1]));
        }
        for (i = 0; i < vertexList.length; ++i) {
            vertexListTem.add(new Vertex(vertexList[i]));
        }
        this.initGraph(edgeListTem, vertexListTem);
    }

    private void DFS() {
        this.runedDFSFlag = true;
        this.time = 0;
        for (String verKey : this.verList.keySet()) {
            Vertex ver = (Vertex)this.verList.get(verKey);
            if (!VertexColor.isWhite(ver.color())) continue;
            DSFRoot root = new DSFRoot(ver.getKey());
            this.dsfRoot.add(root);
            ver.rootKey = ver.getKey();
            this.DFS_Visit(ver, ver.getKey());
        }
    }

    private void DFS_Visit(Vertex u, String rootKey) {
        u.setColor(1);
        ++this.time;
        u.descovery = this.time;
        for (String adjKey : u.adjEdges.keySet()) {
            Edge edge;
            NodeEdgeAdjacency neAdj = (NodeEdgeAdjacency)u.adjEdges.get(adjKey);
            String vertexKey = neAdj.getVertexKey();
            Vertex v = (Vertex)this.verList.get(vertexKey);
            if (VertexColor.isWhite(v.color())) {
                edge = (Edge)this.edgeList.get(neAdj.getEdgeKey());
                edge.setType(0);
                v.setParentKey(u.getKey());
                v.rootKey = rootKey;
                u.addChild(new Child(v.getKey()));
                this.DFS_Visit(v, rootKey);
                continue;
            }
            if (v.getKey().equals(u.getParentKey())) continue;
            edge = (Edge)this.edgeList.get(neAdj.getEdgeKey());
            if (edge == null) {
                System.err.println("edge key " + neAdj.getEdgeKey());
            }
            edge.setType(1);
        }
        ++this.time;
        u.finish = this.time;
    }

    public TreeList getTreeCover(String[] vertices) {
        String[] vTem = new String[vertices.length];
        int realCount = 0;
        block0: for (int i = 0; i < vertices.length; ++i) {
            for (int j = 0; j < realCount; ++j) {
                if (vertices[i].equals(vTem[j])) continue block0;
            }
            vTem[realCount++] = vertices[i];
        }
        if (realCount < vertices.length) {
            vertices = new String[realCount];
            System.arraycopy(vTem, 0, vertices, 0, realCount);
        }
        if (vertices.length <= 1) {
            return new TreeList();
        }
        TreeList coverTrees = new TreeList();
        Iterator verKeys = this.verList.keySet().iterator();
        Object[] allVertexes = new String[this.verList.keySet().size()];
        int i = 0;
        while (verKeys.hasNext()) {
            allVertexes[i] = (String)verKeys.next();
            ++i;
        }
        Combination comb = new Combination(allVertexes, 2);
        VertexPair[] minPaths = new VertexPair[Combination.calculateCombNum(allVertexes.length, 2)];
        int i2 = 0;
        while (comb.hasNext()) {
            String[] tem = (String[])comb.next();
            minPaths[i2] = new VertexPair(tem[0], tem[1]);
            ++i2;
        }
        String[] verClone = vertices;
        while (verClone.length > 1) {
            EdgeList subTree = new EdgeList();
            VertexList addVerList = new VertexList();
            ArrayList<String> unconnectedV = new ArrayList<String>();
            block5: for (int i3 = 0; i3 < verClone.length; ++i3) {
                Vertex v = (Vertex)this.verList.get(verClone[i3]);
                if (addVerList.size() == 0) {
                    addVerList.add(v);
                    continue;
                }
                if (addVerList.contains(v)) continue;
                int shortestLength = Integer.MAX_VALUE;
                EdgeList shortestPath = new EdgeList();
                int size = addVerList.size();
                for (int j = 0; j < size; ++j) {
                    VertexPair vPair = null;
                    for (int m = 0; m < minPaths.length; ++m) {
                        if (!minPaths[m].isFor(((Vertex)addVerList.get(j)).getKey(), v.getKey())) continue;
                        vPair = minPaths[m];
                        break;
                    }
                    if (vPair.getPathLength() == 0) {
                        unconnectedV.add(verClone[i3]);
                        continue block5;
                    }
                    if (shortestLength <= vPair.getPathLength()) continue;
                    shortestLength = vPair.getPathLength();
                    shortestPath = vPair.getShortestPath();
                }
                int size2 = shortestPath.size();
                for (int j = 0; j < size2; ++j) {
                    Edge e = (Edge)shortestPath.get(j);
                    if (!addVerList.contains(e.startKey())) {
                        addVerList.add((Vertex)this.verList.get(e.startKey()));
                    }
                    if (addVerList.contains(e.endKey())) continue;
                    addVerList.add((Vertex)this.verList.get(e.endKey()));
                }
                subTree.addAll(shortestPath);
            }
            if (subTree.size() > 0) {
                coverTrees.add(subTree);
            }
            verClone = new String[unconnectedV.size()];
            unconnectedV.toArray(verClone);
        }
        return coverTrees;
    }

    public int getConnectedGraphNum() {
        if (!this.runedDFSFlag) {
            this.DFS();
        }
        return this.dsfRoot.size();
    }

    public PathList getLoop() {
        Iterator vertexKeys = this.verList.keySet().iterator();
        PathList loopsTem = new PathList();
        while (vertexKeys.hasNext()) {
            Vertex v;
            this.vStart = v = (Vertex)this.verList.get(vertexKeys.next());
            this.detectLoop(v, v);
        }
        for (int i = 0; i < this.loops.size(); ++i) {
            try {
                loopsTem.add(new Path((EdgeList)this.loops.get(i)));
                continue;
            }
            catch (GraphLogicalException gLE) {
                // empty catch block
            }
        }
        return loopsTem;
    }

    private void detectLoop(Vertex v, Vertex previousV) {
        Iterator adjEdgeKeys = v.adjEdges.keySet().iterator();
        while (adjEdgeKeys.hasNext()) {
            NodeEdgeAdjacency edgeAdj = (NodeEdgeAdjacency)v.adjEdges.get(adjEdgeKeys.next());
            Vertex vertexAdj = (Vertex)this.verList.get(edgeAdj.getVertexKey());
            if (!vertexAdj.getKey().equals(previousV.getKey()) && vertexAdj.getKey().equals(this.vStart.getKey())) {
                boolean equalFlag = false;
                Edge edge = new Edge(v.getKey(), this.vStart.getKey());
                this.eLoop.add(edge);
                if (this.loops.size() == 0) {
                    equalFlag = false;
                } else {
                    for (int i = 0; i < this.loops.size(); ++i) {
                        ArrayList loopEdges = (ArrayList)this.loops.get(i);
                        if (loopEdges.size() != this.eLoop.size()) {
                            equalFlag = false;
                            continue;
                        }
                        equalFlag = true;
                        block2: for (int n = 0; n < this.eLoop.size(); ++n) {
                            for (int j = 0; j < loopEdges.size(); ++j) {
                                if (((Edge)loopEdges.get(j)).equals((Edge)this.eLoop.get(n))) continue block2;
                            }
                            equalFlag = false;
                            break;
                        }
                        if (equalFlag) break;
                    }
                }
                if (!equalFlag) {
                    this.loops.add(this.eLoop.clone());
                }
                this.eLoop.remove(this.eLoop.size() - 1);
                continue;
            }
            if (vertexAdj.getKey().equals(previousV.getKey())) continue;
            Edge edge = new Edge(v.getKey(), vertexAdj.getKey());
            if (this.eLoop.size() != 0 && this.loopVertex.containsKey(edge.endKey())) continue;
            this.eLoop.add(edge);
            this.loopVertex.put(edge.startKey(), edge.startKey());
            this.loopVertex.put(edge.endKey(), edge.endKey());
            this.detectLoop(vertexAdj, v);
            edge = (Edge)this.eLoop.remove(this.eLoop.size() - 1);
            this.loopVertex.remove(edge.endKey());
        }
    }

    public EdgeHashMap getEdgeList() {
        return this.edgeList;
    }

    public VertexHashMap getVertexList() {
        return this.verList;
    }

    public String[] getCanCoverVertexes(String[] coverVertexes) {
        ArrayList<String> vertexes = new ArrayList<String>();
        for (int i = 0; i < coverVertexes.length; ++i) {
            if (!this.verList.containsKey(coverVertexes[i])) continue;
            vertexes.add(coverVertexes[i]);
        }
        String[] tem = new String[vertexes.size()];
        vertexes.toArray(tem);
        return tem;
    }

    public String[] getCannotCoverVertexes(String[] coverVertexes) {
        ArrayList<String> vertexes = new ArrayList<String>();
        for (int i = 0; i < coverVertexes.length; ++i) {
            if (this.verList.containsKey(coverVertexes[i])) continue;
            vertexes.add(coverVertexes[i]);
        }
        String[] tem = new String[vertexes.size()];
        vertexes.toArray(tem);
        return tem;
    }

    public boolean canCoverVertexes(String[] vertexes) {
        for (int i = 0; i < vertexes.length; ++i) {
            if (this.verList.containsKey(vertexes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isContainsEdge(Edge edge) {
        for (Edge e : this.getEdgeList().values()) {
            if (!e.equals(edge)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Graph g) {
        int edgeNum = this.edgeList.size();
        int verNum = this.verList.size();
        if (edgeNum != g.getEdgeList().size() || verNum != g.getVertexList().size()) {
            return false;
        }
        EdgeHashMap temE = g.getEdgeList();
        for (Edge e : temE.values()) {
            String key1 = e.getKey();
            String key2 = e.getKey2();
            if (this.edgeList.containsKey(key1) || this.edgeList.containsKey(key2)) continue;
            return false;
        }
        VertexHashMap temV = g.getVertexList();
        for (Vertex v : temV.values()) {
            String key = v.getKey();
            if (this.verList.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return new Graph(this.getEdgeList(), this.getVertexList());
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("Edges : [");
        for (Edge e : this.edgeList.values()) {
            strBuf.append(e.getKey() + ", ");
        }
        strBuf.append("]\nVertices : [");
        for (Vertex v : this.verList.values()) {
            strBuf.append(v.getKey() + ", ");
        }
        strBuf.append("]\n");
        return strBuf.toString();
    }

    class VertexPair {
        private String v1;
        private String v2;
        private EdgeList shortestPath = new EdgeList();

        VertexPair(String v1, String v2) {
            this.v1 = v1;
            this.v2 = v2;
            Vertex start = (Vertex)Graph.this.verList.get(v1);
            Vertex end = (Vertex)Graph.this.verList.get(v2);
            if (start == null || end == null) {
                return;
            }
            for (Vertex tem : Graph.this.verList.values()) {
                tem.setColor(0);
                tem.setParent(null);
            }
            this.shortestPath.clear();
            this.BFSTraverse(start, end);
        }

        private void BFSTraverse(Vertex preV, Vertex endV) {
            VertexList queue = new VertexList();
            preV.setColor(1);
            if (this.visit(preV, endV)) {
                return;
            }
            queue.add(preV);
            while (queue.size() > 0) {
                Vertex v = (Vertex)queue.remove(0);
                for (NodeEdgeAdjacency adjEdge : v.adjEdges.values()) {
                    Vertex adjV = (Vertex)Graph.this.verList.get(adjEdge.getVertexKey());
                    if (adjV.color() != 0) continue;
                    adjV.setParent(v);
                    adjV.setColor(1);
                    if (this.visit(adjV, endV)) {
                        return;
                    }
                    queue.add(adjV);
                }
            }
        }

        private boolean visit(Vertex preV, Vertex endV) {
            Edge tem = new Edge(preV.getKey(), endV.getKey());
            if (Graph.this.edgeList.containsKey(tem.getKey()) || Graph.this.edgeList.containsKey(tem.getKey2())) {
                Vertex pv;
                this.shortestPath.add(tem);
                while ((pv = preV.getParent()) != null) {
                    tem = new Edge(pv.getKey(), preV.getKey());
                    this.shortestPath.add(tem);
                    preV = pv;
                }
                return true;
            }
            return false;
        }

        EdgeList getShortestPath() {
            return this.shortestPath;
        }

        int getPathLength() {
            return this.shortestPath.size();
        }

        boolean isFor(String v1, String v2) {
            return this.v1.equals(v2) && this.v2.equals(v1) || this.v1.equals(v1) && this.v2.equals(v2);
        }

        public String toString() {
            return this.shortestPath.toString();
        }
    }
}

