/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import java.util.ArrayList;
import java.util.Vector;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUJoinPath;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLException;
import jet.universe.businesslogic.joinpathtools.JoinPathFinderAPI;
import jet.universe.businesslogic.joinpathtools.JoinPathSetAPI;
import jet.universe.businesslogic.joinpathtools.graph.JoinList;
import jet.universe.businesslogic.joinpathtools.graph.JoinPathList;
import jet.universe.businesslogic.joinpathtools.graph.PathFinder;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlTable;

public class JoinPathFinder
implements JoinPathFinderAPI {
    private PathFinder pathFinder = null;
    private JetUUniverse universe;
    private String datasourceName;
    private String onDemandQueryName;

    public JoinPathFinder(JetUUniverse universe, String datasourceName, String onDemandQueryName) throws BLException {
        this.universe = universe;
        this.datasourceName = datasourceName;
        this.onDemandQueryName = onDemandQueryName;
        JetUDemandQuery query = (JetUDemandQuery)universe.getQueriableByResourceName(datasourceName, onDemandQueryName);
        Vector v = null;
        v = query.getJoins();
        PsqlJoin[] allJoins = new PsqlJoin[v.size()];
        v.toArray(allJoins);
        v = query.getTables();
        PsqlTable[] allTables = new PsqlTable[v.size()];
        v.toArray(allTables);
        v = query.getJoinPathes();
        JetUJoinPath[] allJoinPath = new JetUJoinPath[v.size()];
        v.toArray(allJoinPath);
        this.pathFinder = new PathFinder(allJoins, allTables, allJoinPath);
    }

    @Override
    public String[] getUncontainTables(String[] tablesQualifyName, PsqlJoin[] joins) {
        ArrayList tablesQName = new ArrayList();
        for (int i = 0; i < joins.length; ++i) {
            String qName1 = joins[i].getTableFrom().getMappingName();
            String qName2 = joins[i].getTableFrom().getMappingName();
            this.addName(tablesQName, qName1);
            this.addName(tablesQName, qName2);
        }
        String[] tem = new String[tablesQName.size()];
        tablesQName.toArray(tem);
        return this.pathFinder.getUncontainTables(tablesQualifyName, tem);
    }

    @Override
    public String[] getUncontainTables(String[] tablesQualifyName, JoinList joins) {
        PsqlJoin[] tem = new PsqlJoin[joins.size()];
        joins.toArray(tem);
        return this.getUncontainTables(tablesQualifyName, tem);
    }

    @Override
    public String[] getUncontainTables(String[] tablesQualifyName, JoinPathList joinPathes) {
        int size = joinPathes.size();
        String[] tem = tablesQualifyName;
        for (int i = 0; i < size; ++i) {
            JoinList joins = (JoinList)joinPathes.get(i);
            if ((tem = this.getUncontainTables(tem, joins)).length != 0) continue;
            return new String[0];
        }
        return tem;
    }

    private boolean addName(ArrayList names, String name2) {
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            if (!name2.equals(names.get(i))) continue;
            return false;
        }
        names.add(name2);
        return true;
    }

    @Override
    public JoinPathSetAPI findJoinPaths(String[] joinPathsQualifyName, String[] mappingNames) throws BLException {
        return this.pathFinder.findJoinPaths(joinPathsQualifyName, this.getDependentTableQName(mappingNames));
    }

    @Override
    public String[] getCandidateJoinPathsQualifyName(String[] joinPathsQualifyName, String[] mappingNames) throws BLException {
        return this.pathFinder.getCandidateJoinPathsQualifyName(joinPathsQualifyName, this.getDependentTableQName(mappingNames));
    }

    @Override
    public String[] getCannotAddTable(String[] joinPathsQualifyName, String[] mappingNames) throws BLException {
        return this.pathFinder.getCannotAddTable(joinPathsQualifyName, this.getDependentTableQName(mappingNames));
    }

    @Override
    public String[] getDependentTableQName(String[] mappingNames) throws BLException {
        return new QueryTransform().getUsedTableMappingName(this.universe, this.datasourceName, this.onDemandQueryName, mappingNames);
    }
}

