/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import jet.universe.JetUJoinPath;
import jet.universe.businesslogic.joinpathtools.JoinPathFinder4DesignerAPI;
import jet.universe.businesslogic.joinpathtools.graph.Edge;
import jet.universe.businesslogic.joinpathtools.graph.EdgeHashMap;
import jet.universe.businesslogic.joinpathtools.graph.EdgeList;
import jet.universe.businesslogic.joinpathtools.graph.Graph;
import jet.universe.businesslogic.joinpathtools.graph.GraphLogicalException;
import jet.universe.businesslogic.joinpathtools.graph.Path;
import jet.universe.businesslogic.joinpathtools.graph.PathFinder;
import jet.universe.businesslogic.joinpathtools.graph.PathList;
import jet.universe.businesslogic.joinpathtools.graph.UserDefinedPathException;
import jet.universe.businesslogic.joinpathtools.graph.VertexList;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlTable;

public class JoinPathFinder4Designer
implements JoinPathFinder4DesignerAPI {
    private UserDefinedJoinPath[] userDefinedJoinPaths;
    private String[] illegalJoinPaths;
    private String[][] unsolvedTables;
    private String[][][] unsolvedLoopsGroup;
    private PsqlJoin[] allJoins;

    public JoinPathFinder4Designer(PsqlJoin[] allJoins, PsqlTable[] tables, JetUJoinPath[] joinPaths) {
        PathFinder pathFinder;
        ArrayList<String[]> unsolvedTableList;
        block15: {
            this.allJoins = allJoins;
            this.userDefinedJoinPaths = new UserDefinedJoinPath[joinPaths.length];
            for (int i = 0; i < joinPaths.length; ++i) {
                this.userDefinedJoinPaths[i] = new UserDefinedJoinPath(joinPaths[i]);
            }
            ArrayList<String> illegalJoinPathList = new ArrayList<String>();
            unsolvedTableList = new ArrayList<String[]>();
            ArrayList<JetUJoinPath> goodJoinPaths = new ArrayList<JetUJoinPath>();
            for (int i = 0; i < this.userDefinedJoinPaths.length; ++i) {
                EdgeList edges = this.userDefinedJoinPaths[i].getEdges();
                Graph g = null;
                try {
                    g = new Graph(edges.toTwoDimensionArray());
                }
                catch (GraphLogicalException e) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, e);
                    }
                    illegalJoinPathList.add(joinPaths[i].getName());
                    continue;
                }
                if (g.getConnectedGraphNum() > 1) {
                    this.userDefinedJoinPaths[i].setAvailable(false);
                    illegalJoinPathList.add(joinPaths[i].getName());
                    continue;
                }
                goodJoinPaths.add(joinPaths[i]);
            }
            this.illegalJoinPaths = new String[illegalJoinPathList.size()];
            illegalJoinPathList.toArray(this.illegalJoinPaths);
            JetUJoinPath[] goodJPs = new JetUJoinPath[goodJoinPaths.size()];
            goodJoinPaths.toArray(goodJPs);
            pathFinder = null;
            try {
                pathFinder = new PathFinder(allJoins, tables, goodJPs);
            }
            catch (UserDefinedPathException e) {
                if (!JRLog.isError(2)) break block15;
                JRLog.error(2, e);
            }
        }
        String[][][] temUnsolvedLG = pathFinder.getUnsolvedLoopsGroup();
        this.unsolvedLoopsGroup = new String[temUnsolvedLG.length][][];
        int len = temUnsolvedLG.length;
        for (int i = 0; i < len; ++i) {
            Graph g;
            block16: {
                g = null;
                try {
                    g = new Graph(temUnsolvedLG[i]);
                }
                catch (GraphLogicalException e) {
                    if (!JRLog.isError(2)) break block16;
                    JRLog.error(2, e);
                }
            }
            PathList loops = g.getLoop();
            this.unsolvedLoopsGroup[i] = new String[loops.size()][];
            int size = loops.size();
            for (int j = 0; j < size; ++j) {
                Path path = (Path)loops.get(j);
                VertexList vertexList = path.getVertexList();
                this.unsolvedLoopsGroup[i][j] = vertexList.toStringArray();
            }
        }
        String[][][] solvedGroup = pathFinder.getSolvedLoopsGroup();
        for (int i = 0; i < solvedGroup.length; ++i) {
            EdgeList loopGroup = new EdgeList();
            for (int j = 0; j < solvedGroup[i].length; ++j) {
                Edge newEdge = new Edge(solvedGroup[i][j][0], solvedGroup[i][j][1]);
                if (loopGroup.indexOf(newEdge) != -1) continue;
                loopGroup.add(newEdge);
            }
            VertexList vertices = loopGroup.getVertices();
            EdgeList joinPath = null;
            for (int j = 0; !(j >= this.userDefinedJoinPaths.length || this.userDefinedJoinPaths[j].isAvailable() && (vertices = (joinPath = this.userDefinedJoinPaths[j].getEdges()).getUncontainsVertices(vertices)).size() == 0); ++j) {
            }
            if (vertices.size() <= 0) continue;
            unsolvedTableList.add(vertices.toStringArray());
        }
        this.unsolvedTables = new String[unsolvedTableList.size()][];
        unsolvedTableList.toArray((T[])this.unsolvedTables);
    }

    @Override
    public String[] getIllegalJoinPaths() {
        return this.illegalJoinPaths;
    }

    @Override
    public String[][][] getUnsolvedLoopsGroup() {
        return this.unsolvedLoopsGroup;
    }

    @Override
    public PsqlJoin[][][] getUnsolvedLoopsGroupByJoins() {
        EdgeHashMap edgeList = new EdgeHashMap();
        for (int i = 0; i < this.allJoins.length; ++i) {
            String start = this.allJoins[i].getTableFrom().getMappingName();
            String end = this.allJoins[i].getTableTo().getMappingName();
            Edge edge = new Edge(start, end);
            String key1 = edge.getKey();
            String key2 = edge.getKey2();
            Edge existanceEdge = null;
            existanceEdge = (Edge)edgeList.get(key1);
            if (existanceEdge != null || (existanceEdge = (Edge)edgeList.get(key2)) != null) {
                existanceEdge.addPeerObject(this.allJoins[i]);
                continue;
            }
            edge.addPeerObject(this.allJoins[i]);
            edgeList.add(edge);
        }
        PsqlJoin[][][] rValue = new PsqlJoin[this.unsolvedLoopsGroup.length][][];
        int len = this.unsolvedLoopsGroup.length;
        for (int i = 0; i < len; ++i) {
            rValue[i] = new PsqlJoin[this.unsolvedLoopsGroup[i].length][];
            int len2 = this.unsolvedLoopsGroup[i].length;
            for (int j = 0; j < len2; ++j) {
                ArrayList temList = new ArrayList();
                int len3 = this.unsolvedLoopsGroup[i][j].length - 1;
                for (int k = 0; k < len3; ++k) {
                    Edge e = new Edge(this.unsolvedLoopsGroup[i][j][k], this.unsolvedLoopsGroup[i][j][k + 1]);
                    Edge e2 = (Edge)edgeList.get(e.getKey());
                    if (e2 == null) {
                        e2 = (Edge)edgeList.get(e.getKey2());
                    }
                    temList.addAll(e2.getPeerObjects());
                }
                rValue[i][j] = new PsqlJoin[temList.size()];
                temList.toArray(rValue[i][j]);
            }
        }
        return rValue;
    }

    @Override
    public String[][] getUnsolvedTables() {
        return this.unsolvedTables;
    }

    private static class UserDefinedJoinPath {
        private EdgeList edgeList = new EdgeList();
        private String name = "";
        private boolean available = true;

        UserDefinedJoinPath(JetUJoinPath joinPath) {
            this.name = joinPath.getQualifyName();
            PsqlJoin[] joins = joinPath.getJoins();
            for (int i = 0; i < joins.length; ++i) {
                Edge newEdge = new Edge(joins[i].getTableFrom().getMappingName(), joins[i].getTableTo().getMappingName());
                newEdge.addPeerObject(joins[i]);
                int index = -1;
                index = this.edgeList.indexOf(newEdge);
                if (index != -1) {
                    Edge tem = (Edge)this.edgeList.get(index);
                    tem.addPeerObject(joins[i]);
                    continue;
                }
                this.edgeList.add(newEdge);
            }
        }

        void setAvailable(boolean available) {
            this.available = available;
        }

        boolean isAvailable() {
            return this.available;
        }

        String getName() {
            return this.name;
        }

        EdgeList getEdges() {
            return this.edgeList;
        }
    }
}

